
const vec4 unsigned_scale = vec4(0.0, 1.0/128.0, 1.0/128.0, 1.0); 

uniform int vflags;

in vec3 Pv;
in vec4 Cv;







out vec4 Cp;
out vec4 Cs;
centroid out vec3 Tp;

uniform mat4 WM;
uniform mat4 VM;
uniform mat4 PM;

/// BONES
uniform mat4 BM[8];

/// LIGHTING
uniform ivec4  LTYPE[2];
uniform mat4   LV;
uniform mat4   LD;
uniform mat4   LAC;
uniform mat4   LDC;
uniform mat4   LSC;
uniform mat4   MC;
uniform mat4   LKA;
uniform vec4   LKS;
uniform vec4   LKO;
uniform vec4   AC;
uniform int    Le;
uniform int    Lmads;
uniform float  MK;
uniform float  NREV;



/// TEXTURE
uniform ivec2 Tmap;
uniform ivec2 Tshade;
uniform vec2  Tscale;
uniform vec2  Ttrans;
uniform mat4  Tproj;

vec3 GetTexture_projection_mapping()
{
    vec3 T;
    if      (Tmap[1] == 0) // Model Coordinate Projection (XYZ)
    {
        T = Pv.xyz;
    }


    else
    {
        T = vec3(0.0);
    }
    return T;
}

vec2 GetTexture_shade_mapping(in vec3 V, in vec3 En, in vec3 Nn)
{
    vec3  R  = normalize(reflect(V, Nn));
    float Pu = dot(R, vec3(mat3(VM) * LV[Tshade.x].xyz));
    float Pv = dot(R, vec3(mat3(VM) * LV[Tshade.y].xyz));
    return vec2(1.0 + Pu, 1.0 + Pv);
}

void main()
{
    
    
    vec4 V = vec4(Pv.xyz, 1.0);
    mat4 M = VM * WM;
       
           
    
    V  = mat4(M) * V;
    
    gl_Position = PM * V;
    
    
    
    if (bool(vflags & 2)) 
    {    
        vec4 Ca = Cv;
        vec4 Cb = vec4(0.0);
    
        Cp = Ca;
        Cs = Cb;
    }
    else
    {
        Cp = Cv;
        Cs = vec4(0.0);
    }

    if (bool(vflags & 4))
    {    
        //Tp  = vec4(Tv * unsigned_scale[vtype.y], 1.0, 1.0);
         
        if      (Tmap[0] == 1)
        {
            Tp = vec3(Tproj * vec4(GetTexture_projection_mapping(), 1.0));
        }


        else

        {
            Tp = vec3(0.0, 0.0, 1.0);
        }

    }
}
