/****************************************\
|* MFZPSP LLE PSP Emulator              *|
|* Copyright (c) 2008 Mauro Frischherz  *|
|* See License.txt for details          *|
\****************************************/

#ifndef MEMORY_H_
#define MEMORY_H_

#include "../types.h"

inline char		Read8(uint Address);
inline short 	Read16(uint Address);
inline int 		Read32(uint Address);

inline ubyte	uRead8(uint Address);
inline ushort	uRead16(uint Address);
inline uint		uRead32(uint Address);

inline void 	Write8(uint Address, char Value);
inline void		Write16(uint Address, short Value);
inline void 	Write32(uint Address, int Value);

inline void 	uWrite8(uint Address, ubyte Value);
inline void		uWrite16(uint Address, ushort Value);
inline void 	uWrite32(uint Address, uint Value);

void			WriteLarge(uint Address, uint* Input, uint Size);

#endif /*MEMORY_H_*/
