/****************************************\
|* MFZPSP LLE PSP Emulator              *|
|* Copyright (c) 2008 Mauro Frischherz  *|
|* See License.txt for details          *|
\****************************************/

#include "corewrapper.h"

#include "core/cpu.h"
#include "core/memory.h"
#include "core/gpu.h"
#include "core/loader.h"

#include "tools/log.h"
#include <stdio.h>


/* PSP Functions */

bool PSPInit() // Inits PSP and tests cpu
{
	printevent("Init PSP");
	return true;
}

bool PSPReset() // Resets CPU, clears memory and registers
{
	InitCPU();
	StopCPU();
	return true;
}

bool PSPStart() // Starts CPU, will not run unless valid rom is loaded
{
	printevent("Starting PSP");
	if(GetLoaded())
	{
		RunCPU();
		return true;
	}
	else
	{
		printerror("No Rom Loaded");
		return false;
	}
}

bool PSPPause() // Pauses CPU
{
	if(GetCPUState() == CPU_STATE_RUNNING)
	{
		printevent("Pausing CPU");
		PauseCPU();
	}
	else
	{
		printerror("Cannot pause CPU. CPU not running");
	}
	return true;
}

bool PSPResume() // Resumes CPU-Operation
{
	printevent("Resuming CPU activity");
	RunCPU();
	return true;
}


/* Loading ROMs */

bool LoadFile(char* path) // Does all the loading and initialisation needed
{
	LoadAndDecodeFile(path, FILE_TYPE_PBP);
	return false;
}

/* Debugging Stuff / Disasm */

uint GetProgramCounter()
{
	return 0x08000000;
}

uint GetCPURegister(int index) // Returns Integer to CPU-Registers array
{
	return 0;
}

void GetCPURegisterText(int index, char* dest) // Return CPU-Register as string
{
	sprintf(dest, "0x%08X", 0);
}

void GetCPUCode(uint pc, char* pclist, char* operation, char* opcode, char* comment)
{
	sprintf(pclist, "00000000");
	sprintf(operation, "XXXXXXXX");	
	sprintf(opcode, "00000000");	
	sprintf(comment, "XXXXXXXX");	
}

inline char* DisasmCode(uint opcode)
{
	return "00000000 XXXXXX 00000000 XXXXXXXXXXXXXXXXXXXX";
}

void MemDump(uint address, char* hexdump, char* asciidump, int mode)
{
	switch(mode)
	{
	case MEM_DUMP_MODE_8:
		hexdump = "XX XX XX XX XX XX XX XX";
		asciidump = "........";
		break;
	case MEM_DUMP_MODE_16:
		hexdump = "XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX";
		asciidump = "................";
		break;
	default:
		break;
	}
}

uint GetBase()
{
	return 0x08000000;
}
