/****************************************\
|* MFZPSP LLE PSP Emulator              *|
|* Copyright (c) 2008 Mauro Frischherz  *|
|* See License.txt for details          *|
\****************************************/

#ifndef COREWRAPPER_H_
#define COREWRAPPER_H_

#include "types.h"

extern int GetCPUState(); // CPU States defined in types.h

bool LoadFile(char* path); // Does all the loading and initialisation needed

bool PSPReset(); // Resets CPU, clears memory and registers
bool PSPStart(); // Starts CPU, will not run unless valid rom is loaded

bool PSPPause(); // Pauses CPU
bool PSPResume(); // Resumes CPU-Operation


// GUI-Registers_______________________________________
uint GetCPURegister(int index); // Returns CPU-Register
void GetCPURegisterText(int index, char* dest); // Returns Text
uint GetProgramCounter();



// GUI-Memory________DO NOT USE THIS YET______________________________________
// fills int array with mem dump and string with ascii dump, modes in types.h
void MemDump(uint address, char* hexdump, char* asciidump, int mode);


// GUI-Disasm_________________________________________________________________________
// fills a uint array with the memory addresses and another with actual opcodes itself
void GetCPUCode(uint pc, char* pclist, char* operation, char* opcode, char* comment); // Pass NULL for pc if current wanted


#endif /*COREWRAPPER_H_*/ //
