/* MFZPSP:     gui/win/win.h               *
 * Created by: Stefan Zurfluh              *
 * Edited by:  - S. Z.                     */

#ifdef GUI_WINDOWS

#include "../gui.h"
#include "../language.h"
#include "../../types.h"
#include "../../tools/log.h"
#include "../../../res/resource.h"
#include <process.h>

#define TMR_SCROLL          101
#define TMR_LAMP            102

#define NUM_TOOLBAR_BUTTONS   3

#define MFZ_LIGHTBLUE          RGB(110, 110, 200)
#define MFZ_LIGHTGRAY          RGB(200, 200, 200)
#define MFZ_MEDIUMGRAY         RGB(160, 160, 160)
#define MFZ_DARKBLUE           RGB(0, 0, 120)
#define MFZ_RED                RGB(100, 0, 0)
#define MFZ_YELLOW             RGB(190, 190, 0)
#define MFZ_ORANGE             RGB(180, 80, 0)
#define MFZ_BLACK              RGB(0, 0, 0)

LRESULT CALLBACK MainWindowProc(HWND mainWindow, UINT message, WPARAM wParam, LPARAM lParam);
VOID CALLBACK TimerScroll(HWND mainWindow, UINT message, UINT_PTR idEvent, DWORD dwTime);
VOID CALLBACK TimerLamp(HWND mainWindow, UINT message, UINT_PTR idEvent, DWORD dwTime);
void CreateMainWin();
void CreateToolBar(HWND win);
void GUI();
void SetUpCoordinates(HWND win);
void ShowHelpDialog();

void GDIInit(HWND win);
void GDIBegin(HWND win);
void GDIEnd(HWND win);
void GDIPaintToolBar();
void GDIPaintStatusBar();
void GDIPaintDisplay();
void GDIPaintRegisters();
void GDIPaintDisasm();
void GDIPaintMemory();
void GDICleanUp(HWND win);
bool GDILoadBMP(LPTSTR file, HBITMAP *bitmap);
void GDIShowBMP(HBITMAP bitmap, LONG x, LONG y);

#endif
