/****************************************\
|* MFZPSP LLE PSP Emulator              *|
|* Copyright (c) 2008 Mauro Frischherz  *|
|* See License.txt for details          *|
\****************************************/

#ifndef TYPES_H_
#define TYPES_H_

/* CPU - States */
#define CPU_STATE_STOPPED	0
#define CPU_STATE_RUNNING 	1
#define CPU_STATE_PAUSED	2
#define CPU_STATE_READY		4

/* Filetypes */
#define FILE_TYPE_ELF		0
#define FILE_TYPE_PRX		1
#define FILE_TYPE_PBP		2
#define FILE_TYPE_PSF		3
#define FILE_TYPE_SFO		3
#define FILE_TYPE_PSP		4
#define FILE_TYPE_PSAR		5
#define FILE_TYPE_PMF		6
#define FILE_TYPE_PSMF		6
#define FILE_TYPE_PGF		7
#define FILE_TYPE_THM		8
#define FILE_TYPE_RCO		9
#define FILE_TYPE_IREG		10
#define FILE_TYPE_ISO		11
#define FILE_TYPE_CSO		12

/* Memory - States */
#define MEM_STATE_RESET		0
#define MEM_STATE_OFF		1

/* MemDump Modes */
#define MEM_DUMP_MODE_8		0
#define MEM_DUMP_MODE_16	1

/* Typedefs */
typedef unsigned short	ushort;
typedef unsigned char 	ubyte;
typedef unsigned int 	uint;

typedef enum {false,true} bool;

typedef unsigned long* uintptr_t;


#endif /*TYPES_H_*/
