/************************************************************************

About.cpp

Copyright (C) 2007 Virus
Copyright (C) 2002 mooby

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

************************************************************************/

//#include "zlib/zlib.h"
#include "defines.h"
#include "externs.h"
#include "Utils.hpp"
#include <string.h>
#include <bzlib.h>
#include "SDL.h"
#include "SDL_version.h"

//  About.cpp
//  has the config, about, and test functions and related structs

//  lots of this code was taken from PEOPS.  THANK YOU!!!!

const  unsigned char version	= 1;	  // do not touch - library for PSEmu 1.x

#define REVISION  1
#define BUILD 7

#ifdef _DEBUG
#ifdef SUPER_DEBUG
static char *libraryName		= "VirusCDR image super debug driver";
#else
static char *libraryName		= "VirusCDR image debug driver";
#endif
#else
static char *libraryName		= "VirusCDR Image Driver";
#endif

static const char *pluginAuthor[] = {"Mooby","Virus","Micket (DFBinImage)", NULL};

static FPSEAbout aboutMooby = {FPSE_CDROM, 
   BUILD, 
   REVISION, 
   FPSE_OK, 
   "vir", 
#ifdef _DEBUG
#ifdef SUPER_DEBUG
   "Virus cd disk image super debug driver",
#else
   "Virus cd disk image debug driver",
#endif
#else
   "Virus cd disk image driver",
#endif
   "vir"};


/** PSX emu interface **/

// lots of this code was swiped from PEOPS.  thank you =)
char * CALLBACK PSEgetLibName(void)
{
 return libraryName;
}

unsigned long CALLBACK PSEgetLibType(void)
{
 return	PSE_LT_CDR;
}

unsigned long CALLBACK PSEgetLibVersion(void)
{
 return version<<16|REVISION<<8|BUILD;
}

void CALLBACK CDRabout(void)
{
   std::ostringstream out;
   const SDL_version * v = SDL_Linked_Version();

   out << libraryName << " based on CDRMooby2 by Virus" <<std::endl
	   << "Some features backported from DFBinImage by Micket" <<std::endl
	   << "BZIP2 " << BZ2_bzlibVersion() << ", FLTK " << FL_VERSION
	   << " SDL " << int(v->major) << "." << int(v->minor) << "." << int(v->patch) <<std::endl;
   moobyMessage(out.str());
}

long CALLBACK CDRtest(void)
{
   moobyMessage("Of course it'll work.");
   return 0;
}

/** FPSE interface **/

void   CD_About(UINT32 *par)
{
   memcpy(par, &aboutMooby, sizeof(FPSEAbout));
}

/** PCSX2 interface **/
/*
void CALLBACK CDVDabout()
{
   CDRabout();
}

s32  CALLBACK CDVDtest()
{
  return CDRtest();
}

u32   CALLBACK PS2EgetLibType(void)
{
   return PS2E_LT_CDVD;
}

u32   CALLBACK PS2EgetLibVersion2(void)
{
   return PSEgetLibVersion();
}

char* CALLBACK PS2EgetLibName(void)
{
   return PSEgetLibName();  
}
*/
