/************************************************************************

ConfigFunctions.cpp

Copyright (C) 2007 Virus
Copyright (C) 2002 mooby

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

************************************************************************/

#include "defines.h"
#include "externs.h"
#include <iostream>
#include "Utils.hpp"
#include "Preferences.hpp"
#include "ConfigFunctions.hpp"

using namespace std;

extern Preferences prefs;

void ConfigWindow::makeWindow()
{
  { 
    Fl_Double_Window* o = new Fl_Double_Window(500, 350, "VirusCDR Configuration");
    w = o;
	o->begin();
	{ Flu_Label* o = new Flu_Label(20, 10, 220, 25, "CDDA Play Options:");
	  //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	}
    { Fl_Radio_Round_Button* o = new Fl_Radio_Round_Button(20,35,220,20, "Repeat all tracks");
      o->value(prefs.prefsMap[repeatString] == repeatAllString);
      o->callback((Fl_Callback*)repeatAllCDDA, this);
      repeatAllButton = o;
    }
    { Fl_Radio_Round_Button* o = new Fl_Radio_Round_Button(20,55,220,20, "Repeat one track");
      o->value(prefs.prefsMap[repeatString] == repeatOneString);
      o->callback((Fl_Callback*)repeatOneCDDA, this);
      repeatOneButton = o;
    }
    { Fl_Radio_Round_Button* o = new Fl_Radio_Round_Button(20,75,220,20, "Play one track and stop");
      o->value(prefs.prefsMap[repeatString] == playOneString);
      o->callback((Fl_Callback*)playOneCDDA, this);
      playOneButton = o;
    }
    { Fl_Value_Slider* o = new Fl_Value_Slider(20, 105, 220, 25, "CDDA Volume");
      o->type(5);
      o->range(0, 100);
      o->step(1);
      o->value(atof(prefs.prefsMap[volumeString].c_str()));
      o->callback((Fl_Callback*)CDDAVolume);
    }
	{Flu_Label* o = new Flu_Label(20, 150, 220, 25, "Compress to bz/track:");
	  //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	}
	//new Fl_Box(5, 280, 250, 25, "Z/table compression");
    { Fl_Button* o = new Fl_Button(20, 175, 220, 25, "Compress");
      o->callback((Fl_Callback*)bzCompress);
    }
    { Fl_Button* o = new Fl_Button(20, 205, 220, 25, "Decompress");
      o->callback((Fl_Callback*)bzDecompress);
    }/*
    { Fl_Button* o = new Fl_Button(20, 305, 95, 25, "Compress");
      o->callback((Fl_Callback*)zCompress);
    }
    { Fl_Button* o = new Fl_Button(130, 305, 95, 25, "Decompress");
      o->callback((Fl_Callback*)zDecompress);
    }*/
	{ Flu_Label* o = new Flu_Label(260, 150, 220, 25, "Autorun:");
	  //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	}
    {
      Fl_Button* o = new Fl_Button(260, 175, 220, 25, "Choose an autorun image");
      o->callback((Fl_Callback*)chooseAutorunImage, this);
    }
    {
      Fl_Button* o = new Fl_Button(260, 205, 220, 25, "Clear the autorun image");
      o->callback((Fl_Callback*)clearAutorunImage, this);
    }
    { Fl_Return_Button* o = new Fl_Return_Button(400, 320, 80, 25, "OK");
      o->callback((Fl_Callback*)configOK, this);
    }
	{ Flu_Label* o = new Flu_Label(260, 10, 220, 25, "Image Read Options:");
	  //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	}
    { Fl_Check_Button* o = new Fl_Check_Button(260,35,220,20, "Read subchannel data");
      o->value(prefs.prefsMap[subEnableString] != std::string());
      o->callback((Fl_Callback*)subEnable);
    }
    { Fl_Check_Button* o = new Fl_Check_Button(260,75,220,20, "Alternative caching mode");
      o->value(prefs.prefsMap[cachingModeString] == newCachingString);
      o->callback((Fl_Callback*)newCaching);
    }
    { Fl_Value_Slider* o = new Fl_Value_Slider(260, 105, 220, 25, "Cache size (MB)");
      o->type(5);
      o->range(1, 256);
      o->step(1);
      o->value(atoi(prefs.prefsMap[cacheSizeString].c_str())/445);
      o->callback((Fl_Callback*)cacheSize);
    }

	{ Flu_Label* o = new Flu_Label(20, 235, 220, 25, "Autorun image:");
	  //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	}

	  autorunimage="sholund't see this";
      if (prefs.prefsMap[autorunString] == std::string("")){
          autorunimage="no image selected";
      }
      else autorunimage=prefs.prefsMap[autorunString].c_str();

	{ Flu_Label* o = new Flu_Label(20, 260, 460, 55, autorunimage);
	 //o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
	 //o->redraw_label();
	   o->box(FL_DOWN_BOX);
	 autorunBox = o;
    }
    o->end();
  }
}

/** configure plugin external functions **/

long CALLBACK CDRconfigure(void)
{
	RunConfig();
	prefs.write();
	return 0;
}


int	CD_Configure(UINT32 *par)
{
	RunConfig();
	prefs.write();
	return 0;
}
