/************************************************************************

Progress_Bar.cpp

Copyright (C) 2007 Virus

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

************************************************************************/

/* A progress bar. */

#include <cstdio>
#include <stdlib.h>
#include <string>
#include <math.h>
#include "ProgressBar.hpp"

Progress_Bar::Progress_Bar(int x, int y, int w, int h, const char *l) :
    Fl_Group(x, y, w, h),
	slider(FL_HOR_FILL_SLIDER, x, y, w, h, l),
	label(x, y, w, h, "0%")
{
	slider.slider(FL_PLASTIC_DOWN_BOX);
	slider.selection_color(fl_rgb_color(25,235,55));
	slider.set_output();
	slider.maximum(1);
	slider.step(5);
	end();
}

int Progress_Bar::inc() {
	double v;
	value(v = slider.increment(slider.value(), 1)*100);
	return (int)v;
}

void Progress_Bar::value(double v) {
	slider.value(v);
	//ansiitoa((int)(v*100),buf,10);
	sprintf_s(buf,_countof(buf),"%d%%",(int)(v*100));
	//strcat(buf, "%");
	label.label(buf);
	label.redraw();
}
