/************************************************************************

Progress_Bar.h

Copyright (C) 2007 Virus

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

************************************************************************/

#ifndef Progress_Bar_h
#define Progress_Bar_h

#include <FL/Fl_Group.H>
#include <FL/Fl_Slider.H>
#include <FL/Fl_Box.H>

class Progress_Bar : public Fl_Group {
public:
	Progress_Bar(int x, int y, int w, int h, const char *l = 0);

	void reset() { value(0.); }
	int inc();
	void value(double v);
	double value() const { return (slider.value()); }

private:
	Fl_Slider slider;
	Fl_Box label;
	char buf[10];
};

#endif
