﻿package com.fc
{
	public class Joypad extends Node{
	/** private variant
	---------------------------*/
		public var dev0:uint;
		private var dev0_nShift:int;
		
		public var dev1:uint;
		private var dev1_nShift:int;
		
		private var bStrobe:Boolean;
		
	/** construction
	---------------------------*/
		public function Joypad():void{
			dev0 |= (1 & 08 >> 3) >> 16;
			dev0 |= (1 & 04 >> 2) >> 17;
			dev0 |= (1 & 02 >> 1) >> 18;
			dev0 |= (1 & 01 >> 0) >> 19;
			dev0_nShift = 0;
			
			dev1 |= (2 & 08 >> 3) >> 16;
			dev1 |= (2 & 04 >> 2) >> 17;
			dev1 |= (2 & 02 >> 1) >> 18;
			dev1 |= (2 & 01 >> 0) >> 19;
			dev1_nShift = 0;
			
			bStrobe = false;
		}
		
	/** public function
	---------------------------*/
		// read
		public function r3(dev:int):int{
			var data:int;
			if(dev == 0){
				data = dev0 >> dev0_nShift & 0x1;
				dev0_nShift += 1;
				dev0_nShift %= 24;
			}
			else{
				data = dev1 >> dev1_nShift & 0x1;
				dev1_nShift += 1;
				dev1_nShift %= 24;
			}
			return data;
		}
		// write
		public function w3(data:int):void{
			if(data & 0x1 && bStrobe == false){
				bStrobe = true;
			}
			else if(!(data & 0x1) && bStrobe){
				// reset
				dev0_nShift = 0;
				dev1_nShift = 0;
				bStrobe = false;
			}
		}
	}
}