﻿package com.fc
{
	//
	// iNes header length:16(0x10)bytes		- iNes的头部长度:16(0x10)个字节 
	//
	// a bank of PRG-ROM is 0x4000(16KB)	- PRG-ROM的一个bank是16KB
	// a bank of CHR-ROM is 0x1000(4KB)		- CHR-ROM的一个bank是4KB
	// all CHR-ROM is 0x2000(8KB)			- 整个CHR-ROM是8KB
	//
	// lower PRG-ROM address is:0x8000		- 低部PRG-ROM的起始址是0x8000
	// upper PRG-ROM address is:0xC000		- 高部PRG-ROM的起始址是0xC000
	//
	public class Mapper0 extends Node implements Mapper{
		// 构造函数
		public function Mapper0():void{
		}
		// 复位
		public function reset():void{
			var i:int;
			var offset:int;
			// load first PRG-ROM of 16K	- 载入第一个16K的PRG-ROM
			offset = 0x10;
			for(i = 0;i < 0x4000; i+=1){
				bus.cpu.vtMem[int(0x8000 + i)] = bus.vtRom[int(offset + i)];
			}
			// load last PRG-ROM of 16K		- 载入最后一个16K的PRG-ROM
			offset = 0x10 + (bus.nPRomNum - 1) * 0x4000;
			for(i = 0;i < 0x4000; i+=1){
				bus.cpu.vtMem[int(0xC000 + i)] = bus.vtRom[int(offset + i)];
			}
			// load VROM of 8K				- 载入8K VROM
			offset = 0x10 + bus.nPRomNum * 0x4000;
			if(bus.nVRomNum != 0){
				for(i = 0;i < 0x2000;i+=1){
					bus.ppu.vtVRam[i] = bus.vtRom[int(offset + i)];
				}
			}
		}
		// 写入
		public function write(addr:int,src:int):void{
		}
	}
}