﻿package com.fc
{
	public class PPU extends Node{
	/** I/0 register
	---------------------------*/
		// ------------ 2000
		/* bit2 */		private var nOffset32:int;			// nt_addr offset value(递增地址数量标志)
		/* bit3 */		private var nSPHeadAddr:int;		// sprite head adderess - 0:0x0000,1:0x1000(图形的起始地址)
		/* bit4 */		private var nBGHeadAddr:int;		// background head address - 0:0x0000,1:0x1000(背景的起始地址)
		/* bit5 */		private var b8x16:Boolean;			// big sprite flag - 0:8*8 sprite,1:8*16 sprite(大图形标志)
		/* bit7 */		private var bNMI:Boolean;			// NMI flag - 0:on,1:off(NMI中断标志)
						public var nENC:int;				// spend time that enter NMI interrupt 7cc(进入中断花费的时间)
		// ------------ 2001
		/* bit0 */		private var bBWColor:Boolean;		// [no uesd]		- 黑白色标志 - 0:彩色;1:黑白色
		/* bit1 */		private var bBgL1Col:Boolean;		// [no uesd]		- 显示背景左1列标志 - 0:不显示;1:显示
		/* bit2 */		private var bSpL1Col:Boolean;		// [no uesd]		- 显示图形左1列标志 - 0:不显示;1:显示
		/* bit3 */		private var bHideBG:Boolean;		// hide background	- 显示背景标志 - 0:不显示;1:显示
		/* bit4 */		private var bHideSP:Boolean;		// hide sprite		- 显示图形标志 - 0:不显示;1:显示
		/* point[5-7] */private var nLightness:int;			// [no uesd]
		// ------------ 2002
		/* bit4 */		private var bIgnoreWrite:Boolean;	// [no uesd]		- 忽略写入VRAM标志
		/* bit5 */		private var bMore8Sprite:Boolean;	// [no uesd]		- 扫描超过8个图形标志
		/* bit6 */		private var bHit:Boolean;			// hit flag			- 碰撞检测标志
		/* bit7 */		private var bVBlank:Boolean;		// VBlank Flag		- VBlank标志
		// ------------ 2003
						private var nReg2003:int;
		// ------------ 2005 & 2006共享标志
						private var bToggle:Boolean;
		// ------------ 2006
						private var nReg2006:int;			// Counter			- 计数器
		// ------------ 2007
						private var nReadBuffer:int;		// VRAM read buffer,first read $2007 is invalid(under 0x3000)
															// VRAM读取缓冲区,第一次读2007是无效的(0x3000以下地址)

	/** register
	---------------------------*/
		private var nRegTemp:int;	// temporary register			- 临时寄存器
		
		private var FV:int;			// fine vertical				- 精确垂直偏移
		private var VT:int;			// vertical tile index			- 垂直Tile索引
		private var HT:int;			// horizontal tile index		- 水平Tile索引
		private var V:int;			// vertical table index			- 垂直表索引
		private var H:int;			// horizontal table index		- 水平表索引
		private var VH:int;

		private var FH:int;			// fine horizontal				- 精确水平偏移
		//private var S:int;		// 背景图案表索引(nBGHeadAddr代替)
		//private var PAR:int;		// 图片地址寄存器
		//private var AR:int;		// 调色板选择器
		
	/** public variant
	---------------------------*/
		public var vtVRam:Vector.<int>;					// PPU's memory,somrwhere are mapping(PPU内存,某些地址为映射地址)
		public var vtSpRAM:Vector.<int>;				// Sprite RAM(256 bytes,64 sprites)
		public var vtIMG:Vector.<uint>;					// bitmap of output image(输出的位图图像)
		public var nFrameCount:int;
				
	/** private variant
	---------------------------*/
		private var vtBG:Vector.<int>;					// bitmap of background 			- 背景矩阵点
		private var vtSM_0:Vector.<int>;				// Matrix Mapping 0					- 方块索引转换属性表位的映射表0
		private var vtSM_1:Vector.<int>;				// Matrix Mapping 1					- 方块索引转换属性表位的映射表1
		private var nScanline:int;						// Current Scan   Line				- 当前扫描线
		private var nRenderLine:int;					// Cureent Render Line				- 当前渲染线
		private var bForcedVBlank:Boolean;				// Forced VBlank					- 强制VBlank模式
		private var vtSprite0:Vector.<int>;				// Sprite 0 graphics,used in hit	- Sprite 0的图形,用在碰撞上
		
	/** 局部变量(提到全局变量以提速)
	---------------------------*/
		// coordinate(坐标)
		private var topX:int;
		private var topY:int;
		private var sp_H:int;
		private var sp0_Y:int;
		private var sp0_X:int;
		// name table(命名表)
		private var nt_addr:int;
		// attribute table(属性表)
		private var groupRow:int;
		private var squareRow:int;
		private var sq_index:int;
		private var at_addr:int;
		private var at_data:int;
		// pattern table(图案表)
		private var pt_addr:int;
		private var pt0_data:int;
		private var pt1_data:int;
		// point attribute(绘点属性)
		private var point:int;
		private var point_row:int;
		private var l_bit_pal:int;			// lower image palette address
		private var u_bit_pal:int;			// upper image palette address
		private var pal_index:int;			// image palette address
		private var pal_data:uint;			// image palette value
		// Sprite
		private var pt0_row:int;
		private var pt1_row:int;
		private var pt0_vt:Vector.<int>;
		private var pt1_vt:Vector.<int>;
		
		private var pt_index:int;
		private var sp_at:int;
		private var bFG:Boolean;
		private var bFlipH:Boolean;
		private var bFlipV:Boolean;
		private var bg_point:int;
				
		private var fitX:int;
		private var fitY:int;
		
		private var bitX:int;
		private var bitY:int;
		
	/** construction
	---------------------------*/
		public function PPU():void{
		//----------------------------------------------------
			nOffset32 = 0;
			nSPHeadAddr = 0;
			nBGHeadAddr = 0;
			b8x16 = false;
			bNMI = false;
			nENC = 0;
			bBWColor = false;
			bBgL1Col = false;
			bSpL1Col = false;
			bHideBG = true;
			bHideSP = true;
			nLightness = 0;
			bIgnoreWrite = false;
			bMore8Sprite = false;
			bHit = false;
			bVBlank = false;
			nReg2003 = 0;
			bToggle = false;
			nReg2006 = 0;
			nReadBuffer = 0;
		//----------------------------------------------------
			nRegTemp = 0;
			FV = 0;
			VT = 0;
			HT = 0;
			FH = 0;
			V = 0;
			H = 0;
			VH = 0;
		//----------------------------------------------------
			vtVRam = new Vector.<int>(0x10000);
			vtSpRAM = new Vector.<int>(0x100);
			vtIMG = new Vector.<uint>(256 * 240);
		//----------------------------------------------------
			vtBG= new Vector.<int>(256 * 240);
			vtSM_0 = new Vector.<int>();
			vtSM_0.push(
				0x03,0x03,0x0C,0x0C,
				0x03,0x03,0x0C,0x0C,
				0x30,0x30,0xC0,0xC0,
				0x30,0x30,0xC0,0xC0);
			vtSM_1 = new Vector.<int>();
			vtSM_1.push(
				0,0,2,2,
				0,0,2,2,
				4,4,6,6,
				4,4,6,6);
			nScanline = 0;
			nRenderLine = 0;
			bForcedVBlank = false;
			vtSprite0 = new Vector.<int>(0x80);
		//----------------------------------------------------
			topX = 0;
			topY = 0;
			sp_H = 0;
			sp0_Y = 0;
			sp0_X = 0;
			nt_addr = 0;
			groupRow = 0;
			squareRow = 0;
			sq_index = 0;
			at_addr = 0;
			at_data = 0;
			pt_addr = 0;
			pt0_data = 0;
			pt1_data = 0;
			point = 0;
			point_row = 0;
			l_bit_pal = 0;
			u_bit_pal = 0;
			pal_index = 0;
			pal_data = 0;
			pt0_row = 0;
			pt1_row = 0;
			pt0_vt = new Vector.<int>(16);
			pt1_vt = new Vector.<int>(16);
			pt_index = 0;
			sp_at = 0;
			bFG = false;
			bFlipH = false;
			bFlipV = false;
			bg_point = 0;
			fitX = 0;
			fitY = 0;
			bitX = 0;
			bitY = 0;
		}
		// render line(return next scanline number)
		// 渲染线(返回下条扫描线行号)
		public function renderLine():int{
			if(nScanline == 0){								// initial render line(渲染初始化线)
				// 1.set flag(设置标志)
				bVBlank = false;
				bHit = false;
				bMore8Sprite = false;
				// 2.update counter(更新计数器)
				if(!bHideBG || !bHideSP){
					nReg2006 = nRegTemp;
				}
				renderSprite0();
			}
			else if(nScanline >= 1 && nScanline <= 240){	// render line(渲染线)
				// both of bHideBG and bHideSP are true,then enter VBlank mode(两者都隐藏的话,进入'被迫VBlank'模式)
				if(bHideBG && bHideSP){
					renderBGColor();
					bForcedVBlank = true;
				}
				else if(bHideBG){
					renderBGColor();
				}
				else{
					if(bForcedVBlank){
						nReg2006 = nRegTemp;
						bForcedVBlank = false;
					}
					renderBG();
				}
			}
			else if(nScanline == 241){						// end render line(渲染结束线)
				if(!bHideSP){
					renderSprite();
				}
				// 1.set flag(设置标志)
				bVBlank = true;
				// 2.create a interrupt(产生中断)
				if(bNMI){
					nENC = 7; // enter NMI must spend 7 cc
				}
			}
			else if(nScanline == 261){						// end frame line(帧结束线)
				nScanline = -1;
				nFrameCount += 1;
			}
			// increase line(递增扫描线)
			nScanline += 1;
			return nScanline;
		}
		private function renderBGColor():void{
			nRenderLine = nScanline - 1;
			point_row = nRenderLine * 256;
			var bgColor:int = bus.curPAL[int(vtVRam[0x3F00])];
			for(var i:int = 0;i < 256;i+=1){
				point = point_row + i;
				vtIMG[point] = bgColor;
				vtBG[point] = 0;
			}
		}
		private function renderBG():void{
			nRenderLine = nScanline - 1;
			// parse counter(分解计数器)
			FV = (nReg2006 & 0x7000) >> 12;
			V  = (nReg2006 & 0x0800) >> 11;
			H  = (nReg2006 & 0x0400) >> 10;
			VT = (nReg2006 & 0x03E0) >> 5;
			HT = nReg2006 & 0x001F;
			// update counter(更新计数器)
			H  = (nRegTemp & 0x0400) >> 10;
			HT = nRegTemp & 0x001F;
			// initialize variable(初始化变量)
			groupRow = (VT >> 2) * 8;			// Tile所在的4*4 组
			squareRow =(VT & 0x03) * 4;			// Tile所在的2*2方块
			point_row = nRenderLine * 256;		// 位行
			var fineX:int = FH;
			var XRenderPoint:int = 0;			// X渲染点
			// draw tile(渲染tile)
			for(var times:int = 0;times < 33;times += 1){
				VH = int((V << 11) + (H << 10)) + 0x2000;
				// 1.get name table(获取命名表)
				nt_addr = int(VH + HT) + (VT << 5);
				// 2.get attribute table(获取属性表)
				at_addr = int(VH + 0x3C0) + int(groupRow + (HT >> 2));
				// 3.get pattern table(获取命名表值=图案表)
				pt_addr = (vtVRam[nt_addr] << 4) + int(nBGHeadAddr + FV);
				// 4.get tile index(获取Tile对应的方块索引)
				sq_index = squareRow + (HT & 0x03);
				// 5.get upper 2 bits of palette(获取高2位调色板值)
				u_bit_pal = (vtVRam[at_addr] & vtSM_0[sq_index]) >> vtSM_1[sq_index];
				// 6.get character matrix(获取字模矩阵)
				pt0_data = vtVRam[pt_addr];	pt1_data = vtVRam[int(pt_addr + 8)];
				// 7.get draw point position(生成渲染起点)
				point = point_row + XRenderPoint;
				// 8.get render X(渲染X轴像素)
				for(;fineX < 8;fineX += 1){
					// 1.get lower 2 bits of palette(获取低2位调色板值/也是背景矩阵/00为背景色板)
					l_bit_pal = ((pt1_data & 0x80 >> fineX) << 1 | (pt0_data & 0x80 >> fineX)) >> (7 - fineX);
					// 2.get color of palette(获取调色板颜色)
					pal_data = vtVRam[int(0x3F00 + (u_bit_pal << 2 | l_bit_pal))];
					// 3.save point of infomation(保存点信息)
					vtIMG[point] = bus.curPAL[pal_data];
					vtBG[point] = l_bit_pal;			// used in hit(保存背景矩阵以用作与Sprite做碰撞测试)
					// 4.move to next render point(偏移下个渲染点)
					point += 1;
					XRenderPoint += 1;
					if(XRenderPoint >= 256){				// 256个点
						times = 1000;
						break;
					}
				}
				// reset fine X
				fineX = 0;
				// update HT、H
				HT += 1;
				HT &= 31;
				if(!HT){ H ^= 1; }
			}
			// update FV、VT、V
			FV += 1;
			FV &= 7;
			if(!FV){
				VT += 1;
				// Tile Y只有30行，索引0开始到29
				if(VT == 30){ VT = 0; V  ^= 1;}
				// 从30开始的值只递增不翻转V
				else if(VT == 32){ VT = 0;}
			}
			// update counter(更新计数器)
			nReg2006 = (FV << 12) + (V << 11) + (H << 10) + (VT << 5) + HT;
			// hit test(碰撞测试)
			if(!bHit && nRenderLine < int(sp0_Y + sp_H) && nRenderLine >= sp0_Y){
				for(XRenderPoint = 0;XRenderPoint < 256;XRenderPoint += 1){
					if(XRenderPoint >= int(sp0_X + 8)){
						break;
					}
					if(XRenderPoint >= sp0_X){
						if(vtSprite0[int(int(nRenderLine - sp0_Y << 3) + int(XRenderPoint - sp0_X))] != 0 && vtIMG[int(point_row + XRenderPoint)] != 0){
							bHit = true;
							break;
						}
					}
				}
			}
		}
		// render Sprite 0 for hit(渲染Sprite 0为了碰撞)
		private function renderSprite0():void{
			// 1.get infomation(获取信息)
			sp0_Y    = vtSpRAM[0];
			pt_index = vtSpRAM[1];
			sp_at	 = vtSpRAM[2];
			sp0_X	 = vtSpRAM[3];
			sp_H	 = 1 << 3 + int(b8x16);
			// 2.parse attribute(分析属性)
			u_bit_pal = sp_at & 0x03;
			bFG    = !(sp_at & 0x20);		// foreground
			bFlipH    = Boolean(sp_at & 0x40);
			bFlipV    = Boolean(sp_at & 0x80);
			if(b8x16){
				if((pt_index & 1) == 0){	//even number(偶数)
					// 1.get pattern table(获取图案表)
					pt_addr = pt_index << 4;
					// 2.get matrix(获取矩阵)
					pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
					pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
					pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
					pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
					pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
					pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
					pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
					pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
					pt0_vt[0x8] = vtVRam[int(pt_addr + 0x10)];pt1_vt[0x8] = vtVRam[int(pt_addr + 0x18)];
					pt0_vt[0x9] = vtVRam[int(pt_addr + 0x11)];pt1_vt[0x9] = vtVRam[int(pt_addr + 0x19)];
					pt0_vt[0xA] = vtVRam[int(pt_addr + 0x12)];pt1_vt[0xA] = vtVRam[int(pt_addr + 0x1A)];
					pt0_vt[0xB] = vtVRam[int(pt_addr + 0x13)];pt1_vt[0xB] = vtVRam[int(pt_addr + 0x1B)];
					pt0_vt[0xC] = vtVRam[int(pt_addr + 0x14)];pt1_vt[0xC] = vtVRam[int(pt_addr + 0x1C)];
					pt0_vt[0xD] = vtVRam[int(pt_addr + 0x15)];pt1_vt[0xD] = vtVRam[int(pt_addr + 0x1D)];
					pt0_vt[0xE] = vtVRam[int(pt_addr + 0x16)];pt1_vt[0xE] = vtVRam[int(pt_addr + 0x1E)];
					pt0_vt[0xF] = vtVRam[int(pt_addr + 0x17)];pt1_vt[0xF] = vtVRam[int(pt_addr + 0x1F)];
				}
				else{						// odd number(奇数)
					// 1.get pattern table(获取图案表)
					pt_addr = 0x1000 + ((pt_index & 0xFE) << 4);
					// 2.get matrix(获取矩阵)
					pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
					pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
					pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
					pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
					pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
					pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
					pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
					pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
					pt0_vt[0x8] = vtVRam[int(pt_addr + 0x10)];pt1_vt[0x8] = vtVRam[int(pt_addr + 0x18)];
					pt0_vt[0x9] = vtVRam[int(pt_addr + 0x11)];pt1_vt[0x9] = vtVRam[int(pt_addr + 0x19)];
					pt0_vt[0xA] = vtVRam[int(pt_addr + 0x12)];pt1_vt[0xA] = vtVRam[int(pt_addr + 0x1A)];
					pt0_vt[0xB] = vtVRam[int(pt_addr + 0x13)];pt1_vt[0xB] = vtVRam[int(pt_addr + 0x1B)];
					pt0_vt[0xC] = vtVRam[int(pt_addr + 0x14)];pt1_vt[0xC] = vtVRam[int(pt_addr + 0x1C)];
					pt0_vt[0xD] = vtVRam[int(pt_addr + 0x15)];pt1_vt[0xD] = vtVRam[int(pt_addr + 0x1D)];
					pt0_vt[0xE] = vtVRam[int(pt_addr + 0x16)];pt1_vt[0xE] = vtVRam[int(pt_addr + 0x1E)];
					pt0_vt[0xF] = vtVRam[int(pt_addr + 0x17)];pt1_vt[0xF] = vtVRam[int(pt_addr + 0x1F)];
				}
			}
			else{
				// 1.get pattern table(获取图案表)
				pt_addr = nSPHeadAddr + (pt_index << 4);
				// 2.get matrix(获取矩阵)
				pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
				pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
				pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
				pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
				pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
				pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
				pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
				pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
			}
			// 3.render(渲染)
			for(var spY:int = 0;spY < sp_H;spY+=1){						// offset Y				- Y偏移点
				bFlipV ? fitY = int(sp_H - 1) - spY : fitY = spY;		// flip vertical		- 垂直翻转
				pt0_row = pt0_vt[fitY];									// 对应字模0
				pt1_row = pt1_vt[fitY];									// 对应字模1
				for(var spX:int = 0;spX < 8;spX+=1){					// offset X				- X偏移点
					bFlipH ? fitX = 7 - spX : fitX = spX;				// flip horizintal		- 水平翻转
					point = spY * 8 + spX;								// current render point - 当前渲染点
					l_bit_pal = ((pt1_row & 0x80 >> fitX) << 1 | (pt0_row & 0x80 >> fitX)) >> (7 - fitX);
					vtSprite0[point] = l_bit_pal;
				}
			}
		}
		private function renderSprite():void{
			// 从Sprite 63开始绘起
			for(var index:int = 252;index >= 0;index -= 4){
				// 1.get infomation(获取信息)
				topY     = vtSpRAM[index];
				pt_index = vtSpRAM[int(index + 1)];
				sp_at	 = vtSpRAM[int(index + 2)];
				topX	 = vtSpRAM[int(index + 3)];
				sp_H	 = 1 << 3 + int(b8x16);
				// 2.parse attribute(分析属性)
				u_bit_pal = sp_at & 0x03;
				bFG    = !(sp_at & 0x20);		// foreground
				bFlipH    = Boolean(sp_at & 0x40);
				bFlipV    = Boolean(sp_at & 0x80);
				if(b8x16){
					if((pt_index & 1) == 0){	//even number(偶数)
						// 1.get pattern table(获取图案表)
						pt_addr = pt_index << 4;
						// 2.get matrix(获取矩阵)
						pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
						pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
						pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
						pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
						pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
						pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
						pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
						pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
						pt0_vt[0x8] = vtVRam[int(pt_addr + 0x10)];pt1_vt[0x8] = vtVRam[int(pt_addr + 0x18)];
						pt0_vt[0x9] = vtVRam[int(pt_addr + 0x11)];pt1_vt[0x9] = vtVRam[int(pt_addr + 0x19)];
						pt0_vt[0xA] = vtVRam[int(pt_addr + 0x12)];pt1_vt[0xA] = vtVRam[int(pt_addr + 0x1A)];
						pt0_vt[0xB] = vtVRam[int(pt_addr + 0x13)];pt1_vt[0xB] = vtVRam[int(pt_addr + 0x1B)];
						pt0_vt[0xC] = vtVRam[int(pt_addr + 0x14)];pt1_vt[0xC] = vtVRam[int(pt_addr + 0x1C)];
						pt0_vt[0xD] = vtVRam[int(pt_addr + 0x15)];pt1_vt[0xD] = vtVRam[int(pt_addr + 0x1D)];
						pt0_vt[0xE] = vtVRam[int(pt_addr + 0x16)];pt1_vt[0xE] = vtVRam[int(pt_addr + 0x1E)];
						pt0_vt[0xF] = vtVRam[int(pt_addr + 0x17)];pt1_vt[0xF] = vtVRam[int(pt_addr + 0x1F)];
					}
					else{						// odd number(奇数)
						// 1.get pattern table(获取图案表)
						pt_addr = 0x1000 + ((pt_index & 0xFE) << 4);
						// 2.get matrix(获取矩阵)
						pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
						pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
						pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
						pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
						pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
						pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
						pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
						pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
						pt0_vt[0x8] = vtVRam[int(pt_addr + 0x10)];pt1_vt[0x8] = vtVRam[int(pt_addr + 0x18)];
						pt0_vt[0x9] = vtVRam[int(pt_addr + 0x11)];pt1_vt[0x9] = vtVRam[int(pt_addr + 0x19)];
						pt0_vt[0xA] = vtVRam[int(pt_addr + 0x12)];pt1_vt[0xA] = vtVRam[int(pt_addr + 0x1A)];
						pt0_vt[0xB] = vtVRam[int(pt_addr + 0x13)];pt1_vt[0xB] = vtVRam[int(pt_addr + 0x1B)];
						pt0_vt[0xC] = vtVRam[int(pt_addr + 0x14)];pt1_vt[0xC] = vtVRam[int(pt_addr + 0x1C)];
						pt0_vt[0xD] = vtVRam[int(pt_addr + 0x15)];pt1_vt[0xD] = vtVRam[int(pt_addr + 0x1D)];
						pt0_vt[0xE] = vtVRam[int(pt_addr + 0x16)];pt1_vt[0xE] = vtVRam[int(pt_addr + 0x1E)];
						pt0_vt[0xF] = vtVRam[int(pt_addr + 0x17)];pt1_vt[0xF] = vtVRam[int(pt_addr + 0x1F)];
					}
				}
				else{
					// 1.get pattern table(获取图案表)
					pt_addr = nSPHeadAddr + (pt_index << 4);
					// 2.get matrix(获取矩阵)
					pt0_vt[0x0] = vtVRam[int(pt_addr + 0x00)];pt1_vt[0x0] = vtVRam[int(pt_addr + 0x08)];
					pt0_vt[0x1] = vtVRam[int(pt_addr + 0x01)];pt1_vt[0x1] = vtVRam[int(pt_addr + 0x09)];
					pt0_vt[0x2] = vtVRam[int(pt_addr + 0x02)];pt1_vt[0x2] = vtVRam[int(pt_addr + 0x0A)];
					pt0_vt[0x3] = vtVRam[int(pt_addr + 0x03)];pt1_vt[0x3] = vtVRam[int(pt_addr + 0x0B)];
					pt0_vt[0x4] = vtVRam[int(pt_addr + 0x04)];pt1_vt[0x4] = vtVRam[int(pt_addr + 0x0C)];
					pt0_vt[0x5] = vtVRam[int(pt_addr + 0x05)];pt1_vt[0x5] = vtVRam[int(pt_addr + 0x0D)];
					pt0_vt[0x6] = vtVRam[int(pt_addr + 0x06)];pt1_vt[0x6] = vtVRam[int(pt_addr + 0x0E)];
					pt0_vt[0x7] = vtVRam[int(pt_addr + 0x07)];pt1_vt[0x7] = vtVRam[int(pt_addr + 0x0F)];
				}
				// 3.render(渲染)
				for(var spY:int = 0;spY < sp_H;spY+=1){					// offset Y				- Y偏移点
					bFlipV ? fitY = int(sp_H - 1) - spY : fitY = spY;	// flip vertical		- 垂直翻转
					pt0_row = pt0_vt[fitY];								// 对应字模0
					pt1_row = pt1_vt[fitY];								// 对应字模1
					for(var spX:int = 0;spX < 8;spX+=1){				// offset X				- X偏移点
						bFlipH ? fitX = 7 - spX : fitX = spX;			// flip horizintal		- 水平翻转
						bitY = topY + spY;
						bitX = topX + spX;
						if(bitX >= 256 || bitY >= 240){
							continue;
						}
						l_bit_pal = ((pt1_row & 0x80 >> fitX) << 1 | (pt0_row & 0x80 >> fitX)) >> (7 - fitX);
						// dont render transparent point(不渲染透明点)
						if(l_bit_pal == 0){
							continue;
						}
						point = int(bitY * 256) + bitX;					// current render point - 当前渲染点
						bg_point = vtBG[point];							// 对应的背景点
						// if it is in foreground and isnt transparent(如果在前景或背景为透明的话)
						if(bFG || bg_point == 0){
							pal_index = u_bit_pal << 2 | l_bit_pal;		// make color index		- 生成颜色索引
							pal_data = vtVRam[int(0x3F10 + pal_index)];
							vtIMG[point] = bus.curPAL[pal_data];		// save ponit(保存点)
						}
					}
				}
			}
		}
		// read data
		public function r2(address:int):int{
			//inline:return PPU_r2(address);#
			var value:int = 0;
			if(address == 0x2002){					// PPU status	- PPU状态
				value = int(bVBlank) << 7 | int(bHit) << 6 | int(bMore8Sprite) << 5 | int(bIgnoreWrite) << 4;
				bVBlank = false;
				bToggle = false;
			}
			else if(address == 0x2007){				// VRAM data	- VRAM 数据
				if(nReg2006 >= 0x3F20){
					trace('PPU read 0x3F20');
				}
				else if(nReg2006 >= 0x3F00){
					value = vtVRam[nReg2006];
				}
				else if(nReg2006 >= 0x3000){
					trace('PPU read 0x3000');
				}
				else{
					value = nReadBuffer;
					nReadBuffer = vtVRam[nReg2006];
				}
				// move to next position(移动下个位置)
				nReg2006 += 1 + int(nOffset32 * 31);
				nReg2006 &= 0xFFFF;
			}
			else if(address == 0x2004){
				value = vtVRam[nReg2003];
				nReg2003 += 1;
				nReg2003 &= 0xFF;
			}
			else{
				trace('unknown PPU read',address);
			}
			return value;
			//inline#
		}
		// write data
		public function w2(address:int,value:int):void{
			//inline:PPU_w2(address,value);#
			if(address == 0x2007){					// VRAM data	- VRAM 数据
				if(nReg2006 >= 0x3F20){
					trace('PPU write 0x3F20');
				}
				else if(nReg2006 >= 0x3F00){
					if(nReg2006 % 0x10 == 0){		// 0x3F00 or 0x3F10
						var t:int = (value & 0x3F);
						vtVRam[0x3F00] = t;
						vtVRam[0x3F04] = t;
						vtVRam[0x3F08] = t;
						vtVRam[0x3F0C] = t;
						vtVRam[0x3F10] = t;
						vtVRam[0x3F14] = t;
						vtVRam[0x3F18] = t;
						vtVRam[0x3F1C] = t;
					}
					else if(nReg2006 % 0x04 != 0){	// invalid write in 0x3F04|0x3F08|0x3F0C|0x3F14|0x3F18|0x3F1C(写入无效)
						vtVRam[nReg2006] = (value & 0x3F);
					}
				}
				else if(nReg2006 >= 0x3000){
					trace('PPU write 0x3000',nScanline);
				}
				else if(nReg2006 >= 0x2000){
					if(bus.bMirror_S){
						vtVRam[int(0x2000 + (nReg2006 & 0x3FF))] = value;
						vtVRam[int(0x2400 + (nReg2006 & 0x3FF))] = value;
						vtVRam[int(0x2800 + (nReg2006 & 0x3FF))] = value;
						vtVRam[int(0x2C00 + (nReg2006 & 0x3FF))] = value;
					}
					else if(bus.bMirror_F){
						vtVRam[nReg2006] = value;
					}
					else if(nReg2006 >= 0x2C00){
						vtVRam[nReg2006] = value;
						if(bus.bMirror_V){	vtVRam[int(nReg2006 - 0x0800)] = value; }
						else{				vtVRam[int(nReg2006 - 0x0400)] = value; }
					}
					else if(nReg2006 >= 0x2800){
						vtVRam[nReg2006] = value;
						if(bus.bMirror_V){	vtVRam[int(nReg2006 - 0x0800)] = value; }
						else{				vtVRam[int(nReg2006 + 0x0400)] = value; }
					}
					else if(nReg2006 >= 0x2400){
						vtVRam[nReg2006] = value;
						if(bus.bMirror_V){	vtVRam[int(nReg2006 + 0x0800)] = value; }
						else{				vtVRam[int(nReg2006 - 0x0400)] = value; }
					}
					else if(nReg2006 >= 0x2000){
						vtVRam[nReg2006] = value;
						if(bus.bMirror_V){	vtVRam[int(nReg2006 + 0x0800)] = value; }
						else{				vtVRam[int(nReg2006 + 0x0400)] = value; }
					}
				}
				else{
					vtVRam[nReg2006] = value;
				}
				// move to next position(移动下个位置)
				nReg2006 += 1 + int(nOffset32 * 31);
				nReg2006 &= 0xFFFF;
			}
			else if(address == 0x2006){					// VRAM address				- VRAM地址
				if(bToggle){							// lower,second time		- 低位,第二次
					nRegTemp &= 0x7F00;					// cleare data				- 清数据
					nRegTemp |= value;
					nReg2006 = nRegTemp;
				}
				else{									// upper,first time			- 高位,第一次
					nRegTemp &= 0x00FF;					// cleare data				- 清数据
					nRegTemp |= (value & 0x3F) << 8;
				}
				bToggle = !bToggle;						// toggle switch			- 切换开关
			}
			else if(address == 0x2005){					// VRAM address				- VRAM地址
    			if(bToggle){							// Y,second time			- Y值,第二次
    				nRegTemp &= 0xC1F;					// cleare data				- 清数据
    				nRegTemp |= (value & 0xF8) << 2;	// Tile Y
    				nRegTemp |= (value & 0x7) << 12;	// Fine Y
    			}
    			else{									// X,first time				- X值,第一次
    				nRegTemp &= 0xFFE0;					// cleare data				- 清数据
    				nRegTemp |= value >> 3;				// Tile X
    				FH = value & 0x7;					// Fine X
    			}
				bToggle = !bToggle;						// toggle switch			- 切换开关
			}
			else if(address == 0x2004){					// Spirte RAM address
				vtSpRAM[nReg2003] = value;
				nReg2003 += 1;
				nReg2003 &= 0xFF;
			}
			else if(address == 0x2003){					// Spirte RAM data
				nReg2003 = value;
			}
			else if(address == 0x2001){					// control register 2		- 控制寄存器2
				bBWColor = Boolean(value & 0x01);
				bBgL1Col = Boolean(value & 0x02);
				bSpL1Col = Boolean(value & 0x04);
				bHideBG = !(value & 0x08);
				bHideSP = !(value & 0x10);
				nLightness = (value & 0xE0) >> 5;
				//trace(bSpL1Col,bBgL1Col);
			}
			else if(address == 0x2000){					// control register 1		- 控制寄存器2
				nRegTemp &= 0xF3FF;						// cleare data				- 清数据
				nRegTemp |= (value & 0x03) << 10;
				nOffset32 = (value & 0x4) >> 2;
				nSPHeadAddr = (value & 0x08) && 0x1000;
				nBGHeadAddr = (value & 0x10) && 0x1000;
				b8x16 = Boolean(value & 0x20);
				bNMI = Boolean(value & 0x80);
			}
			else{
				trace('unknown PPU write',address);
			}
			//inline#
		}
	}
}