###########################################################################
#
#   tinycdi.mak
#
#   tinycdi target makefile
#
###########################################################################


#-------------------------------------------------
# tinycdi core defines
#-------------------------------------------------

COREDEFS += -DTINYCDI

# add some additional include libraries for the mame files
CFLAGS += \
	-I$(SRC)/mame \
	-I$(SRC)/mame/includes

# Root object directories
MAMESRC = $(SRC)/mame
MAMEOBJ = $(OBJ)/mame
tinycdiSRC = $(SRC)/tinycdi
tinycdiOBJ = $(OBJ)/tinycdi
EMUSRC = $(SRC)/emu
EMUOBJ = $(OBJ)/emu

# MAME directories
EMU_AUDIO = $(EMUOBJ)/audio
EMU_MACHINE = $(EMUOBJ)/machine
EMU_VIDEO = $(EMUOBJ)/video
MAME_AUDIO = $(MAMEOBJ)/audio
MAME_MACHINE = $(MAMEOBJ)/machine
MAME_DRIVERS = $(MAMEOBJ)/drivers
MAME_VIDEO = $(MAMEOBJ)/video

# tinycdi directories
tinycdi_DRIVERS = $(tinycdiOBJ)/drivers

OBJDIRS += \
	$(EMU_AUDIO) \
	$(EMU_MACHINE) \
	$(EMU_VIDEO) \
	$(MAME_AUDIO) \
	$(MAME_DRIVERS) \
	$(MAME_LAYOUT) \
	$(MAME_MACHINE) \
	$(MAME_VIDEO) \
	$(tinycdi_DRIVERS) \


#-------------------------------------------------
# specify available CPU cores
#-------------------------------------------------

CPUS += Z80
#CPUS += Z180
#CPUS += I8085
#CPUS += M6502
#CPUS += H6280
#CPUS += I86
#CPUS += I386
#CPUS += NEC
#CPUS += V30MZ
#CPUS += V60
CPUS += MCS48
#CPUS += MCS51
#CPUS += M6800
#CPUS += M6805
#CPUS += HD6309
#CPUS += M6809
#CPUS += KONAMI
CPUS += M680X0
#CPUS += T11
#CPUS += S2650
#CPUS += TMS340X0
#CPUS += TMS9900
#CPUS += Z8000
#CPUS += TMS32010
#CPUS += TMS32025
#CPUS += TMS32031
#CPUS += TMS32051
#CPUS += TMS57002
#CPUS += CCPU
#CPUS += ADSP21XX
#CPUS += ASAP
#CPUS += UPD7810
#CPUS += ARM
#CPUS += ARM7
#CPUS += JAGUAR
#CPUS += CUBEQCPU
#CPUS += ESRIP
#CPUS += MIPS
#CPUS += SH2
#CPUS += SH4
#CPUS += DSP32C
#CPUS += PIC16C5X
#CPUS += G65816
#CPUS += SPC700
#CPUS += E1
#CPUS += I860
#CPUS += I960
#CPUS += H83002
#CPUS += H83334
#CPUS += V810
#CPUS += M37710
#CPUS += POWERPC
#CPUS += SE3208
#CPUS += MC68HC11
#CPUS += ADSP21062
CPUS += DSP56156
#CPUS += RSP
#CPUS += ALPHA8201
#CPUS += CDP1802
#CPUS += COP400
#CPUS += TLCS90
#CPUS += TLCS900
#CPUS += MB88XX
#CPUS += MB86233
#CPUS += SSP1601
#CPUS += APEXC
#CPUS += CP1610
#CPUS += F8
#CPUS += LH5801
#CPUS += PDP1
#CPUS += SATURN
#CPUS += SC61860
#CPUS += LR35902
#CPUS += TMS7000
#CPUS += SM8500
#CPUS += MINX
#CPUS += SSEM
#CPUS += AVR8
#CPUS += TMS0980
#CPUS += I4004
#CPUS += SUPERFX
#CPUS += Z8


#-------------------------------------------------
# specify available sound cores; some of these are
# only for MAME and so aren't included
#-------------------------------------------------

#SOUNDS += CUSTOM
#SOUNDS += SAMPLES
SOUNDS += DAC
SOUNDS += DMADAC
#SOUNDS += SPEAKER
#SOUNDS += BEEP
#SOUNDS += DISCRETE
#SOUNDS += AY8910
#SOUNDS += YM2151
#SOUNDS += YM2203
#SOUNDS += YM2413
#SOUNDS += YM2608
#SOUNDS += YM2610
#SOUNDS += YM2610B
#SOUNDS += YM2612
#SOUNDS += YM3438
#SOUNDS += YM3812
#SOUNDS += YM3526
#SOUNDS += Y8950
#SOUNDS += YMF262
#SOUNDS += YMF271
#SOUNDS += YMF278B
#SOUNDS += YMZ280B
#SOUNDS += SN76477
#SOUNDS += SN76496
#SOUNDS += POKEY
#SOUNDS += TIA
#SOUNDS += NES
#SOUNDS += ASTROCADE
#SOUNDS += NAMCO
#SOUNDS += NAMCO_15XX
#SOUNDS += NAMCO_CUS30
#SOUNDS += NAMCO_52XX
#SOUNDS += NAMCO_63701X
#SOUNDS += T6W28
#SOUNDS += SNKWAVE
#SOUNDS += C140
#SOUNDS += C352
#SOUNDS += TMS36XX
#SOUNDS += TMS3615
#SOUNDS += TMS5110
#SOUNDS += TMS5220
#SOUNDS += VLM5030
#SOUNDS += ADPCM
#SOUNDS += MSM5205
#SOUNDS += MSM5232
#SOUNDS += OKIM6258
#SOUNDS += OKIM6295
#SOUNDS += OKIM6376
#SOUNDS += UPD7759
#SOUNDS += HC55516
#SOUNDS += K005289
#SOUNDS += K007232
#SOUNDS += K051649
#SOUNDS += K053260
#SOUNDS += K054539
#SOUNDS += SEGAPCM
#SOUNDS += MULTIPCM
#SOUNDS += SCSP
#SOUNDS += AICA
#SOUNDS += RF5C68
#SOUNDS += RF5C400
#SOUNDS += CEM3394
#SOUNDS += QSOUND
#SOUNDS += SAA1099
#SOUNDS += IREMGA20
#SOUNDS += ES5503
#SOUNDS += ES5505
#SOUNDS += ES5506
#SOUNDS += BSMT2000
#SOUNDS += GAELCO_CG1V
#SOUNDS += GAELCO_GAE1
#SOUNDS += C6280
#SOUNDS += SP0250
#SOUNDS += PSXSPU
SOUNDS += CDDA
#SOUNDS += ICS2115
#SOUNDS += ST0016
#SOUNDS += NILE
#SOUNDS += X1_010
#SOUNDS += VRENDER0
#SOUNDS += VOTRAX
#SOUNDS += ES8712
#SOUNDS += CDP1869
#SOUNDS += S14001A
#SOUNDS += WAVE
#SOUNDS += SID6581
#SOUNDS += SID8580
#SOUNDS += SP0256
#SOUNDS += DIGITALKER
#SOUNDS += CDP1863
#SOUNDS += CDP1864
#SOUNDS += SOCRATES
#SOUNDS += TMC0285
#SOUNDS += TMS5200
#SOUNDS += CD2801
#SOUNDS += CD2802
#SOUNDS += M58817
#SOUNDS += TMC0281
#SOUNDS += TMS5100
#SOUNDS += TMS5110A


#-------------------------------------------------
# this is the list of driver libraries that
# comprise tinycdi plus hmd_driv.o which contains
# the list of drivers
#-------------------------------------------------

DRVLIBS = \
	$(tinycdiOBJ)/tcdi_drv.o \
	$(tinycdiOBJ)/tinycdi.a \


#-------------------------------------------------
# manufacturer-specific groupings for drivers
#-------------------------------------------------

$(tinycdiOBJ)/tinycdi.a:	\
	$(tinycdi_DRIVERS)/cdi.o \




