/******************************************************************************

    mamedriv.c

    Copyright Nicola Salmoria and the MAME Team.
    Visit http://mamedev.org for licensing and usage restrictions.

    The list of all available drivers. Drivers have to be included here to be
    recognized by the executable.

    To save some typing, we use a hack here. This file is recursively #included
    twice, with different definitions of the DRIVER() macro. The first one
    declares external references to the drivers; the second one builds an array
    storing all the drivers.

******************************************************************************/

#include "driver.h"

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) GAME_EXTERN(NAME);
#include "tcdi_drv.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#define DRIVER(NAME) &GAME_NAME(NAME),
const game_driver * const drivers[] =
{
#include "tcdi_drv.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */

	DRIVER( 3rddeg )
	DRIVER( affair )
	DRIVER( alice )
	DRIVER( aliengt )
	DRIVER( angedem )
	DRIVER( appren )
	DRIVER( axis )
	DRIVER( batlshp )
	DRIVER( burn )
	DRIVER( caebox )
	DRIVER( caegamb )
	DRIVER( carcclas )
	DRIVER( casterix )
	DRIVER( cbackgam )
	DRIVER( cdimono1 )
	DRIVER( cdiquiz )
	DRIVER( cdomino )
	DRIVER( cdshoot )
	DRIVER( cinca )
	DRIVER( clemming )
	DRIVER( confour )
	DRIVER( cothel )
	DRIVER( ctetris )
	DRIVER( cybercit )
	DRIVER( darkcstl )
	DRIVER( defcrown )
	DRIVER( dimos )
	DRIVER( earth )
	DRIVER( effacer )
	DRIVER( family1 )
	DRIVER( family2 )
	DRIVER( flback )
	DRIVER( girlclub )
	DRIVER( golden1 )
	DRIVER( golden2 )
	DRIVER( greatrac )
	DRIVER( hie )
	DRIVER( hoteleu )
	DRIVER( hotelus )
	DRIVER( inten )
	DRIVER( jeop ) 
	DRIVER( jigsaw )
	DRIVER( jokerjr )
	DRIVER( jokers )
	DRIVER( kether )
	DRIVER( laslords )
	DRIVER( lbounty )
	DRIVER( lingo )
	DRIVER( link )
	DRIVER( lords )
	DRIVER( magerase )
	DRIVER( marcod1 )
	DRIVER( marcod2 )
	DRIVER( megamaze )
	DRIVER( megamazu )
	DRIVER( merlin )
	DRIVER( microm )
	DRIVER( midwayp )
	DRIVER( mmrip )
	DRIVER( myst )
	DRIVER( nfltc ) 
	DRIVER( nfltc94 )
	DRIVER( pacpanic )
	DRIVER( palmopen )
	DRIVER( pinball )
	DRIVER( plunder )
	DRIVER( powerhit )
	DRIVER( remem60 )
	DRIVER( sarchess )
	DRIVER( scotyard )
	DRIVER( secmis )
	DRIVER( shao )
	DRIVER( sprtfrk )
	DRIVER( strikpro )
	DRIVER( strippl )
	DRIVER( strippp )
	DRIVER( tangram )
	DRIVER( texttile )
	DRIVER( ultnoah )
	DRIVER( vegasgl )
	DRIVER( vidspeed )
	DRIVER( voyeur )
	DRIVER( wackmini )
	DRIVER( wbubble )
	DRIVER( wimchal )
	DRIVER( wordplay )
	DRIVER( zelda )
	DRIVER( zeldwand )
	DRIVER( zenith )
	DRIVER( zomb )

	//DRIVER( gose )

#endif	/* DRIVER_RECURSIVE */
