/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AudioVideoEncoder
implements Hardware,
Bus32bit,
Configurable {
    private static final int VIDEO_FPS_REG = 0;
    private static final int AUDIO_ENABLE_REG = 0;
    private static final int AUDIO_SAMPLE_RATE_REG = 1;
    private static final int AUDIO_BIT_LEN_REG = 2;
    private static final int AUDIO_CHANNELS_REG = 3;
    private static final int AUDIO_BUF_POS_REG = 4;
    private ExecutorService audioThreadExecutor;
    private int audioSampleRate;
    private int audioBitLength;
    private int audioChannels;
    private ExecutorService videoThreadExecutor;
    private Component drawSurface;
    private Graphics2D graphics;
    private BufferedImage bufferedImage;
    private int[] convet16to32 = new int[65536];
    private int audioDmaOffset;
    private int videoDmaOffset;
    private Bus32bit video;
    private Bus32bit audio;
    private Hardware rdram;

    public AudioVideoEncoder() {
        this.audioThreadExecutor = Executors.newSingleThreadExecutor();
        this.videoThreadExecutor = Executors.newSingleThreadExecutor();
        int count = 0;
        while (count < 65536) {
            int color32;
            int color16 = count;
            int red = (color16 & 0xF800) >> 11;
            int green = (color16 & 0x7C0) >> 6;
            int blue = (color16 & 0x3E) >> 1;
            int alpha = color16 & 1;
            this.convet16to32[count] = color32 = alpha << 27 | red << 19 | green << 11 | blue << 3;
            ++count;
        }
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.video = (Bus32bit)bus;
                if (this.video == null || this.drawSurface == null) break;
                ((Configurable)this.video).writeConfig("screen", (Object)this.drawSurface);
                this.graphics = (Graphics2D)this.drawSurface.getGraphics();
                break;
            }
            case 1: {
                if (bus == null) {
                    this.audioThreadExecutor.shutdownNow();
                }
                this.audio = (Bus32bit)bus;
                if (this.audio == null) break;
                this.audio.write32bit(1, this.audioSampleRate);
                this.audio.write32bit(2, this.audioBitLength);
                this.audio.write32bit(3, this.audioChannels);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.rdram = bus;
            }
        }
    }

    public void reset() {
    }

    public int read32bit(int reg) {
        switch (reg) {
            case 0: {
                return this.audio != null ? this.audio.read32bit(4) : -1;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg) {
            case 0: {
                if (this.audio == null) break;
                this.audio.write32bit(0, value);
                break;
            }
            case 1: {
                this.audioSampleRate = value;
                if (this.audio == null) break;
                this.audio.write32bit(1, value);
                break;
            }
            case 2: {
                this.audioBitLength = value;
                if (this.audio == null) break;
                this.audio.write32bit(2, value);
                break;
            }
            case 3: {
                this.audioChannels = value;
                if (this.audio == null) break;
                this.audio.write32bit(3, value);
                break;
            }
            case 4: {
                if (value == 0) break;
                this.bufferedImage = new BufferedImage(value, (value >> 2) * 3, 1);
                break;
            }
            case 5: {
                if (this.video == null) break;
                this.video.write32bit(0, value);
                break;
            }
            case 6: {
                this.audioDmaOffset = value;
                break;
            }
            case 7: {
                if (this.audio == null) break;
                this.audioThreadExecutor.execute(new AudioProcessThread((BusDMA)this.rdram, this.audioDmaOffset, value));
                break;
            }
            case 8: {
                this.videoDmaOffset = value;
                break;
            }
            case 9: {
                this.videoThreadExecutor.execute(new VideoProcessThread((BusDMA)this.rdram, this.videoDmaOffset, value));
            }
        }
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("screen")) {
            this.drawSurface = (Component)value;
        }
    }

    public class AudioProcessThread
    implements Runnable {
        ByteBuffer buff;

        public AudioProcessThread(BusDMA source, int offset, int length) {
            this.buff = ByteBuffer.allocate(length);
            source.readDMA(offset, this.buff, 0, length);
        }

        @Override
        public void run() {
            ((BusDMA)AudioVideoEncoder.this.audio).writeDMA(0, this.buff, 0, this.buff.array().length);
        }
    }

    public class VideoProcessThread
    implements Runnable {
        byte[] buffer;
        ByteBuffer buff;

        public VideoProcessThread(BusDMA source, int offset, int length) {
            this.buff = ByteBuffer.allocate(length);
            this.buffer = this.buff.array();
            source.readDMA(offset, this.buff, 0, length);
        }

        @Override
        public void run() {
            if (AudioVideoEncoder.this.bufferedImage == null || AudioVideoEncoder.this.graphics == null) {
                return;
            }
            int w = (int)Math.sqrt((this.buffer.length << 1) / 3);
            int h = (w >> 2) * 3;
            int offset = 0;
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    AudioVideoEncoder.this.bufferedImage.setRGB(x + 1, y, AudioVideoEncoder.this.convet16to32[(this.buffer[offset] & 0xFF) << 8 | this.buffer[offset + 1] & 0xFF]);
                    AudioVideoEncoder.this.bufferedImage.setRGB(x, y, AudioVideoEncoder.this.convet16to32[(this.buffer[offset + 2] & 0xFF) << 8 | this.buffer[offset + 3] & 0xFF]);
                    offset += 4;
                    x += 2;
                }
                ++y;
            }
            AudioVideoEncoder.this.graphics.drawImage((Image)AudioVideoEncoder.this.bufferedImage, 0, 0, null);
        }
    }
}

