/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.cartridge;

import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CartRom
implements Hardware,
Bus8bit,
Bus32bit,
BusDMA,
Configurable {
    private boolean debug;
    private static final int BUFFER = 2048;
    private Hardware sram;
    private Bus32bit flashRam;
    private ByteBuffer rom;
    private boolean writtenToRom;
    private int wroteToRom;
    private boolean flashRamUsed;

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.sram = bus;
                break;
            }
            case 1: {
                this.flashRam = (Bus32bit)bus;
            }
        }
    }

    public void reset() {
        if (this.sram != null) {
            this.sram.reset();
        }
        if (this.flashRam != null) {
            ((Hardware)this.flashRam).reset();
        }
    }

    public Object readConfig(String key) {
        if (key.equals("cic")) {
            return this.rom == null ? 0 : this.getCicChipID();
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("romfile")) {
            this.rom = this.loadDataFromRomFile((String)value);
        } else if (key.equals("debug")) {
            this.debug = (Boolean)value;
        }
    }

    public byte read8bit(int pAddr) {
        if (this.rom == null) {
            System.err.println("ROM loadByte: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0x1000000) {
            System.err.println("ROM loadByte Domain 2 Address 1: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0x3000000) {
            System.err.println("ROM loadByte Domain 1 Address 1: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0xB000000) {
            System.err.println("ROM loadByte Domain 2 Address 2: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0x11000000) {
            if (this.writtenToRom) {
                System.err.println("Illegal LB: writtenToRom");
                return 0;
            }
            if (pAddr - 0xB000000 < this.rom.capacity()) {
                return this.rom.get(pAddr - 0xB000000);
            }
            return 0;
        }
        System.err.println("ROM loadByte: " + Integer.toHexString(pAddr));
        return 0;
    }

    public int read32bit(int pAddr) {
        if (this.rom == null) {
            System.err.println("ROM loadWord: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0x1000000) {
            return (pAddr & 0xFFFF) << 16 | pAddr & 0xFFFF;
        }
        if (pAddr < 0x3000000) {
            System.err.println("ROM loadWord Domain 1 Address 1: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr < 0xB000000) {
            this.flashRamUsed = true;
            return this.flashRam.read32bit(pAddr - 0x3000000 >> 2);
        }
        if (pAddr < 0x11000000) {
            if (this.writtenToRom) {
                this.writtenToRom = false;
                return this.wroteToRom;
            }
            if (pAddr - 0xB000000 < this.rom.capacity()) {
                return this.rom.getInt(pAddr - 0xB000000);
            }
            return (pAddr & 0xFFFF) << 16 | pAddr & 0xFFFF;
        }
        System.err.println("ROM loadWord: " + Integer.toHexString(pAddr));
        return 0;
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.rom == null) {
            System.err.println("ROM loadByteDma: " + Integer.toHexString(pAddr));
            return;
        }
        if (pAddr >= 0x3000000 && pAddr <= 0x3010000) {
            if (this.flashRamUsed) {
                ((BusDMA)this.flashRam).readDMA(pAddr - 0x3000000, dma, offset, length);
            } else {
                ((BusDMA)this.sram).readDMA(pAddr - 0x3000000, dma, offset, length);
            }
            return;
        }
        if (pAddr >= 0xB000000 && pAddr <= 448790527) {
            if (pAddr - 0xB000000 + length < this.rom.capacity()) {
                int i = 0;
                while (i < length) {
                    dma.array()[offset + i] = this.rom.get(pAddr - 0xB000000 + i);
                    ++i;
                }
            } else {
                int partLength = this.rom.capacity() - (pAddr - 0xB000000);
                int i = 0;
                while (i < partLength) {
                    dma.array()[offset + i] = this.rom.get(pAddr - 0xB000000 + i);
                    ++i;
                }
                i = partLength;
                while (i < length - partLength) {
                    dma.array()[offset + i] = 0;
                    ++i;
                }
            }
            return;
        }
        if (this.debug) {
            System.err.printf("PI_DMA_WRITE not in ROM\n", new Object[0]);
        }
    }

    public void write8bit(int pAddr, byte value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write32bit(int pAddr, int value) {
        if (this.rom == null) {
            System.err.println("ROM storeWord: " + Integer.toHexString(pAddr));
            return;
        }
        if (pAddr >= 0x1000000) {
            if (pAddr < 0x3000000) {
                System.err.println("ROM storeWord Domain 1 Address 1: " + Integer.toHexString(pAddr));
                return;
            }
            if (pAddr < 0xB000000) {
                if (pAddr == 0x3010000) {
                    this.flashRamUsed = true;
                }
                this.flashRam.write32bit(pAddr - 0x3000000 >> 2, value);
            } else if (pAddr < 0x11000000) {
                if (pAddr - 0xB000000 < this.rom.capacity()) {
                    this.writtenToRom = true;
                    this.wroteToRom = value;
                } else {
                    System.err.println("Illegal ROM Memory SW: " + Integer.toHexString(pAddr));
                    return;
                }
            }
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.rom == null) {
            System.err.println("ROM storeByteDma: " + Integer.toHexString(pAddr));
            return;
        }
        if (pAddr >= 0x3000000 && pAddr <= 0x3010000) {
            if (this.flashRamUsed) {
                ((BusDMA)this.flashRam).writeDMA(pAddr - 0x3000000, dma, offset, length);
            } else {
                ((BusDMA)this.sram).writeDMA(pAddr - 0x3000000, dma, offset, length);
            }
            return;
        }
        if (this.flashRamUsed) {
            System.err.printf("**** FLashRam DMA Read address %X *****\n", pAddr);
            return;
        }
        System.err.printf("PI_DMA_READ where are you dmaing to ?\n", new Object[0]);
    }

    private int getCicChipID() {
        long crc = 0L;
        int count = 64;
        while (count < 4096) {
            crc += (long)this.rom.getInt(count) & 0xFFFFFFFFL;
            count += 4;
        }
        if (crc == 893395132209L) {
            return 1;
        }
        if (crc == 893275804195L) {
            return 1;
        }
        if (crc == 894825943620L) {
            return 2;
        }
        if (crc == 920356012363L) {
            return 3;
        }
        if (crc == 1212421639830L) {
            return 5;
        }
        if (crc == 922709022080L) {
            return 6;
        }
        return -1;
    }

    private boolean isValidRomImage(ByteBuffer test) {
        if (test.getInt(0) == 1074935680) {
            if (this.debug) {
                System.out.printf("ROM format: 0x40123780\n", new Object[0]);
            }
            return true;
        }
        if (test.getInt(0) == 306217015) {
            if (this.debug) {
                System.out.printf("ROM format: 0x12408037\n", new Object[0]);
            }
            return true;
        }
        if (test.getInt(0) == -2143874496) {
            if (this.debug) {
                System.out.printf("ROM format: 0x80371240\n", new Object[0]);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer loadDataFromRomFile(String fileName) {
        File file = new File(fileName);
        ByteBuffer test = ByteBuffer.allocate(4);
        test.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer tmpData = null;
        int romSize = 0;
        if (file.getName().substring(file.getName().lastIndexOf(46)).equalsIgnoreCase(".zip")) {
            if (this.debug) {
                System.out.println("Opening compressed ROM.");
            }
            try {
                ZipEntry entry;
                boolean foundRom = false;
                FileInputStream fis = new FileInputStream(file);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                block8: while ((entry = zis.getNextEntry()) != null) {
                    byte[] data = new byte[2048];
                    int size = (int)entry.getSize();
                    byte[] tmpbuff = new byte[size];
                    int pos = 0;
                    while (true) {
                        int counter;
                        if ((counter = zis.read(data, 0, 2048)) == -1) {
                            System.arraycopy(tmpbuff, 0, test.array(), 0, 4);
                            if (!this.isValidRomImage(test)) continue block8;
                            romSize = tmpbuff.length;
                            tmpData = ByteBuffer.allocate(romSize);
                            tmpData.order(ByteOrder.LITTLE_ENDIAN);
                            System.arraycopy(tmpbuff, 0, tmpData.array(), 0, romSize);
                            foundRom = true;
                            break block8;
                        }
                        System.arraycopy(data, 0, tmpbuff, pos, counter);
                        pos += counter;
                    }
                }
                zis.close();
                if (!foundRom) {
                    System.err.println("No valid rom image found in zipfile: " + file);
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.debug) {
                System.out.println("Opening UNcompressed ROM.");
            }
            try {
                RandomAccessFile hFile = new RandomAccessFile(file, "r");
                hFile.read(test.array(), 0, 4);
                if (!this.isValidRomImage(test)) {
                    hFile.close();
                    System.err.printf("Not a valid rom image: %X\n", test.getInt(0));
                    return null;
                }
                hFile.seek(0L);
                romSize = (int)hFile.length();
                tmpData = ByteBuffer.allocate(romSize);
                tmpData.order(ByteOrder.LITTLE_ENDIAN);
                hFile.read(tmpData.array());
                hFile.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        byte[] data = tmpData.array();
        switch (tmpData.getInt(0)) {
            case 306217015: {
                int count = 0;
                while (count < romSize) {
                    int n = count;
                    data[n] = (byte)(data[n] ^ data[count + 2]);
                    int n2 = count + 2;
                    data[n2] = (byte)(data[n2] ^ data[count]);
                    int n3 = count;
                    data[n3] = (byte)(data[n3] ^ data[count + 2]);
                    int n4 = count + 1;
                    data[n4] = (byte)(data[n4] ^ data[count + 3]);
                    int n5 = count + 3;
                    data[n5] = (byte)(data[n5] ^ data[count + 1]);
                    int n6 = count + 1;
                    data[n6] = (byte)(data[n6] ^ data[count + 3]);
                    count += 4;
                }
                break;
            }
            case 1074935680: {
                int count = 0;
                while (count < romSize) {
                    int n = count;
                    data[n] = (byte)(data[n] ^ data[count + 3]);
                    int n7 = count + 3;
                    data[n7] = (byte)(data[n7] ^ data[count]);
                    int n8 = count;
                    data[n8] = (byte)(data[n8] ^ data[count + 3]);
                    int n9 = count + 1;
                    data[n9] = (byte)(data[n9] ^ data[count + 2]);
                    int n10 = count + 2;
                    data[n10] = (byte)(data[n10] ^ data[count + 1]);
                    int n11 = count + 1;
                    data[n11] = (byte)(data[n11] ^ data[count + 2]);
                    count += 4;
                }
                break;
            }
        }
        int count = 0;
        while (count < romSize) {
            int n = count;
            data[n] = (byte)(data[n] ^ data[count + 3]);
            int n12 = count + 3;
            data[n12] = (byte)(data[n12] ^ data[count]);
            int n13 = count;
            data[n13] = (byte)(data[n13] ^ data[count + 3]);
            int n14 = count + 1;
            data[n14] = (byte)(data[n14] ^ data[count + 2]);
            int n15 = count + 2;
            data[n15] = (byte)(data[n15] ^ data[count + 1]);
            int n16 = count + 1;
            data[n16] = (byte)(data[n16] ^ data[count + 2]);
            count += 4;
        }
        tmpData.order(ByteOrder.BIG_ENDIAN);
        return tmpData;
    }
}

