/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDISurface;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsDummyWGLDrawable
extends WindowsWGLDrawable {
    private long hwnd;
    private boolean handleHwndLifecycle;

    private WindowsDummyWGLDrawable(GLDrawableFactory gLDrawableFactory, GDISurface gDISurface, boolean bl) {
        super(gLDrawableFactory, gDISurface, true);
        this.handleHwndLifecycle = bl;
        if (1 >= gDISurface.lockSurface()) {
            throw new GLException("WindowsDummyWGLDrawable: surface not ready (lockSurface)");
        }
        try {
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)gDISurface.getGraphicsConfiguration();
            windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(gLDrawableFactory, gDISurface, null);
            if (DEBUG) {
                System.err.println("WindowsDummyWGLDrawable: " + windowsWGLGraphicsConfiguration);
            }
        }
        catch (Throwable throwable) {
            this.destroyImpl();
            throw new GLException(throwable);
        }
        finally {
            this.unlockSurface();
        }
    }

    public static WindowsDummyWGLDrawable create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, long l, int n, int n2, boolean bl) {
        if (0L == l) {
            throw new GLException("Error windowHandle 0, werr: " + GDI.GetLastError());
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.createDefaultGraphicsConfiguration(gLCapabilities, abstractGraphicsScreen);
        GDISurface gDISurface = new GDISurface(windowsWGLGraphicsConfiguration, l);
        gDISurface.surfaceSizeChanged(n, n2);
        return new WindowsDummyWGLDrawable(gLDrawableFactory, gDISurface, bl);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    @Override
    protected void destroyImpl() {
        if (this.handleHwndLifecycle && this.hwnd != 0L) {
            GDI.ShowWindow(this.hwnd, 0);
            GDIUtil.DestroyDummyWindow(this.hwnd);
            this.hwnd = 0L;
        }
    }
}

