/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.accessories;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioPlayer
implements Hardware,
Bus32bit,
BusDMA,
Configurable {
    private static final int DEFAULT_AUDIO_SAMPLE_RATE = 44100;
    private static final int DEFAULT_AUDIO_BIT_LENGTH = 16;
    private static final int DEFAULT_AUDIO_CHANNELS = 2;
    private AudioFormat audioFormat;
    private SourceDataLine audioDataLine;
    private int audioSampleRate = 44100;
    private int audioBitLength = 16;
    private int audioChannels = 2;
    private boolean changed;
    private boolean audioOn = true;

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int read32bit(int reg) {
        switch (reg) {
            case 0: {
                return this.audioOn ? 1 : 0;
            }
            case 1: {
                return this.audioSampleRate;
            }
            case 2: {
                return this.audioBitLength;
            }
            case 3: {
                return this.audioChannels;
            }
            case 4: {
                if (this.audioDataLine != null) {
                    return this.audioDataLine.getFramePosition() << 2;
                }
                return -1;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg) {
            case 0: {
                this.audioOn = value != 0;
                break;
            }
            case 1: {
                this.audioSampleRate = value;
                this.changed = true;
                break;
            }
            case 2: {
                this.audioBitLength = value;
                this.changed = true;
                break;
            }
            case 3: {
                this.audioChannels = value;
                this.changed = true;
            }
        }
    }

    public Object readConfig(String key) {
        if (key.equals("enable")) {
            return this.audioOn;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("enable")) {
            this.audioOn = (Boolean)value;
        }
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.audioOn && this.audioDataLine == null) {
            this.initAudio();
        }
        if (!this.audioOn && this.audioDataLine != null) {
            this.closeAudio();
        }
        if (this.changed) {
            this.initAudio();
            this.changed = false;
        }
        if (this.audioDataLine != null) {
            this.audioDataLine.write(dma.array(), offset, length);
        }
    }

    private boolean initAudio() {
        this.closeAudio();
        this.audioFormat = new AudioFormat(this.audioSampleRate, this.audioBitLength, this.audioChannels, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
        try {
            this.audioDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.audioDataLine.open(this.audioFormat, 8192);
            this.audioDataLine.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void closeAudio() {
        if (this.audioDataLine != null) {
            this.audioDataLine.stop();
            this.audioDataLine.close();
            this.audioDataLine = null;
        }
    }
}

