/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.hardware.Bus16bit;
import jario.hardware.Bus64bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class ABI1
implements Hardware,
Clockable,
Bus64bit {
    protected static final int A_INIT = 1;
    protected static final int A_CONTINUE = 0;
    protected static final int A_LOOP = 2;
    protected static final int A_OUT = 2;
    protected static final int A_LEFT = 2;
    protected static final int A_RIGHT = 0;
    protected static final int A_VOL = 4;
    protected static final int A_RATE = 0;
    protected static final int A_AUX = 8;
    protected static final int A_NOAUX = 0;
    protected static final int A_MAIN = 0;
    protected static final int A_MIX = 16;
    protected static int AudioInBuffer;
    protected static int AudioOutBuffer;
    protected static int AudioCount;
    protected static short Vol_Left;
    protected static short Vol_Right;
    protected static int AudioAuxA;
    protected static int AudioAuxC;
    protected static int AudioAuxE;
    protected static int loopval;
    protected static short VolTrg_Left;
    protected static int VolRamp_Left;
    protected static short VolTrg_Right;
    protected static int VolRamp_Right;
    protected static short Env_Dry;
    protected static short Env_Wet;
    protected static Bus16bit rdram;
    protected static BusDMA rdramDMA;
    protected static Hardware sp;
    protected OpCode[] alist = new OpCode[32];
    protected static ByteBuffer BufferSpace;
    protected static ShortBuffer BufferSpaceShort;
    protected static ByteBuffer hleMixerWorkArea;
    protected static short[] adpcmtable;
    protected static short[] ResampleLUT;
    protected OpCode SPNOOP = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
        }
    };
    protected OpCode CLEARBUFF = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int addr = inst1 & 0xFFFC;
            int count = (inst2 & 0xFFFF) + 3 & 0xFFFC;
            Arrays.fill(BufferSpace.array(), addr, addr + count, (byte)0);
        }
    };
    protected OpCode ENVMIXER = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int LRamp;
            int RRamp;
            int RAdderEnd;
            int LAdderEnd;
            int RAdderStart;
            int LAdderStart;
            int RTrg;
            int LTrg;
            short Dry;
            short Wet;
            int RVol;
            int LVol;
            int flags = inst1 >>> 16 & 0xFF;
            int addy = inst2 & 0xFFFFFF;
            ShortBuffer inp = BufferSpaceShort;
            int inp_p = AudioInBuffer / 2;
            ShortBuffer out = BufferSpaceShort;
            int out_p = AudioOutBuffer / 2;
            ShortBuffer aux1 = BufferSpaceShort;
            int aux1_p = AudioAuxA / 2;
            ShortBuffer aux2 = BufferSpaceShort;
            int aux2_p = AudioAuxC / 2;
            ShortBuffer aux3 = BufferSpaceShort;
            int aux3_p = AudioAuxE / 2;
            int a2 = 0;
            int a3 = 0;
            boolean AuxIncRate = true;
            ShortBuffer zero = ShortBuffer.allocate(8);
            int ptr = 0;
            if ((flags & 1) != 0) {
                LVol = Vol_Left * VolRamp_Left;
                RVol = Vol_Right * VolRamp_Right;
                Wet = Env_Wet;
                Dry = Env_Dry;
                LTrg = VolTrg_Left << 16;
                RTrg = VolTrg_Right << 16;
                LAdderStart = Vol_Left << 16;
                RAdderStart = Vol_Right << 16;
                LAdderEnd = LVol;
                RAdderEnd = RVol;
                RRamp = VolRamp_Right;
                LRamp = VolRamp_Left;
            } else {
                rdramDMA.readDMA(addy, hleMixerWorkArea, 0, 80);
                Wet = hleMixerWorkArea.getShort(2);
                Dry = hleMixerWorkArea.getShort(6);
                LTrg = hleMixerWorkArea.getInt(8);
                RTrg = hleMixerWorkArea.getInt(12);
                LRamp = hleMixerWorkArea.getInt(16);
                RRamp = hleMixerWorkArea.getInt(20);
                LAdderEnd = hleMixerWorkArea.getInt(24);
                RAdderEnd = hleMixerWorkArea.getInt(28);
                LAdderStart = hleMixerWorkArea.getInt(32);
                RAdderStart = hleMixerWorkArea.getInt(36);
            }
            if ((flags & 8) == 0) {
                AuxIncRate = false;
                aux2 = aux3 = zero;
            }
            int oMainL = Dry * (LTrg >> 16) + 16384 >> 15;
            int oAuxL = Wet * (LTrg >> 16) + 16384 >> 15;
            int oMainR = Dry * (RTrg >> 16) + 16384 >> 15;
            int oAuxR = Wet * (RTrg >> 16) + 16384 >> 15;
            int y = 0;
            while (y < AudioCount) {
                int RAcc;
                int LAcc;
                if (LAdderStart != LTrg) {
                    LAcc = LAdderStart;
                    LVol = LAdderEnd - LAdderStart >> 3;
                    LAdderEnd = (int)((long)LAdderEnd * (long)LRamp >> 16);
                    LAdderStart = (int)((long)LAcc * (long)LRamp >> 16);
                } else {
                    LAcc = LTrg;
                    LVol = 0;
                }
                if (RAdderStart != RTrg) {
                    RAcc = RAdderStart;
                    RVol = RAdderEnd - RAdderStart >> 3;
                    RAdderEnd = (int)((long)RAdderEnd * (long)RRamp >> 16);
                    RAdderStart = (int)((long)RAcc * (long)RRamp >> 16);
                } else {
                    RAcc = RTrg;
                    RVol = 0;
                }
                int x = 0;
                while (x < 8) {
                    int AuxR;
                    int MainR;
                    int AuxL;
                    int MainL;
                    short i1 = inp.get(inp_p + (ptr ^ 1));
                    int o1 = out.get(out_p + (ptr ^ 1));
                    int a1 = aux1.get(aux1_p + (ptr ^ 1));
                    if (AuxIncRate) {
                        a2 = aux2.get(aux2_p + (ptr ^ 1));
                        a3 = aux3.get(aux3_p + (ptr ^ 1));
                    }
                    LAcc += LVol;
                    RAcc += RVol;
                    if (LVol <= 0) {
                        if (LAcc < LTrg) {
                            LAcc = LTrg;
                            LAdderStart = LTrg;
                            MainL = oMainL;
                            AuxL = oAuxL;
                        } else {
                            MainL = Dry * (LAcc >> 16) + 16384 >> 15;
                            AuxL = Wet * (LAcc >> 16) + 16384 >> 15;
                        }
                    } else if (LAcc > LTrg) {
                        LAcc = LTrg;
                        LAdderStart = LTrg;
                        MainL = oMainL;
                        AuxL = oAuxL;
                    } else {
                        MainL = Dry * (LAcc >> 16) + 16384 >> 15;
                        AuxL = Wet * (LAcc >> 16) + 16384 >> 15;
                    }
                    if (RVol <= 0) {
                        if (RAcc < RTrg) {
                            RAcc = RTrg;
                            RAdderStart = RTrg;
                            MainR = oMainR;
                            AuxR = oAuxR;
                        } else {
                            MainR = Dry * (RAcc >> 16) + 16384 >> 15;
                            AuxR = Wet * (RAcc >> 16) + 16384 >> 15;
                        }
                    } else if (RAcc > RTrg) {
                        RAcc = RTrg;
                        RAdderStart = RTrg;
                        MainR = oMainR;
                        AuxR = oAuxR;
                    } else {
                        MainR = Dry * (RAcc >> 16) + 16384 >> 15;
                        AuxR = Wet * (RAcc >> 16) + 16384 >> 15;
                    }
                    a1 += i1 * MainL + 16384 >> 15;
                    if ((o1 += i1 * MainR + 16384 >> 15) > Short.MAX_VALUE) {
                        o1 = Short.MAX_VALUE;
                    } else if (o1 < Short.MIN_VALUE) {
                        o1 = Short.MIN_VALUE;
                    }
                    if (a1 > Short.MAX_VALUE) {
                        a1 = Short.MAX_VALUE;
                    } else if (a1 < Short.MIN_VALUE) {
                        a1 = Short.MIN_VALUE;
                    }
                    out.put(out_p + (ptr ^ 1), (short)o1);
                    aux1.put(aux1_p + (ptr ^ 1), (short)a1);
                    if (AuxIncRate) {
                        a3 += i1 * AuxL + 16384 >> 15;
                        if ((a2 += i1 * AuxR + 16384 >> 15) > Short.MAX_VALUE) {
                            a2 = Short.MAX_VALUE;
                        } else if (a2 < Short.MIN_VALUE) {
                            a2 = Short.MIN_VALUE;
                        }
                        if (a3 > Short.MAX_VALUE) {
                            a3 = Short.MAX_VALUE;
                        } else if (a3 < Short.MIN_VALUE) {
                            a3 = Short.MIN_VALUE;
                        }
                        aux2.put(aux2_p + (ptr ^ 1), (short)a2);
                        aux3.put(aux3_p + (ptr ^ 1), (short)a3);
                    }
                    ++ptr;
                    ++x;
                }
                y += 16;
            }
            hleMixerWorkArea.putShort(2, Wet);
            hleMixerWorkArea.putShort(6, Dry);
            hleMixerWorkArea.putInt(8, LTrg);
            hleMixerWorkArea.putInt(12, RTrg);
            hleMixerWorkArea.putInt(16, LRamp);
            hleMixerWorkArea.putInt(20, RRamp);
            hleMixerWorkArea.putInt(24, LAdderEnd);
            hleMixerWorkArea.putInt(28, RAdderEnd);
            hleMixerWorkArea.putInt(32, LAdderStart);
            hleMixerWorkArea.putInt(36, RAdderStart);
            rdramDMA.writeDMA(addy, hleMixerWorkArea, 0, 80);
        }
    };
    protected OpCode RESAMPLE = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int x;
            int flags = inst1 >>> 16 & 0xFF;
            int Pitch = (inst1 & 0xFFFF) << 1;
            int addy = inst2 & 0xFFFFFF;
            int Accum = 0;
            ShortBuffer dst = BufferSpaceShort;
            ShortBuffer src = BufferSpaceShort;
            int srcPtr = AudioInBuffer / 2;
            int dstPtr = AudioOutBuffer / 2;
            srcPtr -= 4;
            if ((flags & 1) == 0) {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, rdram.read16bit((addy / 2 + x ^ 1) * 2));
                    ++x;
                }
                Accum = rdram.read16bit(addy + 8) & 0xFFFF;
            } else {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, (short)0);
                    ++x;
                }
            }
            int count = (AudioCount + 15 & 0xFFF0) / 2;
            int i = 0;
            while (i < count) {
                int location = (Accum >>> 10) * 8 / 2;
                int temp = src.get(srcPtr + 0 ^ 1) * ResampleLUT[location + 0];
                int accum = temp >> 15;
                temp = src.get(srcPtr + 1 ^ 1) * ResampleLUT[location + 1];
                accum += temp >> 15;
                temp = src.get(srcPtr + 2 ^ 1) * ResampleLUT[location + 2];
                accum += temp >> 15;
                temp = src.get(srcPtr + 3 ^ 1) * ResampleLUT[location + 3];
                if ((accum += temp >> 15) > Short.MAX_VALUE) {
                    accum = Short.MAX_VALUE;
                }
                if (accum < Short.MIN_VALUE) {
                    accum = Short.MIN_VALUE;
                }
                dst.put(dstPtr ^ 1, (short)accum);
                ++dstPtr;
                srcPtr += (Accum += Pitch) >>> 16;
                Accum &= 0xFFFF;
                ++i;
            }
            int x2 = 0;
            while (x2 < 4) {
                rdram.write16bit((addy / 2 + x2 ^ 1) * 2, src.get(srcPtr + x2 ^ 1));
                ++x2;
            }
            rdram.write16bit(addy + 8, (short)Accum);
        }
    };
    protected OpCode SETVOL = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int flags = inst1 >>> 16 & 0xFF;
            int vol = inst1 & 0xFFFF;
            int volrate = inst2 & 0xFFFF;
            if ((flags & 8) != 0) {
                Env_Dry = (short)vol;
                Env_Wet = (short)volrate;
                return;
            }
            if ((flags & 4) != 0) {
                if ((flags & 2) != 0) {
                    Vol_Left = (short)vol;
                } else {
                    Vol_Right = (short)vol;
                }
                return;
            }
            if ((flags & 2) != 0) {
                VolTrg_Left = (short)inst1;
                VolRamp_Left = inst2;
            } else {
                VolTrg_Right = (short)inst1;
                VolRamp_Right = inst2;
            }
        }
    };
    protected OpCode UNKNOWN = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
        }
    };
    protected OpCode SETLOOP = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            loopval = inst2 & 0xFFFFFF;
        }
    };
    protected OpCode ADPCM = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int flags = inst1 >>> 16 & 0xFF;
            int Address = inst2 & 0xFFFFFF;
            int inPtr = 0;
            ByteBuffer out = BufferSpace;
            int out_p = AudioOutBuffer;
            short count = (short)AudioCount;
            int[] a = new int[8];
            Arrays.fill(out.array(), out_p, out_p + 32, (byte)0);
            if ((flags & 1) == 0) {
                if ((flags & 2) != 0) {
                    rdramDMA.readDMA(loopval & 0x7FFFFF, out, out_p, 32);
                } else {
                    rdramDMA.readDMA(Address, out, out_p, 32);
                }
            }
            int l1 = out.getShort(out_p + 28);
            int l2 = out.getShort(out_p + 30);
            int[] inp1 = new int[8];
            int[] inp2 = new int[8];
            out_p += 32;
            while (count > 0) {
                int icode;
                int code = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                int index = code & 0xF;
                int book1_p = index <<= 4;
                int book2_p = book1_p + 8;
                int vscale = 32768 >> 12 - (code >>= 4) - 1;
                ++inPtr;
                int j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                    ++inPtr;
                    inp1[j] = (short)((icode & 0xF0) << 8);
                    if (code < 12) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    inp1[++j] = (short)((icode & 0xF) << 12);
                    if (code < 12) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                    ++inPtr;
                    inp2[j] = (short)((icode & 0xF0) << 8);
                    if (code < 12) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    inp2[++j] = (short)((icode & 0xF) << 12);
                    if (code < 12) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    ++j;
                }
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp1[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp1[0];
                a[1] = a[1] + inp1[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp1[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp1[1];
                a[2] = a[2] + inp1[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp1[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp1[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp1[2];
                a[3] = a[3] + inp1[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp1[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp1[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp1[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp1[3];
                a[4] = a[4] + inp1[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp1[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp1[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp1[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp1[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp1[4];
                a[5] = a[5] + inp1[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp1[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp1[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp1[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp1[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp1[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp1[5];
                a[6] = a[6] + inp1[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp1[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp1[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp1[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp1[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp1[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp1[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp1[6];
                a[7] = a[7] + inp1[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp2[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp2[0];
                a[1] = a[1] + inp2[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp2[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp2[1];
                a[2] = a[2] + inp2[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp2[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp2[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp2[2];
                a[3] = a[3] + inp2[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp2[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp2[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp2[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp2[3];
                a[4] = a[4] + inp2[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp2[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp2[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp2[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp2[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp2[4];
                a[5] = a[5] + inp2[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp2[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp2[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp2[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp2[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp2[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp2[5];
                a[6] = a[6] + inp2[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp2[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp2[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp2[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp2[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp2[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp2[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp2[6];
                a[7] = a[7] + inp2[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                count = (short)(count - 32);
            }
            rdramDMA.writeDMA(Address, out, out_p -= 32, 32);
        }
    };
    protected OpCode LOADBUFF = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            if (AudioCount == 0) {
                return;
            }
            int cnt = AudioCount + 3 & 0xFFFC;
            int v0 = inst2 & 0xFFFFFC;
            rdramDMA.readDMA(v0, BufferSpace, AudioInBuffer & 0xFFFC, cnt);
        }
    };
    protected OpCode SAVEBUFF = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            if (AudioCount == 0) {
                return;
            }
            int cnt = AudioCount + 3 & 0xFFFC;
            int v0 = inst2 & 0xFFFFFF;
            rdramDMA.writeDMA(v0, BufferSpace, AudioOutBuffer & 0xFFFC, cnt);
        }
    };
    protected OpCode SEGMENT = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
        }
    };
    protected OpCode SETBUFF = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            if ((inst1 >>> 16 & 8) != 0) {
                AudioAuxA = inst1 & 0xFFFF;
                AudioAuxC = inst2 >>> 16;
                AudioAuxE = inst2 & 0xFFFF;
            } else {
                AudioInBuffer = inst1 & 0xFFFF;
                AudioOutBuffer = inst2 >>> 16;
                AudioCount = inst2 & 0xFFFF;
            }
        }
    };
    protected OpCode DMEMMOVE = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            if ((inst2 & 0xFFFF) == 0) {
                return;
            }
            int v0 = inst1 & 0xFFFF;
            int v1 = inst2 >>> 16;
            int count = inst2 + 3 & 0xFFFC;
            System.arraycopy(BufferSpace.array(), v0, BufferSpace.array(), v1, count);
        }
    };
    protected OpCode LOADADPCM = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int v0 = inst2 & 0xFFFFFF;
            int cnt = (inst1 & 0xFFFF) >> 4;
            int x = 0;
            while (x < cnt) {
                ABI1.adpcmtable[0 + (x << 3)] = rdram.read16bit(v0 + 0);
                ABI1.adpcmtable[1 + (x << 3)] = rdram.read16bit(v0 + 2);
                ABI1.adpcmtable[2 + (x << 3)] = rdram.read16bit(v0 + 4);
                ABI1.adpcmtable[3 + (x << 3)] = rdram.read16bit(v0 + 6);
                ABI1.adpcmtable[4 + (x << 3)] = rdram.read16bit(v0 + 8);
                ABI1.adpcmtable[5 + (x << 3)] = rdram.read16bit(v0 + 10);
                ABI1.adpcmtable[6 + (x << 3)] = rdram.read16bit(v0 + 12);
                ABI1.adpcmtable[7 + (x << 3)] = rdram.read16bit(v0 + 14);
                v0 += 16;
                ++x;
            }
        }
    };
    protected OpCode INTERLEAVE = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            ShortBuffer outbuff = BufferSpaceShort;
            int outbuff_p = AudioOutBuffer / 2;
            ShortBuffer inSrcR = BufferSpaceShort;
            int inSrcR_p = (inst2 >>> 16) / 2;
            ShortBuffer inSrcL = BufferSpaceShort;
            int inSrcL_p = (inst2 & 0xFFFF) / 2;
            int x = 0;
            while (x < AudioCount / 4) {
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                ++x;
            }
        }
    };
    protected OpCode MIXER = new OpCode(){

        @Override
        public void exec(int inst1, int inst2) {
            int dmemin = inst2 >>> 16;
            int dmemout = inst2 & 0xFFFF;
            short gain = (short)(inst1 & 0xFFFF);
            if (AudioCount == 0) {
                return;
            }
            int x = 0;
            while (x < AudioCount) {
                int temp = BufferSpace.getShort(dmemin + x) * gain >> 15;
                if ((temp += BufferSpace.getShort(dmemout + x)) > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                }
                if (temp < Short.MIN_VALUE) {
                    temp = Short.MIN_VALUE;
                }
                BufferSpace.putShort(dmemout + x, (short)temp);
                x += 2;
            }
        }
    };

    static {
        BufferSpace = ByteBuffer.allocate(65536);
        BufferSpaceShort = BufferSpace.asShortBuffer();
        hleMixerWorkArea = ByteBuffer.allocate(512);
        adpcmtable = new short[136];
        short[] sArray = new short[512];
        sArray[0] = 3129;
        sArray[1] = 26285;
        sArray[2] = 3398;
        sArray[3] = -33;
        sArray[4] = 2873;
        sArray[5] = 26262;
        sArray[6] = 3679;
        sArray[7] = -40;
        sArray[8] = 2628;
        sArray[9] = 26217;
        sArray[10] = 3971;
        sArray[11] = -48;
        sArray[12] = 2394;
        sArray[13] = 26150;
        sArray[14] = 4276;
        sArray[15] = -56;
        sArray[16] = 2173;
        sArray[17] = 26061;
        sArray[18] = 4592;
        sArray[19] = -65;
        sArray[20] = 1963;
        sArray[21] = 25950;
        sArray[22] = 4920;
        sArray[23] = -74;
        sArray[24] = 1764;
        sArray[25] = 25817;
        sArray[26] = 5260;
        sArray[27] = -84;
        sArray[28] = 1576;
        sArray[29] = 25663;
        sArray[30] = 5611;
        sArray[31] = -95;
        sArray[32] = 1399;
        sArray[33] = 25487;
        sArray[34] = 5974;
        sArray[35] = -106;
        sArray[36] = 1233;
        sArray[37] = 25291;
        sArray[38] = 6347;
        sArray[39] = -118;
        sArray[40] = 1077;
        sArray[41] = 25075;
        sArray[42] = 6732;
        sArray[43] = -130;
        sArray[44] = 932;
        sArray[45] = 24838;
        sArray[46] = 7127;
        sArray[47] = -143;
        sArray[48] = 796;
        sArray[49] = 24583;
        sArray[50] = 7532;
        sArray[51] = -156;
        sArray[52] = 671;
        sArray[53] = 24309;
        sArray[54] = 7947;
        sArray[55] = -170;
        sArray[56] = 554;
        sArray[57] = 24016;
        sArray[58] = 8371;
        sArray[59] = -184;
        sArray[60] = 446;
        sArray[61] = 23706;
        sArray[62] = 8804;
        sArray[63] = -198;
        sArray[64] = 347;
        sArray[65] = 23379;
        sArray[66] = 9246;
        sArray[67] = -212;
        sArray[68] = 257;
        sArray[69] = 23036;
        sArray[70] = 9696;
        sArray[71] = -226;
        sArray[72] = 174;
        sArray[73] = 22678;
        sArray[74] = 10153;
        sArray[75] = -240;
        sArray[76] = 99;
        sArray[77] = 22304;
        sArray[78] = 10618;
        sArray[79] = -254;
        sArray[80] = 31;
        sArray[81] = 21917;
        sArray[82] = 11088;
        sArray[83] = -268;
        sArray[84] = -30;
        sArray[85] = 21517;
        sArray[86] = 11564;
        sArray[87] = -280;
        sArray[88] = -84;
        sArray[89] = 21104;
        sArray[90] = 12045;
        sArray[91] = -293;
        sArray[92] = -132;
        sArray[93] = 20679;
        sArray[94] = 12531;
        sArray[95] = -304;
        sArray[96] = -173;
        sArray[97] = 20244;
        sArray[98] = 13020;
        sArray[99] = -314;
        sArray[100] = -210;
        sArray[101] = 19799;
        sArray[102] = 13512;
        sArray[103] = -323;
        sArray[104] = -241;
        sArray[105] = 19345;
        sArray[106] = 14006;
        sArray[107] = -330;
        sArray[108] = -267;
        sArray[109] = 18882;
        sArray[110] = 14501;
        sArray[111] = -336;
        sArray[112] = -289;
        sArray[113] = 18413;
        sArray[114] = 14997;
        sArray[115] = -340;
        sArray[116] = -306;
        sArray[117] = 17937;
        sArray[118] = 15493;
        sArray[119] = -341;
        sArray[120] = -320;
        sArray[121] = 17456;
        sArray[122] = 15988;
        sArray[123] = -340;
        sArray[124] = -330;
        sArray[125] = 16970;
        sArray[126] = 16480;
        sArray[127] = -337;
        sArray[128] = -337;
        sArray[129] = 16480;
        sArray[130] = 16970;
        sArray[131] = -330;
        sArray[132] = -340;
        sArray[133] = 15988;
        sArray[134] = 17456;
        sArray[135] = -320;
        sArray[136] = -341;
        sArray[137] = 15493;
        sArray[138] = 17937;
        sArray[139] = -306;
        sArray[140] = -340;
        sArray[141] = 14997;
        sArray[142] = 18413;
        sArray[143] = -289;
        sArray[144] = -336;
        sArray[145] = 14501;
        sArray[146] = 18882;
        sArray[147] = -267;
        sArray[148] = -330;
        sArray[149] = 14006;
        sArray[150] = 19345;
        sArray[151] = -241;
        sArray[152] = -323;
        sArray[153] = 13512;
        sArray[154] = 19799;
        sArray[155] = -210;
        sArray[156] = -314;
        sArray[157] = 13020;
        sArray[158] = 20244;
        sArray[159] = -173;
        sArray[160] = -304;
        sArray[161] = 12531;
        sArray[162] = 20679;
        sArray[163] = -132;
        sArray[164] = -293;
        sArray[165] = 12045;
        sArray[166] = 21104;
        sArray[167] = -84;
        sArray[168] = -280;
        sArray[169] = 11564;
        sArray[170] = 21517;
        sArray[171] = -30;
        sArray[172] = -268;
        sArray[173] = 11088;
        sArray[174] = 21917;
        sArray[175] = 31;
        sArray[176] = -254;
        sArray[177] = 10618;
        sArray[178] = 22304;
        sArray[179] = 99;
        sArray[180] = -240;
        sArray[181] = 10153;
        sArray[182] = 22678;
        sArray[183] = 174;
        sArray[184] = -226;
        sArray[185] = 9696;
        sArray[186] = 23036;
        sArray[187] = 257;
        sArray[188] = -212;
        sArray[189] = 9246;
        sArray[190] = 23379;
        sArray[191] = 347;
        sArray[192] = -198;
        sArray[193] = 8804;
        sArray[194] = 23706;
        sArray[195] = 446;
        sArray[196] = -184;
        sArray[197] = 8371;
        sArray[198] = 24016;
        sArray[199] = 554;
        sArray[200] = -170;
        sArray[201] = 7947;
        sArray[202] = 24309;
        sArray[203] = 671;
        sArray[204] = -156;
        sArray[205] = 7532;
        sArray[206] = 24583;
        sArray[207] = 796;
        sArray[208] = -143;
        sArray[209] = 7127;
        sArray[210] = 24838;
        sArray[211] = 932;
        sArray[212] = -130;
        sArray[213] = 6732;
        sArray[214] = 25075;
        sArray[215] = 1077;
        sArray[216] = -118;
        sArray[217] = 6347;
        sArray[218] = 25291;
        sArray[219] = 1233;
        sArray[220] = -106;
        sArray[221] = 5974;
        sArray[222] = 25487;
        sArray[223] = 1399;
        sArray[224] = -95;
        sArray[225] = 5611;
        sArray[226] = 25663;
        sArray[227] = 1576;
        sArray[228] = -84;
        sArray[229] = 5260;
        sArray[230] = 25817;
        sArray[231] = 1764;
        sArray[232] = -74;
        sArray[233] = 4920;
        sArray[234] = 25950;
        sArray[235] = 1963;
        sArray[236] = -65;
        sArray[237] = 4592;
        sArray[238] = 26061;
        sArray[239] = 2173;
        sArray[240] = -56;
        sArray[241] = 4276;
        sArray[242] = 26150;
        sArray[243] = 2394;
        sArray[244] = -48;
        sArray[245] = 3971;
        sArray[246] = 26217;
        sArray[247] = 2628;
        sArray[248] = -40;
        sArray[249] = 3679;
        sArray[250] = 26262;
        sArray[251] = 2873;
        sArray[252] = -33;
        sArray[253] = 3398;
        sArray[254] = 26285;
        sArray[255] = 3129;
        ResampleLUT = sArray;
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                break;
            }
            case 1: {
                rdram = (Bus16bit)bus;
                rdramDMA = (BusDMA)bus;
                break;
            }
            case 2: {
                sp = bus;
            }
        }
    }

    public void reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clock(long ticks) {
        this.alist[0] = this.SPNOOP;
        this.alist[1] = this.ADPCM;
        this.alist[2] = this.CLEARBUFF;
        this.alist[3] = this.ENVMIXER;
        this.alist[4] = this.LOADBUFF;
        this.alist[5] = this.RESAMPLE;
        this.alist[6] = this.SAVEBUFF;
        this.alist[7] = this.UNKNOWN;
        this.alist[8] = this.SETBUFF;
        this.alist[9] = this.SETVOL;
        this.alist[10] = this.DMEMMOVE;
        this.alist[11] = this.LOADADPCM;
        this.alist[12] = this.MIXER;
        this.alist[13] = this.INTERLEAVE;
        this.alist[14] = this.UNKNOWN;
        this.alist[15] = this.SETLOOP;
        this.alist[16] = this.SPNOOP;
        this.alist[17] = this.SPNOOP;
        this.alist[18] = this.SPNOOP;
        this.alist[19] = this.SPNOOP;
        this.alist[20] = this.SPNOOP;
        this.alist[21] = this.SPNOOP;
        this.alist[22] = this.SPNOOP;
        this.alist[23] = this.SPNOOP;
        this.alist[24] = this.SPNOOP;
        this.alist[25] = this.SPNOOP;
        this.alist[26] = this.SPNOOP;
        this.alist[27] = this.SPNOOP;
        this.alist[28] = this.SPNOOP;
        this.alist[29] = this.SPNOOP;
        this.alist[30] = this.SPNOOP;
        this.alist[31] = this.SPNOOP;
        loopval = 0;
    }

    public long read64bit(int pAddr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write64bit(int pAddr, long value) {
        int inst1 = (int)(value >> 32);
        int inst2 = (int)value;
        this.alist[inst1 >>> 24].exec(inst1, inst2);
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }
}

