/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.cartridge;

import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Eeprom
implements Hardware,
BusDMA,
Configurable {
    private static final String AUTO_SAVE_DIR = "./save/default.eep";
    private RandomAccessFile hEepromFile;
    private File file;
    private byte[] eeprom = new byte[2048];

    public Eeprom() {
        this.file = new File(AUTO_SAVE_DIR);
    }

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        this.close();
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("file")) {
            this.file = new File(value.toString());
        }
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.hEepromFile == null) {
            this.loadEeprom();
        }
        int i = 0;
        while (i < length) {
            dma.array()[offset + i] = this.eeprom[pAddr * 8 + i];
            ++i;
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        int i = 0;
        while (i < length) {
            this.eeprom[pAddr * 8 + i] = dma.array()[offset + i];
            ++i;
        }
        if (this.hEepromFile == null && !this.loadEeprom()) {
            return;
        }
        try {
            this.hEepromFile.seek(pAddr * 8);
            this.hEepromFile.write(dma.array(), offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        if (this.hEepromFile != null) {
            try {
                this.hEepromFile.close();
                this.hEepromFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean loadEeprom() {
        try {
            this.hEepromFile = new RandomAccessFile(this.file, "rwd");
            Arrays.fill(this.eeprom, (byte)0);
            this.hEepromFile.read(this.eeprom, 0, this.eeprom.length);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hEepromFile = null;
        return false;
    }
}

