/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.cpu;

import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Hardware;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Fpu
implements Hardware,
Bus32bit,
Bus64bit {
    protected static final int REVISION_REGISTER = 0;
    protected static final int FSTATUS_REGISTER = 31;
    protected static final int FPCSR_FS = 0x1000000;
    protected static final int FPCSR_C = 0x800000;
    protected static final int FPCSR_CE = 131072;
    protected static final int FPCSR_CV = 65536;
    protected static final int FPCSR_CZ = 32768;
    protected static final int FPCSR_CO = 16384;
    protected static final int FPCSR_CU = 8192;
    protected static final int FPCSR_CI = 4096;
    protected static final int FPCSR_EV = 2048;
    protected static final int FPCSR_EZ = 1024;
    protected static final int FPCSR_EO = 512;
    protected static final int FPCSR_EU = 256;
    protected static final int FPCSR_EI = 128;
    protected static final int FPCSR_FV = 64;
    protected static final int FPCSR_FZ = 32;
    protected static final int FPCSR_FO = 16;
    protected static final int FPCSR_FU = 8;
    protected static final int FPCSR_FI = 4;
    protected static final int FPCSR_RM_MASK = 3;
    protected static final int FPCSR_RM_RN = 0;
    protected static final int FPCSR_RM_RZ = 1;
    protected static final int FPCSR_RM_RP = 2;
    protected static final int FPCSR_RM_RM = 3;
    protected static final int PC_REGISTER = 32;
    protected static final int DELAY_SLOT_REGISTER = 40;
    protected static final int FMT = 21;
    protected static final int FT = 16;
    protected static final int FS = 11;
    protected static final int FD = 6;
    protected static final int R4300I_COP1 = 0;
    protected static final int R4300I_COP1_BC = 1;
    protected static final int R4300I_COP1_S = 2;
    protected static final int R4300I_COP1_D = 3;
    protected static final int R4300I_COP1_W = 4;
    protected static final int R4300I_COP1_L = 5;
    protected static final int RC_NEAR = 0;
    protected static final int RC_CHOP = 1;
    protected static final int RC_UP = 2;
    protected static final int RC_DOWN = 3;
    protected RoundingMode[] roundingMode = new RoundingMode[]{RoundingMode.HALF_EVEN, RoundingMode.DOWN, RoundingMode.CEILING, RoundingMode.FLOOR};
    protected MathContext[] floatContext = new MathContext[]{MathContext.DECIMAL32, new MathContext(7, RoundingMode.DOWN), new MathContext(7, RoundingMode.CEILING), new MathContext(7, RoundingMode.FLOOR)};
    protected OpCode[] r4300i_CoP1;
    protected OpCode[] r4300i_CoP1_BC;
    protected OpCode[] r4300i_CoP1_S;
    protected OpCode[] r4300i_CoP1_D;
    protected OpCode[] r4300i_CoP1_W;
    protected OpCode[] r4300i_CoP1_L;
    protected int[] FPCR;
    protected MipsDword[] FPR;
    protected boolean mode32;
    protected int instruction;
    protected int roundingModel;
    private MipsDword[] tmpFPR;
    protected Bus32bit bus0;
    protected Bus64bit bus0DW;
    protected OpCode R4300i_opcode_COP1_BC = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.r4300i_CoP1_BC[inst >> 16 & 0x1F].exec(inst, unused);
        }
    };
    protected OpCode R4300i_opcode_COP1_S = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.r4300i_CoP1_S[inst & 0x3F].exec(inst, unused);
        }
    };
    protected OpCode R4300i_opcode_COP1_D = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.r4300i_CoP1_D[inst & 0x3F].exec(inst, unused);
        }
    };
    protected OpCode R4300i_opcode_COP1_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.r4300i_CoP1_W[inst & 0x3F].exec(inst, unused);
        }
    };
    protected OpCode R4300i_opcode_COP1_L = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.r4300i_CoP1_L[inst & 0x3F].exec(inst, unused);
        }
    };
    protected OpCode r4300i_COP1_MF = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.bus0.write32bit(inst >> 16 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getW(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_DMF = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.bus0DW.write64bit(inst >> 16 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].DW);
        }
    };
    protected OpCode r4300i_COP1_CF = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            try {
                if ((inst >> 11 & 0x1F) != 31 && (inst >> 11 & 0x1F) != 0) {
                    System.err.printf("CFC1 what register are you reading from ?\n", new Object[0]);
                    Fpu.this.bus0.write32bit(inst >> 16 & 0x1F, 0);
                    return;
                }
                Fpu.this.bus0.write32bit(inst >> 16 & 0x1F, Fpu.this.FPCR[inst >> 11 & 0x1F]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    protected OpCode r4300i_COP1_MT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 11 & 0x1F].setW(inst >> 11 & 0x1F, Fpu.this.bus0.read32bit(inst >> 16 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_DMT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 11 & 0x1F].DW = Fpu.this.bus0DW.read64bit(inst >> 16 & 0x1F);
        }
    };
    protected OpCode r4300i_COP1_CT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            try {
                if ((inst >> 11 & 0x1F) != 31) {
                    System.err.printf("CTC1 what register are you writing to ?\n", new Object[0]);
                    return;
                }
                Fpu.this.FPCR[31] = Fpu.this.bus0.read32bit(inst >> 16 & 0x1F);
                switch (Fpu.this.FPCR[31] & 3) {
                    case 0: {
                        Fpu.this.roundingModel = 0;
                        break;
                    }
                    case 1: {
                        Fpu.this.roundingModel = 1;
                        break;
                    }
                    case 2: {
                        Fpu.this.roundingModel = 2;
                        break;
                    }
                    case 3: {
                        Fpu.this.roundingModel = 3;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    protected OpCode r4300i_COP1_BCF = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((Fpu.this.FPCR[31] & 0x800000) == 0) {
                Fpu.this.bus0.write32bit(32, Fpu.this.bus0.read32bit(32) + ((short)inst << 2));
                Fpu.this.bus0.write32bit(40, 1);
            }
        }
    };
    protected OpCode r4300i_COP1_BCT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((Fpu.this.FPCR[31] & 0x800000) != 0) {
                Fpu.this.bus0.write32bit(32, Fpu.this.bus0.read32bit(32) + ((short)inst << 2));
                Fpu.this.bus0.write32bit(40, 1);
            }
        }
    };
    protected OpCode r4300i_COP1_BCFL = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((Fpu.this.FPCR[31] & 0x800000) == 0) {
                Fpu.this.bus0.write32bit(32, Fpu.this.bus0.read32bit(32) + ((short)inst << 2));
                Fpu.this.bus0.write32bit(40, 1);
            } else {
                Fpu.this.bus0.write32bit(40, 0);
            }
        }
    };
    protected OpCode r4300i_COP1_BCTL = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((Fpu.this.FPCR[31] & 0x800000) != 0) {
                Fpu.this.bus0.write32bit(32, Fpu.this.bus0.read32bit(32) + ((short)inst << 2));
                Fpu.this.bus0.write32bit(40, 1);
            } else {
                Fpu.this.bus0.write32bit(40, 0);
            }
        }
    };
    protected OpCode r4300i_COP1_S_ADD = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F) + Fpu.this.FPR[inst >> 16 & 0x1F].getF(inst >> 16 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_SUB = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F) - Fpu.this.FPR[inst >> 16 & 0x1F].getF(inst >> 16 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_MUL = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F) * Fpu.this.FPR[inst >> 16 & 0x1F].getF(inst >> 16 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_DIV = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F) / Fpu.this.FPR[inst >> 16 & 0x1F].getF(inst >> 16 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_SQRT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, BigDecimal.valueOf(StrictMath.sqrt(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F))).round(Fpu.this.floatContext[Fpu.this.roundingModel]).floatValue());
        }
    };
    protected OpCode r4300i_COP1_S_ABS = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, StrictMath.abs(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)));
        }
    };
    protected OpCode r4300i_COP1_S_MOV = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_NEG = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)).negate(Fpu.this.floatContext[Fpu.this.roundingModel]).floatValue());
        }
    };
    protected OpCode r4300i_COP1_S_TRUNC_L = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].DW = (long)Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F);
        }
    };
    protected OpCode r4300i_COP1_S_ROUND_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)).setScale(0, Fpu.this.roundingMode[0]).intValue());
        }
    };
    protected OpCode r4300i_COP1_S_TRUNC_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, (int)Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_FLOOR_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, (int)StrictMath.floor(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)));
        }
    };
    protected OpCode r4300i_COP1_S_CVT_D = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_S_CVT_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)).setScale(0, Fpu.this.roundingMode[Fpu.this.roundingModel]).intValue());
        }
    };
    protected OpCode r4300i_COP1_S_CVT_L = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].DW = BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F)).setScale(0, Fpu.this.roundingMode[Fpu.this.roundingModel]).longValue();
        }
    };
    protected OpCode r4300i_COP1_S_CMP = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            boolean unorded;
            boolean equal;
            boolean less;
            float temp0 = Fpu.this.FPR[inst >> 11 & 0x1F].getF(inst >> 11 & 0x1F);
            float temp1 = Fpu.this.FPR[inst >> 16 & 0x1F].getF(inst >> 16 & 0x1F);
            if (Float.isNaN(temp0) || Float.isNaN(temp1)) {
                System.err.printf("Nan ?\n", new Object[0]);
                less = false;
                equal = false;
                unorded = true;
                if ((inst & 0x3F & 8) != 0) {
                    System.err.printf("Signal InvalidOperationException\nin r4300i_COP1_S_CMP\n%X  %ff\n%X  %ff\n", Float.valueOf(temp0), Float.valueOf(temp0), Float.valueOf(temp1), Float.valueOf(temp1));
                }
            } else {
                less = temp0 < temp1;
                equal = temp0 == temp1;
                unorded = false;
            }
            boolean condition = ((inst & 0x3F & 4) != 0 && less) | ((inst & 0x3F & 2) != 0 && equal) | ((inst & 0x3F & 1) != 0 && unorded);
            Fpu.this.FPCR[31] = condition ? Fpu.this.FPCR[31] | 0x800000 : Fpu.this.FPCR[31] & 0xFF7FFFFF;
        }
    };
    protected OpCode r4300i_COP1_D_ADD = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD() + Fpu.this.FPR[inst >> 16 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_SUB = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD() - Fpu.this.FPR[inst >> 16 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_MUL = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD() * Fpu.this.FPR[inst >> 16 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_DIV = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD() / Fpu.this.FPR[inst >> 16 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_SQRT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(StrictMath.sqrt(Fpu.this.FPR[inst >> 11 & 0x1F].getD()));
        }
    };
    protected OpCode r4300i_COP1_D_ABS = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(StrictMath.abs(Fpu.this.FPR[inst >> 11 & 0x1F].getD()));
        }
    };
    protected OpCode r4300i_COP1_D_MOV = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_NEG = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getD() * -1.0);
        }
    };
    protected OpCode r4300i_COP1_D_ROUND_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getD()).setScale(0, Fpu.this.roundingMode[0]).intValue());
        }
    };
    protected OpCode r4300i_COP1_D_TRUNC_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, (int)Fpu.this.FPR[inst >> 11 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_CVT_S = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, (float)Fpu.this.FPR[inst >> 11 & 0x1F].getD());
        }
    };
    protected OpCode r4300i_COP1_D_CVT_W = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setW(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getD()).setScale(0, Fpu.this.roundingMode[Fpu.this.roundingModel]).intValue());
        }
    };
    protected OpCode r4300i_COP1_D_CVT_L = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].DW = BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].getD()).setScale(0, Fpu.this.roundingMode[Fpu.this.roundingModel]).longValue();
        }
    };
    protected OpCode r4300i_COP1_D_CMP = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            boolean unorded;
            boolean equal;
            boolean less;
            double temp0 = Fpu.this.FPR[inst >> 11 & 0x1F].getD();
            double temp1 = Fpu.this.FPR[inst >> 16 & 0x1F].getD();
            if (Double.isNaN(temp0) || Double.isNaN(temp1)) {
                System.err.printf("Nan ?\n", new Object[0]);
                less = false;
                equal = false;
                unorded = true;
                if ((inst & 0x3F & 8) != 0) {
                    System.err.printf("Signal InvalidOperationException\nin r4300i_COP1_D_CMP\n", new Object[0]);
                }
            } else {
                less = temp0 < temp1;
                equal = temp0 == temp1;
                unorded = false;
            }
            boolean condition = ((inst & 0x3F & 4) != 0 && less) | ((inst & 0x3F & 2) != 0 && equal) | ((inst & 0x3F & 1) != 0 && unorded);
            Fpu.this.FPCR[31] = condition ? Fpu.this.FPCR[31] | 0x800000 : Fpu.this.FPCR[31] & 0xFF7FFFFF;
        }
    };
    protected OpCode r4300i_COP1_W_CVT_S = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, Fpu.this.FPR[inst >> 11 & 0x1F].getW(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_W_CVT_D = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(Fpu.this.FPR[inst >> 11 & 0x1F].getW(inst >> 11 & 0x1F));
        }
    };
    protected OpCode r4300i_COP1_L_CVT_S = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setF(inst >> 6 & 0x1F, BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].DW).round(Fpu.this.floatContext[Fpu.this.roundingModel]).floatValue());
        }
    };
    protected OpCode r4300i_COP1_L_CVT_D = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Fpu.this.FPR[inst >> 6 & 0x1F].setD(BigDecimal.valueOf(Fpu.this.FPR[inst >> 11 & 0x1F].DW).round(Fpu.this.floatContext[Fpu.this.roundingModel]).doubleValue());
        }
    };
    protected OpCode R4300i_UnknownOpcode = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            System.err.printf("PC:%X ,Unhandled r4300i FPU OpCode:%X\n", Fpu.this.bus0.read32bit(32), inst);
            System.exit(0);
        }
    };

    public Fpu() {
        this.FPCR = new int[32];
        this.FPCR[0] = 1297;
        this.FPR = new MipsDword[32];
        this.tmpFPR = new MipsDword[16];
        int i = 0;
        while (i < this.FPR.length) {
            this.FPR[i] = new MipsDword();
            ++i;
        }
        this.roundingModel = 0;
        this.buildOps();
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.bus0 = (Bus32bit)bus;
                this.bus0DW = (Bus64bit)bus;
            }
        }
    }

    public void reset() {
        this.FPCR = new int[32];
        this.FPCR[0] = 1297;
        this.FPR = new MipsDword[32];
        this.tmpFPR = new MipsDword[16];
        int i = 0;
        while (i < this.FPR.length) {
            this.FPR[i] = new MipsDword();
            ++i;
        }
        this.mode32 = false;
        this.instruction = 0;
        this.roundingModel = 0;
    }

    public int read32bit(int pAddr) {
        if (pAddr < 64) {
            return this.FPR[pAddr].getW(pAddr);
        }
        switch (pAddr) {
            case 64: {
                return this.mode32 ? 0 : 1;
            }
            case 65: {
                return this.instruction;
            }
        }
        return 0;
    }

    public long read64bit(int pAddr) {
        return this.FPR[pAddr].DW;
    }

    public void write32bit(int pAddr, int value) {
        if (pAddr < 64) {
            this.FPR[pAddr].setW(pAddr, value);
        } else {
            switch (pAddr) {
                case 64: {
                    if (value == 0) {
                        this.mode32 = true;
                        int i = 0;
                        while (i < 16) {
                            this.tmpFPR[i] = this.FPR[(i << 1) + 1];
                            this.FPR[(i << 1) + 1] = this.FPR[i << 1];
                            ++i;
                        }
                    } else {
                        this.mode32 = false;
                        int i = 0;
                        while (i < 16) {
                            this.FPR[(i << 1) + 1] = this.tmpFPR[i];
                            ++i;
                        }
                    }
                    break;
                }
                case 65: {
                    this.instruction = value;
                    this.r4300i_CoP1[value >> 21 & 0x1F].exec(value, 0);
                }
            }
        }
    }

    public void write64bit(int pAddr, long value) {
        this.FPR[pAddr].DW = value;
    }

    private void buildOps() {
        this.r4300i_CoP1 = new OpCode[32];
        int i = 0;
        while (i < 32) {
            this.r4300i_CoP1[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1[0] = this.r4300i_COP1_MF;
        this.r4300i_CoP1[1] = this.r4300i_COP1_DMF;
        this.r4300i_CoP1[2] = this.r4300i_COP1_CF;
        this.r4300i_CoP1[4] = this.r4300i_COP1_MT;
        this.r4300i_CoP1[5] = this.r4300i_COP1_DMT;
        this.r4300i_CoP1[6] = this.r4300i_COP1_CT;
        this.r4300i_CoP1[8] = this.R4300i_opcode_COP1_BC;
        this.r4300i_CoP1[16] = this.R4300i_opcode_COP1_S;
        this.r4300i_CoP1[17] = this.R4300i_opcode_COP1_D;
        this.r4300i_CoP1[20] = this.R4300i_opcode_COP1_W;
        this.r4300i_CoP1[21] = this.R4300i_opcode_COP1_L;
        this.r4300i_CoP1_BC = new OpCode[32];
        i = 0;
        while (i < 32) {
            this.r4300i_CoP1_BC[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1_BC[0] = this.r4300i_COP1_BCF;
        this.r4300i_CoP1_BC[1] = this.r4300i_COP1_BCT;
        this.r4300i_CoP1_BC[2] = this.r4300i_COP1_BCFL;
        this.r4300i_CoP1_BC[3] = this.r4300i_COP1_BCTL;
        this.r4300i_CoP1_S = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_CoP1_S[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1_S[0] = this.r4300i_COP1_S_ADD;
        this.r4300i_CoP1_S[1] = this.r4300i_COP1_S_SUB;
        this.r4300i_CoP1_S[2] = this.r4300i_COP1_S_MUL;
        this.r4300i_CoP1_S[3] = this.r4300i_COP1_S_DIV;
        this.r4300i_CoP1_S[4] = this.r4300i_COP1_S_SQRT;
        this.r4300i_CoP1_S[5] = this.r4300i_COP1_S_ABS;
        this.r4300i_CoP1_S[6] = this.r4300i_COP1_S_MOV;
        this.r4300i_CoP1_S[7] = this.r4300i_COP1_S_NEG;
        this.r4300i_CoP1_S[9] = this.r4300i_COP1_S_TRUNC_L;
        this.r4300i_CoP1_S[12] = this.r4300i_COP1_S_ROUND_W;
        this.r4300i_CoP1_S[13] = this.r4300i_COP1_S_TRUNC_W;
        this.r4300i_CoP1_S[15] = this.r4300i_COP1_S_FLOOR_W;
        this.r4300i_CoP1_S[33] = this.r4300i_COP1_S_CVT_D;
        this.r4300i_CoP1_S[36] = this.r4300i_COP1_S_CVT_W;
        this.r4300i_CoP1_S[37] = this.r4300i_COP1_S_CVT_L;
        i = 48;
        while (i < 64) {
            this.r4300i_CoP1_S[i] = this.r4300i_COP1_S_CMP;
            ++i;
        }
        this.r4300i_CoP1_D = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_CoP1_D[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1_D[0] = this.r4300i_COP1_D_ADD;
        this.r4300i_CoP1_D[1] = this.r4300i_COP1_D_SUB;
        this.r4300i_CoP1_D[2] = this.r4300i_COP1_D_MUL;
        this.r4300i_CoP1_D[3] = this.r4300i_COP1_D_DIV;
        this.r4300i_CoP1_D[4] = this.r4300i_COP1_D_SQRT;
        this.r4300i_CoP1_D[5] = this.r4300i_COP1_D_ABS;
        this.r4300i_CoP1_D[6] = this.r4300i_COP1_D_MOV;
        this.r4300i_CoP1_D[7] = this.r4300i_COP1_D_NEG;
        this.r4300i_CoP1_D[12] = this.r4300i_COP1_D_ROUND_W;
        this.r4300i_CoP1_D[13] = this.r4300i_COP1_D_TRUNC_W;
        this.r4300i_CoP1_D[32] = this.r4300i_COP1_D_CVT_S;
        this.r4300i_CoP1_D[36] = this.r4300i_COP1_D_CVT_W;
        this.r4300i_CoP1_D[37] = this.r4300i_COP1_D_CVT_L;
        i = 48;
        while (i < 64) {
            this.r4300i_CoP1_D[i] = this.r4300i_COP1_D_CMP;
            ++i;
        }
        this.r4300i_CoP1_W = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_CoP1_W[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1_W[32] = this.r4300i_COP1_W_CVT_S;
        this.r4300i_CoP1_W[33] = this.r4300i_COP1_W_CVT_D;
        this.r4300i_CoP1_L = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_CoP1_L[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP1_L[32] = this.r4300i_COP1_L_CVT_S;
        this.r4300i_CoP1_L[33] = this.r4300i_COP1_L_CVT_D;
    }

    protected class MipsDword {
        public long DW;

        protected MipsDword() {
        }

        public int getW(int index) {
            switch (Fpu.this.mode32 ? index & 1 : 0) {
                case 0: {
                    return (int)this.DW;
                }
                case 1: {
                    return (int)(this.DW >> 32);
                }
            }
            return 0;
        }

        public void setW(int index, int w) {
            switch (Fpu.this.mode32 ? index & 1 : 0) {
                case 0: {
                    this.DW = (long)w & 0xFFFFFFFFL | this.DW & 0xFFFFFFFF00000000L;
                    break;
                }
                case 1: {
                    this.DW = (long)w << 32 & 0xFFFFFFFF00000000L | this.DW & 0xFFFFFFFFL;
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public float getF(int index) {
            return Float.intBitsToFloat((int)this.DW);
        }

        public void setF(int index, float f) {
            this.DW = (long)Float.floatToIntBits(f) & 0xFFFFFFFFL;
        }

        public double getD() {
            return Double.longBitsToDouble(this.DW);
        }

        public void setD(double d) {
            this.DW = Double.doubleToLongBits(d);
        }
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }
}

