/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.n64.ucode.ABI1;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class ABI3
extends ABI1 {
    protected ABI1.OpCode SETVOL3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int flags = inst1 >>> 16 & 0xFF;
            if ((flags & 4) != 0) {
                if ((flags & 2) != 0) {
                    Vol_Left = (short)inst1;
                    Env_Dry = (short)(inst2 >> 16);
                    Env_Wet = (short)inst2;
                } else {
                    VolTrg_Right = (short)inst1;
                    VolRamp_Right = inst2;
                }
            } else {
                VolTrg_Left = (short)inst1;
                VolRamp_Left = inst2;
            }
        }
    };
    protected ABI1.OpCode ENVMIXER3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            short RTrg;
            short LTrg;
            short Dry;
            short Wet;
            short RSig;
            int RVol;
            int RAcc;
            int RAdder;
            short LSig;
            int LVol;
            int LAcc;
            int LAdder;
            int flags = inst1 >>> 16 & 0xFF;
            int addy = inst2 & 0xFFFFFF;
            ShortBuffer inp = BufferSpaceShort;
            int inp_p = 632;
            ShortBuffer out = BufferSpaceShort;
            int out_p = 1256;
            ShortBuffer aux1 = BufferSpaceShort;
            int aux1_p = 1440;
            ShortBuffer aux2 = BufferSpaceShort;
            int aux2_p = 1624;
            ShortBuffer aux3 = BufferSpaceShort;
            int aux3_p = 1808;
            Vol_Right = (short)inst1;
            if ((flags & 1) != 0) {
                LAdder = VolRamp_Left / 8;
                LAcc = 0;
                LVol = Vol_Left;
                LSig = (short)(VolRamp_Left >> 16);
                RAdder = VolRamp_Right / 8;
                RAcc = 0;
                RVol = Vol_Right;
                RSig = (short)(VolRamp_Right >> 16);
                Wet = Env_Wet;
                Dry = Env_Dry;
                LTrg = VolTrg_Left;
                RTrg = VolTrg_Right;
            } else {
                rdramDMA.readDMA(addy, hleMixerWorkArea, 0, 80);
                Wet = hleMixerWorkArea.getShort(2);
                Dry = hleMixerWorkArea.getShort(6);
                LTrg = hleMixerWorkArea.getShort(10);
                RTrg = hleMixerWorkArea.getShort(14);
                LAdder = hleMixerWorkArea.getInt(16);
                RAdder = hleMixerWorkArea.getInt(20);
                LAcc = hleMixerWorkArea.getInt(24);
                RAcc = hleMixerWorkArea.getInt(28);
                LVol = hleMixerWorkArea.getInt(32);
                RVol = hleMixerWorkArea.getInt(36);
                LSig = hleMixerWorkArea.getShort(42);
                RSig = hleMixerWorkArea.getShort(46);
            }
            int y = 0;
            while (y < 184) {
                LVol += (LAcc += LAdder) >> 16;
                LAcc &= 0xFFFF;
                RVol += (RAcc += RAdder) >> 16;
                RAcc &= 0xFFFF;
                if (LSig >= 0) {
                    if (LVol > LTrg) {
                        LVol = LTrg;
                    }
                } else if (LVol < LTrg) {
                    LVol = LTrg;
                }
                if (RSig >= 0) {
                    if (RVol > RTrg) {
                        RVol = RTrg;
                    }
                } else if (RVol < RTrg) {
                    RVol = RTrg;
                }
                int MainL = Dry * LVol + 16384 >> 15;
                int MainR = Dry * RVol + 16384 >> 15;
                int o1 = out.get(out_p + (y ^ 1));
                int a1 = aux1.get(aux1_p + (y ^ 1));
                short i1 = inp.get(inp_p + (y ^ 1));
                a1 += i1 * MainR + 16384 >> 15;
                if ((o1 += i1 * MainL + 16384 >> 15) > Short.MAX_VALUE) {
                    o1 = Short.MAX_VALUE;
                } else if (o1 < Short.MIN_VALUE) {
                    o1 = Short.MIN_VALUE;
                }
                if (a1 > Short.MAX_VALUE) {
                    a1 = Short.MAX_VALUE;
                } else if (a1 < Short.MIN_VALUE) {
                    a1 = Short.MIN_VALUE;
                }
                out.put(out_p + (y ^ 1), (short)o1);
                aux1.put(aux1_p + (y ^ 1), (short)a1);
                int a2 = aux2.get(aux2_p + (y ^ 1));
                int a3 = aux3.get(aux3_p + (y ^ 1));
                int AuxL = Wet * LVol + 16384 >> 15;
                int AuxR = Wet * RVol + 16384 >> 15;
                a3 += i1 * AuxR + 16384 >> 15;
                if ((a2 += i1 * AuxL + 16384 >> 15) > Short.MAX_VALUE) {
                    a2 = Short.MAX_VALUE;
                } else if (a2 < Short.MIN_VALUE) {
                    a2 = Short.MIN_VALUE;
                }
                if (a3 > Short.MAX_VALUE) {
                    a3 = Short.MAX_VALUE;
                } else if (a3 < Short.MIN_VALUE) {
                    a3 = Short.MIN_VALUE;
                }
                aux2.put(aux2_p + (y ^ 1), (short)a2);
                aux3.put(aux3_p + (y ^ 1), (short)a3);
                ++y;
            }
            hleMixerWorkArea.putShort(2, Wet);
            hleMixerWorkArea.putShort(6, Dry);
            hleMixerWorkArea.putShort(10, LTrg);
            hleMixerWorkArea.putShort(14, RTrg);
            hleMixerWorkArea.putInt(16, LAdder);
            hleMixerWorkArea.putInt(20, RAdder);
            hleMixerWorkArea.putInt(24, LAcc);
            hleMixerWorkArea.putInt(28, RAcc);
            hleMixerWorkArea.putInt(32, LVol);
            hleMixerWorkArea.putInt(36, RVol);
            hleMixerWorkArea.putShort(42, LSig);
            hleMixerWorkArea.putShort(46, RSig);
            rdramDMA.writeDMA(addy, hleMixerWorkArea, 0, 80);
        }
    };
    protected ABI1.OpCode CLEARBUFF3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int addr = (inst1 & 0xFFFF) + 1264;
            int count = inst2 & 0xFFFF;
            Arrays.fill(BufferSpace.array(), addr, addr + count, (byte)0);
        }
    };
    protected ABI1.OpCode MIXER3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int dmemin = (inst2 >>> 16) + 1264 & 0xFFFF;
            int dmemout = (inst2 & 0xFFFF) + 1264 & 0xFFFF;
            int gain = (short)(inst1 & 0xFFFF) * 2;
            int x = 0;
            while (x < 368) {
                int temp = BufferSpace.getShort(dmemin + x) * gain >> 16;
                if ((temp += BufferSpace.getShort(dmemout + x)) > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                }
                if (temp < Short.MIN_VALUE) {
                    temp = Short.MIN_VALUE;
                }
                BufferSpace.putShort(dmemout + x, (short)temp);
                x += 2;
            }
        }
    };
    protected ABI1.OpCode LOADBUFF3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int cnt = (inst1 >>> 12) + 3 & 0xFFC;
            int v0 = inst2 & 0xFFFFFC;
            rdramDMA.readDMA(v0, BufferSpace, (inst1 & 0xFFC) + 1264, cnt);
        }
    };
    protected ABI1.OpCode SAVEBUFF3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int cnt = (inst1 >>> 12) + 3 & 0xFFC;
            int v0 = inst2 & 0xFFFFFC;
            rdramDMA.writeDMA(v0, BufferSpace, (inst1 & 0xFFC) + 1264, cnt);
        }
    };
    protected ABI1.OpCode LOADADPCM3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int v0 = inst2 & 0xFFFFFF;
            int cnt = (inst1 & 0xFFFF) >> 4;
            int x = 0;
            while (x < cnt) {
                ABI3.adpcmtable[0 + (x << 3)] = rdram.read16bit(v0 + 0);
                ABI3.adpcmtable[1 + (x << 3)] = rdram.read16bit(v0 + 2);
                ABI3.adpcmtable[2 + (x << 3)] = rdram.read16bit(v0 + 4);
                ABI3.adpcmtable[3 + (x << 3)] = rdram.read16bit(v0 + 6);
                ABI3.adpcmtable[4 + (x << 3)] = rdram.read16bit(v0 + 8);
                ABI3.adpcmtable[5 + (x << 3)] = rdram.read16bit(v0 + 10);
                ABI3.adpcmtable[6 + (x << 3)] = rdram.read16bit(v0 + 12);
                ABI3.adpcmtable[7 + (x << 3)] = rdram.read16bit(v0 + 14);
                v0 += 16;
                ++x;
            }
        }
    };
    protected ABI1.OpCode DMEMMOVE3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int v0 = (inst1 & 0xFFFF) + 1264;
            int v1 = (inst2 >>> 16) + 1264;
            int count = inst2 + 3 & 0xFFFC;
            System.arraycopy(BufferSpace.array(), v0, BufferSpace.array(), v1, count);
        }
    };
    protected ABI1.OpCode SETLOOP3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            loopval = inst2 & 0xFFFFFF;
        }
    };
    protected ABI1.OpCode ADPCM3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int flags = inst2 >>> 28 & 0xFF;
            int Address = inst1 & 0xFFFFFF;
            int inPtr = inst2 >>> 12 & 0xF;
            ByteBuffer out = BufferSpace;
            int out_p = (inst2 & 0xFFF) + 1264;
            short count = (short)(inst2 >>> 16 & 0xFFF);
            int[] a = new int[8];
            Arrays.fill(out.array(), out_p, out_p + 32, (byte)0);
            if ((flags & 1) == 0) {
                if ((flags & 2) != 0) {
                    rdramDMA.readDMA(loopval, out, out_p, 32);
                } else {
                    rdramDMA.readDMA(Address, out, out_p, 32);
                }
            }
            int l1 = out.getShort(out_p + 28);
            int l2 = out.getShort(out_p + 30);
            int[] inp1 = new int[8];
            int[] inp2 = new int[8];
            out_p += 32;
            while (count > 0) {
                int icode;
                int code = BufferSpace.get(1264 + inPtr) & 0xFF;
                int index = code & 0xF;
                int book1_p = index <<= 4;
                int book2_p = book1_p + 8;
                int vscale = 32768 >> 12 - (code >>= 4) - 1;
                ++inPtr;
                int j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(1264 + inPtr) & 0xFF;
                    ++inPtr;
                    inp1[j] = (short)((icode & 0xF0) << 8);
                    if (code < 12) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    inp1[++j] = (short)((icode & 0xF) << 12);
                    if (code < 12) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(1264 + inPtr) & 0xFF;
                    ++inPtr;
                    inp2[j] = (short)((icode & 0xF0) << 8);
                    if (code < 12) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    inp2[++j] = (short)((icode & 0xF) << 12);
                    if (code < 12) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    ++j;
                }
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp1[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp1[0];
                a[1] = a[1] + inp1[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp1[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp1[1];
                a[2] = a[2] + inp1[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp1[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp1[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp1[2];
                a[3] = a[3] + inp1[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp1[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp1[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp1[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp1[3];
                a[4] = a[4] + inp1[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp1[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp1[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp1[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp1[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp1[4];
                a[5] = a[5] + inp1[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp1[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp1[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp1[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp1[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp1[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp1[5];
                a[6] = a[6] + inp1[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp1[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp1[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp1[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp1[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp1[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp1[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp1[6];
                a[7] = a[7] + inp1[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp2[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp2[0];
                a[1] = a[1] + inp2[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp2[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp2[1];
                a[2] = a[2] + inp2[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp2[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp2[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp2[2];
                a[3] = a[3] + inp2[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp2[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp2[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp2[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp2[3];
                a[4] = a[4] + inp2[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp2[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp2[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp2[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp2[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp2[4];
                a[5] = a[5] + inp2[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp2[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp2[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp2[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp2[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp2[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp2[5];
                a[6] = a[6] + inp2[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp2[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp2[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp2[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp2[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp2[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp2[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp2[6];
                a[7] = a[7] + inp2[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                count = (short)(count - 32);
            }
            rdramDMA.writeDMA(Address, out, out_p -= 32, 32);
        }
    };
    protected ABI1.OpCode RESAMPLE3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int x;
            int flags = inst2 >>> 30 & 0xFF;
            int Pitch = (inst2 >>> 14 & 0xFFFF) << 1;
            int addy = inst1 & 0xFFFFFF;
            int Accum = 0;
            ShortBuffer dst = BufferSpaceShort;
            ShortBuffer src = BufferSpaceShort;
            int srcPtr = ((inst2 >>> 2 & 0xFFF) + 1264) / 2;
            srcPtr -= 4;
            int dstPtr = (inst2 & 3) != 0 ? 816 : 632;
            if ((flags & 1) == 0) {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, rdram.read16bit((addy / 2 + x ^ 1) * 2));
                    ++x;
                }
                Accum = rdram.read16bit(addy + 8) & 0xFFFF;
            } else {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, (short)0);
                    ++x;
                }
            }
            int i = 0;
            while (i < 184) {
                int location = (Accum * 64 >>> 16) * 8 / 2;
                int temp = src.get(srcPtr + 0 ^ 1) * ResampleLUT[location + 0];
                int accum = temp >> 15;
                temp = src.get(srcPtr + 1 ^ 1) * ResampleLUT[location + 1];
                accum += temp >> 15;
                temp = src.get(srcPtr + 2 ^ 1) * ResampleLUT[location + 2];
                accum += temp >> 15;
                temp = src.get(srcPtr + 3 ^ 1) * ResampleLUT[location + 3];
                if ((accum += temp >> 15) > Short.MAX_VALUE) {
                    accum = Short.MAX_VALUE;
                }
                if (accum < Short.MIN_VALUE) {
                    accum = Short.MIN_VALUE;
                }
                dst.put(dstPtr ^ 1, (short)accum);
                ++dstPtr;
                srcPtr += (Accum += Pitch) >>> 16;
                Accum &= 0xFFFF;
                ++i;
            }
            x = 0;
            while (x < 4) {
                rdram.write16bit((addy / 2 + x ^ 1) * 2, src.get(srcPtr + x ^ 1));
                ++x;
            }
            rdram.write16bit(addy + 8, (short)Accum);
        }
    };
    protected ABI1.OpCode INTERLEAVE3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            ShortBuffer outbuff = BufferSpaceShort;
            int outbuff_p = 632;
            ShortBuffer inSrcR = BufferSpaceShort;
            int inSrcR_p = 1440;
            ShortBuffer inSrcL = BufferSpaceShort;
            int inSrcL_p = 1256;
            int x = 0;
            while (x < 92) {
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                ++x;
            }
        }
    };
    protected ABI1.OpCode WHATISTHIS = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
        }
    };
    protected ABI1.OpCode MP3ADDY = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
        }
    };
    protected ABI1.OpCode MP3 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
        }
    };
    protected ABI1.OpCode DISABLE = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
        }
    };

    public void clock(long ticks) {
        this.alist[0] = this.DISABLE;
        this.alist[1] = this.ADPCM3;
        this.alist[2] = this.CLEARBUFF3;
        this.alist[3] = this.ENVMIXER3;
        this.alist[4] = this.LOADBUFF3;
        this.alist[5] = this.RESAMPLE3;
        this.alist[6] = this.SAVEBUFF3;
        this.alist[7] = this.MP3;
        this.alist[8] = this.MP3ADDY;
        this.alist[9] = this.SETVOL3;
        this.alist[10] = this.DMEMMOVE3;
        this.alist[11] = this.LOADADPCM3;
        this.alist[12] = this.MIXER3;
        this.alist[13] = this.INTERLEAVE3;
        this.alist[14] = this.WHATISTHIS;
        this.alist[15] = this.SETLOOP3;
        this.alist[16] = this.SPNOOP;
        this.alist[17] = this.SPNOOP;
        this.alist[18] = this.SPNOOP;
        this.alist[19] = this.SPNOOP;
        this.alist[20] = this.SPNOOP;
        this.alist[21] = this.SPNOOP;
        this.alist[22] = this.SPNOOP;
        this.alist[23] = this.SPNOOP;
        this.alist[24] = this.SPNOOP;
        this.alist[25] = this.SPNOOP;
        this.alist[26] = this.SPNOOP;
        this.alist[27] = this.SPNOOP;
        this.alist[28] = this.SPNOOP;
        this.alist[29] = this.SPNOOP;
        this.alist[30] = this.SPNOOP;
        this.alist[31] = this.SPNOOP;
        loopval = 0;
    }
}

