/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.n64.ucode.F3d;
import jario.n64.ucode.F3dex2;
import jario.n64.ucode.Gbi;
import jario.n64.ucode.Math3D;

public class F3dexbg
extends F3dex2 {
    protected F3d.OpCode F3DEXBG_Vtx = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            F3dexbg.this.gSPVertexBg(F3dexbg.segmentToPhysical((int)w1), w0 >> 12 & 0xFF, w0 >> 1 & 0x7F);
        }
    };
    protected F3d.OpCode F3DEXBG_MoveWord = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            int index = w0 >> 16 & 0xFF;
            int offset = w0 & 0xFFFF;
            int data = w1;
            switch (index) {
                case 2: {
                    F3dexbg.gSPNumLights((int)(data / 48));
                    break;
                }
                case 4: {
                    break;
                }
                case 6: {
                    F3dexbg.gSPSegment((int)(offset >> 2), (int)(data & 0xFFFFFF));
                    break;
                }
                case 8: {
                    F3dexbg.gSPFogFactor((short)((short)(data >> 16 & 0xFFFF)), (short)((short)(data & 0xFFFF)));
                    break;
                }
                case 12: {
                    break;
                }
                case 14: {
                    break;
                }
                case 16: {
                    if ((w0 & 8) != 0) {
                        return;
                    }
                    F3dexbg.this.gSPCoordMod(w1, w0 >> 1 & 3, w0 & 0x30);
                    break;
                }
                default: {
                    System.err.printf("moveword unknown (index: 0x%08X, offset 0x%08X)\n", index, offset);
                }
            }
        }
    };
    protected F3d.OpCode F3DEXBG_MoveMem = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            int idx = w0 & 0xFF;
            switch (idx) {
                case 8: {
                    int addr = F3dexbg.segmentToPhysical((int)w1);
                    if (addr + 16 > rdramSize) break;
                    F3dexbg.dp_writeRegister((int)10, (int)addr);
                    break;
                }
                case 10: {
                    F3dexbg.this.gSPLightBg(F3dexbg.segmentToPhysical((int)w1), (w0 >> 5 & 0x3FFF) / 48);
                    break;
                }
                case 14: {
                    F3dexbg.this.gSPNormals(F3dexbg.segmentToPhysical((int)w1));
                    break;
                }
                default: {
                    System.err.printf("movemem unknown (%d)\n", idx);
                }
            }
        }
    };
    protected F3d.OpCode F3DEXBG_Tri4 = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            F3dexbg.gSP4Triangles((int)(w0 >> 23 & 0x1F), (int)(w0 >> 18 & 0x1F), (int)((w0 >> 15 & 7) << 2 | w1 >> 30 & 3), (int)(w0 >> 10 & 0x1F), (int)(w0 >> 5 & 0x1F), (int)(w0 >> 0 & 0x1F), (int)(w1 >> 25 & 0x1F), (int)(w1 >> 20 & 0x1F), (int)(w1 >> 15 & 0x1F), (int)(w1 >> 10 & 0x1F), (int)(w1 >> 5 & 0x1F), (int)(w1 >> 0 & 0x1F));
        }
    };

    public void clock(long ticks) {
        F3dexbg.gbiInitFlags();
        Gbi.G_TRI1 = 5;
        Gbi.G_TRI2 = 6;
        Gbi.G_QUAD = 7;
        F3dexbg.sp_writeRegister((int)9, (int)18);
        F3dexbg.dlist[241] = this.F3D_RDPHalf_2;
        F3dexbg.dlist[227] = this.F3DEX2_SetOtherMode_H;
        F3dexbg.dlist[226] = this.F3DEX2_SetOtherMode_L;
        F3dexbg.dlist[225] = this.F3D_RDPHalf_1;
        F3dexbg.dlist[224] = this.F3D_SPNoOp;
        F3dexbg.dlist[223] = this.F3D_EndDL;
        F3dexbg.dlist[222] = this.F3D_DList;
        F3dexbg.dlist[221] = this.F3DEX_Load_uCode;
        F3dexbg.dlist[220] = this.F3DEXBG_MoveMem;
        F3dexbg.dlist[219] = this.F3DEXBG_MoveWord;
        F3dexbg.dlist[218] = this.F3DEX2_Mtx;
        F3dexbg.dlist[217] = this.F3DEX2_GeometryMode;
        F3dexbg.dlist[216] = this.F3DEX2_PopMtx;
        F3dexbg.dlist[215] = this.F3DEX2_Texture;
        F3dexbg.dlist[214] = this.F3DEX2_DMAIO;
        F3dexbg.dlist[213] = this.F3DEX2_Special_1;
        F3dexbg.dlist[212] = this.F3DEX2_Special_2;
        F3dexbg.dlist[211] = this.F3DEX2_Special_3;
        F3dexbg.dlist[1] = this.F3DEXBG_Vtx;
        F3dexbg.dlist[2] = this.F3DEX_ModifyVtx;
        F3dexbg.dlist[3] = this.F3DEX_CullDL;
        F3dexbg.dlist[4] = this.F3DEX_Branch_Z;
        F3dexbg.dlist[5] = this.F3DEX2_Tri1;
        F3dexbg.dlist[6] = this.F3DEX_Tri2;
        F3dexbg.dlist[7] = this.F3DEX2_Quad;
        int i = 16;
        while (i < 32) {
            F3dexbg.dlist[i] = this.F3DEXBG_Tri4;
            ++i;
        }
    }

    protected void gSPNormals(int address) {
        uc8_normale_addr = address;
    }

    protected void gSPCoordMod(int coord, int index, int pos) {
        if (pos == 0) {
            F3dexbg.uc8_coord_mod[0 + index] = (short)(coord >> 16);
            F3dexbg.uc8_coord_mod[1 + index] = (short)(coord & 0xFFFF);
        } else if (pos == 16) {
            F3dexbg.uc8_coord_mod[4 + index] = (float)(coord >> 16) / 65536.0f;
            F3dexbg.uc8_coord_mod[5 + index] = (float)(coord & 0xFFFF) / 65536.0f;
            F3dexbg.uc8_coord_mod[12 + index] = uc8_coord_mod[0 + index] + uc8_coord_mod[4 + index];
            F3dexbg.uc8_coord_mod[13 + index] = uc8_coord_mod[1 + index] + uc8_coord_mod[5 + index];
        } else if (pos == 32) {
            F3dexbg.uc8_coord_mod[8 + index] = (short)(coord >> 16);
            F3dexbg.uc8_coord_mod[9 + index] = (short)(coord & 0xFFFF);
        }
    }

    protected void gSPLightBg(int address, int n) {
        if ((n -= 2) >= 0) {
            int col = rdram.read8bit(address + 0) & 0xFF;
            F3dexbg.lights[n].color[0] = (float)col / 255.0f;
            F3dexbg.lights[n].nonblack = col;
            col = rdram.read8bit(address + 1) & 0xFF;
            F3dexbg.lights[n].color[1] = (float)col / 255.0f;
            F3dexbg.lights[n].nonblack += col;
            col = rdram.read8bit(address + 2) & 0xFF;
            F3dexbg.lights[n].color[2] = (float)col / 255.0f;
            F3dexbg.lights[n].nonblack += col;
            F3dexbg.lights[n].a = 1.0f;
            F3dexbg.lights[n].vec[0] = (float)rdram.read8bit(address + 8) / 127.0f;
            F3dexbg.lights[n].vec[1] = (float)rdram.read8bit(address + 9) / 127.0f;
            F3dexbg.lights[n].vec[2] = (float)rdram.read8bit(address + 10) / 127.0f;
            F3dexbg.lights[n].x = rdram16bit.read16bit(address + 32);
            F3dexbg.lights[n].y = rdram16bit.read16bit(address + 34);
            F3dexbg.lights[n].z = rdram16bit.read16bit(address + 36);
            F3dexbg.lights[n].w = rdram16bit.read16bit(address + 38);
            F3dexbg.lights[n].nonzero = rdram.read8bit(address + 12);
            F3dexbg.lights[n].ca = (float)F3dexbg.lights[n].nonzero / 16.0f;
        }
    }

    protected void gSPVertexBg(int address, int n, int v0) {
        if ((changed & 2) != 0) {
            F3dexbg.gSPCombineMatrices();
        }
        if (v0 - n < 0) {
            return;
        }
        int i = 0;
        while (i < n << 4) {
            F3d.SPVertex vertex = vertices[v0 - n + (i >> 4)];
            vertex.vtx[0] = rdram16bit.read16bit(address + i + 0);
            vertex.vtx[1] = rdram16bit.read16bit(address + i + 2);
            vertex.vtx[2] = rdram16bit.read16bit(address + i + 4);
            vertex.flag = rdram16bit.read16bit(address + i + 6);
            vertex.tex[0] = (float)rdram16bit.read16bit(address + i + 8) * 0.03125f;
            vertex.tex[1] = (float)rdram16bit.read16bit(address + i + 10) * 0.03125f;
            vertex.color[3] = (float)(rdram.read8bit(address + i + 15) & 0xFF) * 0.003921569f;
            Math3D.transformVertex((float[])vertex.vtx, (float[][])F3dexbg.matrix.combined);
            vertex.clip[0] = vertex.vtx[0] < -vertex.vtx[3] ? -1.0f : (vertex.vtx[0] > vertex.vtx[3] ? 1.0f : 0.0f);
            vertex.clip[1] = vertex.vtx[1] < -vertex.vtx[3] ? -1.0f : (vertex.vtx[1] > vertex.vtx[3] ? 1.0f : 0.0f);
            vertex.clip[2] = vertex.vtx[3] <= 0.0f ? -1.0f : (vertex.vtx[2] < -vertex.vtx[3] ? -0.1f : (vertex.vtx[2] > vertex.vtx[3] ? 1.0f : 0.0f));
            vertex.color[0] = (float)(rdram.read8bit(address + i + 12) & 0xFF) * 0.003921569f;
            vertex.color[1] = (float)(rdram.read8bit(address + i + 13) & 0xFF) * 0.003921569f;
            vertex.color[2] = (float)(rdram.read8bit(address + i + 14) & 0xFF) * 0.003921569f;
            if ((geometryMode & 0x20000) != 0) {
                float len;
                float vw;
                float vz;
                float vy;
                float vx;
                int l;
                int shift = v0 - n << 1;
                vertex.norm[0] = rdram.read8bit(uc8_normale_addr + (i >> 3) + shift + 0);
                vertex.norm[1] = rdram.read8bit(uc8_normale_addr + (i >> 3) + shift + 1);
                vertex.norm[2] = (byte)(vertex.flag & 0xFF);
                Math3D.transformVector((float[])vertex.norm, (float[][])F3dexbg.matrix.modelView[F3dexbg.matrix.modelViewi]);
                Math3D.normalize((float[])vertex.norm);
                if ((geometryMode & 0x80000) != 0) {
                    vertex.tex[0] = (float)StrictMath.acos(vertex.norm[0]) * 325.9493f;
                    vertex.tex[1] = (float)StrictMath.acos(vertex.norm[1]) * 325.9493f;
                } else {
                    vertex.tex[0] = (vertex.norm[0] + 1.0f) * 512.0f;
                    vertex.tex[1] = (vertex.norm[1] + 1.0f) * 512.0f;
                }
                float[] color = new float[]{F3dexbg.lights[F3dexbg.numLights].color[0], F3dexbg.lights[F3dexbg.numLights].color[1], F3dexbg.lights[F3dexbg.numLights].color[2]};
                float light_intensity = 0.0f;
                if ((geometryMode & 0x400000) != 0) {
                    Math3D.normalize((float[])vertex.norm);
                    l = 0;
                    while (l < numLights - 1) {
                        if (F3dexbg.lights[l].nonblack != 0 && !((light_intensity = Math3D.dotProduct((float[])vertex.norm, (float[])F3dexbg.lights[l].vec)) < 0.0f)) {
                            if (F3dexbg.lights[l].ca > 0.0f) {
                                vx = (vertex.vtx[0] + uc8_coord_mod[8]) * uc8_coord_mod[12] - F3dexbg.lights[l].x;
                                vy = (vertex.vtx[1] + uc8_coord_mod[9]) * uc8_coord_mod[13] - F3dexbg.lights[l].y;
                                vz = (vertex.vtx[2] + uc8_coord_mod[10]) * uc8_coord_mod[14] - F3dexbg.lights[l].z;
                                vw = (vertex.vtx[3] + uc8_coord_mod[11]) * uc8_coord_mod[15] - F3dexbg.lights[l].w;
                                len = (vx * vx + vy * vy + vz * vz + vw * vw) / 65536.0f;
                                float p_i = F3dexbg.lights[l].ca / len;
                                if (p_i > 1.0f) {
                                    p_i = 1.0f;
                                }
                                light_intensity *= p_i;
                            }
                            color[0] = color[0] + F3dexbg.lights[l].color[0] * light_intensity;
                            color[1] = color[1] + F3dexbg.lights[l].color[1] * light_intensity;
                            color[2] = color[2] + F3dexbg.lights[l].color[2] * light_intensity;
                        }
                        ++l;
                    }
                    light_intensity = Math3D.dotProduct((float[])vertex.norm, (float[])F3dexbg.lights[l].vec);
                    if (light_intensity > 0.0f) {
                        color[0] = color[0] + F3dexbg.lights[l].color[0] * light_intensity;
                        color[1] = color[1] + F3dexbg.lights[l].color[1] * light_intensity;
                        color[2] = color[2] + F3dexbg.lights[l].color[2] * light_intensity;
                    }
                } else {
                    l = 0;
                    while (l < numLights) {
                        if (F3dexbg.lights[l].nonblack != 0 && F3dexbg.lights[l].nonzero != 0) {
                            vx = (vertex.vtx[0] + uc8_coord_mod[8]) * uc8_coord_mod[12] - F3dexbg.lights[l].x;
                            vy = (vertex.vtx[1] + uc8_coord_mod[9]) * uc8_coord_mod[13] - F3dexbg.lights[l].y;
                            vz = (vertex.vtx[2] + uc8_coord_mod[10]) * uc8_coord_mod[14] - F3dexbg.lights[l].z;
                            vw = (vertex.vtx[3] + uc8_coord_mod[11]) * uc8_coord_mod[15] - F3dexbg.lights[l].w;
                            len = (vx * vx + vy * vy + vz * vz + vw * vw) / 65536.0f;
                            light_intensity = F3dexbg.lights[l].ca / len;
                            if (light_intensity > 1.0f) {
                                light_intensity = 1.0f;
                            }
                            color[0] = color[0] + F3dexbg.lights[l].color[0] * light_intensity;
                            color[1] = color[1] + F3dexbg.lights[l].color[1] * light_intensity;
                            color[2] = color[2] + F3dexbg.lights[l].color[2] * light_intensity;
                        }
                        ++l;
                    }
                }
                if (color[0] > 1.0f) {
                    color[0] = 1.0f;
                }
                if (color[1] > 1.0f) {
                    color[1] = 1.0f;
                }
                if (color[2] > 1.0f) {
                    color[2] = 1.0f;
                }
                vertex.color[0] = vertex.color[0] * color[0];
                vertex.color[1] = vertex.color[1] * color[1];
                vertex.color[2] = vertex.color[2] * color[2];
            }
            i += 16;
        }
    }
}

