/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Pif
implements Hardware,
Bus1bit,
Bus8bit,
Bus32bit {
    private static final int EEPROM_4K = 1;
    private static final int EEPROM_16K = 2;
    private BusDMA[] ctrbus;
    private BusDMA eeprom;
    private byte[] pifRom;
    private ByteBuffer pifRam;
    private boolean debug;
    private BusDMA noController = new BusDMA(){

        public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
            switch (dma.array()[offset + 2] & 0xFF) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        public void writeDMA(int pAddr, ByteBuffer dmaObj, int offset, int length) {
            byte[] dma = dmaObj.array();
            switch (dma[offset + 2] & 0xFF) {
                case 0: 
                case 255: {
                    if ((dma[offset + 1] & 0x80) != 0) break;
                    dma[offset + 1] = (byte)(dma[offset + 1] & 0xFF | 0x80);
                    break;
                }
                case 1: {
                    dma[offset + 1] = (byte)(dma[offset + 1] & 0xFF | 0x80);
                    break;
                }
                case 2: {
                    dma[offset + 1] = (byte)(dma[offset + 1] & 0xFF | 0x80);
                    break;
                }
                case 3: {
                    dma[offset + 1] = (byte)(dma[offset + 1] & 0xFF | 0x80);
                    break;
                }
                default: {
                    if (!Pif.this.debug) break;
                    System.err.printf("Unknown ControllerCommand %d\n", dma[offset + 2]);
                }
            }
        }
    };

    public Pif() {
        this.pifRom = new byte[1984];
        this.pifRam = ByteBuffer.wrap(new byte[64]);
        this.ctrbus = new BusDMA[4];
        int i = 0;
        while (i < 4) {
            this.ctrbus[i] = this.noController;
            ++i;
        }
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.ctrbus[0] = bus != null ? (BusDMA)bus : this.noController;
                break;
            }
            case 1: {
                this.ctrbus[1] = bus != null ? (BusDMA)bus : this.noController;
                break;
            }
            case 2: {
                this.ctrbus[2] = bus != null ? (BusDMA)bus : this.noController;
                break;
            }
            case 3: {
                this.ctrbus[3] = bus != null ? (BusDMA)bus : this.noController;
                break;
            }
            case 4: {
                this.eeprom = (BusDMA)bus;
            }
        }
    }

    public void reset() {
        this.pifRom = new byte[1984];
        this.pifRam = ByteBuffer.wrap(new byte[64]);
    }

    public boolean read1bit(int reg) {
        return false;
    }

    public void write1bit(int reg, boolean value) {
        switch (reg) {
            case 0: {
                if (value) {
                    this.pifRamRead();
                    break;
                }
                if ((this.pifRam.get(63) & 0xFF) > 1) {
                    this.pifRamControl(this.pifRam.get(63) & 0xFF);
                    break;
                }
                this.pifRamWrite();
                break;
            }
            case 256: {
                this.debug = value;
            }
        }
    }

    public byte read8bit(int pAddr) {
        if (pAddr < 1984) {
            return this.pifRom[pAddr];
        }
        if (pAddr < 2048) {
            return this.pifRam.get(pAddr - 1984);
        }
        System.err.println("Illegal PifRam LW: " + Integer.toHexString(pAddr));
        return 0;
    }

    public int read32bit(int pAddr) {
        if (pAddr < 1984) {
            return this.pifRom[pAddr] << 24 | this.pifRom[pAddr + 1] << 16 | this.pifRom[pAddr + 2] << 8 | this.pifRom[pAddr + 3];
        }
        if (pAddr < 2048) {
            return this.pifRam.getInt(pAddr - 1984);
        }
        System.err.println("Illegal PifRam LW: " + Integer.toHexString(pAddr));
        return 0;
    }

    public void write8bit(int pAddr, byte value) {
        if (pAddr < 1984) {
            System.err.println("Illegal PifRam SW: " + Integer.toHexString(pAddr));
            return;
        }
        if (pAddr < 2048) {
            this.pifRam.put(pAddr - 1984, value);
            if (pAddr == 2044) {
                if ((this.pifRam.get(63) & 0xFF) > 1) {
                    this.pifRamControl(this.pifRam.get(63) & 0xFF);
                } else {
                    this.pifRamWrite();
                }
            }
            return;
        }
        System.err.println("Illegal PifRam Register SW: " + Integer.toHexString(pAddr));
    }

    public void write32bit(int pAddr, int value) {
        if (pAddr < 1984) {
            System.err.println("Illegal PifRam SW: " + Integer.toHexString(pAddr));
            return;
        }
        if (pAddr < 2048) {
            this.pifRam.putInt(pAddr - 1984, value);
            if (pAddr == 2044) {
                if ((this.pifRam.get(63) & 0xFF) > 1) {
                    this.pifRamControl(this.pifRam.get(63) & 0xFF);
                } else {
                    this.pifRamWrite();
                }
            }
            return;
        }
        System.err.println("Illegal PifRam Register SW: " + Integer.toHexString(pAddr));
    }

    private void pifRamRead() {
        int channel = 0;
        int curPos = 0;
        block6: do {
            switch (this.pifRam.get(curPos) & 0xFF) {
                case 0: {
                    if (++channel <= 6) continue block6;
                    curPos = 64;
                    break;
                }
                case 254: {
                    curPos = 64;
                    break;
                }
                case 255: {
                    break;
                }
                case 86: 
                case 180: 
                case 184: {
                    break;
                }
                default: {
                    if ((this.pifRam.get(curPos) & 0xC0) == 0) {
                        if (channel < 4) {
                            this.ctrbus[channel].readDMA(channel, this.pifRam, curPos, 0);
                        }
                        curPos += (this.pifRam.get(curPos) & 0xFF) + (this.pifRam.get(curPos + 1) & 0x3F) + 1;
                        ++channel;
                        break;
                    }
                    if (this.debug) {
                        System.err.printf("Unknown Command in PifRamRead(%X)\n", this.pifRam.get(curPos));
                    }
                    curPos = 64;
                }
            }
        } while (++curPos < 64);
    }

    private void pifRamWrite() {
        int channel = 0;
        int curPos = 0;
        while (curPos < 64) {
            switch (this.pifRam.get(curPos) & 0xFF) {
                case 0: {
                    if (++channel <= 6) break;
                    curPos = 64;
                    break;
                }
                case 254: {
                    curPos = 64;
                    break;
                }
                case 255: {
                    break;
                }
                case 86: 
                case 180: 
                case 184: {
                    break;
                }
                default: {
                    if ((this.pifRam.get(curPos) & 0xC0) == 0) {
                        if (channel < 4) {
                            this.ctrbus[channel].writeDMA(channel, this.pifRam, curPos, 0);
                        } else if (channel == 4) {
                            this.pifRam.position(curPos);
                            this.eepromCommand(this.pifRam.slice(), curPos, 1, this.debug);
                            this.pifRam.position(0);
                        } else {
                            System.err.printf("Command on channel 5?\n", new Object[0]);
                        }
                        curPos += (this.pifRam.get(curPos) & 0xFF) + (this.pifRam.get(curPos + 1) & 0x3F) + 1;
                        ++channel;
                        break;
                    }
                    if (this.debug) {
                        System.err.printf("Unknown Command in PifRamWrite(%X)\n", this.pifRam.get(curPos));
                    }
                    curPos = 64;
                }
            }
            ++curPos;
        }
        this.pifRam.put(63, (byte)0);
    }

    private void pifRamControl(int command) {
        switch (command) {
            case 8: {
                this.pifRam.put(63, (byte)0);
                break;
            }
            case 16: {
                break;
            }
            case 48: {
                this.pifRam.put(63, (byte)-128);
                break;
            }
            case 192: {
                Arrays.fill(this.pifRam.array(), 0, 64, (byte)0);
                break;
            }
            default: {
                if (!this.debug) break;
                System.err.printf("Unkown PifRam control: %d\n", this.pifRam.get(63));
            }
        }
    }

    private void eepromCommand(ByteBuffer command, int offset, int saveType, boolean showPifRamErrors) {
        switch (command.get(2)) {
            case 0: {
                if (saveType != 1 && saveType != 2) {
                    command.put(1, (byte)(command.get(1) & 0xFF | 0x80));
                    break;
                }
                if (command.get(1) != 3) {
                    command.put(1, (byte)(command.get(1) & 0xFF | 0x40));
                    if ((command.get(1) & 3) > 0) {
                        command.put(3, (byte)0);
                    }
                    if (saveType == 1) {
                        if ((command.get(1) & 3) > 1) {
                            command.put(4, (byte)-128);
                        }
                    } else if ((command.get(1) & 3) > 1) {
                        command.put(4, (byte)-64);
                    }
                    if ((command.get(1) & 3) <= 2) break;
                    command.put(5, (byte)0);
                    break;
                }
                command.put(3, (byte)0);
                command.put(4, (byte)(saveType == 1 ? 128 : 192));
                command.put(5, (byte)0);
                break;
            }
            case 4: {
                if (command.get(0) != 2) {
                    System.err.printf("What am I meant to do with this Eeprom Command\n", new Object[0]);
                }
                if (command.get(1) != 8) {
                    System.err.printf("What am I meant to do with this Eeprom Command\n", new Object[0]);
                }
                this.eeprom.readDMA((int)command.get(3), command, offset + 4, 8);
                break;
            }
            case 5: {
                if (command.get(0) != 10) {
                    System.err.printf("What am I meant to do with this Eeprom Command\n", new Object[0]);
                }
                if (command.get(1) != 1) {
                    System.err.printf("What am I meant to do with this Eeprom Command\n", new Object[0]);
                }
                this.eeprom.writeDMA((int)command.get(3), command, offset + 4, 8);
                break;
            }
            default: {
                if (!showPifRamErrors) break;
                System.err.printf("Unkown EepromCommand %d\n", command.get(2));
            }
        }
    }
}

