/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console;

import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class Console
implements Hardware,
Configurable {
    private static final int Default_CountPerOp = 2;
    private static final int PIF_CONTROLLER1_PORT = 0;
    private static final int PIF_CONTROLLER2_PORT = 1;
    private static final int PIF_CONTROLLER3_PORT = 2;
    private static final int PIF_CONTROLLER4_PORT = 3;
    private static final int PIF_EEPROM_PORT = 4;
    private static final int DAC_VIDEO_PORT = 0;
    private static final int DAC_AUDIO_PORT = 1;
    private static final int CPU_DATA_PORT = 4;
    private static final int CPU_TIMING_PORT = 5;
    private static final int CPU_CLOCK_REG = 33;
    private static final int RCP_CART_PORT = 1;
    private static final int RCP_PIF_PORT = 2;
    private static final int RCP_MIPS_PORT = 3;
    private static final int RCP_RDRAM_PORT = 4;
    private static final int RCP_DAC_PORT = 6;
    private Hardware cpu;
    private Hardware rcp;
    private Hardware rdram;
    private Hardware pif;
    private Hardware dac;
    private Hardware cartridge;
    private Hardware[] controllers;

    public Console() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cpu = (Hardware)Class.forName(prop.getProperty("CPU", "CPU"), true, loader).newInstance();
            this.rcp = (Hardware)Class.forName(prop.getProperty("RCP", "RCP"), true, loader).newInstance();
            this.rdram = (Hardware)Class.forName(prop.getProperty("RDRAM", "RDRAM"), true, loader).newInstance();
            this.pif = (Hardware)Class.forName(prop.getProperty("PIF", "PIF"), true, loader).newInstance();
            this.dac = (Hardware)Class.forName(prop.getProperty("DAC", "DAC"), true, loader).newInstance();
        }
        catch (Exception e) {
            System.err.println("Missing resources.");
            e.printStackTrace();
            return;
        }
        this.cpu.connect(4, (Hardware)((Configurable)this.rcp).readConfig("MIPS"));
        this.cpu.connect(5, (Hardware)((Configurable)this.rcp).readConfig("TIMER"));
        this.rcp.connect(2, this.pif);
        this.rcp.connect(3, this.cpu);
        this.rcp.connect(4, this.rdram);
        this.rcp.connect(6, this.dac);
        this.dac.connect(6, this.rdram);
        this.controllers = new Hardware[4];
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                break;
            }
            case 1: {
                if (bus == null) {
                    this.pif.connect(0, null);
                    if (this.controllers[0] == null) break;
                    this.controllers[0].reset();
                    break;
                }
                this.controllers[0] = bus;
                this.controllers[0].reset();
                this.pif.connect(0, null);
                this.pif.connect(0, this.controllers[0]);
                break;
            }
            case 2: {
                if (bus == null) {
                    this.pif.connect(1, null);
                    if (this.controllers[1] == null) break;
                    this.controllers[1].reset();
                    break;
                }
                this.controllers[1] = bus;
                this.controllers[1].reset();
                this.pif.connect(1, null);
                this.pif.connect(1, this.controllers[1]);
                break;
            }
            case 3: {
                if (bus == null) {
                    this.pif.connect(2, null);
                    if (this.controllers[2] == null) break;
                    this.controllers[2].reset();
                    break;
                }
                this.controllers[2] = bus;
                this.controllers[2].reset();
                this.pif.connect(2, null);
                this.pif.connect(2, this.controllers[2]);
                break;
            }
            case 4: {
                if (bus == null) {
                    this.pif.connect(3, null);
                    if (this.controllers[3] == null) break;
                    this.controllers[3].reset();
                    break;
                }
                this.controllers[3] = bus;
                this.controllers[3].reset();
                this.pif.connect(3, null);
                this.pif.connect(3, this.controllers[3]);
                break;
            }
            case 5: {
                if (bus == null) {
                    ((Clockable)this.cpu).clock(0L);
                    if (this.cartridge != null) {
                        this.cartridge.reset();
                    }
                    this.cpu.reset();
                    this.rcp.reset();
                    this.pif.reset();
                    this.dac.reset();
                    break;
                }
                this.cartridge = bus;
                this.cartridge.reset();
                this.pif.connect(4, (Hardware)((Configurable)this.cartridge).readConfig("S-DAT"));
                int countPerOp = -1;
                if (countPerOp < 1) {
                    countPerOp = 2;
                }
                if (countPerOp > 6) {
                    countPerOp = 2;
                }
                ((Bus32bit)this.cpu).write32bit(33, countPerOp);
                this.runBIOS((Bus8bit)this.cartridge, (Bus32bit)((Configurable)this.rcp).readConfig("MIPS"), (Bus64bit)this.cpu);
                this.rcp.connect(1, bus);
                ((Clockable)this.cpu).clock(1L);
                break;
            }
            case 6: {
                this.dac.connect(0, bus);
                break;
            }
            case 7: {
                this.dac.connect(1, bus);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
    }

    public void reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object readConfig(String key) {
        if (key.equals("instructioncache")) {
            return ((Configurable)this.cpu).readConfig("instructioncache");
        }
        if (key.equals("framelimit")) {
            return ((Configurable)this.rcp).readConfig("framelimit");
        }
        if (key.equals("framebuffer")) {
            return ((Configurable)this.rcp).readConfig("framebuffer");
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("instructioncache")) {
            ((Configurable)this.cpu).writeConfig("instructioncache", value);
        } else if (key.equals("framelimit")) {
            ((Configurable)this.rcp).writeConfig("framelimit", value);
        } else if (key.equals("framebuffer")) {
            ((Configurable)this.rcp).writeConfig("framebuffer", value);
        }
    }

    private void runBIOS(Bus8bit rom, Bus32bit mem, Bus64bit cpu) {
        switch (rom.read8bit(184549438)) {
            case 68: 
            case 70: 
            case 73: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: {
                break;
            }
            case 0: 
            case 55: 
            case 65: 
            case 69: 
            case 74: {
                break;
            }
            default: {
                System.err.printf("Unknown country in LoadPifRom\n", new Object[0]);
            }
        }
        byte country = rom.read8bit(184549438);
        int cicChip = (Integer)((Configurable)rom).readConfig("cic");
        if (cicChip < 0) {
            System.err.printf("Unknown Cic Chip: %d", cicChip);
            cicChip = 2;
        }
        int i = 0;
        while (i < 4028) {
            ((Bus8bit)mem).write8bit(0x4000040 + i, rom.read8bit(0xB000040 + i));
            ++i;
        }
        ((Bus32bit)cpu).write32bit(32, -1543503808);
        cpu.write64bit(0, 0L);
        cpu.write64bit(6, -1543495924L);
        cpu.write64bit(7, -1543495928L);
        cpu.write64bit(8, 192L);
        cpu.write64bit(9, 0L);
        cpu.write64bit(10, 64L);
        cpu.write64bit(11, -1543503808L);
        cpu.write64bit(16, 0L);
        cpu.write64bit(17, 0L);
        cpu.write64bit(18, 0L);
        cpu.write64bit(19, 0L);
        cpu.write64bit(21, 0L);
        cpu.write64bit(26, 0L);
        cpu.write64bit(27, 0L);
        cpu.write64bit(28, 0L);
        cpu.write64bit(29, -1543495696L);
        cpu.write64bit(30, 0L);
        switch (country) {
            case 68: 
            case 70: 
            case 73: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: {
                switch (cicChip) {
                    case 2: {
                        cpu.write64bit(5, -1057892263L);
                        cpu.write64bit(14, 769722602L);
                        cpu.write64bit(24, 0L);
                        break;
                    }
                    case 3: {
                        cpu.write64bit(5, -731618701L);
                        cpu.write64bit(14, 452565380L);
                        cpu.write64bit(24, 0L);
                        break;
                    }
                    case 5: {
                        mem.write32bit(0x4001004, -1113061380);
                        cpu.write64bit(5, -557143343L);
                        cpu.write64bit(14, 217603091L);
                        cpu.write64bit(24, 2L);
                        break;
                    }
                    case 6: {
                        cpu.write64bit(5, -1337079549L);
                        cpu.write64bit(14, 452565380L);
                        cpu.write64bit(24, 2L);
                    }
                }
                cpu.write64bit(20, 0L);
                cpu.write64bit(23, 6L);
                cpu.write64bit(31, -1543498412L);
                break;
            }
            default: {
                switch (cicChip) {
                    case 2: {
                        cpu.write64bit(5, -916884523L);
                        cpu.write64bit(14, 608805734L);
                        break;
                    }
                    case 3: {
                        cpu.write64bit(5, -1791927768L);
                        cpu.write64bit(14, 1538040287L);
                        break;
                    }
                    case 5: {
                        mem.write32bit(0x4001004, -1918367748);
                        cpu.write64bit(5, 1418984346L);
                        cpu.write64bit(14, -1027472508L);
                    }
                    case 6: {
                        cpu.write64bit(5, -530111969L);
                        cpu.write64bit(14, 1557313295L);
                    }
                }
                cpu.write64bit(20, 1L);
                cpu.write64bit(23, 0L);
                cpu.write64bit(24, 3L);
                cpu.write64bit(31, -1543498416L);
            }
        }
        switch (cicChip) {
            case 1: {
                cpu.write64bit(22, 63L);
                break;
            }
            case 2: {
                cpu.write64bit(1, 1L);
                cpu.write64bit(2, 247309622L);
                cpu.write64bit(3, 247309622L);
                cpu.write64bit(4, 42294L);
                cpu.write64bit(12, -317665101L);
                cpu.write64bit(13, 335717580L);
                cpu.write64bit(15, 822337825L);
                cpu.write64bit(22, 63L);
                cpu.write64bit(25, -1645497009L);
                break;
            }
            case 3: {
                cpu.write64bit(1, 1L);
                cpu.write64bit(2, 1235611286L);
                cpu.write64bit(3, 1235611286L);
                cpu.write64bit(4, 61078L);
                cpu.write64bit(12, -828507145L);
                cpu.write64bit(13, -828507145L);
                cpu.write64bit(15, 414596392L);
                cpu.write64bit(22, 120L);
                cpu.write64bit(25, -2107956791L);
                break;
            }
            case 5: {
                mem.write32bit(0x4001000, 1007534016);
                mem.write32bit(67112968, 632096704);
                mem.write32bit(67112972, 822608000);
                mem.write32bit(0x4001010, 1426128892);
                mem.write32bit(0x4001014, 1007534016);
                mem.write32bit(67112984, -1918369756);
                mem.write32bit(67112988, 1007398912);
                cpu.write64bit(1, 0L);
                cpu.write64bit(2, -175435841L);
                cpu.write64bit(3, -175435841L);
                cpu.write64bit(4, 4031L);
                cpu.write64bit(12, -1773012962L);
                cpu.write64bit(13, 759343813L);
                cpu.write64bit(15, 1448627552L);
                cpu.write64bit(22, 145L);
                cpu.write64bit(25, -842115489L);
                break;
            }
            case 6: {
                cpu.write64bit(1, 0L);
                cpu.write64bit(2, -1453772636L);
                cpu.write64bit(3, -1453772636L);
                cpu.write64bit(4, 12452L);
                cpu.write64bit(12, -1128950512L);
                cpu.write64bit(13, -1128950512L);
                cpu.write64bit(15, 2050754548L);
                cpu.write64bit(22, 133L);
                cpu.write64bit(25, 1180581746L);
            }
        }
        System.out.printf("BIOS complete\n", new Object[0]);
    }
}

