/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.cartridge;

import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.Properties;

public class Cartridge
implements Hardware,
Bus8bit,
Bus32bit,
BusDMA,
Configurable {
    private static final int CART_SRAM_PORT = 0;
    private static final int CART_FLASHRAM_PORT = 1;
    private Hardware cartrom;
    private final Bus8bit cartrom8bit;
    private final Bus32bit cartrom32bit;
    private final BusDMA cartromDMA;
    private Hardware eeprom;
    private Hardware sram;
    private Hardware flashram;

    public Cartridge() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cartrom = (Hardware)Class.forName(prop.getProperty("CARTRIDGE_ROM", "CARTRIDGE_ROM"), true, loader).newInstance();
            this.eeprom = (Hardware)Class.forName(prop.getProperty("EEPROM", "EEPROM"), true, loader).newInstance();
            this.sram = (Hardware)Class.forName(prop.getProperty("SRAM", "SRAM"), true, loader).newInstance();
            this.flashram = (Hardware)Class.forName(prop.getProperty("FLASHRAM", "FLASHRAM"), true, loader).newInstance();
        }
        catch (Exception e) {
            System.err.println("Missing resources.");
            e.printStackTrace();
        }
        this.cartrom.connect(0, this.sram);
        this.cartrom.connect(1, this.flashram);
        this.cartrom8bit = (Bus8bit)this.cartrom;
        this.cartrom32bit = (Bus32bit)this.cartrom;
        this.cartromDMA = (BusDMA)this.cartrom;
    }

    public void connect(int port, Hardware bus) {
    }

    public void reset() {
        this.cartrom.reset();
        this.eeprom.reset();
    }

    public final byte read8bit(int address) {
        return this.cartrom8bit.read8bit(address);
    }

    public final void write8bit(int address, byte data) {
        this.cartrom8bit.write8bit(address, data);
    }

    public final int read32bit(int address) {
        return this.cartrom32bit.read32bit(address);
    }

    public final void write32bit(int address, int data) {
        this.cartrom32bit.write32bit(address, data);
    }

    public final void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        this.cartromDMA.readDMA(pAddr, dma, offset, length);
    }

    public final void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        this.cartromDMA.writeDMA(pAddr, dma, offset, length);
    }

    public Object readConfig(String key) {
        if (key.equals("S-DAT")) {
            return this.eeprom;
        }
        if (key.equals("cic")) {
            return ((Configurable)this.cartrom).readConfig("cic");
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("romfile")) {
            ((Configurable)this.cartrom).writeConfig("romfile", value);
        } else if (key.equals("savefile")) {
            ((Configurable)this.eeprom).writeConfig("file", (Object)(value + ".eep"));
            ((Configurable)this.sram).writeConfig("file", (Object)(value + ".sra"));
            ((Configurable)this.flashram).writeConfig("file", (Object)(value + ".fla"));
        }
    }
}

