/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class SignalProcessor
implements Hardware,
Bus8bit,
Bus16bit,
Bus32bit,
Bus64bit {
    private static final int MI_INTR_REG = 70254600;
    private static final int MI_INTR_CLR_SP = 1;
    private static final int MI_INTR_SET_SP = 2;
    private static final int DPC_STATUS_REG = 68157452;
    private static final int DPC_INIT_REG = 68157484;
    private static final int DPC_CLR_FREEZE = 4;
    private static final int SP_MEM_ADDR_REG = 0;
    private static final int SP_DRAM_ADDR_REG = 1;
    private static final int SP_RD_LEN_REG = 2;
    private static final int SP_WR_LEN_REG = 3;
    private static final int SP_STATUS_REG = 4;
    private static final int SP_DMA_FULL_REG = 5;
    private static final int SP_DMA_BUSY_REG = 6;
    private static final int SP_SEMAPHORE_REG = 7;
    private static final int SP_PC_REG = 8;
    private static final int SP_CLR_HALT = 1;
    private static final int SP_SET_HALT = 2;
    private static final int SP_CLR_BROKE = 4;
    private static final int SP_CLR_INTR = 8;
    private static final int SP_SET_INTR = 16;
    private static final int SP_CLR_SSTEP = 32;
    private static final int SP_SET_SSTEP = 64;
    private static final int SP_CLR_INTR_BREAK = 128;
    private static final int SP_SET_INTR_BREAK = 256;
    private static final int SP_CLR_SIG0 = 512;
    private static final int SP_SET_SIG0 = 1024;
    private static final int SP_CLR_SIG1 = 2048;
    private static final int SP_SET_SIG1 = 4096;
    private static final int SP_CLR_SIG2 = 8192;
    private static final int SP_SET_SIG2 = 16384;
    private static final int SP_CLR_SIG3 = 32768;
    private static final int SP_SET_SIG3 = 65536;
    private static final int SP_CLR_SIG4 = 131072;
    private static final int SP_SET_SIG4 = 262144;
    private static final int SP_CLR_SIG5 = 524288;
    private static final int SP_SET_SIG5 = 0x100000;
    private static final int SP_CLR_SIG6 = 0x200000;
    private static final int SP_SET_SIG6 = 0x400000;
    private static final int SP_CLR_SIG7 = 0x800000;
    private static final int SP_SET_SIG7 = 0x1000000;
    private static final int SP_STATUS_HALT = 1;
    private static final int SP_STATUS_BROKE = 2;
    private static final int SP_STATUS_DMA_BUSY = 4;
    private static final int SP_STATUS_SSTEP = 32;
    private static final int SP_STATUS_INTR_BREAK = 64;
    private static final int SP_STATUS_SIG0 = 128;
    private static final int SP_STATUS_SIG1 = 256;
    private static final int SP_STATUS_SIG2 = 512;
    private static final int SP_STATUS_SIG3 = 1024;
    private static final int SP_STATUS_SIG4 = 2048;
    private static final int SP_STATUS_SIG5 = 4096;
    private static final int SP_STATUS_SIG6 = 8192;
    private static final int SP_STATUS_SIG7 = 16384;
    private static final int RDRAM_CAPACITY_REG = 66060328;
    private static final int UCODE_RDRAM_PORT = 1;
    private static final int UCODE_SP_PORT = 2;
    private static final int UCODE_DP_PORT = 3;
    private static final boolean DLIST = true;
    private static final boolean ALIST = true;
    private int[] regSP = new int[10];
    private ByteBuffer dmem;
    private Bus32bit rdram;
    private Bus32bit mi;
    private Bus32bit dp;
    private int inst2;
    private int inst1;
    private int UCData;
    private int pcStackSize;
    private int[] PC = new int[18];
    private int PCi;
    private boolean halt;
    private int rdramSize;
    private Microcode current;
    private int numMicrocodes;
    private Microcode top;
    private Microcode bottom;
    private Checksum crc32 = new Adler32();
    private int uc_crc;
    private String uc_str;
    private ByteBuffer rdramcrc = ByteBuffer.allocate(4096);
    private Microcode[] specialMicrocodes = new Microcode[]{new Microcode(10, false, -780597534, "RSP SW Version: 2.0D, 04-01-96"), new Microcode(10, false, -1799043021, "RSP SW Version: 2.0D, 04-01-96"), new Microcode(6, false, -1645014911, "RSP Gfx ucode S2DEX  1.06 Yoshitaka Yasumoto Nintendo."), new Microcode(9, false, -1919867825, "Diddy Kong Racing"), new Microcode(9, false, 1852819603, "Diddy Kong Racing"), new Microcode(9, false, -1108749829, "Jet Force Gemini"), new Microcode(8, false, 474970217, "Perfect Dark")};
    private Bus64bit[] dUcode = new Bus64bit[13];
    private Bus64bit[] aUcode = new Bus64bit[4];

    public SignalProcessor() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dUcode[0] = (Bus64bit)Class.forName(prop.getProperty("UGBI00", "UGBI00"), true, loader).newInstance();
            this.dUcode[1] = (Bus64bit)Class.forName(prop.getProperty("UGBI01", "UGBI01"), true, loader).newInstance();
            this.dUcode[2] = (Bus64bit)Class.forName(prop.getProperty("UGBI02", "UGBI02"), true, loader).newInstance();
            this.dUcode[3] = (Bus64bit)Class.forName(prop.getProperty("UGBI03", "UGBI03"), true, loader).newInstance();
            this.dUcode[4] = (Bus64bit)Class.forName(prop.getProperty("UGBI04", "UGBI04"), true, loader).newInstance();
            this.dUcode[5] = (Bus64bit)Class.forName(prop.getProperty("UGBI05", "UGBI05"), true, loader).newInstance();
            this.dUcode[6] = (Bus64bit)Class.forName(prop.getProperty("UGBI06", "UGBI06"), true, loader).newInstance();
            this.dUcode[7] = (Bus64bit)Class.forName(prop.getProperty("UGBI07", "UGBI07"), true, loader).newInstance();
            this.dUcode[8] = (Bus64bit)Class.forName(prop.getProperty("UGBI08", "UGBI08"), true, loader).newInstance();
            this.dUcode[9] = (Bus64bit)Class.forName(prop.getProperty("UGBI09", "UGBI09"), true, loader).newInstance();
            this.dUcode[10] = (Bus64bit)Class.forName(prop.getProperty("UGBI10", "UGBI10"), true, loader).newInstance();
            this.dUcode[11] = (Bus64bit)Class.forName(prop.getProperty("UGBI11", "UGBI11"), true, loader).newInstance();
            this.dUcode[12] = (Bus64bit)Class.forName(prop.getProperty("UGBI12", "UGBI12"), true, loader).newInstance();
            this.aUcode[0] = (Bus64bit)Class.forName(prop.getProperty("UABI00", "UABI00"), true, loader).newInstance();
            this.aUcode[1] = (Bus64bit)Class.forName(prop.getProperty("UABI01", "UABI01"), true, loader).newInstance();
            this.aUcode[2] = (Bus64bit)Class.forName(prop.getProperty("UABI02", "UABI02"), true, loader).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.regSP[4] = 1;
        this.dmem = ByteBuffer.allocate(8192);
        int i = 0;
        while (i < this.dUcode.length) {
            if (this.dUcode[i] != null) {
                ((Hardware)this.dUcode[i]).connect(2, (Hardware)this);
            }
            ++i;
        }
        i = 0;
        while (i < this.aUcode.length) {
            if (this.aUcode[i] != null) {
                ((Hardware)this.aUcode[i]).connect(2, (Hardware)this);
            }
            ++i;
        }
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram = (Bus32bit)bus;
                int i = 0;
                while (i < this.dUcode.length) {
                    if (this.dUcode[i] != null) {
                        ((Hardware)this.dUcode[i]).connect(1, (Hardware)this.rdram);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.aUcode.length) {
                    if (this.aUcode[i] != null) {
                        ((Hardware)this.aUcode[i]).connect(1, (Hardware)this.rdram);
                    }
                    ++i;
                }
                if (this.rdram == null) break;
                this.rdramSize = this.rdram.read32bit(66060328);
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.dp = (Bus32bit)bus;
                if (this.dp == null) break;
                this.top = null;
                this.bottom = null;
                this.current = null;
                this.numMicrocodes = 0;
                int i = 0;
                while (i < this.dUcode.length) {
                    if (this.dUcode[i] != null) {
                        ((Hardware)this.dUcode[i]).connect(3, (Hardware)this.dp);
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                break;
            }
            default: {
                System.err.println("Attempting to connect bus on invalid port: " + port);
            }
        }
    }

    public void reset() {
        this.regSP[4] = 1;
        if (this.dUcode[0] != null) {
            ((Hardware)this.dUcode[0]).reset();
        }
    }

    public byte read8bit(int pAddr) {
        return this.dmem.get(pAddr);
    }

    public short read16bit(int pAddr) {
        return this.dmem.getShort(pAddr);
    }

    public int read32bit(int pAddr) {
        if (pAddr < 8192) {
            return this.dmem.getInt(pAddr);
        }
        switch (pAddr - 0x4040000 >> 2) {
            case 4: {
                return this.regSP[4];
            }
            case 5: {
                return this.regSP[5];
            }
            case 6: {
                return this.regSP[6];
            }
            case 10: {
                return this.PC[this.PCi];
            }
            case 11: {
                if (this.PCi > 0) {
                    --this.PCi;
                } else {
                    this.halt = true;
                }
                return this.PCi;
            }
            case 12: {
                return this.current.NoN ? 1 : 0;
            }
            case 65536: {
                return this.regSP[8];
            }
        }
        return 0;
    }

    public long read64bit(int pAddr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write8bit(int pAddr, byte value) {
        this.dmem.put(pAddr, value);
    }

    public void write16bit(int pAddr, short value) {
        this.dmem.putShort(pAddr, value);
    }

    public void write32bit(int pAddr, int value) {
        if (pAddr < 8192) {
            this.dmem.putInt(pAddr, value);
        } else {
            if (pAddr - 0x4040000 >> 2 < 0) {
                return;
            }
            switch (pAddr - 0x4040000 >> 2) {
                case 0: {
                    this.regSP[0] = value;
                    break;
                }
                case 1: {
                    this.regSP[1] = value;
                    break;
                }
                case 2: {
                    this.regSP[2] = value;
                    this.spDmaRead(this.regSP[1], this.regSP[0], this.regSP[2]);
                    break;
                }
                case 3: {
                    this.regSP[3] = value;
                    System.out.println("SP_DMA_WRITE");
                    break;
                }
                case 4: {
                    if ((value & 1) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFFFE;
                    }
                    if ((value & 2) != 0) {
                        this.regSP[4] = this.regSP[4] | 1;
                    }
                    if ((value & 4) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFFFD;
                    }
                    if ((value & 8) != 0) {
                        this.mi.write32bit(70254600, 1);
                    }
                    if ((value & 0x10) != 0) {
                        System.err.printf("SP_SET_INTR\n", new Object[0]);
                    }
                    if ((value & 0x20) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFFDF;
                    }
                    if ((value & 0x40) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x20;
                    }
                    if ((value & 0x80) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFFBF;
                    }
                    if ((value & 0x100) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x40;
                    }
                    if ((value & 0x200) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFF7F;
                    }
                    if ((value & 0x400) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x80;
                    }
                    if ((value & 0x800) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFEFF;
                    }
                    if ((value & 0x1000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x100;
                    }
                    if ((value & 0x2000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFDFF;
                    }
                    if ((value & 0x4000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x200;
                    }
                    if ((value & 0x8000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFFBFF;
                    }
                    if ((value & 0x10000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x400;
                    }
                    if ((value & 0x20000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFF7FF;
                    }
                    if ((value & 0x40000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x800;
                    }
                    if ((value & 0x80000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFEFFF;
                    }
                    if ((value & 0x100000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x1000;
                    }
                    if ((value & 0x200000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFDFFF;
                    }
                    if ((value & 0x400000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x2000;
                    }
                    if ((value & 0x800000) != 0) {
                        this.regSP[4] = this.regSP[4] & 0xFFFFBFFF;
                    }
                    if ((value & 0x1000000) != 0) {
                        this.regSP[4] = this.regSP[4] | 0x4000;
                    }
                    this.runRsp(this.dmem.getInt(4032));
                    break;
                }
                case 7: {
                    this.regSP[7] = 0;
                    break;
                }
                case 9: {
                    this.pcStackSize = value;
                    break;
                }
                case 10: {
                    this.PC[this.PCi] = value;
                    break;
                }
                case 11: {
                    if (value + 8 > this.rdramSize || this.PCi >= this.pcStackSize - 1) break;
                    ++this.PCi;
                    this.PC[this.PCi] = value;
                    break;
                }
                case 65536: {
                    this.regSP[8] = value & 0xFFC;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write64bit(int pAddr, long value) {
        block1: {
            if (value >>> 63 == 0L) ** GOTO lbl10
            this.gSPLoadUcodeEx((int)value, pAddr, (short)(value >> 32));
            break block1;
            while ((int)value <= 0 || this.PC[this.PCi] - pAddr < (int)value << 3) {
                w0 = this.rdram.read32bit(this.PC[this.PCi]);
                w1 = this.rdram.read32bit(this.PC[this.PCi] + 4);
                v0 = this.PCi;
                this.PC[v0] = this.PC[v0] + 8;
                this.dUcode[this.current.type].write64bit(0, (long)w0 << 32 | (long)w1 & 0xFFFFFFFFL);
lbl10:
                // 2 sources

                if (!this.halt) continue;
            }
        }
    }

    private void gSPLoadUcodeEx(int uc_start, int uc_dstart, short uc_dsize) {
        this.PCi = 0;
        if ((uc_start & 0x1FFFFFFF) + 4096 > this.rdramSize || (uc_dstart & 0x1FFFFFFF) + uc_dsize > this.rdramSize) {
            return;
        }
        Microcode ucode = this.detectMicrocode(uc_start, uc_dstart, uc_dsize);
        if (ucode.type != 12) {
            if (ucode != this.top) {
                if (ucode == this.bottom) {
                    this.bottom = ucode.higher;
                    this.bottom.lower = null;
                } else {
                    ucode.higher.lower = ucode.lower;
                    ucode.lower.higher = ucode.higher;
                }
                ucode.higher = null;
                ucode.lower = this.top;
                this.top.higher = ucode;
                this.top = ucode;
            }
            if (this.current == null || this.current.type != ucode.type) {
                ((Clockable)this.dUcode[12]).clock(1L);
                ((Clockable)this.dUcode[ucode.type]).clock(1L);
            }
            this.current = ucode;
        }
    }

    private void runRsp(int taskType) {
        if ((this.regSP[4] & 1) == 0 && (this.regSP[4] & 2) == 0) {
            if (taskType == 1) {
                this.processDList();
                this.regSP[4] = this.regSP[4] | 0x203;
                if ((this.regSP[4] & 0x40) != 0) {
                    this.mi.write32bit(70254600, 2);
                }
                this.dp.write32bit(68157452, 4);
                return;
            }
            if (taskType == 2) {
                this.processAList();
                this.regSP[4] = this.regSP[4] | 0x203;
                if ((this.regSP[4] & 0x40) != 0) {
                    this.mi.write32bit(70254600, 2);
                }
                return;
            }
            this.regSP[4] = this.regSP[4] | 0x203;
            if ((this.regSP[4] & 0x40) != 0) {
                this.mi.write32bit(70254600, 2);
            }
            return;
        }
    }

    private void spDmaRead(int dramAddr, int memAddr, int rdLen) {
        if ((dramAddr &= 0x1FFFFFFF) > this.rdram.read32bit(66060328)) {
            System.err.printf("SP DMA READ\nSP_DRAM_ADDR_REG not in RDRam space\n", new Object[0]);
            this.regSP[6] = 0;
            this.regSP[4] = this.regSP[4] & 0xFFFFFFFB;
            return;
        }
        if (rdLen + 1 + (memAddr & 0xFFF) > 4096) {
            System.err.printf("SP DMA READ\ncould not fit copy in memory segement\n", new Object[0]);
            return;
        }
        ((BusDMA)this.rdram).readDMA(dramAddr, this.dmem, memAddr & 0x1FFF, rdLen + 1);
        this.regSP[6] = 0;
        this.regSP[4] = this.regSP[4] & 0xFFFFFFFB;
    }

    private void processDList() {
        this.loadGfxUcode(0, 0);
        this.PCi = 0;
        this.PC[this.PCi] = this.dmem.getInt(4080);
        this.halt = false;
        this.dp.write32bit(68157484, 1);
        this.write64bit(0, 0L);
        ((Clockable)this.dp).clock(1L);
    }

    private void processAList() {
        this.UCData = this.dmem.getInt(4056);
        int ucode = this.audio_ucode_detect();
        ((Clockable)this.aUcode[ucode]).clock(1L);
        this.PC[0] = this.dmem.getInt(4080);
        this.PCi = 0;
        int listLen = this.dmem.getInt(4084) >>> 2;
        int x = 0;
        while (x < listLen) {
            this.inst1 = this.rdram.read32bit(this.PC[this.PCi]);
            this.inst2 = this.rdram.read32bit(this.PC[this.PCi] + 4);
            int n = this.PCi;
            this.PC[n] = this.PC[n] + 8;
            this.aUcode[ucode].write64bit(0, (long)this.inst1 << 32 | (long)this.inst2 & 0xFFFFFFFFL);
            x += 2;
        }
    }

    private void loadGfxUcode(int uc_start, int uc_dstart) {
        ((Bus32bit)this.dUcode[0]).write32bit(0, this.dmem.getInt(4068));
        int uc_start_t = this.dmem.getInt(4048);
        int uc_dstart_t = this.dmem.getInt(4056);
        int uc_dsize_t = this.dmem.getInt(4060);
        if (uc_start_t != uc_start || uc_dstart_t != uc_dstart) {
            this.gSPLoadUcodeEx(uc_start_t, uc_dstart_t, (short)uc_dsize_t);
        }
    }

    private int audio_ucode_detect() {
        if (this.rdram.read32bit(this.UCData + 0) != 1) {
            if ((((Bus8bit)this.rdram).read8bit(this.UCData + 3) & 0xFF) == 15) {
                return 3;
            }
            return 2;
        }
        if (this.rdram.read32bit(this.UCData + 48) == -268431616) {
            return 0;
        }
        return 1;
    }

    private Microcode detectMicrocode(int uc_start, int uc_dstart, short uc_dsize) {
        Microcode detected;
        int i = 0;
        while (i < this.numMicrocodes) {
            detected = this.top;
            while (detected != null) {
                if (detected.address == uc_start && detected.dataAddress == uc_dstart && detected.dataSize == uc_dsize) {
                    return detected;
                }
                detected = detected.lower;
            }
            ++i;
        }
        detected = this.addMicrocode();
        detected.address = uc_start;
        detected.dataAddress = uc_dstart;
        detected.dataSize = uc_dsize;
        detected.NoN = false;
        detected.type = 12;
        this.crc32.reset();
        ((BusDMA)this.rdram).readDMA(uc_start & 0x1FFFFFFF, this.rdramcrc, 0, 4096);
        this.crc32.update(this.rdramcrc.array(), 0, 4096);
        this.uc_crc = (int)this.crc32.getValue();
        i = 0;
        while (i < this.specialMicrocodes.length) {
            if (this.uc_crc == this.specialMicrocodes[i].crc) {
                detected.type = this.specialMicrocodes[i].type;
                return detected;
            }
            ++i;
        }
        ByteBuffer buff = ByteBuffer.allocate(2048);
        byte[] uc_data = buff.array();
        ((BusDMA)this.rdram).readDMA(uc_dstart & 0x1FFFFFFF, buff, 0, 2048);
        this.uc_str = "Not Found";
        int i2 = 0;
        while (i2 < 2048) {
            if (uc_data[i2] == 82 && uc_data[i2 + 1] == 83 && uc_data[i2 + 2] == 80) {
                int j = 0;
                this.uc_str = "";
                while (uc_data[i2 + j] > 10) {
                    this.uc_str = String.valueOf(this.uc_str) + (char)uc_data[i2 + j];
                    ++j;
                }
                int type = 12;
                if (uc_data[i2 + 4] == 83 && uc_data[i2 + 5] == 87) {
                    type = 0;
                } else if (uc_data[i2 + 4] == 71 && uc_data[i2 + 5] == 102 && uc_data[i2 + 6] == 120) {
                    detected.NoN = this.uc_str.contains(".NoN");
                    if (uc_data[i2 + 14] == 70 && uc_data[i2 + 15] == 51 && uc_data[i2 + 16] == 68) {
                        if (detected.lower != null && detected.lower.type == 11) {
                            type = 11;
                        } else if (uc_data[i2 + 19] == 66 && uc_data[i2 + 20] == 71) {
                            type = 11;
                        } else if (uc_data[i2 + 28] == 48 || uc_data[i2 + 28] == 49) {
                            type = 1;
                        } else if (uc_data[i2 + 31] == 50) {
                            type = 2;
                        }
                    } else if (uc_data[i2 + 14] == 76 && uc_data[i2 + 15] == 51 && uc_data[i2 + 16] == 68) {
                        if (uc_data[i2 + 28] == 49) {
                            type = 4;
                        } else if (uc_data[i2 + 31] == 50) {
                            type = 5;
                        }
                    } else if (uc_data[i2 + 14] == 83 && uc_data[i2 + 15] == 50 && uc_data[i2 + 16] == 68) {
                        if (uc_data[i2 + 28] == 49) {
                            type = 6;
                        } else if (uc_data[i2 + 31] == 50) {
                            type = 7;
                        }
                    }
                }
                if (type == 12) break;
                detected.type = type;
                return detected;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.specialMicrocodes.length) {
            if (this.uc_str.compareTo(this.specialMicrocodes[i2].text) == 0) {
                detected.type = this.specialMicrocodes[i2].type;
                return detected;
            }
            ++i2;
        }
        return detected;
    }

    private Microcode addMicrocode() {
        Microcode newtop = new Microcode(0, false, 0, null);
        newtop.lower = this.top;
        newtop.higher = null;
        if (this.top != null) {
            this.top.higher = newtop;
        }
        if (this.bottom == null) {
            this.bottom = newtop;
        }
        this.top = newtop;
        ++this.numMicrocodes;
        return newtop;
    }

    private class Microcode {
        public static final int F3D = 0;
        public static final int F3DEX = 1;
        public static final int F3DEX2 = 2;
        public static final int L3DEX = 4;
        public static final int L3DEX2 = 5;
        public static final int S2DEX = 6;
        public static final int S2DEX2 = 7;
        public static final int F3DPD = 8;
        public static final int F3DDKR = 9;
        public static final int F3DWRUS = 10;
        public static final int F3DEXBG = 11;
        public static final int NONE = 12;
        public int address;
        public int dataAddress;
        public short dataSize;
        public int type;
        public boolean NoN;
        public int crc;
        public String text;
        public Microcode higher;
        public Microcode lower;

        public Microcode(int type, boolean NoN, int crc, String text) {
            this.type = type;
            this.NoN = NoN;
            this.crc = crc;
            this.text = text;
        }
    }
}

