/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus32bit;
import jario.hardware.Hardware;

public class AudioInterface
implements Hardware,
Bus32bit {
    private static final int SYSTEM_NTSC = 0;
    private static final int SYSTEM_PAL = 1;
    private static final int SYSTEM_MPAL = 2;
    private static final int AI_DRAM_ADDR_REG = 0;
    private static final int AI_LEN_REG = 1;
    private static final int AI_CONTROL_REG = 2;
    private static final int AI_STATUS_REG = 3;
    private static final int AI_DACRATE_REG = 4;
    private static final int AI_BITRATE_REG = 5;
    private static final int MI_INTR_REG = 70254600;
    private static final int MI_INTR_CLR_AI = 16;
    private static final int MI_INTR_SET_AI = 32;
    private static final int SND_IS_NOT_EMPTY = 0x4000000;
    private static final int SND_IS_FULL = 0x8000000;
    private static final int SEGMENTS = 3;
    private static final int DAC_AUDIO_POS_REG = 0;
    private static final int DAC_SAMPLE_RATE_REG = 1;
    private static final int DAC_BIT_LENGTH_REG = 2;
    private static final int DAC_CHANNELS_REG = 3;
    private static final int DAC_DMA_OFFSET_REG = 6;
    private static final int DAC_DMA_REG = 7;
    private int readLoc;
    private int writeLoc;
    private int SampleRate;
    private int SegmentSize;
    private int write_pos = 0;
    private int play_pos = 0;
    private int last_write = -1;
    private int buffsize = 0;
    private int laststatus = 0;
    private int dacrate = 0;
    private int[] regAI = new int[6];
    private Hardware rdram;
    private Bus32bit mi;
    private Bus32bit dac;

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram = bus;
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.dac = (Bus32bit)bus;
                if (this.dac == null) break;
                this.dac.write32bit(0, 1);
                break;
            }
        }
    }

    public void reset() {
        this.dacrate = 0;
    }

    public int read32bit(int reg) {
        switch (reg - 0x4500000 >> 2) {
            case 1: {
                if (this.buffsize == 0) {
                    this.regAI[1] = 0;
                    return this.regAI[1];
                }
                this.updateStatus();
                return this.regAI[1];
            }
            case 3: {
                return this.regAI[3];
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg - 0x4500000 >> 2) {
            case 0: {
                this.regAI[0] = value;
                break;
            }
            case 1: {
                this.regAI[1] = value;
                this.addBuffer(this.rdram, this.regAI[0] & 0xFFFFF8, this.regAI[1] & 0x3FFF8);
                break;
            }
            case 2: {
                this.regAI[2] = value & 1;
                break;
            }
            case 3: {
                this.mi.write32bit(70254600, 16);
                break;
            }
            case 4: {
                this.regAI[4] = value;
                int systemType = 0;
                if (this.dacrate == this.regAI[4]) break;
                this.dacrate = this.regAI[4];
                float frequency = 0.0f;
                switch (systemType) {
                    case 0: {
                        frequency = 4.8681812E7f / (float)(this.dacrate + 1);
                        break;
                    }
                    case 1: {
                        frequency = 4.965653E7f / (float)(this.dacrate + 1);
                        break;
                    }
                    case 2: {
                        frequency = 4.8628316E7f / (float)(this.dacrate + 1);
                    }
                }
                this.SampleRate = (int)(frequency * 1.0416666f);
                this.SegmentSize = 0;
                break;
            }
            case 5: {
                this.regAI[5] = value;
            }
        }
    }

    private void updateStatus() {
        this.play_pos = this.dac.read32bit(0);
        if (this.play_pos == -1) {
            return;
        }
        this.write_pos = this.play_pos < this.buffsize ? this.buffsize * 3 - this.buffsize : this.play_pos / this.buffsize * this.buffsize - this.buffsize;
        int writediff = this.write_pos - this.last_write;
        if (writediff < 0) {
            writediff += 3 * this.buffsize;
        }
        int play_seg = this.play_pos / this.buffsize;
        int last_seg = this.last_write / this.buffsize;
        int write_seg = this.play_pos / this.buffsize;
        if (last_seg == write_seg) {
            this.regAI[3] = this.regAI[3] | 0xC0000000;
            this.regAI[1] = this.buffsize - (this.play_pos - this.play_pos / this.buffsize * this.buffsize);
            this.regAI[1] = this.play_pos > this.write_pos ? this.buffsize - (this.write_pos - this.play_pos - this.buffsize) : this.buffsize - this.play_pos;
            this.regAI[1] = this.regAI[1] + this.buffsize;
            this.laststatus = -1073741824;
            return;
        }
        if (this.laststatus == -1073741824) {
            this.regAI[1] = this.buffsize;
            this.regAI[1] = this.buffsize - (this.play_pos - this.play_pos / this.buffsize * this.buffsize);
            this.regAI[3] = 0x40000000;
            if ((play_seg - last_seg & 7) > 3) {
                this.mi.write32bit(70254600, 32);
            }
            this.laststatus = 0x40000000;
            return;
        }
        if (this.laststatus == 0x40000000) {
            if (writediff > this.buffsize * 2) {
                this.regAI[1] = 0;
                this.regAI[3] = 0;
                if ((play_seg - last_seg & 7) > 2) {
                    this.mi.write32bit(70254600, 32);
                }
            }
            return;
        }
    }

    private void fillBuffer(Hardware buff, int offset, int len) {
        int write_seg = 0;
        int last_seg = 0;
        this.buffsize = len;
        this.play_pos = this.dac.read32bit(0);
        this.write_pos = this.play_pos < len ? len * 3 - len : this.play_pos / len * len - len;
        if (this.last_write == -1) {
            this.last_write = this.write_pos - 2 * len;
            if (this.last_write < 0) {
                this.last_write += 3 * len;
            }
        }
        if ((last_seg = this.last_write / len) == ((write_seg = this.write_pos / len) - 2 & 7)) {
            this.write_pos = this.last_write + len;
            if (this.write_pos >= len * 3) {
                this.write_pos -= len * 3;
            }
            this.last_write += len;
            if (this.last_write >= len * 3) {
                this.last_write -= len * 3;
            }
            this.regAI[3] = this.regAI[3] | 0x40000000;
            this.laststatus = 0x40000000;
        } else if (last_seg == (write_seg - 1 & 7)) {
            this.last_write = this.write_pos;
            this.regAI[3] = this.regAI[3] | 0xC0000000;
            this.laststatus = -1073741824;
        } else {
            this.last_write = this.write_pos;
            this.regAI[3] = this.regAI[3] | 0;
            this.laststatus = 0;
        }
        this.dac.write32bit(6, offset);
        this.dac.write32bit(7, len);
    }

    private int addBuffer(Hardware start, int offset, int length) {
        int retVal = 0;
        if (length == 0) {
            return 0;
        }
        if (length == 2240) {
            length = 2112;
        }
        if (length == 2176) {
            length = 2112;
        }
        if (length != this.SegmentSize && this.SampleRate != 0) {
            this.SegmentSize = length;
            this.dac.write32bit(1, this.SampleRate);
            this.dac.write32bit(2, 16);
            this.dac.write32bit(3, 2);
        }
        if (this.readLoc == this.writeLoc) {
            this.readLoc = 0;
            this.writeLoc = 0;
        }
        if (this.readLoc != this.writeLoc) {
            retVal |= 0x8000000;
        }
        retVal |= 0x4000000;
        this.writeLoc += length;
        this.fillBuffer(start, offset, length);
        this.writeLoc = 0;
        this.readLoc = 0;
        this.updateStatus();
        return retVal;
    }
}

