/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

public class DepthBufferStack {
    public DepthBuffer top;
    public DepthBuffer bottom;
    private int numBuffers;

    public void init() {
        this.top = null;
        this.bottom = null;
        this.numBuffers = 0;
    }

    public void removeBottom() {
        if (this.bottom == this.top) {
            this.top = null;
        }
        this.bottom = this.bottom.higher;
        if (this.bottom != null) {
            this.bottom.lower = null;
        }
        --this.numBuffers;
    }

    public void remove(DepthBuffer buffer) {
        if (buffer == this.bottom && buffer == this.top) {
            this.top = null;
            this.bottom = null;
        } else if (buffer == this.bottom) {
            this.bottom = buffer.higher;
            if (this.bottom != null) {
                this.bottom.lower = null;
            }
        } else if (buffer == this.top) {
            this.top = buffer.lower;
            if (this.top != null) {
                this.top.higher = null;
            }
        } else {
            buffer.higher.lower = buffer.lower;
            buffer.lower.higher = buffer.higher;
        }
        --this.numBuffers;
    }

    public void addTop(DepthBuffer newtop) {
        newtop.lower = this.top;
        newtop.higher = null;
        if (this.top != null) {
            this.top.higher = newtop;
        }
        if (this.bottom == null) {
            this.bottom = newtop;
        }
        this.top = newtop;
        ++this.numBuffers;
    }

    public void moveToTop(DepthBuffer newtop) {
        if (newtop == this.top) {
            return;
        }
        if (newtop == this.bottom) {
            this.bottom = newtop.higher;
            this.bottom.lower = null;
        } else {
            newtop.higher.lower = newtop.lower;
            newtop.lower.higher = newtop.higher;
        }
        newtop.higher = null;
        newtop.lower = this.top;
        this.top.higher = newtop;
        this.top = newtop;
    }

    public DepthBuffer findBuffer(int address) {
        DepthBuffer buffer = this.top;
        while (buffer != null) {
            if (buffer.address == address) {
                return buffer;
            }
            buffer = buffer.lower;
        }
        return null;
    }

    public static class DepthBuffer {
        public boolean cleared;
        public DepthBuffer higher;
        public DepthBuffer lower;
        public int address;
    }
}

