/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import com.jogamp.common.nio.Buffers;
import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.n64.console.rcp.DepthBufferStack;
import jario.n64.console.rcp.combiners.Combiners;
import jario.n64.console.rcp.textures.TextureCache;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.awt.GLCanvas;

public class DisplayProcessor
implements Hardware,
Clockable,
Bus32bit,
BusDMA {
    private static final boolean debug = false;
    private static final boolean wireframe = false;
    private static final int SIZEOF_FLOAT = 4;
    private static final int SIZEOF_GLVERTEX = 68;
    private static final int VI_H_START_REG = 9;
    private static final int VI_V_START_REG = 10;
    private static final int VI_X_SCALE_REG = 12;
    private static final int VI_Y_SCALE_REG = 13;
    private static final int MI_INTR_REG = 70254600;
    private static final int MI_INTR_SET_DP = 2048;
    private static final int DPC_START_REG = 0;
    private static final int DPC_END_REG = 1;
    private static final int DPC_CURRENT_REG = 2;
    private static final int DPC_STATUS_REG = 3;
    private static final int DPC_CLOCK_REG = 4;
    private static final int DPC_BUFBUSY_REG = 5;
    private static final int DPC_PIPEBUSY_REG = 6;
    private static final int DPC_TMEM_REG = 7;
    private static final int DPC_CLR_XBUS_DMEM_DMA = 1;
    private static final int DPC_SET_XBUS_DMEM_DMA = 2;
    private static final int DPC_CLR_FREEZE = 4;
    private static final int DPC_SET_FREEZE = 8;
    private static final int DPC_CLR_FLUSH = 16;
    private static final int DPC_SET_FLUSH = 32;
    private static final int DPC_STATUS_XBUS_DMEM_DMA = 1;
    private static final int DPC_STATUS_FREEZE = 2;
    private static final int DPC_STATUS_FLUSH = 4;
    private static final int CHANGED_RENDERMODE = 1;
    private static final int CHANGED_CYCLETYPE = 2;
    private static final int CHANGED_SCISSOR = 4;
    private static final int CHANGED_TILE = 16;
    private static final int CHANGED_COMBINE_COLORS = 32;
    private static final int CHANGED_COMBINE = 64;
    private static final int CHANGED_ALPHACOMPARE = 128;
    private static final int CHANGED_FOGCOLOR = 256;
    private static final int CHANGED_TEXTURE = 512;
    private static final int CHANGED_VIEWPORT = 1024;
    private static final float FIXED2FLOATRECIP2 = 0.25f;
    private static final float FIXED2FLOATRECIP5 = 0.03125f;
    private static final float FIXED2FLOATRECIP10 = 9.765625E-4f;
    private static final int G_PM_NPRIMITIVE = 0;
    private static final int G_CYC_1CYCLE = 0;
    private static final int G_CYC_2CYCLE = 1;
    private static final int G_CYC_COPY = 2;
    private static final int G_CYC_FILL = 3;
    private static final int G_TP_PERSP = 1;
    private static final int G_TD_CLAMP = 0;
    private static final int G_TL_TILE = 0;
    private static final int G_TT_NONE = 0;
    private static final int G_TF_POINT = 0;
    private static final int G_TC_FILT = 6;
    private static final int G_CK_NONE = 0;
    private static final int G_CD_DISABLE = 3;
    private static final int G_AD_DISABLE = 3;
    private static final int G_AC_NONE = 0;
    private static final int G_AC_THRESHOLD = 1;
    private static final int G_AC_DITHER = 3;
    private static final int G_ZS_PIXEL = 0;
    private static final int G_ZS_PRIM = 1;
    private static final int ZMODE_DEC = 3;
    private static final int PIPELINE_MODE = 0x800000;
    private static final int CYCLE_TYPE = 0x300000;
    private static final int TEX_PERSP = 524288;
    private static final int TEX_DETAIL = 393216;
    private static final int TEX_LOD = 65536;
    private static final int TEX_LUT = 49152;
    private static final int TEX_FILTER = 12288;
    private static final int TEX_CONVERT = 3584;
    private static final int COMBINE_KEY = 256;
    private static final int COLOR_DITHER = 192;
    private static final int ALPHA_DITHER = 48;
    private static final int DEPTH_SOURCE = 4;
    private static final int ALPHA_COMPARE = 3;
    private static GL2 gl;
    private static TextureCache cache;
    private static int width;
    private static int height;
    private static int windowedWidth;
    private static int windowedHeight;
    private GLCanvas canvas;
    private GLDrawable hDC;
    private GLContext context;
    private boolean colorbufferChanged;
    private boolean render;
    private int changed;
    private OtherMode otherMode = new OtherMode();
    private float[] fogColor = new float[4];
    private float[] blendColor = new float[4];
    private Scissor scissor = new Scissor();
    private ColorImage colorImage = new ColorImage();
    private PrimDepth primDepth = new PrimDepth();
    private DepthBufferStack depthBuffers = new DepthBufferStack();
    private DepthBufferStack.DepthBuffer current;
    private int depthImageAddress;
    private FillColor fillColor = new FillColor();
    private Combiners combiners = new Combiners();
    private ByteBuffer tmem = ByteBuffer.allocate(4096);
    private OpCode[] rdp_command_table;
    private byte[] rdp_cmd_data;
    private int numTriangles;
    private GLVertex[] vertices = new GLVertex[256];
    private FloatBuffer bigArray;
    private float zDepth;
    private int numVertices;
    private float nearZ;
    private float vTrans;
    private float vScale;
    private int heightOffset;
    private boolean usePolygonStipple;
    private byte[][][] stipplePattern = new byte[32][8][128];
    private int lastStipple;
    private final GLSimpleVertex rect0 = new GLSimpleVertex();
    private final GLSimpleVertex rect1 = new GLSimpleVertex();
    private int screenWidth;
    private int screenHeight;
    private float scaleX;
    private float scaleY;
    private int[] regDPC = new int[10];
    private Bus16bit rdram;
    private Bus32bit mi;
    private Bus32bit vi;
    protected OpCode rdp_noop = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_tri_noshade = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 0, 0, 0, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_noshade_z = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 0, 0, 1, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_tex = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 0, 1, 0, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_tex_z = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 0, 1, 1, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_shade = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 1, 0, 0, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_shade_z = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 1, 0, 1, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_texshade = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 1, 1, 0, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tri_texshade_z = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.rglTriangle(w1, w2, 1, 1, 1, DisplayProcessor.this.rdp_cmd_data, 0);
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_tex_rect = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            int w3 = (DisplayProcessor.this.rdp_cmd_data[8] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[9] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[10] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[11] & 0xFF;
            int w4 = (DisplayProcessor.this.rdp_cmd_data[12] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[13] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[14] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[15] & 0xFF;
            DisplayProcessor.this.gDPTextureRectangle(w1, w2, w3, w4);
        }
    };
    protected OpCode rdp_tex_rect_flip = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            int w3 = (DisplayProcessor.this.rdp_cmd_data[8] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[9] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[10] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[11] & 0xFF;
            int w4 = (DisplayProcessor.this.rdp_cmd_data[12] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[13] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[14] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[15] & 0xFF;
            DisplayProcessor.this.gDPTextureRectangleFlip(w1, w2, w3, w4);
        }
    };
    protected OpCode rdp_sync_load = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_sync_pipe = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_sync_tile = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_sync_full = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            DisplayProcessor.this.mi.write32bit(70254600, 2048);
        }
    };
    protected OpCode rdp_set_key_gb = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_set_key_r = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_set_convert = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
        }
    };
    protected OpCode rdp_set_scissor = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).scissor.ulx = (float)(w1 >> 12 & 0xFFF) * 0.25f;
            ((DisplayProcessor)DisplayProcessor.this).scissor.uly = (float)(w1 >> 0 & 0xFFF) * 0.25f;
            ((DisplayProcessor)DisplayProcessor.this).scissor.lrx = (float)(w2 >> 12 & 0xFFF) * 0.25f;
            ((DisplayProcessor)DisplayProcessor.this).scissor.lry = (float)(w2 >> 0 & 0xFFF) * 0.25f;
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 4;
        }
    };
    protected OpCode rdp_set_prim_depth = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).primDepth.z = w2 >> 16 & 0xFFFF;
            DisplayProcessor.this.zDepth = StrictMath.min(1.0f, StrictMath.max(0.0f, (((DisplayProcessor)DisplayProcessor.this).primDepth.z * 3.0517578E-5f - DisplayProcessor.this.vTrans) / DisplayProcessor.this.vScale));
        }
    };
    protected OpCode rdp_set_other_modes = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).otherMode.w0 = w1 & 0xFFFFFF;
            ((DisplayProcessor)DisplayProcessor.this).otherMode.w1 = w2;
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x83;
        }
    };
    protected OpCode rdp_load_tlut = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTileSize(w1, w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x10;
            cache.loadLUT(w1, w2);
        }
    };
    protected OpCode rdp_set_tile_size = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTileSize(w1, w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x10;
        }
    };
    protected OpCode rdp_load_block = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTileSize(w1, w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x10;
            cache.loadBlock(w1, w2);
        }
    };
    protected OpCode rdp_load_tile = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTileSize(w1, w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x10;
            cache.loadTile(w1, w2);
        }
    };
    protected OpCode rdp_set_tile = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTile(w1, w2);
        }
    };
    protected OpCode rdp_fill_rect = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            int ulx = w2 >> 14 & 0x3FF;
            int uly = w2 >> 2 & 0x3FF;
            int lrx = w1 >> 14 & 0x3FF;
            int lry = w1 >> 2 & 0x3FF;
            DepthBufferStack.DepthBuffer buffer = DisplayProcessor.this.depthBuffers.findBuffer(((DisplayProcessor)DisplayProcessor.this).colorImage.address);
            if (buffer != null) {
                buffer.cleared = true;
            }
            if (DisplayProcessor.this.depthImageAddress == ((DisplayProcessor)DisplayProcessor.this).colorImage.address) {
                DisplayProcessor.this.glClearDepthBuffer(DisplayProcessor.RDP_GETOM_Z_UPDATE_EN(DisplayProcessor.this.otherMode) != 0);
                return;
            }
            if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(DisplayProcessor.this.otherMode) == 3 && ulx == 0 && uly == 0 && ++lrx == DisplayProcessor.this.screenWidth && ++lry == DisplayProcessor.this.screenHeight) {
                DisplayProcessor.this.glClearColorBuffer(((DisplayProcessor)DisplayProcessor.this).fillColor.color);
                return;
            }
            DisplayProcessor.this.glDrawRect(ulx, uly, lrx, lry, DisplayProcessor.RDP_GETOM_CYCLE_TYPE(DisplayProcessor.this.otherMode) == 3 ? ((DisplayProcessor)DisplayProcessor.this).fillColor.color : DisplayProcessor.this.blendColor, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(DisplayProcessor.this.otherMode));
            if (DisplayProcessor.this.current != null) {
                ((DisplayProcessor)DisplayProcessor.this).current.cleared = false;
            }
            ((DisplayProcessor)DisplayProcessor.this).colorImage.height = StrictMath.max(((DisplayProcessor)DisplayProcessor.this).colorImage.height, lry);
        }
    };
    protected OpCode rdp_set_fill_color = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).fillColor.color[0] = (float)(w2 >> 11 & 0x1F) * 0.032258064f;
            ((DisplayProcessor)DisplayProcessor.this).fillColor.color[1] = (float)(w2 >> 6 & 0x1F) * 0.032258064f;
            ((DisplayProcessor)DisplayProcessor.this).fillColor.color[2] = (float)(w2 >> 1 & 0x1F) * 0.032258064f;
            ((DisplayProcessor)DisplayProcessor.this).fillColor.color[3] = w2 & 1;
        }
    };
    protected OpCode rdp_set_fog_color = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).fogColor[0] = (float)(w2 >> 24 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).fogColor[1] = (float)(w2 >> 16 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).fogColor[2] = (float)(w2 >> 8 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).fogColor[3] = (float)(w2 >> 0 & 0xFF) * 0.003921569f;
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x100;
        }
    };
    protected OpCode rdp_set_blend_color = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).blendColor[0] = (float)(w2 >> 24 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).blendColor[1] = (float)(w2 >> 16 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).blendColor[2] = (float)(w2 >> 8 & 0xFF) * 0.003921569f;
            ((DisplayProcessor)DisplayProcessor.this).blendColor[3] = (float)(w2 >> 0 & 0xFF) * 0.003921569f;
        }
    };
    protected OpCode rdp_set_prim_color = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            Combiners.primColor.m = w1 >> 8 & 0x1F;
            Combiners.primColor.l = (float)(w1 >> 0 & 0xFF) * 0.003921569f;
            Combiners.primColor.r = (float)(w2 >> 24 & 0xFF) * 0.003921569f;
            Combiners.primColor.g = (float)(w2 >> 16 & 0xFF) * 0.003921569f;
            Combiners.primColor.b = (float)(w2 >> 8 & 0xFF) * 0.003921569f;
            Combiners.primColor.a = (float)(w2 >> 0 & 0xFF) * 0.003921569f;
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x20;
        }
    };
    protected OpCode rdp_set_env_color = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            Combiners.envColor[0] = (float)(w2 >> 24 & 0xFF) * 0.003921569f;
            Combiners.envColor[1] = (float)(w2 >> 16 & 0xFF) * 0.003921569f;
            Combiners.envColor[2] = (float)(w2 >> 8 & 0xFF) * 0.003921569f;
            Combiners.envColor[3] = (float)(w2 >> 0 & 0xFF) * 0.003921569f;
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x20;
        }
    };
    protected OpCode rdp_set_combine = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            ((DisplayProcessor)DisplayProcessor.this).combiners.combine.setMuxs0(w1 & 0xFFFFFF);
            ((DisplayProcessor)DisplayProcessor.this).combiners.combine.setMuxs1(w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x40;
        }
    };
    protected OpCode rdp_set_texture_image = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTextureImage(w1, w2);
        }
    };
    protected OpCode rdp_set_mask_image = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            int address = w2 & 0x3FFFFFF;
            DepthBufferStack.DepthBuffer buffer = ((DisplayProcessor)DisplayProcessor.this).depthBuffers.top;
            while (buffer != null) {
                if (buffer.address == address) {
                    DisplayProcessor.this.depthBuffers.moveToTop(buffer);
                    DisplayProcessor.this.current = buffer;
                    return;
                }
                buffer = buffer.lower;
            }
            buffer = new DepthBufferStack.DepthBuffer();
            DisplayProcessor.this.depthBuffers.addTop(buffer);
            buffer.address = address;
            buffer.cleared = true;
            DisplayProcessor.this.current = buffer;
            if (((DisplayProcessor)DisplayProcessor.this).current.cleared) {
                DisplayProcessor.this.glClearDepthBuffer(DisplayProcessor.RDP_GETOM_Z_UPDATE_EN(DisplayProcessor.this.otherMode) != 0);
            }
            DisplayProcessor.this.depthImageAddress = address;
        }
    };
    protected OpCode rdp_set_color_image = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            int address = w2 & 0x3FFFFFF;
            int width = (w1 & 0xFFF) + 1;
            if (((DisplayProcessor)DisplayProcessor.this).colorImage.address != address) {
                ((DisplayProcessor)DisplayProcessor.this).colorImage.height = width == DisplayProcessor.this.screenWidth ? DisplayProcessor.this.screenHeight : 1;
            }
            ((DisplayProcessor)DisplayProcessor.this).colorImage.address = address;
        }
    };
    protected OpCode rdp_invalid = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            System.out.printf("RDP: invalid command  %d, %s %s\n", w1 >> 24 & 0x3F, Integer.toHexString(w1), Integer.toHexString(w2));
        }
    };
    protected OpCode rdp_hle_triangle = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            Vertex[] tmpvertices = new Vertex[]{new Vertex(), new Vertex(), new Vertex()};
            tmpvertices[0].vtx = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[8] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[9] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[10] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[11] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[12] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[13] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[14] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[15] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[16] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[17] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[18] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[19] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[20] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[21] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[22] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[23] & 0xFF)};
            tmpvertices[1].vtx = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[24] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[25] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[26] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[27] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[28] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[29] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[30] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[31] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[32] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[33] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[34] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[35] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[36] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[37] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[38] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[39] & 0xFF)};
            tmpvertices[2].vtx = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[40] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[41] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[42] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[43] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[44] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[45] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[46] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[47] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[48] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[49] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[50] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[51] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[52] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[53] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[54] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[55] & 0xFF)};
            tmpvertices[0].color = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[56] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[57] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[58] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[59] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[60] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[61] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[62] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[63] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[64] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[65] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[66] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[67] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[68] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[69] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[70] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[71] & 0xFF)};
            tmpvertices[1].color = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[72] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[73] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[74] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[75] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[76] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[77] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[78] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[79] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[80] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[81] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[82] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[83] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[84] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[85] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[86] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[87] & 0xFF)};
            tmpvertices[2].color = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[88] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[89] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[90] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[91] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[92] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[93] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[94] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[95] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[96] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[97] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[98] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[99] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[100] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[101] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[102] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[103] & 0xFF)};
            tmpvertices[0].tex = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[104] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[105] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[106] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[107] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[108] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[109] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[110] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[111] & 0xFF)};
            tmpvertices[1].tex = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[112] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[113] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[114] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[115] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[116] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[117] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[118] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[119] & 0xFF)};
            tmpvertices[2].tex = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[120] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[121] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[122] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[123] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[124] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[125] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[126] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[127] & 0xFF)};
            tmpvertices[0].clip = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[128] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[129] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[130] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[131] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[132] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[133] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[134] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[135] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[136] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[137] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[138] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[139] & 0xFF)};
            tmpvertices[1].clip = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[144] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[145] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[146] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[147] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[148] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[149] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[150] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[151] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[152] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[153] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[154] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[155] & 0xFF)};
            tmpvertices[2].clip = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[160] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[161] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[162] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[163] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[164] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[165] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[166] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[167] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[168] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[169] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[170] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[171] & 0xFF)};
            if ((DisplayProcessor.this.rdp_cmd_data[1] & 0xFF) != 0 && (tmpvertices[0].clip[2] < 0.0f || tmpvertices[1].clip[2] < 0.0f || tmpvertices[2].clip[2] < 0.0f)) {
                Vertex[] nearVertices = new Vertex[4];
                Vertex[] clippedVertices = new Vertex[4];
                int i = 0;
                while (i < 4) {
                    nearVertices[i] = new Vertex();
                    clippedVertices[i] = new Vertex();
                    ++i;
                }
                int nearIndex = 0;
                int clippedIndex = 0;
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                int[] v = nArray;
                int i2 = 0;
                while (i2 < 3) {
                    int j = i2 + 1;
                    if (j == 3) {
                        j = 0;
                    }
                    if (tmpvertices[v[i2]].clip[2] < 0.0f && tmpvertices[v[j]].clip[2] >= 0.0f || tmpvertices[v[i2]].clip[2] >= 0.0f && tmpvertices[v[j]].clip[2] < 0.0f) {
                        float percent = (-tmpvertices[v[i2]].vtx[3] - tmpvertices[v[i2]].vtx[2]) / (tmpvertices[v[j]].vtx[2] - tmpvertices[v[i2]].vtx[2] + (tmpvertices[v[j]].vtx[3] - tmpvertices[v[i2]].vtx[3]));
                        clippedVertices[clippedIndex].interpolateVertex(percent, tmpvertices[v[i2]], tmpvertices[v[j]]);
                        nearVertices[nearIndex].copyVertex(clippedVertices[clippedIndex]);
                        nearVertices[nearIndex].vtx[2] = -nearVertices[nearIndex].vtx[3];
                        ++clippedIndex;
                        ++nearIndex;
                    }
                    if (tmpvertices[v[i2]].clip[2] < 0.0f && tmpvertices[v[j]].clip[2] >= 0.0f || tmpvertices[v[i2]].clip[2] >= 0.0f && tmpvertices[v[j]].clip[2] >= 0.0f) {
                        clippedVertices[clippedIndex].copyVertex(tmpvertices[v[j]]);
                        ++clippedIndex;
                    } else {
                        nearVertices[nearIndex].copyVertex(tmpvertices[v[j]]);
                        nearVertices[nearIndex].vtx[2] = -nearVertices[nearIndex].vtx[3];
                        ++nearIndex;
                    }
                    ++i2;
                }
                DisplayProcessor.this.addTriangle(clippedVertices[0].vtx, clippedVertices[0].color, clippedVertices[0].tex, clippedVertices[1].vtx, clippedVertices[1].color, clippedVertices[1].tex, clippedVertices[2].vtx, clippedVertices[2].color, clippedVertices[2].tex);
                if (clippedIndex == 4) {
                    DisplayProcessor.this.addTriangle(clippedVertices[0].vtx, clippedVertices[0].color, clippedVertices[0].tex, clippedVertices[2].vtx, clippedVertices[2].color, clippedVertices[2].tex, clippedVertices[3].vtx, clippedVertices[3].color, clippedVertices[3].tex);
                }
                gl.glDisable(32823);
                DisplayProcessor.this.addTriangle(nearVertices[0].vtx, nearVertices[0].color, nearVertices[0].tex, nearVertices[1].vtx, nearVertices[1].color, nearVertices[1].tex, nearVertices[2].vtx, nearVertices[2].color, nearVertices[2].tex);
                if (nearIndex == 4) {
                    DisplayProcessor.this.addTriangle(nearVertices[0].vtx, nearVertices[0].color, nearVertices[0].tex, nearVertices[2].vtx, nearVertices[2].color, nearVertices[2].tex, nearVertices[3].vtx, nearVertices[3].color, nearVertices[3].tex);
                }
                if ((((DisplayProcessor)DisplayProcessor.this).otherMode.w1 >> 10 & 3) == 3) {
                    gl.glEnable(32823);
                }
            } else {
                DisplayProcessor.this.addTriangle(tmpvertices[0].vtx, tmpvertices[0].color, tmpvertices[0].tex, tmpvertices[1].vtx, tmpvertices[1].color, tmpvertices[1].tex, tmpvertices[2].vtx, tmpvertices[2].color, tmpvertices[2].tex);
            }
            DisplayProcessor.this.update();
        }
    };
    protected OpCode rdp_hle_line = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            float[] vtx1 = new float[]{Float.intBitsToFloat(w2), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[8] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[9] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[10] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[11] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[12] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[13] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[14] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[15] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[16] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[17] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[18] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[19] & 0xFF)};
            float[] c1 = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[20] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[21] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[22] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[23] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[24] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[25] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[26] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[27] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[28] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[29] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[30] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[31] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[32] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[33] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[34] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[35] & 0xFF)};
            float[] vtx2 = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[36] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[37] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[38] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[39] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[40] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[41] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[42] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[43] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[44] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[45] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[46] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[47] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[48] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[49] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[50] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[51] & 0xFF)};
            float[] c2 = new float[]{Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[52] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[53] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[54] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[55] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[56] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[57] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[58] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[59] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[60] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[61] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[62] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[63] & 0xFF), Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[64] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[65] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[66] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[67] & 0xFF)};
            DisplayProcessor.this.glDrawLine(vtx1, c1, vtx2, c2, Float.intBitsToFloat((DisplayProcessor.this.rdp_cmd_data[68] & 0xFF) << 24 | (DisplayProcessor.this.rdp_cmd_data[69] & 0xFF) << 16 | (DisplayProcessor.this.rdp_cmd_data[70] & 0xFF) << 8 | DisplayProcessor.this.rdp_cmd_data[71] & 0xFF));
        }
    };
    protected OpCode rdp_hle_texture = new OpCode(){

        @Override
        public void exec(int w1, int w2) {
            cache.setTexture(w1, w2);
            DisplayProcessor displayProcessor = DisplayProcessor.this;
            displayProcessor.changed = displayProcessor.changed | 0x200;
        }
    };

    private static final int RDP_GETOM_CYCLE_TYPE(OtherMode om) {
        return om.w0 >> 20 & 3;
    }

    private static final int RDP_GETOM_FORCE_BLEND(OtherMode om) {
        return (om.w1 & 0x4000) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_ALPHA_CVG_SELECT(OtherMode om) {
        return (om.w1 & 0x2000) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_CVG_TIMES_ALPHA(OtherMode om) {
        return (om.w1 & 0x1000) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_Z_MODE(OtherMode om) {
        return om.w1 >> 10 & 3;
    }

    private static final int RDP_GETOM_Z_UPDATE_EN(OtherMode om) {
        return (om.w1 & 0x20) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_Z_COMPARE_EN(OtherMode om) {
        return (om.w1 & 0x10) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_Z_SOURCE_SEL(OtherMode om) {
        return (om.w1 & 4) != 0 ? 1 : 0;
    }

    private static final int RDP_GETOM_ALPHA_COMPARE_EN(OtherMode om) {
        return om.w1 >> 0 & 3;
    }

    public DisplayProcessor() {
        cache = new TextureCache();
        cache.construct();
        this.current = null;
        this.depthBuffers.init();
        int i = 0;
        while (i < 256) {
            this.vertices[i] = new GLVertex();
            ++i;
        }
        this.bigArray = Buffers.newDirectFloatBuffer((int)4352);
        i = 0;
        while (i < 256) {
            this.bigArray.position(i * 17);
            this.vertices[i].vtx = this.bigArray.slice();
            this.bigArray.position(i * 17 + 4);
            this.vertices[i].color = this.bigArray.slice();
            this.bigArray.position(i * 17 + 8);
            this.vertices[i].secondaryColor = this.bigArray.slice();
            this.bigArray.position(i * 17 + 12);
            this.vertices[i].tex0 = this.bigArray.slice();
            this.bigArray.position(i * 17 + 14);
            this.vertices[i].tex1 = this.bigArray.slice();
            this.bigArray.position(i * 17 + 16);
            this.vertices[i].fog = this.bigArray.slice();
            ++i;
        }
        Random rand = new Random();
        int i2 = 0;
        while (i2 < 32) {
            int j = 0;
            while (j < 8) {
                int k = 0;
                while (k < 128) {
                    this.stipplePattern[i2][j][k] = (byte)((i2 > rand.nextInt() >>> 10 ? 1 : 0) << 7 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 6 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 5 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 4 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 3 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 2 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 1 | (i2 > rand.nextInt() >>> 10 ? 1 : 0) << 0);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        this.usePolygonStipple = false;
        cache.config(0x2000000, 1);
        windowedWidth = 640;
        windowedHeight = 480;
        width = windowedWidth;
        height = windowedHeight;
        this.canvas = new GLCanvas();
        this.canvas.setSize(640, 480);
        this.buildOps();
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram = (Bus16bit)bus;
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.vi = (Bus32bit)bus;
                if (this.vi == null) break;
                ((Configurable)this.vi).writeConfig("screen", (Object)this.canvas);
                this.resetDp();
                break;
            }
            case 3: {
                break;
            }
            default: {
                System.err.println("Attempting to connect DP bus on invalid port: " + port);
            }
        }
    }

    public void reset() {
        cache.construct();
        this.current = null;
        this.depthBuffers.init();
        this.usePolygonStipple = false;
        cache.config(0x2000000, 1);
    }

    public void clock(long ticks) {
        this.colorbufferChanged = true;
        this.resetDp();
        this.context.release();
    }

    public int read32bit(int reg) {
        switch (reg - 0x4100000 >> 2) {
            case 3: {
                return this.regDPC[3];
            }
            case 4: {
                return this.regDPC[4];
            }
            case 5: {
                return this.regDPC[5];
            }
            case 6: {
                return this.regDPC[6];
            }
            case 7: {
                return this.regDPC[7];
            }
            case 8: {
                return this.otherMode.w1;
            }
            case 9: {
                return this.otherMode.w0;
            }
            case 11: {
                this.glDrawTriangles();
                return 0;
            }
            case 13: {
                if (this.colorbufferChanged) {
                    this.hDC.swapBuffers();
                    this.colorbufferChanged = false;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg - 0x4100000 >> 2) {
            case 0: {
                this.regDPC[0] = value;
                this.regDPC[2] = value;
                break;
            }
            case 1: {
                this.regDPC[1] = value;
                break;
            }
            case 3: {
                if ((value & 1) != 0) {
                    this.regDPC[3] = this.regDPC[3] & 0xFFFFFFFE;
                }
                if ((value & 2) != 0) {
                    this.regDPC[3] = this.regDPC[3] | 1;
                }
                if ((value & 4) != 0) {
                    this.regDPC[3] = this.regDPC[3] & 0xFFFFFFFD;
                }
                if ((value & 8) != 0) {
                    this.regDPC[3] = this.regDPC[3] | 2;
                }
                if ((value & 0x10) != 0) {
                    this.regDPC[3] = this.regDPC[3] & 0xFFFFFFFB;
                }
                if ((value & 0x20) == 0) break;
                this.regDPC[3] = this.regDPC[3] | 4;
                break;
            }
            case 8: {
                if ((value & 3) != (this.otherMode.w1 & 3)) {
                    this.changed |= 0x80;
                }
                this.changed |= 1;
                this.otherMode.w1 = value;
                break;
            }
            case 9: {
                if ((value >> 20 & 3) != (this.otherMode.w0 >> 20 & 3)) {
                    this.changed |= 2;
                }
                this.otherMode.w0 = value;
                break;
            }
            case 10: {
                this.vTrans = (float)this.rdram.read16bit(value + 14) * 9.765625E-4f;
                this.vScale = (float)this.rdram.read16bit(value + 6) * 9.765625E-4f;
                this.nearZ = this.vTrans - this.vScale;
                this.changed |= 0x400;
                break;
            }
            case 11: {
                if (this.canvas.isDisplayable()) {
                    if (!this.render) {
                        if (this.hDC == null) {
                            this.hDC = this.canvas.createContext(null).getGLDrawable();
                        }
                        this.hDC.setRealized(true);
                        this.context = this.hDC.createContext(null);
                        this.hDC.swapBuffers();
                        this.initGl();
                        this.render = true;
                    }
                    this.context.makeCurrent();
                    gl = this.context.getGL().getGL2();
                    break;
                }
                this.context.release();
                this.context.destroy();
                if (this.hDC != null) {
                    this.hDC.setRealized(false);
                }
                this.render = false;
                break;
            }
            case 12: {
                if (!this.render) break;
                switch (value) {
                    case 0: {
                        gl.glDisable(2884);
                        break;
                    }
                    case 1: {
                        gl.glEnable(2884);
                        gl.glCullFace(1029);
                        break;
                    }
                    case 2: {
                        gl.glEnable(2884);
                        gl.glCullFace(1028);
                    }
                }
                break;
            }
            case 13: {
                if (!this.render) break;
                gl.glDisable(2912);
                break;
            }
            case 14: {
                if (!this.render) break;
                if (value != 0) {
                    gl.glEnable(2929);
                    break;
                }
                gl.glDisable(2929);
            }
        }
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeDMA(int pAddr, ByteBuffer cmdObj, int offset, int length) {
        if (!this.render) {
            return;
        }
        this.rdp_cmd_data = cmdObj.array();
        byte[] cmd = this.rdp_cmd_data;
        int w1 = (cmd[0] & 0xFF) << 24 | (cmd[1] & 0xFF) << 16 | (cmd[2] & 0xFF) << 8 | cmd[3] & 0xFF;
        int w2 = (cmd[4] & 0xFF) << 24 | (cmd[5] & 0xFF) << 16 | (cmd[6] & 0xFF) << 8 | cmd[7] & 0xFF;
        this.rdp_command_table[cmd[0] & 0x3F].exec(w1, w2);
    }

    private void gDPTextureRectangle(int w1, int w2, int w3, int w4) {
        cache.setTextureTile(w1, w2, w3, w4, this.otherMode.w0);
        float ulx = (float)(w2 >> 12 & 0xFFF) * 0.25f;
        float uly = (float)(w2 >> 0 & 0xFFF) * 0.25f;
        float lrx = (float)(w1 >> 12 & 0xFFF) * 0.25f;
        float lry = (float)(w1 >> 0 & 0xFFF) * 0.25f;
        float dsdx = (float)(w4 >> 16 & 0xFFFF) * 9.765625E-4f;
        float dtdy = (float)(w4 >> 0 & 0xFFFF) * 9.765625E-4f;
        float s = (float)(w3 >> 16 & 0xFFFF) * 0.03125f;
        float t = (float)(w3 >> 0 & 0xFFFF) * 0.03125f;
        if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 2) {
            dsdx = 1.0f;
            lrx += 1.0f;
            lry += 1.0f;
        }
        float lrs = s + (lrx - ulx - 1.0f) * dsdx;
        float lrt = t + (lry - uly - 1.0f) * dtdy;
        if (lrs > s) {
            if (lrt > t) {
                this.glDrawTexturedRect(ulx, uly, lrx, lry, s, t, lrs, lrt, false, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
            } else {
                this.glDrawTexturedRect(ulx, lry, lrx, uly, s, lrt, lrs, t, false, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
            }
        } else if (lrt > t) {
            this.glDrawTexturedRect(lrx, uly, ulx, lry, lrs, t, s, lrt, false, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
        } else {
            this.glDrawTexturedRect(lrx, lry, ulx, uly, lrs, lrt, s, t, false, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
        }
        cache.resetTextureTile();
        if (this.current != null) {
            this.current.cleared = false;
        }
        this.colorImage.height = (int)StrictMath.max((float)this.colorImage.height, this.scissor.lry);
    }

    private void gDPTextureRectangleFlip(int w1, int w2, int w3, int w4) {
        cache.setTextureTileFlip(w1, w2, w3, w4, this.otherMode.w0);
        float ulx = (float)(w2 >> 12 & 0xFFF) * 0.25f;
        float uly = (float)(w2 >> 0 & 0xFFF) * 0.25f;
        float lrx = (float)(w1 >> 12 & 0xFFF) * 0.25f;
        float lry = (float)(w1 >> 0 & 0xFFF) * 0.25f;
        float dsdx = -((float)(w4 >> 16 & 0xFFFF) * 9.765625E-4f);
        float dtdy = -((float)(w4 >> 0 & 0xFFFF) * 9.765625E-4f);
        float s = (float)(w3 >> 16 & 0xFFFF) * 0.03125f + (lrx - ulx) * dsdx;
        float t = (float)(w3 >> 0 & 0xFFFF) * 0.03125f + (lry - uly) * dtdy;
        if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 2) {
            dsdx = 1.0f;
            lrx += 1.0f;
            lry += 1.0f;
        }
        float lrs = s + (lrx - ulx - 1.0f) * dsdx;
        float lrt = t + (lry - uly - 1.0f) * dtdy;
        if (lrs > s) {
            if (lrt > t) {
                this.glDrawTexturedRect(ulx, uly, lrx, lry, s, t, lrs, lrt, true, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
            } else {
                this.glDrawTexturedRect(ulx, lry, lrx, uly, s, lrt, lrs, t, true, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
            }
        } else if (lrt > t) {
            this.glDrawTexturedRect(lrx, uly, ulx, lry, lrs, t, s, lrt, true, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
        } else {
            this.glDrawTexturedRect(lrx, lry, ulx, uly, lrs, lrt, s, t, true, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode), DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode));
        }
        cache.resetTextureTile();
        if (this.current != null) {
            this.current.cleared = false;
        }
        this.colorImage.height = (int)StrictMath.max((float)this.colorImage.height, this.scissor.lry);
    }

    private void update() {
        if (this.current != null) {
            this.current.cleared = false;
        }
        this.colorImage.height = (int)StrictMath.max((float)this.colorImage.height, this.scissor.lry);
    }

    private void initGl() {
        this.context.makeCurrent();
        gl = this.context.getGL().getGL2();
        Combiners.ARB_multitexture = gl.glGetString(7939).contains("GL_ARB_multitexture");
        if (Combiners.ARB_multitexture) {
            int[] maxTextureUnits_t = new int[1];
            gl.glGetIntegerv(34018, maxTextureUnits_t, 0);
            Combiners.maxTextureUnits = StrictMath.min(8, maxTextureUnits_t[0]);
        }
        Combiners.EXT_fog_coord = gl.glGetString(7939).contains("GL_EXT_fog_coord");
        Combiners.EXT_secondary_color = gl.glGetString(7939).contains("GL_EXT_secondary_color");
        Combiners.ARB_texture_env_combine = gl.glGetString(7939).contains("GL_ARB_texture_env_combine");
        Combiners.ARB_texture_env_crossbar = gl.glGetString(7939).contains("GL_ARB_texture_env_crossbar");
        Combiners.EXT_texture_env_combine = gl.glGetString(7939).contains("GL_EXT_texture_env_combine");
        Combiners.ATI_texture_env_combine3 = gl.glGetString(7939).contains("GL_ATI_texture_env_combine3");
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.bigArray.position(0);
        gl.glVertexPointer(4, 5126, 68, (Buffer)this.bigArray.slice());
        gl.glEnableClientState(32884);
        this.bigArray.position(4);
        gl.glColorPointer(4, 5126, 68, (Buffer)this.bigArray.slice());
        gl.glEnableClientState(32886);
        if (Combiners.EXT_secondary_color) {
            this.bigArray.position(8);
            gl.glSecondaryColorPointer(3, 5126, 68, (Buffer)this.bigArray.slice());
            gl.glEnableClientState(33886);
        }
        if (Combiners.ARB_multitexture) {
            gl.glClientActiveTexture(33984);
            this.bigArray.position(12);
            gl.glTexCoordPointer(2, 5126, 68, (Buffer)this.bigArray.slice());
            gl.glEnableClientState(32888);
            gl.glClientActiveTexture(33985);
            this.bigArray.position(14);
            gl.glTexCoordPointer(2, 5126, 68, (Buffer)this.bigArray.slice());
            gl.glEnableClientState(32888);
        } else {
            this.bigArray.position(12);
            gl.glTexCoordPointer(2, 5126, 68, (Buffer)this.bigArray.slice());
            gl.glEnableClientState(32888);
        }
        if (Combiners.EXT_fog_coord) {
            gl.glFogi(33872, 33873);
            gl.glFogi(2917, 9729);
            gl.glFogf(2915, 0.0f);
            gl.glFogf(2916, 255.0f);
            this.bigArray.position(16);
            gl.glFogCoordPointer(5126, 68, (Buffer)this.bigArray.slice());
            gl.glEnableClientState(33879);
        }
        gl.glPolygonOffset(-3.0f, -3.0f);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClear(16384);
        cache.init(gl, (Hardware)this.rdram, this.tmem, Combiners.maxTextureUnits, Combiners.ARB_multitexture);
        this.combiners.init();
        this.updateScale();
        this.changed = -1;
        this.context.release();
    }

    private void resetDp() {
        this.updateSize();
        this.updateScale();
        this.otherMode.w1 &= 0xFFFFFFFC;
        this.otherMode.w1 |= 0;
        this.otherMode.w1 &= 0xFFFFFFFB;
        this.otherMode.w1 |= 0;
        this.otherMode.w1 &= 7;
        this.otherMode.w1 |= 0;
        this.otherMode.w0 &= 0xFFFFFFCF;
        this.otherMode.w0 |= 0x30;
        this.otherMode.w0 &= 0xFFFFFF3F;
        this.otherMode.w0 |= 0xC0;
        this.otherMode.w0 &= 0xFFFFFEFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFFFFF1FF;
        this.otherMode.w0 |= 0xC00;
        this.otherMode.w0 &= 0xFFFFCFFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFFFF3FFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFFFEFFFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFFF9FFFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFFF7FFFF;
        this.otherMode.w0 |= 0x80000;
        this.otherMode.w0 &= 0xFFCFFFFF;
        this.otherMode.w0 |= 0;
        this.otherMode.w0 &= 0xFF7FFFFF;
        this.otherMode.w0 |= 0;
    }

    private void updateScale() {
        this.scaleX = (float)width / (float)this.screenWidth;
        this.scaleY = (float)height / (float)this.screenHeight;
    }

    private void updateSize() {
        float xScale = (float)(this.vi.read32bit(0x4400030) & 0xFFF) * 9.765625E-4f;
        float yScale = (float)(this.vi.read32bit(0x4400034) & 0xFFF) * 9.765625E-4f;
        int hEnd = this.vi.read32bit(0x4400024) & 0x3FF;
        int hStart = this.vi.read32bit(0x4400024) >> 16 & 0x3FF;
        int vEnd = this.vi.read32bit(71303208) >> 1 & 0x1FF;
        int vStart = this.vi.read32bit(71303208) >> 17 & 0x1FF;
        this.screenWidth = (int)((float)(hEnd - hStart) * xScale);
        this.screenHeight = (int)((float)(vEnd - vStart) * yScale * 1.0126582f);
        if (this.screenWidth == 0) {
            this.screenWidth = 320;
        }
        if (this.screenHeight == 0) {
            this.screenHeight = 240;
        }
    }

    private void addTriangle(float[] vtx1, float[] c1, float[] tex1, float[] vtx2, float[] c2, float[] tex2, float[] vtx3, float[] c3, float[] tex3) {
        if (this.changed != 0) {
            this.glUpdateStates();
        }
        boolean VTX = false;
        boolean CLR = true;
        int TEX = 2;
        float[][][] v = new float[][][]{new float[][]{vtx1, c1, tex1}, new float[][]{vtx2, c2, tex2}, new float[][]{vtx3, c3, tex3}};
        int i = 0;
        while (i < 3) {
            float[][] spvert = v[i];
            GLVertex vertex = this.vertices[this.numVertices];
            vertex.vtx.put(0, spvert[0][0]);
            vertex.vtx.put(1, spvert[0][1]);
            vertex.vtx.put(2, DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode) == 1 ? this.zDepth * spvert[0][3] : spvert[0][2]);
            vertex.vtx.put(3, spvert[0][3]);
            vertex.color.put(0, spvert[1][0]);
            vertex.color.put(1, spvert[1][1]);
            vertex.color.put(2, spvert[1][2]);
            vertex.color.put(3, spvert[1][3]);
            this.combiners.setConstant(vertex.color, this.combiners.vertex.color, this.combiners.vertex.alpha);
            if (Combiners.EXT_secondary_color) {
                vertex.secondaryColor.put(0, 0.0f);
                vertex.secondaryColor.put(0, 0.0f);
                vertex.secondaryColor.put(0, 0.0f);
                vertex.secondaryColor.put(0, 1.0f);
                this.combiners.setConstant(vertex.secondaryColor, this.combiners.vertex.secondaryColor, 19);
            }
            if (this.combiners.usesT0) {
                vertex.tex0.put(0, cache.getTexS(0, spvert[2][0]));
                vertex.tex0.put(1, cache.getTexT(0, spvert[2][1]));
            }
            if (this.combiners.usesT1) {
                vertex.tex1.put(0, cache.getTexS(1, spvert[2][0]));
                vertex.tex1.put(1, cache.getTexT(1, spvert[2][1]));
            }
            ++this.numVertices;
            ++i;
        }
        ++this.numTriangles;
        if (this.numVertices >= 255) {
            this.glDrawTriangles();
        }
    }

    private void glClearDepthBuffer(boolean depthUpdate) {
        this.glUpdateStates();
        gl.glDepthMask(true);
        gl.glClear(256);
        gl.glDepthMask(depthUpdate);
    }

    private void glClearColorBuffer(float[] color) {
        gl.glClearColor(color[0], color[1], color[2], color[3]);
        gl.glClear(16384);
    }

    private void glDrawRect(int ulx, int uly, int lrx, int lry, float[] color, int depthSource) {
        this.glUpdateStates();
        boolean culling = gl.glIsEnabled(2884);
        gl.glDisable(3089);
        gl.glDisable(2884);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)this.screenWidth, (double)this.screenHeight, 0.0, 1.0, -1.0);
        gl.glViewport(0, this.heightOffset, width, height);
        gl.glDepthRange(0.0, 1.0);
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        gl.glBegin(7);
        gl.glVertex4f((float)ulx, (float)uly, depthSource == 1 ? this.zDepth : this.nearZ, 1.0f);
        gl.glVertex4f((float)lrx, (float)uly, depthSource == 1 ? this.zDepth : this.nearZ, 1.0f);
        gl.glVertex4f((float)lrx, (float)lry, depthSource == 1 ? this.zDepth : this.nearZ, 1.0f);
        gl.glVertex4f((float)ulx, (float)lry, depthSource == 1 ? this.zDepth : this.nearZ, 1.0f);
        gl.glEnd();
        gl.glLoadIdentity();
        if (culling) {
            gl.glEnable(2884);
        }
        gl.glEnable(3089);
    }

    private void glDrawTexturedRect(float ulx, float uly, float lrx, float lry, float uls, float ult, float lrs, float lrt, boolean flip, int depthSource, int cycleType) {
        this.glUpdateStates();
        this.rect0.x = ulx;
        this.rect0.y = uly;
        this.rect0.z = depthSource == 1 ? this.zDepth : this.nearZ;
        this.rect0.w = 1.0f;
        this.rect0.color[0] = 1.0f;
        this.rect0.color[1] = 1.0f;
        this.rect0.color[2] = 1.0f;
        this.rect0.color[3] = 0.0f;
        this.rect0.secondaryColor[0] = 1.0f;
        this.rect0.secondaryColor[1] = 1.0f;
        this.rect0.secondaryColor[2] = 1.0f;
        this.rect0.secondaryColor[3] = 1.0f;
        this.rect0.s0 = uls;
        this.rect0.t0 = ult;
        this.rect0.s1 = uls;
        this.rect0.t1 = ult;
        this.rect0.fog = 0.0f;
        this.rect1.x = lrx;
        this.rect1.y = lry;
        this.rect1.z = depthSource == 1 ? this.zDepth : this.nearZ;
        this.rect1.w = 1.0f;
        this.rect1.color[0] = 1.0f;
        this.rect1.color[1] = 1.0f;
        this.rect1.color[2] = 1.0f;
        this.rect1.color[3] = 0.0f;
        this.rect1.secondaryColor[0] = 1.0f;
        this.rect1.secondaryColor[1] = 1.0f;
        this.rect1.secondaryColor[2] = 1.0f;
        this.rect1.secondaryColor[3] = 1.0f;
        this.rect1.s0 = lrs;
        this.rect1.t0 = lrt;
        this.rect1.s1 = lrs;
        this.rect1.t1 = lrt;
        this.rect1.fog = 0.0f;
        boolean culling = gl.glIsEnabled(2884);
        gl.glDisable(2884);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)this.screenWidth, (double)this.screenHeight, 0.0, 1.0, -1.0);
        gl.glViewport(0, this.heightOffset, width, height);
        if (this.combiners.usesT0) {
            this.rect0.s0 = this.rect0.s0 * DisplayProcessor.cache.current[0].shiftScaleS - DisplayProcessor.cache.textureTile[0].fuls;
            this.rect0.t0 = this.rect0.t0 * DisplayProcessor.cache.current[0].shiftScaleT - DisplayProcessor.cache.textureTile[0].fult;
            this.rect1.s0 = (this.rect1.s0 + 1.0f) * DisplayProcessor.cache.current[0].shiftScaleS - DisplayProcessor.cache.textureTile[0].fuls;
            this.rect1.t0 = (this.rect1.t0 + 1.0f) * DisplayProcessor.cache.current[0].shiftScaleT - DisplayProcessor.cache.textureTile[0].fult;
            if (DisplayProcessor.cache.current[0].maskS != 0 && StrictMath.IEEEremainder(this.rect0.s0, DisplayProcessor.cache.current[0].width) == 0.0 && DisplayProcessor.cache.current[0].mirrorS == 0) {
                this.rect1.s0 -= this.rect0.s0;
                this.rect0.s0 = 0.0f;
            }
            if (DisplayProcessor.cache.current[0].maskT != 0 && StrictMath.IEEEremainder(this.rect0.t0, DisplayProcessor.cache.current[0].height) == 0.0 && DisplayProcessor.cache.current[0].mirrorT == 0) {
                this.rect1.t0 -= this.rect0.t0;
                this.rect0.t0 = 0.0f;
            }
            if (Combiners.ARB_multitexture) {
                gl.glActiveTexture(33984);
            }
            if (this.rect0.s0 >= 0.0f && this.rect1.s0 <= (float)DisplayProcessor.cache.current[0].width) {
                gl.glTexParameteri(3553, 10242, 33071);
            }
            if (this.rect0.t0 >= 0.0f && this.rect1.t0 <= (float)DisplayProcessor.cache.current[0].height) {
                gl.glTexParameteri(3553, 10243, 33071);
            }
            this.rect0.s0 *= DisplayProcessor.cache.current[0].scaleS;
            this.rect0.t0 *= DisplayProcessor.cache.current[0].scaleT;
            this.rect1.s0 *= DisplayProcessor.cache.current[0].scaleS;
            this.rect1.t0 *= DisplayProcessor.cache.current[0].scaleT;
        }
        if (this.combiners.usesT1 && Combiners.ARB_multitexture) {
            this.rect0.s1 = this.rect0.s1 * DisplayProcessor.cache.current[1].shiftScaleS - DisplayProcessor.cache.textureTile[1].fuls;
            this.rect0.t1 = this.rect0.t1 * DisplayProcessor.cache.current[1].shiftScaleT - DisplayProcessor.cache.textureTile[1].fult;
            this.rect1.s1 = (this.rect1.s1 + 1.0f) * DisplayProcessor.cache.current[1].shiftScaleS - DisplayProcessor.cache.textureTile[1].fuls;
            this.rect1.t1 = (this.rect1.t1 + 1.0f) * DisplayProcessor.cache.current[1].shiftScaleT - DisplayProcessor.cache.textureTile[1].fult;
            if (DisplayProcessor.cache.current[1].maskS != 0 && StrictMath.IEEEremainder(this.rect0.s1, DisplayProcessor.cache.current[1].width) == 0.0 && DisplayProcessor.cache.current[1].mirrorS == 0) {
                this.rect1.s1 -= this.rect0.s1;
                this.rect0.s1 = 0.0f;
            }
            if (DisplayProcessor.cache.current[1].maskT != 0 && StrictMath.IEEEremainder(this.rect0.t1, DisplayProcessor.cache.current[1].height) == 0.0 && DisplayProcessor.cache.current[1].mirrorT == 0) {
                this.rect1.t1 -= this.rect0.t1;
                this.rect0.t1 = 0.0f;
            }
            gl.glActiveTexture(33985);
            if (this.rect0.s1 == 0.0f && this.rect1.s1 <= (float)DisplayProcessor.cache.current[1].width) {
                gl.glTexParameteri(3553, 10242, 33071);
            }
            if (this.rect0.t1 == 0.0f && this.rect1.t1 <= (float)DisplayProcessor.cache.current[1].height) {
                gl.glTexParameteri(3553, 10243, 33071);
            }
            this.rect0.s1 *= DisplayProcessor.cache.current[1].scaleS;
            this.rect0.t1 *= DisplayProcessor.cache.current[1].scaleT;
            this.rect1.s1 *= DisplayProcessor.cache.current[1].scaleS;
            this.rect1.t1 *= DisplayProcessor.cache.current[1].scaleT;
        }
        if (cycleType == 2) {
            if (Combiners.ARB_multitexture) {
                gl.glActiveTexture(33984);
            }
            gl.glTexParameteri(3553, 10241, 9728);
            gl.glTexParameteri(3553, 10240, 9728);
        }
        this.combiners.setConstant(this.rect0.color, this.combiners.vertex.color, this.combiners.vertex.alpha);
        if (Combiners.EXT_secondary_color) {
            this.combiners.setConstant(this.rect0.secondaryColor, this.combiners.vertex.secondaryColor, this.combiners.vertex.alpha);
        }
        gl.glBegin(7);
        gl.glColor4f(this.rect0.color[0], this.rect0.color[1], this.rect0.color[2], this.rect0.color[3]);
        if (Combiners.EXT_secondary_color) {
            gl.glSecondaryColor3f(this.rect0.secondaryColor[0], this.rect0.secondaryColor[1], this.rect0.secondaryColor[2]);
        }
        if (Combiners.ARB_multitexture) {
            gl.glMultiTexCoord2f(33984, this.rect0.s0, this.rect0.t0);
            gl.glMultiTexCoord2f(33985, this.rect0.s1, this.rect0.t1);
            gl.glVertex4f(this.rect0.x, this.rect0.y, this.rect0.z, 1.0f);
            gl.glMultiTexCoord2f(33984, this.rect1.s0, this.rect0.t0);
            gl.glMultiTexCoord2f(33985, this.rect1.s1, this.rect0.t1);
            gl.glVertex4f(this.rect1.x, this.rect0.y, this.rect0.z, 1.0f);
            gl.glMultiTexCoord2f(33984, this.rect1.s0, this.rect1.t0);
            gl.glMultiTexCoord2f(33985, this.rect1.s1, this.rect1.t1);
            gl.glVertex4f(this.rect1.x, this.rect1.y, this.rect0.z, 1.0f);
            gl.glMultiTexCoord2f(33984, this.rect0.s0, this.rect1.t0);
            gl.glMultiTexCoord2f(33985, this.rect0.s1, this.rect1.t1);
            gl.glVertex4f(this.rect0.x, this.rect1.y, this.rect0.z, 1.0f);
        } else {
            gl.glTexCoord2f(this.rect0.s0, this.rect0.t0);
            gl.glVertex4f(this.rect0.x, this.rect0.y, this.rect0.z, 1.0f);
            if (flip) {
                gl.glTexCoord2f(this.rect0.s0, this.rect1.t0);
            } else {
                gl.glTexCoord2f(this.rect1.s0, this.rect0.t0);
            }
            gl.glVertex4f(this.rect1.x, this.rect0.y, this.rect0.z, 1.0f);
            gl.glTexCoord2f(this.rect1.s0, this.rect1.t0);
            gl.glVertex4f(this.rect1.x, this.rect1.y, this.rect0.z, 1.0f);
            if (flip) {
                gl.glTexCoord2f(this.rect1.s0, this.rect0.t0);
            } else {
                gl.glTexCoord2f(this.rect0.s0, this.rect1.t0);
            }
            gl.glVertex4f(this.rect0.x, this.rect1.y, this.rect0.z, 1.0f);
        }
        gl.glEnd();
        gl.glLoadIdentity();
        if (culling) {
            gl.glEnable(2884);
        }
    }

    private void glDrawLine(float[] vtx1, float[] c1, float[] vtx2, float[] c2, float width) {
        if (this.changed != 0) {
            this.glUpdateStates();
        }
        boolean VTX = false;
        boolean CLR = true;
        float[][][] v = new float[][][]{new float[][]{vtx1, c1}, new float[][]{vtx2, c2}};
        float[] color = new float[4];
        gl.glLineWidth(width * this.scaleX);
        gl.glBegin(1);
        int i = 0;
        while (i < 2) {
            float[][] spvert = v[i];
            color[0] = spvert[1][0];
            color[1] = spvert[1][1];
            color[2] = spvert[1][2];
            color[3] = spvert[1][3];
            this.combiners.setConstant(color, this.combiners.vertex.color, this.combiners.vertex.alpha);
            gl.glColor4fv(color, 0);
            if (Combiners.EXT_secondary_color) {
                color[0] = spvert[1][0];
                color[1] = spvert[1][1];
                color[2] = spvert[1][2];
                color[3] = spvert[1][3];
                this.combiners.setConstant(color, this.combiners.vertex.secondaryColor, this.combiners.vertex.alpha);
                gl.glSecondaryColor3fv(color, 0);
            }
            gl.glVertex4f(spvert[0][0], spvert[0][1], spvert[0][2], spvert[0][3]);
            ++i;
        }
        gl.glEnd();
    }

    private void glDrawTriangles() {
        if (this.numTriangles < 1) {
            return;
        }
        this.glStipple();
        gl.glDrawArrays(4, 0, this.numVertices);
        this.numVertices = 0;
        this.numTriangles = 0;
    }

    private void glStipple() {
        if (this.usePolygonStipple && DisplayProcessor.RDP_GETOM_ALPHA_COMPARE_EN(this.otherMode) == 3 && DisplayProcessor.RDP_GETOM_ALPHA_CVG_SELECT(this.otherMode) == 0) {
            this.lastStipple = this.lastStipple + 1 & 7;
            gl.glPolygonStipple(this.stipplePattern[(int)(Combiners.envColor[3] * 255.0f) >> 3][this.lastStipple], 0);
        }
    }

    private void glUpdateStates() {
        if ((this.changed & 1) != 0) {
            if (DisplayProcessor.RDP_GETOM_Z_COMPARE_EN(this.otherMode) != 0) {
                gl.glDepthFunc(515);
            } else {
                gl.glDepthFunc(519);
            }
            if (DisplayProcessor.RDP_GETOM_Z_UPDATE_EN(this.otherMode) != 0) {
                gl.glDepthMask(true);
            } else {
                gl.glDepthMask(false);
            }
            if (DisplayProcessor.RDP_GETOM_Z_MODE(this.otherMode) == 3) {
                gl.glEnable(32823);
            } else {
                gl.glDisable(32823);
            }
        }
        if ((this.changed & 0x80) != 0 || (this.changed & 1) != 0) {
            if (DisplayProcessor.RDP_GETOM_ALPHA_COMPARE_EN(this.otherMode) == 1 && DisplayProcessor.RDP_GETOM_ALPHA_CVG_SELECT(this.otherMode) == 0) {
                gl.glEnable(3008);
                gl.glAlphaFunc(this.blendColor[3] > 0.0f ? 518 : 516, this.blendColor[3]);
            } else if (DisplayProcessor.RDP_GETOM_CVG_TIMES_ALPHA(this.otherMode) != 0) {
                gl.glEnable(3008);
                gl.glAlphaFunc(518, 0.5f);
            } else {
                gl.glDisable(3008);
            }
            if (this.usePolygonStipple && DisplayProcessor.RDP_GETOM_ALPHA_COMPARE_EN(this.otherMode) == 3 && DisplayProcessor.RDP_GETOM_ALPHA_CVG_SELECT(this.otherMode) == 0) {
                gl.glEnable(2882);
            } else {
                gl.glDisable(2882);
            }
        }
        if ((this.changed & 4) != 0) {
            gl.glScissor((int)(this.scissor.ulx * this.scaleX), (int)(((float)this.screenHeight - this.scissor.lry) * this.scaleY + (float)this.heightOffset), (int)((this.scissor.lrx - this.scissor.ulx) * this.scaleX), (int)((this.scissor.lry - this.scissor.uly) * this.scaleY));
        }
        if ((this.changed & 0x40) != 0 || (this.changed & 2) != 0) {
            if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 2) {
                this.combiners.setCombine(gl, false, this.combiners.encodeCombineMode(31, 31, 31, 1, 7, 7, 7, 1, 31, 31, 31, 1, 7, 7, 7, 1));
            } else if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 3) {
                this.combiners.setCombine(gl, false, this.combiners.encodeCombineMode(31, 31, 31, 4, 7, 7, 7, 6, 31, 31, 31, 4, 7, 7, 7, 6));
            } else {
                this.combiners.setCombine(gl, DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 1, this.combiners.combine.getMux());
            }
            this.changed |= 0x20;
        }
        if ((this.changed & 0x20) != 0) {
            this.combiners.updateCombineColors(gl);
            this.changed &= 0xFFFFFFDF;
        }
        if ((this.changed & 0x200) != 0 || (this.changed & 0x10) != 0 || (DisplayProcessor.cache.changed & 8) != 0) {
            this.combiners.beginTextureUpdate(gl);
            if (this.combiners.usesT0) {
                cache.update(0, this.otherMode.w0);
                this.changed &= 0xFFFFFDFF;
                this.changed &= 0xFFFFFFEF;
                DisplayProcessor.cache.changed &= 0xFFFFFFF7;
            } else {
                cache.activateDummy(0);
            }
            if (this.combiners.usesT1) {
                cache.update(1, this.otherMode.w0);
                this.changed &= 0xFFFFFDFF;
                this.changed &= 0xFFFFFFEF;
                DisplayProcessor.cache.changed &= 0xFFFFFFF7;
            } else {
                cache.activateDummy(1);
            }
            this.combiners.endTextureUpdate(gl);
        }
        if ((this.changed & 1) != 0 || (this.changed & 2) != 0) {
            if (DisplayProcessor.RDP_GETOM_FORCE_BLEND(this.otherMode) != 0 && DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) != 2 && DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) != 3 && DisplayProcessor.RDP_GETOM_ALPHA_CVG_SELECT(this.otherMode) == 0) {
                gl.glEnable(3042);
                switch (this.otherMode.w1 >> 16) {
                    case 1096: 
                    case 1370: {
                        gl.glBlendFunc(1, 1);
                        break;
                    }
                    case 3080: 
                    case 3850: {
                        gl.glBlendFunc(1, 0);
                        break;
                    }
                    case 80: 
                    case 85: 
                    case 3096: 
                    case 3097: 
                    case 51216: 
                    case 51217: {
                        gl.glBlendFunc(770, 771);
                        break;
                    }
                    case 4005: 
                    case 20565: {
                        gl.glBlendFunc(0, 1);
                        break;
                    }
                    default: {
                        gl.glBlendFunc(770, 771);
                        break;
                    }
                }
            } else {
                gl.glDisable(3042);
            }
            if (DisplayProcessor.RDP_GETOM_CYCLE_TYPE(this.otherMode) == 3) {
                gl.glBlendFunc(770, 771);
                gl.glEnable(3042);
            }
        }
        DisplayProcessor.cache.changed &= 8;
        this.changed &= 0x10;
        this.changed &= 0x200;
    }

    private void buildOps() {
        this.rdp_command_table = new OpCode[64];
        int i = 0;
        while (i < 64) {
            this.rdp_command_table[i] = this.rdp_invalid;
            ++i;
        }
        this.rdp_command_table[0] = this.rdp_noop;
        this.rdp_command_table[8] = this.rdp_tri_noshade;
        this.rdp_command_table[9] = this.rdp_tri_noshade_z;
        this.rdp_command_table[10] = this.rdp_tri_tex;
        this.rdp_command_table[11] = this.rdp_tri_tex_z;
        this.rdp_command_table[12] = this.rdp_tri_shade;
        this.rdp_command_table[13] = this.rdp_tri_shade_z;
        this.rdp_command_table[14] = this.rdp_tri_texshade;
        this.rdp_command_table[15] = this.rdp_tri_texshade_z;
        this.rdp_command_table[16] = this.rdp_hle_triangle;
        this.rdp_command_table[17] = this.rdp_hle_line;
        this.rdp_command_table[18] = this.rdp_hle_texture;
        this.rdp_command_table[36] = this.rdp_tex_rect;
        this.rdp_command_table[37] = this.rdp_tex_rect_flip;
        this.rdp_command_table[38] = this.rdp_sync_load;
        this.rdp_command_table[39] = this.rdp_sync_pipe;
        this.rdp_command_table[40] = this.rdp_sync_tile;
        this.rdp_command_table[41] = this.rdp_sync_full;
        this.rdp_command_table[42] = this.rdp_set_key_gb;
        this.rdp_command_table[43] = this.rdp_set_key_r;
        this.rdp_command_table[44] = this.rdp_set_convert;
        this.rdp_command_table[45] = this.rdp_set_scissor;
        this.rdp_command_table[46] = this.rdp_set_prim_depth;
        this.rdp_command_table[47] = this.rdp_set_other_modes;
        this.rdp_command_table[48] = this.rdp_load_tlut;
        this.rdp_command_table[49] = this.rdp_invalid;
        this.rdp_command_table[50] = this.rdp_set_tile_size;
        this.rdp_command_table[51] = this.rdp_load_block;
        this.rdp_command_table[52] = this.rdp_load_tile;
        this.rdp_command_table[53] = this.rdp_set_tile;
        this.rdp_command_table[54] = this.rdp_fill_rect;
        this.rdp_command_table[55] = this.rdp_set_fill_color;
        this.rdp_command_table[56] = this.rdp_set_fog_color;
        this.rdp_command_table[57] = this.rdp_set_blend_color;
        this.rdp_command_table[58] = this.rdp_set_prim_color;
        this.rdp_command_table[59] = this.rdp_set_env_color;
        this.rdp_command_table[60] = this.rdp_set_combine;
        this.rdp_command_table[61] = this.rdp_set_texture_image;
        this.rdp_command_table[62] = this.rdp_set_mask_image;
        this.rdp_command_table[63] = this.rdp_set_color_image;
    }

    private static float zscale(int z) {
        return (float)z / 65535.0f;
    }

    private int RDP_GETOM_PERSP_TEX_EN(OtherMode om) {
        return (om.w1 & 0x80000) != 0 ? 1 : 0;
    }

    private float XSCALE(int x) {
        return (float)x / 262144.0f;
    }

    private float YSCALE(int y) {
        return (float)y / 4.0f;
    }

    private float ZSCALE(int z) {
        return DisplayProcessor.RDP_GETOM_Z_SOURCE_SEL(this.otherMode) != 0 ? this.zDepth : DisplayProcessor.zscale(z >> 16);
    }

    private float WSCALE(int z) {
        return 1.0f / (this.RDP_GETOM_PERSP_TEX_EN(this.otherMode) != 0 ? (float)(z + 65536) / -65536.0f : 1.0f);
    }

    private int CSCALE(int c) {
        return (c > 0x3FF0000 ? 0x3FF0000 : (c < 0 ? 0 : c)) >> 18;
    }

    private long PERSP(int s, int w) {
        return ((long)s << 20) / (long)(w != 0 ? w : 1);
    }

    private float SSCALE(int s, int _w) {
        return this.RDP_GETOM_PERSP_TEX_EN(this.otherMode) != 0 ? (float)this.PERSP(s, _w) / 1024.0f : (float)s / 2097152.0f;
    }

    private float TSCALE(int s, int w) {
        return this.RDP_GETOM_PERSP_TEX_EN(this.otherMode) != 0 ? (float)this.PERSP(s, w) / 1024.0f : (float)s / 2097152.0f;
    }

    private void rglTriangle(int w1, int w2, int shade, int texture, int zbuffer, byte[] rdp_cmd, int rdp_cmd_offset) {
        int dx;
        Vertex[] tmpvertices = new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex(), new Vertex(), new Vertex()};
        int tilenum = w1 >> 16 & 7;
        int drdx = 0;
        int dgdx = 0;
        int dbdx = 0;
        int dadx = 0;
        int dzdx = 0;
        int dsdx = 0;
        int dtdx = 0;
        int dwdx = 0;
        int drdy = 0;
        int dgdy = 0;
        int dbdy = 0;
        int dady = 0;
        int dzdy = 0;
        int dsdy = 0;
        int dtdy = 0;
        int dwdy = 0;
        int drde = 0;
        int dgde = 0;
        int dbde = 0;
        int dade = 0;
        int dzde = 0;
        int dsde = 0;
        int dtde = 0;
        int dwde = 0;
        int flip = (w1 & 0x800000) != 0 ? 1 : 0;
        int shade_base = rdp_cmd_offset + 32;
        int texture_base = rdp_cmd_offset + 32;
        int zbuffer_base = rdp_cmd_offset + 32;
        if (shade != 0) {
            texture_base += 64;
            zbuffer_base += 64;
        }
        if (texture != 0) {
            zbuffer_base += 64;
        }
        int index = rdp_cmd_offset + 8;
        int w3 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        index = rdp_cmd_offset + 12;
        int w4 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        index = rdp_cmd_offset + 16;
        int w5 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        index = rdp_cmd_offset + 20;
        int w6 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        index = rdp_cmd_offset + 24;
        int w7 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        index = rdp_cmd_offset + 28;
        int w8 = (rdp_cmd[index] & 0xFF) << 24 | (rdp_cmd[index + 1] & 0xFF) << 16 | (rdp_cmd[index + 2] & 0xFF) << 8 | rdp_cmd[index + 3] & 0xFF;
        int yl = w1 & 0x3FFF;
        yl = (short)(yl << 2) >> 2;
        int ym = w2 >> 16 & 0x3FFF;
        ym = (short)(ym << 2) >> 2;
        int yh = w2 >> 0 & 0x3FFF;
        yh = (short)(yh << 2) >> 2;
        int xl = w3;
        int xh = w5;
        int xm = w7;
        long dxldy = w4;
        long dxhdy = w6;
        long dxmdy = w8;
        if ((yl & 0x2000) != 0) {
            yl |= 0xFFFFC000;
        }
        if ((ym & 0x2000) != 0) {
            ym |= 0xFFFFC000;
        }
        if ((yh & 0x2000) != 0) {
            yh |= 0xFFFFC000;
        }
        System.out.printf("LLE yl=%d, ym=%d, yh=%d\n", yl, ym, yh &= 0xFFFFFFFC);
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        int z = -65536;
        int s = 0;
        int t = 0;
        int w = 196608;
        boolean dr = false;
        boolean dg = false;
        boolean db = false;
        boolean da = false;
        if (shade != 0) {
            r = (rdp_cmd[shade_base + 0 + 0] & 0xFF) << 24 | (rdp_cmd[shade_base + 1] & 0xFF) << 16 | (rdp_cmd[shade_base + 16 + 0] & 0xFF) << 8 | rdp_cmd[shade_base + 16 + 1] & 0xFF;
            g = (rdp_cmd[shade_base + 0 + 2] & 0xFF) << 24 | (rdp_cmd[shade_base + 0 + 3] & 0xFF) << 16 | (rdp_cmd[shade_base + 16 + 2] & 0xFF) << 8 | rdp_cmd[shade_base + 16 + 3] & 0xFF;
            b = (rdp_cmd[shade_base + 0 + 4] & 0xFF) << 24 | (rdp_cmd[shade_base + 0 + 5] & 0xFF) << 16 | (rdp_cmd[shade_base + 16 + 4] & 0xFF) << 8 | rdp_cmd[shade_base + 16 + 5] & 0xFF;
            a = (rdp_cmd[shade_base + 0 + 6] & 0xFF) << 24 | (rdp_cmd[shade_base + 0 + 7] & 0xFF) << 16 | (rdp_cmd[shade_base + 16 + 6] & 0xFF) << 8 | rdp_cmd[shade_base + 16 + 7] & 0xFF;
            drdx = (rdp_cmd[shade_base + 8 + 0] & 0xFF) << 24 | (rdp_cmd[shade_base + 8 + 1] & 0xFF) << 16 | (rdp_cmd[shade_base + 24 + 0] & 0xFF) << 8 | rdp_cmd[shade_base + 24 + 1] & 0xFF;
            dgdx = (rdp_cmd[shade_base + 8 + 2] & 0xFF) << 24 | (rdp_cmd[shade_base + 8 + 3] & 0xFF) << 16 | (rdp_cmd[shade_base + 24 + 2] & 0xFF) << 8 | rdp_cmd[shade_base + 24 + 3] & 0xFF;
            dbdx = (rdp_cmd[shade_base + 8 + 4] & 0xFF) << 24 | (rdp_cmd[shade_base + 8 + 5] & 0xFF) << 16 | (rdp_cmd[shade_base + 24 + 4] & 0xFF) << 8 | rdp_cmd[shade_base + 24 + 5] & 0xFF;
            dadx = (rdp_cmd[shade_base + 8 + 6] & 0xFF) << 24 | (rdp_cmd[shade_base + 8 + 7] & 0xFF) << 16 | (rdp_cmd[shade_base + 24 + 6] & 0xFF) << 8 | rdp_cmd[shade_base + 24 + 7] & 0xFF;
            drde = (rdp_cmd[shade_base + 32 + 0] & 0xFF) << 24 | (rdp_cmd[shade_base + 32 + 1] & 0xFF) << 16 | (rdp_cmd[shade_base + 48 + 0] & 0xFF) << 8 | rdp_cmd[shade_base + 48 + 1] & 0xFF;
            dgde = (rdp_cmd[shade_base + 32 + 2] & 0xFF) << 24 | (rdp_cmd[shade_base + 32 + 3] & 0xFF) << 16 | (rdp_cmd[shade_base + 48 + 2] & 0xFF) << 8 | rdp_cmd[shade_base + 48 + 3] & 0xFF;
            dbde = (rdp_cmd[shade_base + 32 + 4] & 0xFF) << 24 | (rdp_cmd[shade_base + 32 + 5] & 0xFF) << 16 | (rdp_cmd[shade_base + 48 + 4] & 0xFF) << 8 | rdp_cmd[shade_base + 48 + 5] & 0xFF;
            dade = (rdp_cmd[shade_base + 32 + 6] & 0xFF) << 24 | (rdp_cmd[shade_base + 32 + 7] & 0xFF) << 16 | (rdp_cmd[shade_base + 48 + 6] & 0xFF) << 8 | rdp_cmd[shade_base + 48 + 7] & 0xFF;
            drdy = (rdp_cmd[shade_base + 40 + 0] & 0xFF) << 24 | (rdp_cmd[shade_base + 40 + 1] & 0xFF) << 16 | (rdp_cmd[shade_base + 56 + 0] & 0xFF) << 8 | rdp_cmd[shade_base + 56 + 1] & 0xFF;
            dgdy = (rdp_cmd[shade_base + 40 + 2] & 0xFF) << 24 | (rdp_cmd[shade_base + 40 + 3] & 0xFF) << 16 | (rdp_cmd[shade_base + 56 + 2] & 0xFF) << 8 | rdp_cmd[shade_base + 56 + 3] & 0xFF;
            dbdy = (rdp_cmd[shade_base + 40 + 4] & 0xFF) << 24 | (rdp_cmd[shade_base + 40 + 5] & 0xFF) << 16 | (rdp_cmd[shade_base + 56 + 4] & 0xFF) << 8 | rdp_cmd[shade_base + 56 + 5] & 0xFF;
            dady = (rdp_cmd[shade_base + 40 + 6] & 0xFF) << 24 | (rdp_cmd[shade_base + 40 + 7] & 0xFF) << 16 | (rdp_cmd[shade_base + 56 + 6] & 0xFF) << 8 | rdp_cmd[shade_base + 56 + 7] & 0xFF;
        }
        if (texture != 0) {
            s = rdp_cmd[texture_base + 0] & 0xFFFF0000 | rdp_cmd[texture_base + 16] >> 16 & 0xFFFF;
            t = rdp_cmd[texture_base + 0] << 16 & 0xFFFF0000 | rdp_cmd[texture_base + 16] & 0xFFFF;
            w = rdp_cmd[texture_base + 4] & 0xFFFF0000 | rdp_cmd[texture_base + 20] >> 16 & 0xFFFF;
            dsdx = rdp_cmd[texture_base + 8] & 0xFFFF0000 | rdp_cmd[texture_base + 24] >> 16 & 0xFFFF;
            dtdx = rdp_cmd[texture_base + 8] << 16 & 0xFFFF0000 | rdp_cmd[texture_base + 24] & 0xFFFF;
            dwdx = rdp_cmd[texture_base + 12] & 0xFFFF0000 | rdp_cmd[texture_base + 28] >> 16 & 0xFFFF;
            dsde = rdp_cmd[texture_base + 32] & 0xFFFF0000 | rdp_cmd[texture_base + 48] >> 16 & 0xFFFF;
            dtde = rdp_cmd[texture_base + 32] << 16 & 0xFFFF0000 | rdp_cmd[texture_base + 48] & 0xFFFF;
            dwde = rdp_cmd[texture_base + 36] & 0xFFFF0000 | rdp_cmd[texture_base + 52] >> 16 & 0xFFFF;
            dsdy = rdp_cmd[texture_base + 40] & 0xFFFF0000 | rdp_cmd[texture_base + 56] >> 16 & 0xFFFF;
            dtdy = rdp_cmd[texture_base + 40] << 16 & 0xFFFF0000 | rdp_cmd[texture_base + 56] & 0xFFFF;
            dwdy = rdp_cmd[texture_base + 44] & 0xFFFF0000 | rdp_cmd[texture_base + 60] >> 16 & 0xFFFF;
        }
        if (zbuffer != 0) {
            z = rdp_cmd[zbuffer_base + 0];
            dzdx = rdp_cmd[zbuffer_base + 4];
            dzde = rdp_cmd[zbuffer_base + 8];
            dzdy = rdp_cmd[zbuffer_base + 12];
        }
        xh <<= 2;
        xm <<= 2;
        xl <<= 2;
        r <<= 2;
        g <<= 2;
        b <<= 2;
        a <<= 2;
        dsde >>= 2;
        dtde >>= 2;
        dsdx >>= 2;
        dtdx >>= 2;
        dzdx >>= 2;
        dzde >>= 2;
        dzdy >>= 2;
        dwdx >>= 2;
        dwde >>= 2;
        dwdy >>= 2;
        int xleft = xm;
        int xright = xh;
        int xleft_inc = (int)dxmdy;
        int xright_inc = (int)dxhdy;
        System.out.printf("LLE xl=%d, dxldy=%d,xh=%d, dxhdy=%d, xm=%d, dxmdy=%d\n", xl, dxldy, xh, dxhdy, xm, dxmdy);
        System.out.printf("LLE r=%d, g=%d, b=%d, a=%d, drde=%d, dgde=%d, dbde=%d, dade=%d, drdx=%d, dgdx=%d, dbdx=%d, dadx=%d\n", r, g, b, a, drde, dgde, dbde, dade, drdx, dgdx, dbdx, dadx);
        while (!(yh >= ym || flip == 0 && xleft < xright + 65536 || flip != 0 && xleft > xright - 65536)) {
            xleft += xleft_inc;
            xright += xright_inc;
            s += dsde;
            t += dtde;
            w += dwde;
            r += drde;
            g += dgde;
            b += dbde;
            a += dade;
            z += dzde;
            ++yh;
        }
        int j = ym - yh;
        int vtx = 0;
        if (j > 0) {
            dx = xleft - xright >> 16;
            System.out.printf("flip=%d, xleft=%d, xright=%d\n", flip, xleft, xright);
            if (flip == 0 && xleft < xright || flip != 0) {
                if (shade != 0) {
                    System.out.printf("r01=%d\n", r);
                    tmpvertices[vtx].color[0] = (float)this.CSCALE(r + drdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[1] = (float)this.CSCALE(g + dgdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[2] = (float)this.CSCALE(b + dbdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[3] = (float)this.CSCALE(a + dadx * dx) * 0.003921569f;
                }
                if (texture != 0) {
                    tmpvertices[vtx].tex[0] = this.SSCALE(s + dsdx * dx, w + dwdx * dx);
                    tmpvertices[vtx].tex[1] = this.TSCALE(t + dtdx * dx, w + dwdx * dx);
                }
                System.out.printf("x01=%d\n", xleft);
                tmpvertices[vtx].vtx[0] = this.XSCALE(xleft);
                tmpvertices[vtx].vtx[1] = -this.YSCALE(yh);
                tmpvertices[vtx].vtx[2] = this.ZSCALE(z + dzdx * dx);
                tmpvertices[vtx].vtx[3] = this.WSCALE(w + dwdx * dx);
                ++vtx;
            }
            if (flip == 0 || flip != 0 && xleft > xright) {
                if (shade != 0) {
                    System.out.printf("r02=%d\n", r);
                    tmpvertices[vtx].color[0] = (float)this.CSCALE(r) * 0.003921569f;
                    tmpvertices[vtx].color[1] = (float)this.CSCALE(g) * 0.003921569f;
                    tmpvertices[vtx].color[2] = (float)this.CSCALE(b) * 0.003921569f;
                    tmpvertices[vtx].color[3] = (float)this.CSCALE(a) * 0.003921569f;
                }
                if (texture != 0) {
                    tmpvertices[vtx].tex[0] = this.SSCALE(s, w);
                    tmpvertices[vtx].tex[1] = this.TSCALE(t, w);
                }
                System.out.printf("x02=%d\n", xright);
                tmpvertices[vtx].vtx[0] = this.XSCALE(xright);
                tmpvertices[vtx].vtx[1] = -this.YSCALE(yh);
                tmpvertices[vtx].vtx[2] = this.ZSCALE(z);
                tmpvertices[vtx].vtx[3] = this.WSCALE(w);
                ++vtx;
            }
        }
        xleft += xleft_inc * j;
        xright += xright_inc * j;
        s += dsde * j;
        t += dtde * j;
        w += dwde * j;
        r += drde * j;
        g += dgde * j;
        b += dbde * j;
        a += dade * j;
        z += dzde * j;
        xleft = xl;
        dx = xleft - xright >> 16;
        System.out.printf("flip=%d, xleft=%d, xright=%d\n", flip, xleft, xright);
        if (flip == 0 && xleft <= xright || flip != 0) {
            if (shade != 0) {
                System.out.printf("r11=%d\n", r);
                tmpvertices[vtx].color[0] = (float)this.CSCALE(r + drdx * dx) * 0.003921569f;
                tmpvertices[vtx].color[1] = (float)this.CSCALE(g + dgdx * dx) * 0.003921569f;
                tmpvertices[vtx].color[2] = (float)this.CSCALE(b + dbdx * dx) * 0.003921569f;
                tmpvertices[vtx].color[3] = (float)this.CSCALE(a + dadx * dx) * 0.003921569f;
            }
            if (texture != 0) {
                tmpvertices[vtx].tex[0] = this.SSCALE(s + dsdx * dx, w + dwdx * dx);
                tmpvertices[vtx].tex[1] = this.TSCALE(t + dtdx * dx, w + dwdx * dx);
            }
            System.out.printf("x11=%d\n", xleft);
            tmpvertices[vtx].vtx[0] = this.XSCALE(xleft);
            tmpvertices[vtx].vtx[1] = -this.YSCALE(ym);
            tmpvertices[vtx].vtx[2] = this.ZSCALE(z + dzdx * dx);
            tmpvertices[vtx].vtx[3] = this.WSCALE(w + dwdx * dx);
            ++vtx;
        }
        if (flip == 0 || flip != 0 && xleft >= xright) {
            if (shade != 0) {
                System.out.printf("r12=%d\n", r);
                tmpvertices[vtx].color[0] = (float)this.CSCALE(r) * 0.003921569f;
                tmpvertices[vtx].color[1] = (float)this.CSCALE(g) * 0.003921569f;
                tmpvertices[vtx].color[2] = (float)this.CSCALE(b) * 0.003921569f;
                tmpvertices[vtx].color[3] = (float)this.CSCALE(a) * 0.003921569f;
            }
            if (texture != 0) {
                tmpvertices[vtx].tex[0] = this.SSCALE(s, w);
                tmpvertices[vtx].tex[1] = this.TSCALE(t, w);
            }
            System.out.printf("x12=%d\n", xright);
            tmpvertices[vtx].vtx[0] = this.XSCALE(xright);
            tmpvertices[vtx].vtx[1] = -this.YSCALE(ym);
            tmpvertices[vtx].vtx[2] = this.ZSCALE(z);
            tmpvertices[vtx].vtx[3] = this.WSCALE(w);
            ++vtx;
        }
        xleft_inc = (int)dxldy;
        xright_inc = (int)dxhdy;
        j = yl - ym;
        xleft += xleft_inc * j;
        xright += xright_inc * j;
        s += dsde * j;
        t += dtde * j;
        w += dwde * j;
        r += drde * j;
        g += dgde * j;
        b += dbde * j;
        a += dade * j;
        z += dzde * j;
        while (!(yl <= ym || flip == 0 && xleft < xright + 65536 || flip != 0 && xleft > xright - 65536)) {
            xleft -= xleft_inc;
            xright -= xright_inc;
            s -= dsde;
            t -= dtde;
            w -= dwde;
            r -= drde;
            g -= dgde;
            b -= dbde;
            a -= dade;
            z -= dzde;
            --j;
            --yl;
        }
        if (j >= 0) {
            dx = xleft - xright >> 16;
            System.out.printf("flip=%d, xleft=%d, xright=%d\n", flip, xleft, xright);
            if (flip == 0 && xleft <= xright || flip != 0) {
                if (shade != 0) {
                    System.out.printf("r21=%d\n", r);
                    tmpvertices[vtx].color[0] = (float)this.CSCALE(r + drdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[1] = (float)this.CSCALE(g + dgdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[2] = (float)this.CSCALE(b + dbdx * dx) * 0.003921569f;
                    tmpvertices[vtx].color[3] = (float)this.CSCALE(a + dadx * dx) * 0.003921569f;
                }
                if (texture != 0) {
                    tmpvertices[vtx].tex[0] = this.SSCALE(s + dsdx * dx, w + dwdx * dx);
                    tmpvertices[vtx].tex[1] = this.TSCALE(t + dtdx * dx, w + dwdx * dx);
                }
                System.out.printf("x21=%d\n", xleft);
                tmpvertices[vtx].vtx[0] = this.XSCALE(xleft);
                tmpvertices[vtx].vtx[1] = -this.YSCALE(yl);
                tmpvertices[vtx].vtx[2] = this.ZSCALE(z + dzdx * dx);
                tmpvertices[vtx].vtx[3] = this.WSCALE(w + dwdx * dx);
                ++vtx;
            }
            if (flip == 0 || flip != 0 && xleft >= xright) {
                if (shade != 0) {
                    System.out.printf("r22=%d\n", r);
                    tmpvertices[vtx].color[0] = (float)this.CSCALE(r) * 0.003921569f;
                    tmpvertices[vtx].color[1] = (float)this.CSCALE(g) * 0.003921569f;
                    tmpvertices[vtx].color[2] = (float)this.CSCALE(b) * 0.003921569f;
                    tmpvertices[vtx].color[3] = (float)this.CSCALE(a) * 0.003921569f;
                }
                if (texture != 0) {
                    tmpvertices[vtx].tex[0] = this.SSCALE(s, w);
                    tmpvertices[vtx].tex[1] = this.TSCALE(t, w);
                }
                System.out.printf("x22=%d\n", xright);
                tmpvertices[vtx].vtx[0] = this.XSCALE(xright);
                tmpvertices[vtx].vtx[1] = -this.YSCALE(yl);
                tmpvertices[vtx].vtx[2] = this.ZSCALE(z);
                tmpvertices[vtx].vtx[3] = this.WSCALE(w);
                ++vtx;
            }
        }
        this.addTriangle(tmpvertices[0].vtx, tmpvertices[0].color, tmpvertices[0].tex, tmpvertices[2].vtx, tmpvertices[2].color, tmpvertices[2].tex, tmpvertices[5].vtx, tmpvertices[5].color, tmpvertices[5].tex);
    }

    private static class ColorImage {
        public int height;
        public int address;

        private ColorImage() {
        }
    }

    private static class FillColor {
        public float[] color = new float[4];

        private FillColor() {
        }
    }

    private static class GLSimpleVertex {
        public float x;
        public float y;
        public float z;
        public float w;
        public float[] color = new float[4];
        public float[] secondaryColor = new float[4];
        public float s0;
        public float t0;
        public float s1;
        public float t1;
        public float fog;

        private GLSimpleVertex() {
        }
    }

    private static class GLVertex {
        public FloatBuffer vtx;
        public FloatBuffer color;
        public FloatBuffer secondaryColor;
        public FloatBuffer tex0;
        public FloatBuffer tex1;
        public FloatBuffer fog;
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }

    private static class OtherMode {
        public int w0;
        public int w1;

        private OtherMode() {
        }
    }

    private static class PrimDepth {
        public float z;

        private PrimDepth() {
        }
    }

    private static class Scissor {
        public float ulx;
        public float uly;
        public float lrx;
        public float lry;

        private Scissor() {
        }
    }

    private static class Vertex {
        public float[] vtx = new float[4];
        public float[] color = new float[4];
        public float[] tex = new float[2];
        public float[] clip = new float[3];

        private Vertex() {
        }

        public void copyVertex(Vertex src) {
            this.vtx[0] = src.vtx[0];
            this.vtx[1] = src.vtx[1];
            this.vtx[2] = src.vtx[2];
            this.vtx[3] = src.vtx[3];
            this.color[0] = src.color[0];
            this.color[1] = src.color[1];
            this.color[2] = src.color[2];
            this.color[3] = src.color[3];
            this.tex[0] = src.tex[0];
            this.tex[1] = src.tex[1];
        }

        public void interpolateVertex(float percent, Vertex first, Vertex second) {
            this.vtx[0] = first.vtx[0] + percent * (second.vtx[0] - first.vtx[0]);
            this.vtx[1] = first.vtx[1] + percent * (second.vtx[1] - first.vtx[1]);
            this.vtx[2] = first.vtx[2] + percent * (second.vtx[2] - first.vtx[2]);
            this.vtx[3] = first.vtx[3] + percent * (second.vtx[3] - first.vtx[3]);
            this.color[0] = first.color[0] + percent * (second.color[0] - first.color[0]);
            this.color[1] = first.color[1] + percent * (second.color[1] - first.color[1]);
            this.color[2] = first.color[2] + percent * (second.color[2] - first.color[2]);
            this.color[3] = first.color[3] + percent * (second.color[3] - first.color[3]);
            this.tex[0] = first.tex[0] + percent * (second.tex[0] - first.tex[0]);
            this.tex[1] = first.tex[1] + percent * (second.tex[1] - first.tex[1]);
        }
    }
}

