/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp.textures;

import jario.n64.console.rcp.textures.CachedTexture;
import javax.media.opengl.GL2;

public class CachedTextureStack {
    private GL2 gl;
    public CachedTexture top;
    public CachedTexture bottom;
    private int numCached;

    public void init(GL2 gl) {
        this.gl = gl;
        this.top = null;
        this.bottom = null;
        this.numCached = 0;
    }

    public void removeBottom() {
        this.gl.glDeleteTextures(1, this.bottom.glName, 0);
        if (this.bottom == this.top) {
            this.top = null;
        }
        this.bottom = this.bottom.higher;
        if (this.bottom != null) {
            this.bottom.lower = null;
        }
        --this.numCached;
    }

    public void remove(CachedTexture texture) {
        if (texture == this.bottom && texture == this.top) {
            this.top = null;
            this.bottom = null;
        } else if (texture == this.bottom) {
            this.bottom = texture.higher;
            if (this.bottom != null) {
                this.bottom.lower = null;
            }
        } else if (texture == this.top) {
            this.top = texture.lower;
            if (this.top != null) {
                this.top.higher = null;
            }
        } else {
            texture.higher.lower = texture.lower;
            texture.lower.higher = texture.higher;
        }
        --this.numCached;
        this.gl.glDeleteTextures(1, texture.glName, 0);
    }

    public void addTop(CachedTexture newtop) {
        this.gl.glGenTextures(1, newtop.glName, 0);
        newtop.lower = this.top;
        newtop.higher = null;
        if (this.top != null) {
            this.top.higher = newtop;
        }
        if (this.bottom == null) {
            this.bottom = newtop;
        }
        this.top = newtop;
        ++this.numCached;
    }

    public void moveToTop(CachedTexture newtop) {
        if (newtop == this.top) {
            return;
        }
        if (newtop == this.bottom) {
            this.bottom = newtop.higher;
            this.bottom.lower = null;
        } else {
            newtop.higher.lower = newtop.lower;
            newtop.lower.higher = newtop.higher;
        }
        newtop.higher = null;
        newtop.lower = this.top;
        this.top.higher = newtop;
        this.top = newtop;
    }
}

