/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp.textures;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageFormat {
    public GetTexelFunc Get16;
    public int glType16;
    public int glInternalFormat16;
    public GetTexelFunc Get32;
    public int glType32;
    public int glInternalFormat32;
    public int autoFormat;
    public int lineShift;
    public int maxTexels;
    private static ByteBuffer tmem;
    public static final GetTexelFunc GetNone;
    public static final GetTexelFunc GetCI4IA_RGBA4444;
    public static final GetTexelFunc GetCI4IA_RGBA8888;
    public static final GetTexelFunc GetCI4RGBA_RGBA5551;
    public static final GetTexelFunc GetCI4RGBA_RGBA8888;
    public static final GetTexelFunc GetIA31_RGBA8888;
    public static final GetTexelFunc GetIA31_RGBA4444;
    public static final GetTexelFunc GetI4_RGBA8888;
    public static final GetTexelFunc GetI4_RGBA4444;
    public static final GetTexelFunc GetCI8IA_RGBA4444;
    public static final GetTexelFunc GetCI8IA_RGBA8888;
    public static final GetTexelFunc GetCI8RGBA_RGBA5551;
    public static final GetTexelFunc GetCI8RGBA_RGBA8888;
    public static final GetTexelFunc GetIA44_RGBA8888;
    public static final GetTexelFunc GetIA44_RGBA4444;
    public static final GetTexelFunc GetI8_RGBA8888;
    public static final GetTexelFunc GetI8_RGBA4444;
    public static final GetTexelFunc GetRGBA5551_RGBA8888;
    public static final GetTexelFunc GetRGBA5551_RGBA5551;
    public static final GetTexelFunc GetIA88_RGBA8888;
    public static final GetTexelFunc GetIA88_RGBA4444;
    public static final GetTexelFunc GetRGBA8888_RGBA8888;
    public static final GetTexelFunc GetRGBA8888_RGBA4444;
    public static ImageFormat[][] imageFormat;
    private static final int[] Three2Four;
    private static final int[] One2Four;

    static {
        GetNone = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return 0;
            }
        };
        GetCI4IA_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetCI4IA_RGBA4444");
                return 61695;
            }
        };
        GetCI4IA_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                int color4B = src.get(x >> 1 ^ i << 1) & 0xFF;
                if ((x & 1) != 0) {
                    return ImageFormat.IA88_RGBA8888(tmem.getShort((256 + (palette << 4) + (color4B & 0xF)) * 8));
                }
                return ImageFormat.IA88_RGBA8888(tmem.getShort((256 + (palette << 4) + (color4B >> 4)) * 8));
            }
        };
        GetCI4RGBA_RGBA5551 = new GetTexelFunc(){

            @Override
            public final int GetTexel(ByteBuffer src, int x, int i, int palette) {
                int color4B = src.get(x >> 1 ^ i << 1) & 0xFF;
                if ((x & 1) != 0) {
                    return ImageFormat.RGBA5551_RGBA5551(tmem.getShort((256 + (palette << 4) + (color4B & 0xF)) * 8)) & 0xFFFF;
                }
                return ImageFormat.RGBA5551_RGBA5551(tmem.getShort((256 + (palette << 4) + (color4B >> 4)) * 8)) & 0xFFFF;
            }
        };
        GetCI4RGBA_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetCI4RGBA_RGBA8888");
                return -16711681;
            }
        };
        GetIA31_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetIA31_RGBA8888");
                return -16711681;
            }
        };
        GetIA31_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                int color4B = src.get(x >> 1 ^ i << 1) & 0xFF;
                return ImageFormat.IA31_RGBA4444((x & 1) != 0 ? (byte)(color4B & 0xF) : (byte)(color4B >> 4)) & 0xFFFF;
            }
        };
        GetI4_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetI4_RGBA8888");
                return -16711681;
            }
        };
        GetI4_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                int color4B = src.get(x >> 1 ^ i << 1) & 0xFF;
                return ImageFormat.I4_RGBA4444((x & 1) != 0 ? (byte)(color4B & 0xF) : (byte)(color4B >> 4)) & 0xFFFF;
            }
        };
        GetCI8IA_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetCI8IA_RGBA4444");
                return 61695;
            }
        };
        GetCI8IA_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return -16711681;
            }
        };
        GetCI8RGBA_RGBA5551 = new GetTexelFunc(){

            @Override
            public final int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return ImageFormat.RGBA5551_RGBA5551(tmem.getShort((256 + (src.get(x ^ i << 1) & 0xFF)) * 8)) & 0xFFFF;
            }
        };
        GetCI8RGBA_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetCI8RGBA_RGBA8888");
                return -16711681;
            }
        };
        GetIA44_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetIA44_RGBA8888");
                return -16711681;
            }
        };
        GetIA44_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return ImageFormat.IA44_RGBA4444(src.get(x ^ i << 1)) & 0xFFFF;
            }
        };
        GetI8_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return ImageFormat.I8_RGBA8888(src.get(x ^ i << 1));
            }
        };
        GetI8_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetI8_RGBA4444");
                return 61695;
            }
        };
        GetRGBA5551_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetRGBA5551_RGBA8888 ");
                return -16711681;
            }
        };
        GetRGBA5551_RGBA5551 = new GetTexelFunc(){

            @Override
            public final int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return ImageFormat.RGBA5551_RGBA5551(src.asShortBuffer().get(x ^ i)) & 0xFFFF;
            }
        };
        GetIA88_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                return ImageFormat.IA88_RGBA8888(src.asShortBuffer().get(x ^ i));
            }
        };
        GetIA88_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetIA88_RGBA4444");
                return 61695;
            }
        };
        GetRGBA8888_RGBA8888 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                src.order(ByteOrder.LITTLE_ENDIAN);
                return src.asIntBuffer().get(x ^ i);
            }
        };
        GetRGBA8888_RGBA4444 = new GetTexelFunc(){

            @Override
            public int GetTexel(ByteBuffer src, int x, int i, int palette) {
                System.out.println("GetRGBA8888_RGBA4444");
                return 61695;
            }
        };
        imageFormat = new ImageFormat[][]{{new ImageFormat(GetCI4RGBA_RGBA5551, 32820, 32855, GetCI4RGBA_RGBA8888, 5121, 32856, 32855, 4, 4096), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 4, 8192), new ImageFormat(GetCI4RGBA_RGBA5551, 32820, 32855, GetCI4RGBA_RGBA8888, 5121, 32856, 32855, 4, 4096), new ImageFormat(GetIA31_RGBA4444, 32819, 32854, GetIA31_RGBA8888, 5121, 32856, 32854, 4, 8192), new ImageFormat(GetI4_RGBA4444, 32819, 32854, GetI4_RGBA8888, 5121, 32856, 32854, 4, 8192)}, {new ImageFormat(GetCI8RGBA_RGBA5551, 32820, 32855, GetCI8RGBA_RGBA8888, 5121, 32856, 32855, 3, 2048), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 4096), new ImageFormat(GetCI8RGBA_RGBA5551, 32820, 32855, GetCI8RGBA_RGBA8888, 5121, 32856, 32855, 3, 2048), new ImageFormat(GetIA44_RGBA4444, 32819, 32854, GetIA44_RGBA8888, 5121, 32856, 32854, 3, 4096), new ImageFormat(GetI8_RGBA4444, 32819, 32854, GetI8_RGBA8888, 5121, 32856, 32856, 3, 4096)}, {new ImageFormat(GetRGBA5551_RGBA5551, 32820, 32855, GetRGBA5551_RGBA8888, 5121, 32856, 32855, 2, 2048), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 2, 2048), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 2048), new ImageFormat(GetIA88_RGBA4444, 32819, 32854, GetIA88_RGBA8888, 5121, 32856, 32856, 2, 2048), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 2048)}, {new ImageFormat(GetRGBA8888_RGBA4444, 32819, 32854, GetRGBA8888_RGBA8888, 5121, 32856, 32856, 2, 1024), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 1024), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 1024), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 1024), new ImageFormat(GetNone, 32819, 32854, GetNone, 5121, 32856, 32854, 0, 1024)}};
        int[] nArray = new int[8];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 9;
        nArray[5] = 11;
        nArray[6] = 13;
        nArray[7] = 15;
        Three2Four = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 15;
        One2Four = nArray2;
    }

    private ImageFormat(GetTexelFunc Get16, int glType16, int glInternalFormat16, GetTexelFunc Get32, int glType32, int glInternalFormat32, int autoFormat, int lineShift, int maxTexels) {
        this.Get16 = Get16;
        this.glType16 = glType16;
        this.glInternalFormat16 = glInternalFormat16;
        this.Get32 = Get32;
        this.glType32 = glType32;
        this.glInternalFormat32 = glInternalFormat32;
        this.autoFormat = autoFormat;
        this.lineShift = lineShift;
        this.maxTexels = maxTexels;
    }

    public static void settMem(ByteBuffer mem) {
        tmem = mem;
    }

    private static final short RGBA5551_RGBA5551(short color) {
        return color;
    }

    private static final int IA88_RGBA8888(short color) {
        int al = color & 0xFF;
        int ah = color >> 8 & 0xFF;
        return al << 24 | ah << 16 | ah << 8 | ah;
    }

    private static final short IA44_RGBA4444(byte color) {
        int cl;
        int al = cl = color & 0xFF;
        int ah = cl = cl >> 4 & 0xFF;
        cl = cl << 4 & 0xFF;
        return (short)((ah |= cl) << 8 | al);
    }

    private static final short IA31_RGBA4444(byte color) {
        int ch;
        int cl;
        int bl = cl = color & 0xFF;
        bl = bl >> 1 & 0xFF;
        int ah = ch = Three2Four[bl];
        ch = ch << 4 & 0xFF;
        ah |= ch;
        int al = ch;
        bl = cl;
        ch = One2Four[bl &= 1];
        return (short)(ah << 8 | (al |= ch));
    }

    private static final int I8_RGBA8888(byte color) {
        int cl = color & 0xFF;
        return cl << 24 | cl << 16 | cl << 8 | cl;
    }

    private static final short I4_RGBA4444(byte color) {
        int cl;
        int al = cl = color & 0xFF;
        cl = cl << 4 & 0xFF;
        int ah = al |= cl;
        return (short)((ah & 0xFF) << 8 | al & 0xFF);
    }

    public static interface GetTexelFunc {
        public int GetTexel(ByteBuffer var1, int var2, int var3, int var4);
    }
}

