/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp.textures;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import jario.n64.console.rcp.textures.CachedTexture;
import jario.n64.console.rcp.textures.CachedTextureStack;
import jario.n64.console.rcp.textures.ImageFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import javax.media.opengl.GL2;

public class TextureCache {
    public static final int G_IM_FMT_RGBA = 0;
    public static final int G_IM_FMT_YUV = 1;
    public static final int G_IM_FMT_CI = 2;
    public static final int G_IM_FMT_IA = 3;
    public static final int G_IM_FMT_I = 4;
    public static final int G_IM_SIZ_4b = 0;
    public static final int G_IM_SIZ_8b = 1;
    public static final int G_IM_SIZ_16b = 2;
    public static final int G_IM_SIZ_32b = 3;
    public static final int G_IM_SIZ_DD = 5;
    public static final int TEXTUREMODE_NORMAL = 0;
    public static final int TEXTUREMODE_TEXRECT = 1;
    public static final int TEXTUREMODE_BGIMAGE = 2;
    public static final int LOADTYPE_BLOCK = 0;
    public static final int LOADTYPE_TILE = 1;
    public static final int CHANGED_TMEM = 8;
    private static final int CRC32_POLYNOMIAL = 79764919;
    private final InterleaveFunc DWordInterleave = new InterleaveFunc(){

        @Override
        public final void Interleave(byte[] mem, int off, int numDWords) {
            numDWords = off + (numDWords << 3);
            int i = off;
            while (i < numDWords) {
                System.arraycopy(mem, i, TextureCache.this.tmp, 0, 4);
                System.arraycopy(mem, i + 4, mem, i, 4);
                System.arraycopy(TextureCache.this.tmp, 0, mem, i + 4, 4);
                i += 8;
            }
        }
    };
    private final InterleaveFunc QWordInterleave = new InterleaveFunc(){

        @Override
        public final void Interleave(byte[] mem, int off, int numDWords) {
            numDWords = off + (numDWords << 3);
            int i = off;
            while (i < numDWords) {
                System.arraycopy(mem, i, TextureCache.this.tmp, 0, 4);
                System.arraycopy(mem, i + 8, mem, i, 4);
                System.arraycopy(TextureCache.this.tmp, 0, mem, i + 8, 4);
                System.arraycopy(mem, i + 4, TextureCache.this.tmp, 0, 4);
                System.arraycopy(mem, i + 12, mem, i + 4, 4);
                System.arraycopy(TextureCache.this.tmp, 0, mem, i + 12, 4);
                i += 16;
            }
        }
    };
    public int changed;
    public gDPTile[] textureTile = new gDPTile[2];
    public CachedTexture[] current = new CachedTexture[2];
    private boolean ARB_multitexture;
    private int cachedBytes;
    private CachedTextureStack stack = new CachedTextureStack();
    private Texture texture = new Texture();
    private gDPTile[] tiles = new gDPTile[8];
    private gDPTile loadTile = new gDPTile();
    private TexRect texRect = new TexRect();
    private TextureImage textureImage = new TextureImage();
    private int loadType;
    private ByteBuffer paletteCRC16 = ByteBuffer.allocate(64);
    private ByteBuffer paletteCRC256 = ByteBuffer.allocate(4);
    private int textureMode;
    private GL2 gl;
    private int maxBytes;
    private int textureBitDepth;
    private final byte[] tmp = new byte[4];
    private int hits;
    private int misses;
    private int[] glNoiseNames = new int[32];
    private CachedTexture dummy;
    private BgImage bgImage = new BgImage();
    private Checksum crc32;
    private Bus16bit rdram;
    private ByteBuffer tmem;
    private int rdramSize;
    private boolean enable2xSaI;
    private int[] crcTable = new int[256];
    private int maxTextureUnits;

    public void construct() {
        int i = 0;
        while (i < this.tiles.length) {
            this.tiles[i] = new gDPTile();
            ++i;
        }
        i = 0;
        while (i < this.textureTile.length) {
            this.textureTile[i] = new gDPTile();
            ++i;
        }
        this.loadTile = this.tiles[7];
        this.textureTile[0] = this.tiles[0];
        this.textureTile[1] = this.tiles[1];
    }

    public void config(int maxBytes, int textureBitDepth) {
        this.maxBytes = maxBytes;
        this.textureBitDepth = textureBitDepth;
        this.enable2xSaI = false;
    }

    public void init(GL2 gl, Hardware rdram, ByteBuffer tmem, int maxTextureUnits, boolean ARB_multitexture) {
        this.gl = gl;
        this.rdram = (Bus16bit)rdram;
        this.tmem = tmem;
        this.maxTextureUnits = maxTextureUnits;
        this.ARB_multitexture = ARB_multitexture;
        ImageFormat.settMem(tmem);
        this.rdramSize = ((Bus32bit)rdram).read32bit(66060328);
        ByteBuffer dummyTexture = ByteBuffer.allocateDirect(64);
        this.current[0] = null;
        this.current[1] = null;
        this.stack.init(gl);
        this.cachedBytes = 0;
        gl.glGenTextures(32, this.glNoiseNames, 0);
        ByteBuffer noise = ByteBuffer.allocateDirect(16384);
        int i = 0;
        while (i < 32) {
            gl.glBindTexture(3553, this.glNoiseNames[i]);
            Random rand = new Random();
            int y = 0;
            while (y < 64) {
                int x = 0;
                while (x < 64) {
                    byte random = (byte)(rand.nextInt() & 0xFF);
                    noise.put(y * 64 * 4 + x * 4, random);
                    noise.put(y * 64 * 4 + x * 4 + 1, random);
                    noise.put(y * 64 * 4 + x * 4 + 2, random);
                    noise.put(y * 64 * 4 + x * 4 + 3, random);
                    ++x;
                }
                ++y;
            }
            gl.glTexImage2D(3553, 0, 32856, 64, 64, 0, 6408, 5121, (Buffer)noise);
            ++i;
        }
        this.dummy = CachedTexture.getDummy();
        this.prune();
        this.stack.addTop(this.dummy);
        gl.glBindTexture(3553, this.dummy.glName[0]);
        gl.glTexImage2D(3553, 0, 32856, 2, 2, 0, 6408, 5121, (Buffer)dummyTexture);
        this.cachedBytes = this.dummy.textureBytes;
        this.crc32 = new Adler32();
        i = 0;
        while (i < maxTextureUnits) {
            this.activateDummy(i);
            ++i;
        }
        this.crcBuildTable();
    }

    public float getTexS(int tex, float scale) {
        return (scale * this.current[tex].shiftScaleS * this.texture.scales - this.textureTile[0].fuls + this.current[tex].offsetS) * this.current[tex].scaleS;
    }

    public float getTexT(int tex, float scale) {
        return (scale * this.current[tex].shiftScaleT * this.texture.scalet - this.textureTile[tex].fult + this.current[tex].offsetT) * this.current[tex].scaleT;
    }

    public void activateDummy(int w1) {
        if (this.ARB_multitexture) {
            this.gl.glActiveTexture(33984 + w1);
        }
        this.gl.glBindTexture(3553, this.dummy.glName[0]);
        this.gl.glTexParameteri(3553, 10241, 9728);
        this.gl.glTexParameteri(3553, 10240, 9728);
    }

    public void setTexture(int w1, int w2) {
        this.texture.scales = (float)(w2 >> 16 & 0xFFFF) * 1.5258789E-5f;
        this.texture.scalet = (float)(w2 >> 0 & 0xFFFF) * 1.5258789E-5f;
        if (this.texture.scales == 0.0f) {
            this.texture.scales = 1.0f;
        }
        if (this.texture.scalet == 0.0f) {
            this.texture.scalet = 1.0f;
        }
        this.texture.level = w1 >> 16 & 0xFF;
        this.texture.on = w1 >> 0 & 0xFF;
        this.texture.tile = w1 >> 8 & 0xFF;
        this.textureTile[0] = this.tiles[this.texture.tile];
        this.textureTile[1] = this.tiles[this.texture.tile < 7 ? this.texture.tile + 1 : this.texture.tile];
    }

    public void setTextureImage(int w1, int w2) {
        this.textureImage.format = w1 >> 21 & 7;
        this.textureImage.size = w1 >> 19 & 3;
        this.textureImage.width = (w1 & 0xFFF) + 1;
        this.textureImage.address = w2 & 0x3FFFFFF;
        this.textureImage.bpl = this.textureImage.width << this.textureImage.size >> 1;
    }

    public void setTextureTile(int w1, int w2, int w3, int w4, int w5) {
        float ulx = (float)(w2 >> 12 & 0xFFF) * 0.25f;
        float uly = (float)(w2 >> 0 & 0xFFF) * 0.25f;
        float lrx = (float)(w1 >> 12 & 0xFFF) * 0.25f;
        float lry = (float)(w1 >> 0 & 0xFFF) * 0.25f;
        int tile = w2 >> 24 & 7;
        float dsdx = (float)(w4 >> 16 & 0xFFFF) * 9.765625E-4f;
        float dtdy = (float)(w4 >> 0 & 0xFFFF) * 9.765625E-4f;
        float s = (float)(w3 >> 16 & 0xFFFF) * 0.03125f;
        float t = (float)(w3 >> 0 & 0xFFFF) * 0.03125f;
        if ((w5 >> 20 & 3) == 2) {
            dsdx = 1.0f;
            lrx += 1.0f;
            lry += 1.0f;
        }
        this.textureTile[0] = this.tiles[tile];
        this.textureTile[1] = this.tiles[tile < 7 ? tile + 1 : tile];
        if (this.textureMode == 0) {
            this.textureMode = 1;
        }
        this.texRect.width = (int)(StrictMath.max(s + (lrx - ulx - 1.0f) * dsdx, s) + dsdx);
        this.texRect.height = (int)(StrictMath.max(t + (lry - uly - 1.0f) * dtdy, t) + dtdy);
    }

    public void setTextureTileFlip(int w1, int w2, int w3, int w4, int w5) {
        float ulx = (float)(w2 >> 12 & 0xFFF) * 0.25f;
        float uly = (float)(w2 >> 0 & 0xFFF) * 0.25f;
        float lrx = (float)(w1 >> 12 & 0xFFF) * 0.25f;
        float lry = (float)(w1 >> 0 & 0xFFF) * 0.25f;
        int tile = w2 >> 24 & 7;
        float dsdx = -((float)(w4 >> 16 & 0xFFFF) * 9.765625E-4f);
        float dtdy = -((float)(w4 >> 0 & 0xFFFF) * 9.765625E-4f);
        float s = (float)(w3 >> 16 & 0xFFFF) * 0.03125f + (lrx - ulx) * dsdx;
        float t = (float)(w3 >> 0 & 0xFFFF) * 0.03125f + (lry - uly) * dtdy;
        if ((w5 >> 20 & 3) == 2) {
            dsdx = 1.0f;
            lrx += 1.0f;
            lry += 1.0f;
        }
        this.textureTile[0] = this.tiles[tile];
        this.textureTile[1] = this.tiles[tile < 7 ? tile + 1 : tile];
        if (this.textureMode == 0) {
            this.textureMode = 1;
        }
        this.texRect.width = (int)(StrictMath.max(s + (lrx - ulx - 1.0f) * dsdx, s) + dsdx);
        this.texRect.height = (int)(StrictMath.max(t + (lry - uly - 1.0f) * dtdy, t) + dtdy);
    }

    public void resetTextureTile() {
        this.textureTile[0] = this.tiles[this.texture.tile];
        this.textureTile[1] = this.tiles[this.texture.tile < 7 ? this.texture.tile + 1 : this.texture.tile];
    }

    public void setTile(int w1, int w2) {
        int format = w1 >> 21 & 7;
        int size = w1 >> 19 & 3;
        int tile = w2 >> 24 & 7;
        if ((size == 0 || size == 1) && format == 0) {
            format = 2;
        }
        this.tiles[tile].format = format;
        this.tiles[tile].size = size;
        this.tiles[tile].line = w1 >> 9 & 0x1FF;
        this.tiles[tile].tmem = w1 >> 0 & 0x1FF;
        this.tiles[tile].palette = w2 >> 20 & 0xF;
        this.tiles[tile].setCmt(w2 >> 18 & 3);
        this.tiles[tile].setCms(w2 >> 8 & 3);
        this.tiles[tile].maskt = w2 >> 14 & 0xF;
        this.tiles[tile].masks = w2 >> 4 & 0xF;
        this.tiles[tile].shiftt = w2 >> 10 & 0xF;
        this.tiles[tile].shifts = w2 >> 0 & 0xF;
        if (this.tiles[tile].masks == 0) {
            this.tiles[tile].clamps = 1;
        }
        if (this.tiles[tile].maskt == 0) {
            this.tiles[tile].clampt = 1;
        }
    }

    public void setTileSize(int w1, int w2) {
        int tile = w2 >> 24 & 7;
        int uls = w1 >> 12 & 0xFFF;
        int ult = w1 >> 0 & 0xFFF;
        int lrs = w2 >> 12 & 0xFFF;
        int lrt = w2 >> 0 & 0xFFF;
        this.tiles[tile].uls = uls >> 2 & 0x3FF;
        this.tiles[tile].ult = ult >> 2 & 0x3FF;
        this.tiles[tile].lrs = lrs >> 2 & 0x3FF;
        this.tiles[tile].lrt = lrt >> 2 & 0x3FF;
        this.tiles[tile].fuls = (float)uls * 0.25f;
        this.tiles[tile].fult = (float)ult * 0.25f;
        this.tiles[tile].flrs = (float)lrs * 0.25f;
        this.tiles[tile].flrt = (float)lrt * 0.25f;
    }

    public void loadTile(int w1, int w2) {
        InterleaveFunc Interleave;
        int line;
        this.loadTile = this.tiles[w2 >> 24 & 7];
        if (this.loadTile.line == 0) {
            return;
        }
        int address = this.textureImage.address + this.loadTile.ult * this.textureImage.bpl + (this.loadTile.uls << this.textureImage.size >> 1);
        int dest = this.loadTile.tmem << 3;
        int bpl = this.loadTile.lrs - this.loadTile.uls + 1 << this.loadTile.size >> 1;
        int height = this.loadTile.lrt - this.loadTile.ult + 1;
        int src = address;
        if (address + height * bpl > this.rdramSize || (this.loadTile.tmem << 3) + bpl * height > 4096) {
            return;
        }
        byte[] tmemArray = this.tmem.array();
        if (this.loadTile.size == 3) {
            line = this.loadTile.line << 1;
            Interleave = this.QWordInterleave;
        } else {
            line = this.loadTile.line;
            Interleave = this.DWordInterleave;
        }
        int bplTex = this.textureImage.bpl;
        int lineBytes = line << 3;
        int y = 0;
        while (y < height) {
            ((BusDMA)this.rdram).readDMA(src, this.tmem, dest, bpl);
            if ((y & 1) != 0) {
                Interleave.Interleave(tmemArray, dest, line);
            }
            src += bplTex;
            dest += lineBytes;
            ++y;
        }
        this.textureMode = 0;
        this.loadType = 1;
        this.changed |= 8;
    }

    public void loadBlock(int w1, int w2) {
        this.loadTile = this.tiles[w2 >> 24 & 7];
        int bytes = (w2 >> 12 & 0xFFF) + 1 << this.loadTile.size >>> 1;
        int address = this.textureImage.address + (w1 >> 0 & 0xFFF) * this.textureImage.bpl + ((w1 >> 12 & 0xFFF) << this.textureImage.size >>> 1);
        if (bytes == 0 || address + bytes > this.rdramSize || (this.loadTile.tmem << 3) + bytes > 4096) {
            return;
        }
        int src = address;
        int dest = this.loadTile.tmem << 3;
        byte[] tmemArray = this.tmem.array();
        int dxt = w2 >> 0 & 0xFFF;
        if (dxt > 0) {
            int line = (2047 + dxt) / dxt;
            int bpl = line << 3;
            int height = bytes / bpl;
            InterleaveFunc Interleave = this.loadTile.size == 3 ? this.QWordInterleave : this.DWordInterleave;
            int y = 0;
            while (y < height) {
                ((BusDMA)this.rdram).readDMA(src, this.tmem, dest, bpl);
                if ((y & 1) != 0) {
                    Interleave.Interleave(tmemArray, dest, line);
                }
                src += bpl;
                dest += bpl;
                ++y;
            }
        } else {
            ((BusDMA)this.rdram).readDMA(src, this.tmem, dest, bytes);
        }
        this.textureMode = 0;
        this.loadType = 0;
        this.changed |= 8;
    }

    public void loadLUT(int w1, int w2) {
        int tile = w2 >> 24 & 7;
        int count = (this.tiles[tile].lrs - this.tiles[tile].uls + 1) * (this.tiles[tile].lrt - this.tiles[tile].ult + 1) & 0xFFFF;
        int address = this.textureImage.address + this.tiles[tile].ult * this.textureImage.bpl + (this.tiles[tile].uls << this.textureImage.size >>> 1);
        int dest = this.tiles[tile].tmem * 8;
        int pal = this.tiles[tile].tmem - 256 >>> 4 & 0xFFFF;
        this.tmem.position(0);
        ByteBuffer tmemPtr = this.tmem.slice();
        this.paletteCRC16.position(0);
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < 16 && i < count) {
                this.tmem.putShort(dest, this.rdram.read16bit(address + i * 2));
                dest += 8;
                ++j;
                ++i;
            }
            tmemPtr.position((256 + (pal << 4)) * 8);
            this.paletteCRC16.asIntBuffer().put(pal, this.crcCalculatePalette(-1, tmemPtr.slice(), 16));
            ++pal;
        }
        this.crc32.reset();
        this.crc32.update(this.paletteCRC16.array(), 0, 64);
        this.paletteCRC256.asIntBuffer().put(0, (int)this.crc32.getValue());
        this.changed |= 8;
    }

    public void update(int w1, int w2) {
        int clampHeight;
        int height;
        int width;
        boolean linear;
        int tex = w1;
        boolean IA16 = (w2 >> 14 & 3) == 3;
        boolean bl = linear = (w2 >> 12 & 3) == 2 || (w2 >> 12 & 3) == 3;
        if (this.textureMode == 2) {
            this.updateBackground(IA16, linear);
            return;
        }
        int maxTexels = ImageFormat.imageFormat[this.textureTile[tex].size][this.textureTile[tex].format].maxTexels;
        int tileWidth = this.textureTile[tex].lrs - this.textureTile[tex].uls + 1;
        int tileHeight = this.textureTile[tex].lrt - this.textureTile[tex].ult + 1;
        int maskWidth = 1 << this.textureTile[tex].masks;
        int maskHeight = 1 << this.textureTile[tex].maskt;
        int loadWidth = this.loadTile.lrs - this.loadTile.uls + 1;
        int loadHeight = this.loadTile.lrt - this.loadTile.ult + 1;
        int lineWidth = this.textureTile[tex].line << ImageFormat.imageFormat[this.textureTile[tex].size][this.textureTile[tex].format].lineShift;
        int lineHeight = lineWidth != 0 ? StrictMath.min(maxTexels / lineWidth, tileHeight) : 0;
        if (this.textureMode == 1) {
            int texRectWidth = this.texRect.width - this.textureTile[tex].uls;
            int texRectHeight = this.texRect.height - this.textureTile[tex].ult;
            width = this.textureTile[tex].masks != 0 && maskWidth * maskHeight <= maxTexels ? maskWidth : (tileWidth * tileHeight <= maxTexels ? tileWidth : (tileWidth * texRectHeight <= maxTexels ? tileWidth : (texRectWidth * tileHeight <= maxTexels ? this.texRect.width : (texRectWidth * texRectHeight <= maxTexels ? this.texRect.width : (this.loadType == 1 ? loadWidth : lineWidth)))));
            height = this.textureTile[tex].maskt != 0 && maskWidth * maskHeight <= maxTexels ? maskHeight : (tileWidth * tileHeight <= maxTexels ? tileHeight : (tileWidth * texRectHeight <= maxTexels ? this.texRect.height : (texRectWidth * tileHeight <= maxTexels ? tileHeight : (texRectWidth * texRectHeight <= maxTexels ? this.texRect.height : (this.loadType == 1 ? loadHeight : lineHeight)))));
        } else {
            width = this.textureTile[tex].masks != 0 && maskWidth * maskHeight <= maxTexels ? maskWidth : (tileWidth * tileHeight <= maxTexels ? tileWidth : (this.loadType == 1 ? loadWidth : lineWidth));
            height = this.textureTile[tex].maskt != 0 && maskWidth * maskHeight <= maxTexels ? maskHeight : (tileWidth * tileHeight <= maxTexels ? tileHeight : (this.loadType == 1 ? loadHeight : lineHeight));
        }
        int clampWidth = this.textureTile[tex].clamps != 0 ? tileWidth : width;
        int n = clampHeight = this.textureTile[tex].clampt != 0 ? tileHeight : height;
        if (clampWidth > 256) {
            this.textureTile[tex].clamps = 0;
        }
        if (clampHeight > 256) {
            this.textureTile[tex].clampt = 0;
        }
        if (maskWidth > width) {
            this.textureTile[tex].masks = this.textureTile[tex].powof(width);
            maskWidth = 1 << this.textureTile[tex].masks;
        }
        if (maskHeight > height) {
            this.textureTile[tex].maskt = this.textureTile[tex].powof(height);
            maskHeight = 1 << this.textureTile[tex].maskt;
        }
        int src = this.textureTile[tex].tmem << 3;
        int bpl = width << this.textureTile[tex].size >> 1;
        int lineBytes = this.textureTile[tex].line << 3;
        this.crc32.reset();
        int y = 0;
        while (y < height) {
            this.crc32.update(this.tmem.array(), src, bpl);
            src += lineBytes;
            ++y;
        }
        if (this.textureTile[tex].format == 2) {
            if (this.textureTile[tex].size == 0) {
                this.crc32.update(this.paletteCRC16.array(), this.textureTile[tex].palette << 2, 4);
            } else if (this.textureTile[tex].size == 1) {
                this.crc32.update(this.paletteCRC256.array(), 0, 4);
            }
        }
        int crc = (int)this.crc32.getValue();
        CachedTexture texture = this.stack.top;
        while (texture != null) {
            if (texture.crc == crc && texture.width == width && texture.height == height && texture.clampWidth == clampWidth && texture.clampHeight == clampHeight && texture.maskS == this.textureTile[tex].masks && texture.maskT == this.textureTile[tex].maskt && texture.mirrorS == this.textureTile[tex].mirrors && texture.mirrorT == this.textureTile[tex].mirrort && texture.clampS == this.textureTile[tex].clamps && texture.clampT == this.textureTile[tex].clampt && texture.format == this.textureTile[tex].format && texture.size == this.textureTile[tex].size) {
                this.activateTexture(tex, texture, linear);
                ++this.hits;
                return;
            }
            texture = texture.lower;
        }
        ++this.misses;
        if (this.ARB_multitexture) {
            this.gl.glActiveTexture(33984 + tex);
        }
        this.current[tex] = new CachedTexture();
        this.prune();
        this.stack.addTop(this.current[tex]);
        this.gl.glBindTexture(3553, this.current[tex].glName[0]);
        this.current[tex].address = this.textureImage.address;
        this.current[tex].crc = crc;
        this.current[tex].format = this.textureTile[tex].format;
        this.current[tex].size = this.textureTile[tex].size;
        this.current[tex].width = width;
        this.current[tex].height = height;
        this.current[tex].clampWidth = clampWidth;
        this.current[tex].clampHeight = clampHeight;
        this.current[tex].palette = this.textureTile[tex].palette;
        this.current[tex].maskS = this.textureTile[tex].masks;
        this.current[tex].maskT = this.textureTile[tex].maskt;
        this.current[tex].mirrorS = this.textureTile[tex].mirrors;
        this.current[tex].mirrorT = this.textureTile[tex].mirrort;
        this.current[tex].clampS = this.textureTile[tex].clamps;
        this.current[tex].clampT = this.textureTile[tex].clampt;
        this.current[tex].line = this.textureTile[tex].line;
        this.current[tex].tMem = this.textureTile[tex].tmem;
        this.current[tex].realWidth = this.current[tex].clampS != 0 ? this.current[tex].pow2(clampWidth) : (this.current[tex].mirrorS != 0 ? maskWidth << 1 : this.current[tex].pow2(width));
        this.current[tex].realHeight = this.current[tex].clampT != 0 ? this.current[tex].pow2(clampHeight) : (this.current[tex].mirrorT != 0 ? maskHeight << 1 : this.current[tex].pow2(height));
        this.current[tex].scaleS = 1.0f / (float)this.current[tex].realWidth;
        this.current[tex].scaleT = 1.0f / (float)this.current[tex].realHeight;
        this.current[tex].shiftScaleS = 1.0f;
        this.current[tex].shiftScaleT = 1.0f;
        this.current[tex].offsetS = this.enable2xSaI ? 0.25f : 0.5f;
        float f = this.current[tex].offsetT = this.enable2xSaI ? 0.25f : 0.5f;
        if (this.textureTile[tex].shifts > 10) {
            this.current[tex].shiftScaleS = 1 << 16 - this.textureTile[tex].shifts;
        } else if (this.textureTile[tex].shifts > 0) {
            this.current[tex].shiftScaleS /= (float)(1 << this.textureTile[tex].shifts);
        }
        if (this.textureTile[tex].shiftt > 10) {
            this.current[tex].shiftScaleT = 1 << 16 - this.textureTile[tex].shiftt;
        } else if (this.textureTile[tex].shiftt > 0) {
            this.current[tex].shiftScaleT /= (float)(1 << this.textureTile[tex].shiftt);
        }
        this.current[tex].load(IA16, this.textureBitDepth, this.tmem, this.gl);
        this.activateTexture(tex, this.current[tex], linear);
        this.cachedBytes += this.current[tex].textureBytes;
    }

    private void updateBackground(boolean IA16, boolean linear) {
        int numBytes = this.bgImage.width * this.bgImage.height << this.bgImage.size >>> 1;
        this.crc32.reset();
        ByteBuffer buff = ByteBuffer.allocate(numBytes);
        byte[] rdramcrc = buff.array();
        ((BusDMA)this.rdram).readDMA(this.bgImage.address, buff, 0, numBytes);
        this.crc32.update(rdramcrc, 0, numBytes);
        if (this.bgImage.format == 2) {
            if (this.bgImage.size == 0) {
                this.crc32.update(this.paletteCRC16.array(), this.bgImage.palette << 2, 4);
            } else if (this.bgImage.size == 1) {
                this.crc32.update(this.paletteCRC256.array(), 0, 4);
            }
        }
        int crc = (int)this.crc32.getValue();
        CachedTexture tex = this.stack.top;
        while (tex != null) {
            if (tex.crc == crc && tex.width == this.bgImage.width && tex.height == this.bgImage.height && tex.format == this.bgImage.format && tex.size == this.bgImage.size) {
                this.activateTexture(0, tex, linear);
                ++this.hits;
                return;
            }
            tex = tex.lower;
        }
        ++this.misses;
        if (this.ARB_multitexture) {
            this.gl.glActiveTexture(33984);
        }
        this.current[0] = new CachedTexture();
        this.prune();
        this.stack.addTop(this.current[0]);
        this.gl.glBindTexture(3553, this.current[0].glName[0]);
        this.current[0].address = this.bgImage.address;
        this.current[0].crc = crc;
        this.current[0].format = this.bgImage.format;
        this.current[0].size = this.bgImage.size;
        this.current[0].width = this.bgImage.width;
        this.current[0].height = this.bgImage.height;
        this.current[0].clampWidth = this.bgImage.width;
        this.current[0].clampHeight = this.bgImage.height;
        this.current[0].palette = this.bgImage.palette;
        this.current[0].maskS = 0;
        this.current[0].maskT = 0;
        this.current[0].mirrorS = 0;
        this.current[0].mirrorT = 0;
        this.current[0].clampS = 1;
        this.current[0].clampT = 1;
        this.current[0].line = 0;
        this.current[0].tMem = 0;
        this.current[0].realWidth = this.current[0].pow2(this.bgImage.width);
        this.current[0].realHeight = this.current[0].pow2(this.bgImage.height);
        this.current[0].scaleS = 1.0f / (float)this.current[0].realWidth;
        this.current[0].scaleT = 1.0f / (float)this.current[0].realHeight;
        this.current[0].shiftScaleS = 1.0f;
        this.current[0].shiftScaleT = 1.0f;
        this.current[0].loadBackground(IA16, this.textureBitDepth, (Hardware)this.rdram, this.gl, this.bgImage.width, this.bgImage.height, this.bgImage.size, this.bgImage.address);
        this.activateTexture(0, this.current[0], linear);
        this.cachedBytes += this.current[0].textureBytes;
    }

    private void prune() {
        while (this.cachedBytes > this.maxBytes) {
            if (this.stack.bottom != this.dummy) {
                this.cachedBytes -= this.stack.bottom.textureBytes;
                this.stack.removeBottom();
                continue;
            }
            if (this.dummy.higher == null) continue;
            this.stack.remove(this.dummy.higher);
            this.cachedBytes -= this.dummy.higher.textureBytes;
        }
    }

    private void activateTexture(int tex, CachedTexture texture, boolean linear) {
        if (this.ARB_multitexture) {
            this.gl.glActiveTexture(33984 + tex);
        }
        this.gl.glBindTexture(3553, texture.glName[0]);
        if (linear) {
            this.gl.glTexParameteri(3553, 10241, 9729);
            this.gl.glTexParameteri(3553, 10240, 9729);
        } else {
            this.gl.glTexParameteri(3553, 10241, 9728);
            this.gl.glTexParameteri(3553, 10240, 9728);
        }
        this.gl.glTexParameteri(3553, 10242, texture.clampS != 0 ? 33071 : 10497);
        this.gl.glTexParameteri(3553, 10243, texture.clampT != 0 ? 33071 : 10497);
        this.stack.moveToTop(texture);
        this.current[tex] = texture;
    }

    private int crcCalculatePalette(int crc, ByteBuffer buffer, int count) {
        int p = 0;
        int orig = crc;
        while (count-- != 0) {
            crc = crc >>> 8 ^ this.crcTable[crc & 0xFF ^ buffer.get(p++) & 0xFF];
            crc = crc >>> 8 ^ this.crcTable[crc & 0xFF ^ buffer.get(p++) & 0xFF];
            p += 6;
        }
        return crc ^ orig;
    }

    private void crcBuildTable() {
        int i = 0;
        while (i <= 255) {
            int crc = this.reflect(i, 8) << 24;
            int j = 0;
            while (j < 8) {
                crc = crc << 1 ^ ((crc & Integer.MIN_VALUE) != 0 ? 79764919 : 0);
                ++j;
            }
            this.crcTable[i] = this.reflect(crc, 32);
            ++i;
        }
    }

    private int reflect(int ref, int ch) {
        int value = 0;
        int i = 1;
        while (i < ch + 1) {
            if ((ref & 1) != 0) {
                value |= 1 << ch - i;
            }
            ref >>= 1;
            ++i;
        }
        return value;
    }

    private static class BgImage {
        public int address;
        public int width;
        public int height;
        public int format;
        public int size;
        public int palette;

        private BgImage() {
        }
    }

    private static interface InterleaveFunc {
        public void Interleave(byte[] var1, int var2, int var3);
    }

    private static class TexRect {
        public int width;
        public int height;

        private TexRect() {
        }
    }

    private static class Texture {
        public float scales;
        public float scalet;
        public int level;
        public int on;
        public int tile;

        private Texture() {
        }
    }

    private static class TextureImage {
        public int format;
        public int size;
        public int width;
        public int bpl;
        public int address;

        private TextureImage() {
        }
    }

    public static class gDPTile {
        int format;
        int size;
        int line;
        int tmem;
        int palette;
        public int maskt;
        public int masks;
        public int shiftt;
        public int shifts;
        public float fuls;
        public float fult;
        public float flrs;
        public float flrt;
        public int uls;
        public int ult;
        public int lrs;
        public int lrt;
        public int mirrort;
        public int clampt;
        public int pad0;
        public int mirrors;
        public int clamps;
        public int pad1;

        public void setCmt(int value) {
            this.pad0 = value >> 2 & 0x3FFFFFFF;
            this.clampt = value >> 1 & 1;
            this.mirrort = value & 1;
        }

        public int getCmt() {
            return (this.pad0 & 0x3FFFFFFF) << 2 | (this.clampt & 1) << 1 | this.mirrort & 1;
        }

        public void setCms(int value) {
            this.pad1 = value >> 2 & 0x3FFFFFFF;
            this.clamps = value >> 1 & 1;
            this.mirrors = value & 1;
        }

        public int getCms() {
            return (this.pad1 & 0x3FFFFFFF) << 2 | (this.clamps & 1) << 1 | this.mirrors & 1;
        }

        public final int powof(int dim) {
            int num = 1;
            int i = 0;
            while (num < dim) {
                num <<= 1;
                ++i;
            }
            return i;
        }
    }
}

