/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.cartridge;

import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Sram
implements Hardware,
BusDMA,
Configurable {
    private static final String AUTO_SAVE_DIR = "./save/default.sra";
    private RandomAccessFile hSramFile;
    private File file = new File("./save/default.sra");

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        this.close();
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("file")) {
            this.file = new File(value.toString());
        }
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.hSramFile == null && !this.loadSram()) {
            return;
        }
        try {
            this.hSramFile.seek(pAddr);
            this.hSramFile.read(dma.array(), offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        if (this.hSramFile == null && !this.loadSram()) {
            return;
        }
        try {
            this.hSramFile.seek(pAddr);
            this.hSramFile.write(dma.array(), offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        if (this.hSramFile != null) {
            try {
                this.hSramFile.close();
                this.hSramFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean loadSram() {
        try {
            this.hSramFile = new RandomAccessFile(this.file, "rwd");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

