/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;

public class ParallelInterface
implements Hardware,
Clockable,
Bus32bit {
    private static final int MI_INTR_REG = 70254600;
    private static final int MI_INTR_CLR_PI = 256;
    private static final int MI_INTR_SET_PI = 512;
    private static final int PI_DRAM_ADDR_REG = 0;
    private static final int PI_CART_ADDR_REG = 1;
    private static final int PI_RD_LEN_REG = 2;
    private static final int PI_WR_LEN_REG = 3;
    private static final int PI_STATUS_REG = 4;
    private static final int PI_DOMAIN1_REG = 5;
    private static final int PI_BSD_DOM1_PWD_REG = 6;
    private static final int PI_BSD_DOM1_PGS_REG = 7;
    private static final int PI_BSD_DOM1_RLS_REG = 8;
    private static final int PI_DOMAIN2_REG = 9;
    private static final int PI_BSD_DOM2_PWD_REG = 10;
    private static final int PI_BSD_DOM2_PGS_REG = 11;
    private static final int PI_BSD_DOM2_RLS_REG = 12;
    private static final int RDRAM_CAPACITY_REG = 66060328;
    private static final int PI_STATUS_DMA_BUSY = 1;
    private static final int PI_CLR_INTR = 2;
    private int[] regPI = new int[13];
    private boolean dmaUsed;
    private Bus32bit rdram;
    private BusDMA rdramDMA;
    private Bus32bit mi;
    private BusDMA rom;
    private Bus32bit timer;

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram = (Bus32bit)bus;
                this.rdramDMA = (BusDMA)bus;
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.rom = (BusDMA)bus;
                break;
            }
            case 3: {
                this.timer = (Bus32bit)bus;
                break;
            }
            default: {
                System.err.println("Attempting to connect bus on invalid port: " + port);
            }
        }
    }

    public void reset() {
        this.dmaUsed = false;
    }

    public void clock(long ticks) {
        this.regPI[4] = this.regPI[4] & 0xFFFFFFFE;
        this.mi.write32bit(70254600, 512);
        this.timer.write32bit(2, -((int)ticks));
    }

    public int read32bit(int reg) {
        switch (reg - 0x4600000 >> 2) {
            case 4: {
                return this.regPI[4];
            }
            case 5: {
                return this.regPI[5];
            }
            case 6: {
                return this.regPI[6];
            }
            case 7: {
                return this.regPI[7];
            }
            case 8: {
                return this.regPI[8];
            }
            case 9: {
                return this.regPI[9];
            }
            case 10: {
                return this.regPI[10];
            }
            case 11: {
                return this.regPI[11];
            }
            case 12: {
                return this.regPI[12];
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg - 0x4600000 >> 2) {
            case 0: {
                this.regPI[0] = value;
                break;
            }
            case 1: {
                this.regPI[1] = value;
                break;
            }
            case 2: {
                this.regPI[2] = value;
                this.piDmaRead(this.regPI[0], this.regPI[1], this.regPI[2]);
                this.regPI[4] = this.regPI[4] & 0xFFFFFFFE;
                this.mi.write32bit(70254600, 512);
                break;
            }
            case 3: {
                this.regPI[3] = value;
                this.regPI[4] = this.regPI[4] | 1;
                this.piDmaWrite(this.regPI[0], this.regPI[1], this.regPI[3]);
                this.regPI[4] = this.regPI[4] & 0xFFFFFFFE;
                this.mi.write32bit(70254600, 512);
                break;
            }
            case 4: {
                if ((value & 2) == 0) break;
                this.mi.write32bit(70254600, 256);
                break;
            }
            case 5: {
                this.regPI[5] = value & 0xFF;
                break;
            }
            case 6: {
                this.regPI[6] = value & 0xFF;
                break;
            }
            case 7: {
                this.regPI[7] = value & 0xFF;
                break;
            }
            case 8: {
                this.regPI[8] = value & 0xFF;
                break;
            }
            case 9: {
                this.regPI[9] = value & 0xFF;
                break;
            }
            case 10: {
                this.regPI[10] = value & 0xFF;
                break;
            }
            case 11: {
                this.regPI[11] = value & 0xFF;
                break;
            }
            case 12: {
                this.regPI[12] = value & 0xFF;
            }
        }
    }

    private void piDmaRead(int dramAddr, int cartAddr, int rdLen) {
        if (dramAddr + rdLen + 1 > this.rdram.read32bit(66060328)) {
            System.err.printf("PI_DMA_READ not in Memory\n", new Object[0]);
            return;
        }
        ByteBuffer tmp = ByteBuffer.allocate(rdLen + 1);
        this.rdramDMA.readDMA(dramAddr, tmp, 0, rdLen + 1);
        this.rom.writeDMA(cartAddr - 0x5000000, tmp, 0, rdLen + 1);
    }

    private void piDmaWrite(int dramAddr, int cartAddr, int wrLen) {
        if (dramAddr + wrLen + 1 > this.rdram.read32bit(66060328)) {
            System.err.printf("PI_DMA_WRITE not in Memory\n", new Object[0]);
            return;
        }
        ByteBuffer tmp = ByteBuffer.allocate(wrLen + 1);
        this.rom.readDMA(cartAddr - 0x5000000, tmp, 0, wrLen + 1);
        if (cartAddr >= 0x10000000 && cartAddr <= 0x1FBFFFFF && !this.dmaUsed) {
            this.dmaUsed = true;
            switch ((Integer)((Configurable)this.rom).readConfig("cic")) {
                case 1: {
                    this.rdram.write32bit(792, this.rdram.read32bit(66060328));
                    break;
                }
                case 2: {
                    this.rdram.write32bit(792, this.rdram.read32bit(66060328));
                    break;
                }
                case 3: {
                    this.rdram.write32bit(792, this.rdram.read32bit(66060328));
                    break;
                }
                case 5: {
                    this.rdram.write32bit(1008, this.rdram.read32bit(66060328));
                    break;
                }
                case 6: {
                    this.rdram.write32bit(792, this.rdram.read32bit(66060328));
                    break;
                }
                default: {
                    System.err.printf("Unhandled CicChip(%d) in first DMA\n", (Integer)((Configurable)this.rom).readConfig("cic"));
                }
            }
        }
        this.rdramDMA.writeDMA(dramAddr, tmp, 0, wrLen + 1);
    }
}

