/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.accessories;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KeyboardController
implements Hardware,
BusDMA {
    private static final int PAK_TYPE_NONE = 1;
    private static final int PAK_TYPE_MEMPAK = 2;
    private static final int PAK_TYPE_RAW = 5;
    private static final int PAK_TYPE_REG = 0;
    private static final int PAK_CONTROL_REG = 1;
    private static final int NUMBER_OF_BUTTONS = 14;
    private static final int U_DPAD = 0;
    private static final int D_DPAD = 1;
    private static final int L_DPAD = 2;
    private static final int R_DPAD = 3;
    private static final int START_BUTTON = 4;
    private static final int A_BUTTON = 5;
    private static final int B_BUTTON = 6;
    private static final int L_TRIG = 7;
    private static final int R_TRIG = 8;
    private static final int Z_TRIG = 9;
    private static final int U_CBUTTON = 10;
    private static final int D_CBUTTON = 11;
    private static final int L_CBUTTON = 12;
    private static final int R_CBUTTON = 13;
    private static final int A_BUTTON_VALUE = Integer.MIN_VALUE;
    private static final int B_BUTTON_VALUE = 0x40000000;
    private static final int Z_TRIG_VALUE = 0x20000000;
    private static final int START_BUTTON_VALUE = 0x10000000;
    private static final int U_DPAD_VALUE = 0x8000000;
    private static final int D_DPAD_VALUE = 0x4000000;
    private static final int L_DPAD_VALUE = 0x2000000;
    private static final int R_DPAD_VALUE = 0x1000000;
    private static final int L_TRIG_VALUE = 0x200000;
    private static final int R_TRIG_VALUE = 0x100000;
    private static final int U_CBUTTON_VALUE = 524288;
    private static final int D_CBUTTON_VALUE = 262144;
    private static final int L_CBUTTON_VALUE = 131072;
    private static final int R_CBUTTON_VALUE = 65536;
    private int controllerButtons;
    private Key[] keys = new Key[14];
    private int pakType;
    private boolean config;
    private Bus32bit expansionslot;

    public KeyboardController() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new ControllerListener(), 8L);
        this.pakType = 1;
        this.keys[0] = new Key(this.setXAxis(80) | 0x8000000);
        this.keys[1] = new Key(this.setXAxis(-80) | 0x4000000);
        this.keys[2] = new Key(this.setYAxis(-80) | 0x2000000);
        this.keys[3] = new Key(this.setYAxis(80) | 0x1000000);
        this.keys[4] = new Key(0x10000000);
        this.keys[5] = new Key(Integer.MIN_VALUE);
        this.keys[6] = new Key(0x40000000);
        this.keys[7] = new Key(0x200000);
        this.keys[8] = new Key(0x100000);
        this.keys[9] = new Key(0x20000000);
        this.keys[10] = new Key(524288);
        this.keys[11] = new Key(262144);
        this.keys[12] = new Key(131072);
        this.keys[13] = new Key(65536);
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.expansionslot = (Bus32bit)bus;
                this.pakType = this.expansionslot != null ? this.expansionslot.read32bit(0) : 1;
            }
        }
    }

    public void reset() {
        this.config = false;
        if (this.expansionslot != null) {
            ((Hardware)this.expansionslot).reset();
        }
    }

    public void readDMA(int pAddr, ByteBuffer dmaObj, int offset, int length) {
        if (!this.config) {
            this.config(pAddr);
        }
        byte[] dma = dmaObj.array();
        switch (dma[offset + 2] & 0xFF) {
            case 1: {
                dma[offset + 3] = (byte)(this.controllerButtons >> 24);
                dma[offset + 4] = (byte)(this.controllerButtons >> 16);
                dma[offset + 5] = (byte)(this.controllerButtons >> 8);
                dma[offset + 6] = (byte)this.controllerButtons;
                break;
            }
            case 2: {
                switch (this.pakType) {
                    default: 
                }
                break;
            }
            case 3: {
                switch (this.pakType) {
                    default: 
                }
            }
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dmaObj, int offset, int length) {
        if (!this.config) {
            this.config(pAddr);
        }
        byte[] dma = dmaObj.array();
        block0 : switch (dma[offset + 2] & 0xFF) {
            case 0: 
            case 255: {
                if ((dma[offset + 1] & 0x80) != 0) break;
                dma[offset + 3] = 5;
                dma[offset + 4] = 0;
                switch (this.pakType) {
                    case 2: {
                        dma[offset + 5] = 1;
                        break block0;
                    }
                    case 5: {
                        dma[offset + 5] = 1;
                        break block0;
                    }
                }
                dma[offset + 5] = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int address = (dma[offset + 3] & 0xFF) << 8 | dma[offset + 4] & 0xFF;
                switch (this.pakType) {
                    case 2: {
                        this.expansionslot.write32bit(1, pAddr);
                        ((BusDMA)this.expansionslot).readDMA(address, dmaObj, offset + 5, 32);
                        dma[offset + 5 + 32] = this.mempacksCalulateCrc(dma, offset + 5);
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                Arrays.fill(dma, offset + 5, offset + 5 + 32, (byte)0);
                dma[offset + 37] = 0;
                break;
            }
            case 3: {
                int address = (dma[offset + 3] & 0xFF) << 8 | dma[offset + 4] & 0xFF;
                switch (this.pakType) {
                    case 2: {
                        this.expansionslot.write32bit(1, pAddr);
                        ((BusDMA)this.expansionslot).writeDMA(address, dmaObj, offset + 5, 32);
                        dma[offset + 5 + 32] = this.mempacksCalulateCrc(dma, offset + 5);
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                dma[offset + 5 + 37] = this.mempacksCalulateCrc(dma, offset + 5);
                break;
            }
            default: {
                System.err.printf("Unknown ControllerCommand %d\n", dma[offset + 2]);
            }
        }
    }

    private int setYAxis(int b) {
        return b << 8 & 0xFF00;
    }

    private int setXAxis(int b) {
        return b & 0xFF;
    }

    private byte mempacksCalulateCrc(byte[] data, int offset) {
        byte crc = 0;
        int dataToCrc = 0;
        int count = 0;
        while (count < 33) {
            int length = 128;
            while (length >= 1) {
                int xorTap = (crc & 0x80) != 0 ? 133 : 0;
                crc = (byte)(crc << 1);
                if (count == 32) {
                    crc = (byte)(crc & 0xFF);
                } else if ((data[offset + dataToCrc] & length) != 0) {
                    crc = (byte)(crc | 1);
                }
                crc = (byte)(crc ^ xorTap);
                length >>= 1;
            }
            ++dataToCrc;
            ++count;
        }
        return crc;
    }

    private void config(int value) {
        switch (value) {
            case 0: {
                this.keys[0].vkey = 38;
                this.keys[1].vkey = 40;
                this.keys[2].vkey = 37;
                this.keys[3].vkey = 39;
                this.keys[4].vkey = 10;
                this.keys[5].vkey = 88;
                this.keys[6].vkey = 67;
                this.keys[7].vkey = 65;
                this.keys[8].vkey = 83;
                this.keys[9].vkey = 90;
                this.keys[10].vkey = 36;
                this.keys[11].vkey = 35;
                this.keys[12].vkey = 127;
                this.keys[13].vkey = 34;
                break;
            }
            default: {
                this.keys[0].vkey = -1;
                this.keys[1].vkey = -1;
                this.keys[2].vkey = -1;
                this.keys[3].vkey = -1;
                this.keys[4].vkey = -1;
                this.keys[5].vkey = -1;
                this.keys[6].vkey = -1;
                this.keys[7].vkey = -1;
                this.keys[8].vkey = -1;
                this.keys[9].vkey = -1;
                this.keys[10].vkey = -1;
                this.keys[11].vkey = -1;
                this.keys[12].vkey = -1;
                this.keys[13].vkey = -1;
            }
        }
        this.config = true;
    }

    private class ControllerListener
    implements AWTEventListener {
        private ControllerListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            block6: {
                KeyEvent kevt;
                block5: {
                    if (!KeyboardController.this.config) {
                        return;
                    }
                    kevt = (KeyEvent)event;
                    if (kevt.getID() != 401) break block5;
                    int count = 0;
                    while (count < 14) {
                        if (((KeyboardController)KeyboardController.this).keys[count].vkey == kevt.getKeyCode()) {
                            KeyboardController keyboardController = KeyboardController.this;
                            keyboardController.controllerButtons = keyboardController.controllerButtons | ((KeyboardController)KeyboardController.this).keys[count].value;
                            return;
                        }
                        ++count;
                    }
                    break block6;
                }
                if (kevt.getID() != 402) break block6;
                int count = 0;
                while (count < 14) {
                    if (((KeyboardController)KeyboardController.this).keys[count].vkey == kevt.getKeyCode()) {
                        KeyboardController keyboardController = KeyboardController.this;
                        keyboardController.controllerButtons = keyboardController.controllerButtons & ~((KeyboardController)KeyboardController.this).keys[count].value;
                        return;
                    }
                    ++count;
                }
            }
        }
    }

    private class Key {
        public int vkey;
        public int value;

        public Key(int value) {
            this.value = value;
        }
    }
}

