/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.cpu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class Cop0
implements Hardware,
Clockable,
Bus32bit,
Configurable {
    private static final boolean DEBUG_EXCEPTIONS = false;
    private static final int INDEX_REGISTER = 0;
    private static final int RANDOM_REGISTER = 1;
    private static final int ENTRYLO0_REGISTER = 2;
    private static final int ENTRYLO1_REGISTER = 3;
    private static final int CONTEXT_REGISTER = 4;
    private static final int PAGE_MASK_REGISTER = 5;
    private static final int WIRED_REGISTER = 6;
    private static final int BAD_VADDR_REGISTER = 8;
    private static final int COUNT_REGISTER = 9;
    private static final int ENTRYHI_REGISTER = 10;
    private static final int COMPARE_REGISTER = 11;
    private static final int STATUS_REGISTER = 12;
    private static final int CAUSE_REGISTER = 13;
    private static final int EPC_REGISTER = 14;
    private static final int CONFIG_REGISTER = 16;
    private static final int TAGLO_REGISTER = 28;
    private static final int TAGHI_REGISTER = 29;
    private static final int ERROREPC_REGISTER = 30;
    private static final int FAKE_CAUSE_REGISTER = 32;
    private static final int CAUSE_IP2 = 1024;
    private static final int CAUSE_IP7 = 32768;
    private static final int CAUSE_BD = Integer.MIN_VALUE;
    private static final int STATUS_IE = 1;
    private static final int STATUS_EXL = 2;
    private static final int STATUS_ERL = 4;
    private static final int EXC_INT = 0;
    private static final int EXC_RMISS = 8;
    protected static final int CPU_PC_REG = 32;
    protected static final int CPU_LLBIT_REG = 35;
    protected static final int CPU_JMP_DELAY_REG = 37;
    protected static final int CPU_INTERRUPT_REG = 38;
    protected static final int JUMP = 6;
    protected static final int RS = 21;
    protected static final int RT = 16;
    protected static final int RD = 11;
    protected static final int SA = 6;
    protected OpCode[] r4300i_CoP0;
    protected OpCode[] r4300i_CoP0_Function;
    protected int[] CP0 = new int[33];
    protected int instruction;
    private int timerCompare;
    private int countPerOp;
    private int wired = 32;
    private int addr;
    private CPU_ACTION cpuAction;
    private boolean useTlb = true;
    protected Bus32bit cpu;
    protected Bus32bit mmu;
    protected OpCode R4300i_opcode_COP0_CO = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Cop0.this.r4300i_CoP0_Function[inst & 0x3F].exec(inst, unused);
        }
    };
    protected OpCode r4300i_COP0_MF = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((inst >> 11 & 0x1F) == 1 || (inst >> 11 & 0x1F) == 9) {
                Cop0.this.update();
            }
            Cop0.this.cpu.write32bit(inst >> 16 & 0x1F, Cop0.this.CP0[inst >> 11 & 0x1F]);
        }
    };
    protected OpCode r4300i_COP0_MT = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            switch (inst >> 11 & 0x1F) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 10: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 28: 
                case 29: {
                    Cop0.this.CP0[inst >> 11 & 0x1F] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F);
                    break;
                }
                case 4: {
                    Cop0.this.CP0[4] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F) & 0xFF800000;
                    break;
                }
                case 6: {
                    Cop0.this.CP0[6] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F);
                    Cop0.this.wired = 32 - Cop0.this.CP0[6];
                    Cop0.this.CP0[1] = 31;
                    break;
                }
                case 9: {
                    Cop0.this.CP0[9] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F);
                    Cop0.this.update();
                    Cop0.this.changeCompareTimer();
                    break;
                }
                case 11: {
                    Cop0.this.CP0[11] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F);
                    Cop0.this.CP0[32] = Cop0.this.CP0[32] & 0xFFFF7FFF;
                    Cop0.this.update();
                    Cop0.this.changeCompareTimer();
                    break;
                }
                case 12: {
                    Cop0.this.CP0[12] = Cop0.this.cpu.read32bit(inst >> 16 & 0x1F);
                    if ((Cop0.this.CP0[12] & 0x18) != 0) {
                        System.err.printf("Left kernel mode ??\n", new Object[0]);
                    }
                    Cop0.this.CP0[32] = Cop0.this.cpu.read32bit(38) != 0 ? Cop0.this.CP0[32] | 0x400 : Cop0.this.CP0[32] & 0xFFFFFBFF;
                    if ((Cop0.this.CP0[12] & 1) == 0 || (Cop0.this.CP0[12] & 2) != 0 || (Cop0.this.CP0[12] & 4) != 0 || (Cop0.this.CP0[12] & Cop0.this.CP0[32] & 0xFF00) == 0 || ((Cop0)Cop0.this).cpuAction.DoInterrupt) break;
                    ((Cop0)Cop0.this).cpuAction.DoSomething = true;
                    ((Cop0)Cop0.this).cpuAction.DoInterrupt = true;
                    break;
                }
                case 13: {
                    Cop0.this.CP0[13] = Cop0.this.CP0[13] & 0xFFFFCFF;
                    if ((Cop0.this.cpu.read32bit(inst >> 16 & 0x1F) & 0x300) == 0) break;
                    System.err.printf("Set IP0 or IP1\n", new Object[0]);
                    break;
                }
                default: {
                    System.err.printf("COP0_MT: Unknown RD: %d\n", inst >> 11 & 0x1F);
                }
            }
        }
    };
    protected OpCode r4300i_COP0_CO_ERET = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if ((Cop0.this.CP0[12] & 4) != 0) {
                Cop0.this.cpu.write32bit(32, Cop0.this.CP0[30] - 4);
                Cop0.this.CP0[12] = Cop0.this.CP0[12] & 0xFFFFFFFB;
            } else {
                Cop0.this.cpu.write32bit(32, Cop0.this.CP0[14] - 4);
                Cop0.this.CP0[12] = Cop0.this.CP0[12] & 0xFFFFFFFD;
            }
            Cop0.this.cpu.write32bit(35, 0);
            Cop0.this.CP0[32] = Cop0.this.cpu.read32bit(38) != 0 ? Cop0.this.CP0[32] | 0x400 : Cop0.this.CP0[32] & 0xFFFFFBFF;
            if ((Cop0.this.CP0[12] & 1) != 0 && (Cop0.this.CP0[12] & 2) == 0 && (Cop0.this.CP0[12] & 4) == 0 && (Cop0.this.CP0[12] & Cop0.this.CP0[32] & 0xFF00) != 0 && !((Cop0)Cop0.this).cpuAction.DoInterrupt) {
                ((Cop0)Cop0.this).cpuAction.DoSomething = true;
                ((Cop0)Cop0.this).cpuAction.DoInterrupt = true;
            }
        }
    };
    protected OpCode R4300i_opcode_COP0_CO_TLB = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            if (!Cop0.this.useTlb) {
                return;
            }
            Cop0.this.mmu.write32bit(0, inst);
        }
    };
    protected OpCode R4300i_UnknownOpcode = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            System.err.printf("PC:%X ,Unhandled r4300i Cop0 OpCode:%X\n", Cop0.this.cpu.read32bit(32), inst);
            System.exit(0);
        }
    };

    public Cop0() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mmu = (Bus32bit)Class.forName(prop.getProperty("CPU_MMU", "CPU_MMU"), true, loader).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((Hardware)this.mmu).connect(0, (Hardware)this);
        this.CP0[1] = 31;
        this.CP0[9] = 20480;
        this.CP0[13] = 92;
        this.CP0[4] = 0x7FFFF0;
        this.CP0[14] = -1;
        this.CP0[8] = -1;
        this.CP0[30] = -1;
        this.CP0[16] = 451683;
        this.CP0[12] = 0x34000000;
        this.cpuAction = new CPU_ACTION();
        this.buildOps();
        this.changeCompareTimer();
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.cpu = (Bus32bit)bus;
            }
        }
    }

    public void reset() {
        this.timerCompare = 0;
        this.countPerOp = 0;
        this.instruction = 0;
        this.wired = 32;
        this.addr = 0;
        this.CP0 = new int[33];
        ((Hardware)this.mmu).reset();
        this.CP0[1] = 31;
        this.CP0[9] = 20480;
        this.CP0[13] = 92;
        this.CP0[4] = 0x7FFFF0;
        this.CP0[14] = -1;
        this.CP0[8] = -1;
        this.CP0[30] = -1;
        this.CP0[16] = 451683;
        this.CP0[12] = 0x34000000;
        this.cpuAction = new CPU_ACTION();
        this.changeCompareTimer();
    }

    public void clock(long ticks) {
        this.CP0[9] = (int)((long)this.CP0[9] + ticks);
        this.timerCompare = -1;
    }

    public Object readConfig(String key) {
        if (key.equalsIgnoreCase("MMU")) {
            return this.mmu;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
    }

    public int read32bit(int reg) {
        switch (reg) {
            case 0: {
                return this.CP0[0];
            }
            case 1: {
                this.update();
                return this.CP0[1];
            }
            case 2: {
                return this.CP0[2];
            }
            case 3: {
                return this.CP0[3];
            }
            case 4: {
                return this.CP0[4];
            }
            case 5: {
                return this.CP0[5];
            }
            case 6: {
                return this.CP0[6];
            }
            case 7: {
                return this.CP0[7];
            }
            case 8: {
                return this.CP0[8];
            }
            case 9: {
                this.update();
                return this.CP0[9];
            }
            case 10: {
                return this.CP0[10];
            }
            case 11: {
                return this.CP0[11];
            }
            case 12: {
                return this.CP0[12];
            }
            case 13: {
                return this.CP0[13];
            }
            case 14: {
                return this.CP0[14];
            }
            case 15: {
                return this.CP0[15];
            }
            case 16: {
                return this.CP0[16];
            }
            case 17: {
                return this.CP0[17];
            }
            case 18: {
                return this.CP0[18];
            }
            case 19: {
                return this.CP0[19];
            }
            case 20: {
                return this.CP0[20];
            }
            case 21: {
                return this.CP0[21];
            }
            case 22: {
                return this.CP0[22];
            }
            case 23: {
                return this.CP0[23];
            }
            case 24: {
                return this.CP0[24];
            }
            case 25: {
                return this.CP0[25];
            }
            case 26: {
                return this.CP0[26];
            }
            case 27: {
                return this.CP0[27];
            }
            case 28: {
                return this.CP0[28];
            }
            case 29: {
                return this.CP0[29];
            }
            case 30: {
                return this.CP0[30];
            }
            case 31: {
                return this.CP0[31];
            }
            case 33: {
                return this.addr;
            }
            case 37: {
                this.update();
                if (this.timerCompare < 0) {
                    this.timerCompareDone();
                }
                if (this.cpuAction.DoSomething) {
                    if (this.cpuAction.CheckInterrupts) {
                        this.cpuAction.CheckInterrupts = false;
                        this.CP0[32] = this.cpu.read32bit(38) != 0 ? this.CP0[32] | 0x400 : this.CP0[32] & 0xFFFFFBFF;
                        if ((this.CP0[12] & 1) != 0 && (this.CP0[12] & 2) == 0 && (this.CP0[12] & 4) == 0 && (this.CP0[12] & this.CP0[32] & 0xFF00) != 0 && !this.cpuAction.DoInterrupt) {
                            this.cpuAction.DoSomething = true;
                            this.cpuAction.DoInterrupt = true;
                        }
                    }
                    if (this.cpuAction.DoInterrupt) {
                        this.cpuAction.DoInterrupt = false;
                        this.doException(this.CP0[32], this.addr);
                    }
                    this.cpuAction.DoSomething = false;
                    if (this.cpuAction.DoInterrupt) {
                        this.cpuAction.DoSomething = true;
                    }
                }
                return 0;
            }
            case 38: {
                return this.checkInPermLoop();
            }
            case 40: {
                return this.instruction;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg) {
            case 0: {
                this.CP0[0] = value;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.CP0[2] = value;
                break;
            }
            case 3: {
                this.CP0[3] = value;
                break;
            }
            case 4: {
                this.CP0[4] = value;
                break;
            }
            case 5: {
                this.CP0[5] = value;
                break;
            }
            case 6: {
                this.CP0[6] = value;
                this.wired = 32 - value;
                this.CP0[1] = 31;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.CP0[8] = value;
                break;
            }
            case 9: {
                this.CP0[9] = value;
                this.update();
                this.changeCompareTimer();
                break;
            }
            case 10: {
                this.CP0[10] = value;
                break;
            }
            case 11: {
                this.CP0[11] = value;
                this.CP0[32] = this.CP0[32] & 0xFFFF7FFF;
                this.update();
                this.changeCompareTimer();
                break;
            }
            case 12: {
                this.CP0[12] = value;
                break;
            }
            case 13: {
                this.CP0[13] = value;
                break;
            }
            case 14: {
                this.CP0[14] = value;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                this.CP0[16] = value;
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                this.CP0[18] = value;
                break;
            }
            case 19: {
                this.CP0[19] = value;
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                this.CP0[28] = value;
                break;
            }
            case 29: {
                this.CP0[29] = value;
                break;
            }
            case 30: {
                this.CP0[30] = value;
                break;
            }
            case 31: {
                break;
            }
            case 33: {
                this.addr = value;
                break;
            }
            case 36: {
                this.countPerOp = value;
                break;
            }
            case 37: {
                this.checkInterrupts(value);
                break;
            }
            case 40: {
                this.instruction = value;
                this.r4300i_CoP0[this.instruction >> 21 & 0x1F].exec(value, 0);
                break;
            }
            case 41: {
                this.doException(value, this.addr);
                break;
            }
            case 42: {
                this.CP0[4] = this.CP0[4] & 0xFF80000F;
                this.CP0[4] = this.CP0[4] | this.addr >>> 9 & 0x7FFFF0;
                this.CP0[10] = this.addr & 0xFFFFE000;
                this.tlbReadException(value, this.addr);
                this.cpu.write32bit(64, 1);
            }
        }
    }

    private void update() {
        int tick = this.cpu.read32bit(33);
        this.timerCompare -= tick * this.countPerOp;
        this.CP0[9] = this.CP0[9] + tick * this.countPerOp;
        this.CP0[1] = this.CP0[1] - (tick > this.wired ? tick % this.wired : tick);
        if (this.CP0[1] < this.CP0[6]) {
            this.CP0[1] = this.CP0[1] + this.wired;
        }
    }

    private void timerCompareDone() {
        this.CP0[32] = this.CP0[32] | 0x8000;
        this.CP0[32] = this.cpu.read32bit(38) != 0 ? this.CP0[32] | 0x400 : this.CP0[32] & 0xFFFFFBFF;
        if ((this.CP0[12] & 1) != 0 && (this.CP0[12] & 2) == 0 && (this.CP0[12] & 4) == 0 && (this.CP0[12] & this.CP0[32] & 0xFF00) != 0 && !this.cpuAction.DoInterrupt) {
            this.cpuAction.DoSomething = true;
            this.cpuAction.DoInterrupt = true;
        }
        this.changeCompareTimer();
    }

    private void changeCompareTimer() {
        int nextTimerCompare;
        int nextCompare = this.CP0[11] - this.CP0[9];
        if ((nextCompare & Integer.MIN_VALUE) != 0) {
            nextCompare = Integer.MAX_VALUE;
        }
        if (nextCompare == 0) {
            nextCompare = 1;
        }
        if ((nextTimerCompare = nextCompare - this.timerCompare) != Integer.MAX_VALUE) {
            nextTimerCompare += this.timerCompare;
        }
        this.timerCompare = Integer.MAX_VALUE;
        if (nextTimerCompare < this.timerCompare) {
            this.timerCompare = nextTimerCompare;
        }
        if (nextTimerCompare == Integer.MAX_VALUE && ((nextCompare = this.CP0[11] - this.CP0[9]) & Integer.MIN_VALUE) == 0 && nextCompare != Integer.MAX_VALUE) {
            this.changeCompareTimer();
        }
    }

    private int checkInPermLoop() {
        if (this.cpuAction.DoInterrupt) {
            return 0;
        }
        if ((this.CP0[12] & 1) == 0) {
            return 1;
        }
        if ((this.CP0[12] & 2) != 0) {
            return 1;
        }
        if ((this.CP0[12] & 4) != 0) {
            return 1;
        }
        if ((this.CP0[12] & 0xFF00) == 0) {
            return 1;
        }
        this.update();
        this.timerCompare -= 5;
        this.CP0[9] = this.CP0[9] + 5;
        return 2;
    }

    private void doException(int type, int badVaddr) {
        if ((this.CP0[12] & 2) != 0) {
            System.err.printf("EXL set in Exception type: %d\n", type);
            return;
        }
        if ((this.CP0[12] & 4) != 0) {
            System.err.printf("ERL set in Exception type: %d\n", type);
            return;
        }
        if (false && (this.CP0[12] & 1) == 0) {
            return;
        }
        this.CP0[13] = type;
        this.CP0[8] = badVaddr;
        if (this.cpu.read32bit(37) == 6) {
            this.CP0[13] = this.CP0[13] | Integer.MIN_VALUE;
            this.CP0[14] = this.cpu.read32bit(32) - 4;
        } else {
            this.CP0[14] = this.cpu.read32bit(32);
        }
        this.CP0[12] = this.CP0[12] | 2;
        this.cpu.write32bit(32, -2147483268);
    }

    private void tlbReadException(int type, int badVaddr) {
        this.CP0[13] = type;
        this.CP0[8] = badVaddr;
        if ((this.CP0[12] & 2) == 0) {
            if (this.cpu.read32bit(37) == 6) {
                this.CP0[13] = this.CP0[13] | Integer.MIN_VALUE;
                this.CP0[14] = this.cpu.read32bit(32) - 4;
            } else {
                this.CP0[14] = this.cpu.read32bit(32);
            }
            this.CP0[12] = this.CP0[12] | 2;
            if (((Bus1bit)this.mmu).read1bit(0)) {
                this.cpu.write32bit(32, -2147483268);
            } else {
                this.cpu.write32bit(32, 0x7FFFFFFC);
            }
        } else {
            System.err.printf("EXL Set\nAddress (%X) Defined: %s\n", badVaddr, ((Bus1bit)this.mmu).read1bit(0) ? "TRUE" : "FALSE");
            this.cpu.write32bit(32, -2147483268);
        }
    }

    private void checkInterrupts(int cause) {
        this.CP0[32] = cause != 0 ? this.CP0[32] | 0x400 : this.CP0[32] & 0xFFFFFBFF;
        if ((this.CP0[12] & 1) != 0 && (this.CP0[12] & 2) == 0 && (this.CP0[12] & 4) == 0 && (this.CP0[12] & this.CP0[32] & 0xFF00) != 0 && !this.cpuAction.DoInterrupt) {
            this.cpuAction.DoSomething = true;
            this.cpuAction.DoInterrupt = true;
        }
    }

    private void buildOps() {
        this.r4300i_CoP0 = new OpCode[32];
        int i = 0;
        while (i < 32) {
            this.r4300i_CoP0[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP0[0] = this.r4300i_COP0_MF;
        this.r4300i_CoP0[4] = this.r4300i_COP0_MT;
        i = 16;
        while (i < 32) {
            this.r4300i_CoP0[i] = this.R4300i_opcode_COP0_CO;
            ++i;
        }
        this.r4300i_CoP0_Function = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_CoP0_Function[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_CoP0_Function[1] = this.R4300i_opcode_COP0_CO_TLB;
        this.r4300i_CoP0_Function[2] = this.R4300i_opcode_COP0_CO_TLB;
        this.r4300i_CoP0_Function[6] = this.R4300i_opcode_COP0_CO_TLB;
        this.r4300i_CoP0_Function[8] = this.R4300i_opcode_COP0_CO_TLB;
        this.r4300i_CoP0_Function[24] = this.r4300i_COP0_CO_ERET;
    }

    private class CPU_ACTION {
        public boolean DoSomething;
        public boolean CheckInterrupts;
        public boolean DoInterrupt;

        private CPU_ACTION() {
        }
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }
}

