/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp.textures;

import com.jogamp.common.nio.Buffers;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import jario.n64.console.rcp.textures.ImageFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL2;

public class CachedTexture {
    public int[] glName = new int[1];
    public int address;
    public int crc;
    public float offsetS;
    public float offsetT;
    public int maskS;
    public int maskT;
    public int clampS;
    public int clampT;
    public int mirrorS;
    public int mirrorT;
    public int line;
    public int size;
    public int format;
    public int tMem;
    public int palette;
    public int width;
    public int height;
    public int clampWidth;
    public int clampHeight;
    public int realWidth;
    public int realHeight;
    public float scaleS;
    public float scaleT;
    public float shiftScaleS;
    public float shiftScaleT;
    public int textureBytes;
    public CachedTexture lower;
    public CachedTexture higher;

    public static CachedTexture getDummy() {
        CachedTexture dummy = new CachedTexture();
        dummy.address = 0;
        dummy.clampS = 1;
        dummy.clampT = 1;
        dummy.clampWidth = 2;
        dummy.clampHeight = 2;
        dummy.crc = 0;
        dummy.format = 0;
        dummy.size = 0;
        dummy.width = 2;
        dummy.height = 2;
        dummy.realWidth = 0;
        dummy.realHeight = 0;
        dummy.maskS = 0;
        dummy.maskT = 0;
        dummy.scaleS = 0.5f;
        dummy.scaleT = 0.5f;
        dummy.shiftScaleS = 1.0f;
        dummy.shiftScaleT = 1.0f;
        dummy.textureBytes = 64;
        dummy.tMem = 0;
        return dummy;
    }

    public final int pow2(int dim) {
        int i = 1;
        while (i < dim) {
            i <<= 1;
        }
        return i;
    }

    public void load(boolean IA16, int textureBitDepth, ByteBuffer tmem, GL2 gl) {
        int mirrorTBit;
        int maskTMask;
        int clampTClamp;
        int mirrorSBit;
        int maskSMask;
        int clampSClamp;
        int glType;
        int glInternalFormat;
        ImageFormat.GetTexelFunc GetTexel;
        if ((ImageFormat.imageFormat[this.size][this.format].autoFormat == 32856 || this.format == 2 && IA16 || textureBitDepth == 2) && textureBitDepth != 0) {
            this.textureBytes = this.realWidth * this.realHeight << 2;
            if (this.format == 2 && IA16) {
                GetTexel = this.size == 0 ? ImageFormat.GetCI4IA_RGBA8888 : ImageFormat.GetCI8IA_RGBA8888;
                glInternalFormat = 32856;
                glType = 5121;
            } else {
                GetTexel = ImageFormat.imageFormat[this.size][this.format].Get32;
                glInternalFormat = ImageFormat.imageFormat[this.size][this.format].glInternalFormat32;
                glType = ImageFormat.imageFormat[this.size][this.format].glType32;
            }
        } else {
            this.textureBytes = this.realWidth * this.realHeight << 1;
            if (this.format == 2 && IA16) {
                GetTexel = this.size == 0 ? ImageFormat.GetCI4IA_RGBA4444 : ImageFormat.GetCI8IA_RGBA4444;
                glInternalFormat = 32854;
                glType = 32819;
            } else {
                GetTexel = ImageFormat.imageFormat[this.size][this.format].Get16;
                glInternalFormat = ImageFormat.imageFormat[this.size][this.format].glInternalFormat16;
                glType = ImageFormat.imageFormat[this.size][this.format].glType16;
            }
        }
        ByteBuffer dest = Buffers.newDirectByteBuffer((int)this.textureBytes);
        int newline = this.line;
        if (this.size == 3) {
            newline <<= 1;
        }
        if (this.maskS != 0) {
            clampSClamp = this.clampS != 0 ? this.clampWidth - 1 : (this.mirrorS != 0 ? (this.width << 1) - 1 : this.width - 1);
            maskSMask = (1 << this.maskS) - 1;
            mirrorSBit = this.mirrorS != 0 ? 1 << this.maskS : 0;
        } else {
            clampSClamp = StrictMath.min(this.clampWidth, this.width) - 1;
            maskSMask = 65535;
            mirrorSBit = 0;
        }
        if (this.maskT != 0) {
            clampTClamp = this.clampT != 0 ? this.clampHeight - 1 : (this.mirrorT != 0 ? (this.height << 1) - 1 : this.height - 1);
            maskTMask = (1 << this.maskT) - 1;
            mirrorTBit = this.mirrorT != 0 ? 1 << this.maskT : 0;
        } else {
            clampTClamp = StrictMath.min(this.clampHeight, this.height) - 1;
            maskTMask = 65535;
            mirrorTBit = 0;
        }
        int j = 0;
        int y = 0;
        while (y < this.realHeight) {
            int ty = StrictMath.min(y, clampTClamp) & maskTMask;
            if ((y & mirrorTBit) != 0) {
                ty ^= maskTMask;
            }
            tmem.position((this.tMem + newline * ty) * 8);
            ByteBuffer src = tmem.slice();
            int i = (ty & 1) << 1;
            int x = 0;
            while (x < this.realWidth) {
                int tx = StrictMath.min(x, clampSClamp) & maskSMask;
                if ((x & mirrorSBit) != 0) {
                    tx ^= maskSMask;
                }
                if (glInternalFormat == 32856) {
                    dest.asIntBuffer().put(j++, GetTexel.GetTexel(src, tx, i, this.palette));
                } else {
                    dest.asShortBuffer().put(j++, (short)GetTexel.GetTexel(src, tx, i, this.palette));
                }
                ++x;
            }
            ++y;
        }
        gl.glTexImage2D(3553, 0, glInternalFormat, this.realWidth, this.realHeight, 0, 6408, glType, (Buffer)dest);
    }

    public void loadBackground(boolean IA16, int textureBitDepth, Hardware rdram, GL2 gl, int imgwidth, int imgheight, int imgsize, int address) {
        int glType;
        int glInternalFormat;
        ImageFormat.GetTexelFunc GetTexel;
        if ((ImageFormat.imageFormat[this.size][this.format].autoFormat == 32856 || this.format == 2 && IA16 || textureBitDepth == 2) && textureBitDepth != 0) {
            this.textureBytes = this.realWidth * this.realHeight << 2;
            if (this.format == 2 && IA16) {
                GetTexel = this.size == 0 ? ImageFormat.GetCI4IA_RGBA8888 : ImageFormat.GetCI8IA_RGBA8888;
                glInternalFormat = 32856;
                glType = 5121;
            } else {
                GetTexel = ImageFormat.imageFormat[this.size][this.format].Get32;
                glInternalFormat = ImageFormat.imageFormat[this.size][this.format].glInternalFormat32;
                glType = ImageFormat.imageFormat[this.size][this.format].glType32;
            }
        } else {
            this.textureBytes = this.realWidth * this.realHeight << 1;
            if (this.format == 2 && IA16) {
                GetTexel = this.size == 0 ? ImageFormat.GetCI4IA_RGBA4444 : ImageFormat.GetCI8IA_RGBA4444;
                glInternalFormat = 32854;
                glType = 32819;
            } else {
                GetTexel = ImageFormat.imageFormat[this.size][this.format].Get16;
                glInternalFormat = ImageFormat.imageFormat[this.size][this.format].glInternalFormat16;
                glType = ImageFormat.imageFormat[this.size][this.format].glType16;
            }
        }
        int bpl = imgwidth << imgsize >> 1;
        int numBytes = bpl * imgheight;
        ByteBuffer swapped = ByteBuffer.allocate(numBytes);
        ((BusDMA)rdram).readDMA(address, swapped, 0, numBytes);
        ByteBuffer dest = ByteBuffer.allocateDirect(this.textureBytes);
        int clampSClamp = this.width - 1;
        int clampTClamp = this.height - 1;
        int y = 0;
        while (y < this.realHeight) {
            int ty = StrictMath.min(y, clampTClamp);
            swapped.position(bpl * ty);
            ByteBuffer src = swapped.slice();
            int x = 0;
            while (x < this.realWidth) {
                int tx = StrictMath.min(x, clampSClamp);
                if (glInternalFormat == 32856) {
                    dest.putInt(GetTexel.GetTexel(src, tx, 0, this.palette));
                } else {
                    dest.putShort((short)GetTexel.GetTexel(src, tx, 0, this.palette));
                }
                ++x;
            }
            ++y;
        }
        gl.glTexImage2D(3553, 0, glInternalFormat, this.realWidth, this.realHeight, 0, 6408, glType, (Buffer)dest);
    }

    public void activate(float uls, float ult, int shifts, int shiftt, float scaleX, float scaleY) {
        this.scaleS = scaleX / (float)this.realWidth;
        this.scaleT = scaleY / (float)this.realHeight;
        this.shiftScaleS = shifts > 10 ? (float)(1 << 16 - shifts) : (shifts > 0 ? 1.0f / (float)(1 << shifts) : 1.0f);
        this.shiftScaleT = shiftt > 10 ? (float)(1 << 16 - shiftt) : (shiftt > 0 ? 1.0f / (float)(1 << shiftt) : 1.0f);
        this.offsetS = uls;
        this.offsetT = ult;
    }
}

