/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import com.jogamp.opengl.util.texture.spi.NetPbmTextureWriter;
import com.jogamp.opengl.util.texture.spi.PNGImage;
import com.jogamp.opengl.util.texture.spi.SGIImage;
import com.jogamp.opengl.util.texture.spi.TGAImage;
import com.jogamp.opengl.util.texture.spi.TextureProvider;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2GL3;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    private static final boolean DEBUG;
    private static boolean texRectEnabled;
    private static List<TextureProvider> textureProviders;
    private static List<TextureWriter> textureWriters;

    public static TextureData newTextureData(GLProfile gLProfile, File file, boolean bl, String string) throws IOException {
        if (string == null) {
            string = IOUtil.getFileSuffix((File)file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, boolean bl, String string) throws IOException {
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, boolean bl, String string) throws IOException {
        if (string == null) {
            string = IOUtil.getFileSuffix((String)uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = IOUtil.getFileSuffix((File)file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, n, n2, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, n, n2, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = IOUtil.getFileSuffix((String)uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, n, n2, bl, string);
    }

    public static Texture newTexture(TextureData textureData) throws GLException, IllegalArgumentException {
        return TextureIO.newTexture(GLContext.getCurrentGL(), textureData);
    }

    public static Texture newTexture(GL gL, TextureData textureData) throws GLException, IllegalArgumentException {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(gL, textureData);
    }

    public static Texture newTexture(File file, boolean bl) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, file, bl, IOUtil.getFileSuffix((File)file));
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(InputStream inputStream, boolean bl, String string) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, inputStream, bl, string);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(URL uRL, boolean bl, String string) throws IOException, GLException {
        if (string == null) {
            string = IOUtil.getFileSuffix((String)uRL.getPath());
        }
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, uRL, bl, string);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(int n) {
        return new Texture(n);
    }

    public static Texture newTexture(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return new Texture(n, n2, n3, n4, n5, n6, bl);
    }

    public static void write(Texture texture, File file) throws IOException, GLException {
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLContext.getCurrentGL();
        if (!gL.isGL2GL3()) {
            throw new GLException("Implementation only supports GL2GL3 (Use GLReadBufferUtil and the TextureData variant), have: " + gL);
        }
        GL2 gL2 = gL.getGL2();
        texture.bind(gL2);
        int n = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4099);
        int n2 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4096);
        int n3 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4097);
        int n4 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4101);
        TextureData textureData = null;
        if (n == 33776 || n == 33777 || n == 33778 || n == 33779) {
            int n5 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 34464);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
            gL2.glGetCompressedTexImage(3553, 0, byteBuffer);
            textureData = new TextureData(gL2.getGLProfile(), n, n2, n3, n4, n, 5121, false, true, true, byteBuffer, null);
        } else {
            int n6 = 0;
            int n7 = 0;
            switch (n) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n6 = 3;
                    n7 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n6 = 4;
                    n7 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n));
                }
            }
            int n8 = TextureIO.glGetInteger(gL2, 3333);
            int n9 = TextureIO.glGetInteger(gL2, 3330);
            int n10 = TextureIO.glGetInteger(gL2, 3331);
            int n11 = TextureIO.glGetInteger(gL2, 3332);
            int n12 = TextureIO.glGetInteger(gL2, 3328);
            gL2.glPixelStorei(3333, 1);
            gL2.glPixelStorei(3330, 0);
            gL2.glPixelStorei(3331, 0);
            gL2.glPixelStorei(3332, 0);
            gL2.glPixelStorei(3328, 0);
            ByteBuffer byteBuffer = ByteBuffer.allocate((n2 + 2 * n4) * (n3 + 2 * n4) * n6);
            if (DEBUG) {
                System.out.println("Allocated buffer of size " + byteBuffer.remaining() + " for fetched image (" + (n7 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL2.glGetTexImage(3553, 0, n7, 5121, byteBuffer);
            gL2.glPixelStorei(3333, n8);
            gL2.glPixelStorei(3330, n9);
            gL2.glPixelStorei(3331, n10);
            gL2.glPixelStorei(3332, n11);
            gL2.glPixelStorei(3328, n12);
            textureData = new TextureData(gL2.getGLProfile(), n, n2, n3, n4, n7, 5121, false, false, false, byteBuffer, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        TextureIO.write(textureData, file);
    }

    public static void write(TextureData textureData, File file) throws IOException, GLException {
        for (TextureWriter textureWriter : textureWriters) {
            if (!textureWriter.write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found for " + file.getAbsolutePath());
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        textureProviders.add(0, textureProvider);
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    public static void setTexRectEnabled(boolean bl) {
        texRectEnabled = bl;
    }

    public static boolean isTexRectEnabled() {
        return texRectEnabled;
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string) throws IOException {
        if (file == null) {
            throw new IOException("File was null");
        }
        string = TextureIO.toLowerCase(string);
        for (TextureProvider textureProvider : textureProviders) {
            TextureData textureData = textureProvider.newTextureData(gLProfile, file, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given file " + file.getAbsolutePath());
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
        if (inputStream == null) {
            throw new IOException("Stream was null");
        }
        string = TextureIO.toLowerCase(string);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        for (TextureProvider textureProvider : textureProviders) {
            TextureData textureData = textureProvider.newTextureData(gLProfile, inputStream, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string) throws IOException {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        string = TextureIO.toLowerCase(string);
        for (TextureProvider textureProvider : textureProviders) {
            TextureData textureData = textureProvider.newTextureData(gLProfile, uRL, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given URL " + uRL);
    }

    private static int glGetInteger(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    private static int glGetTexLevelParameteri(GL2GL3 gL2GL3, int n, int n2, int n3) {
        int[] nArray = new int[1];
        gL2GL3.glGetTexLevelParameteriv(n, 0, n3, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    static {
        block9: {
            Object object;
            block8: {
                DEBUG = Debug.debug("TextureIO");
                texRectEnabled = true;
                textureProviders = new ArrayList<TextureProvider>();
                textureWriters = new ArrayList<TextureWriter>();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        object = (TextureProvider)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureProvider").newInstance();
                        TextureIO.addTextureProvider((TextureProvider)object);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block8;
                        exception.printStackTrace();
                    }
                }
            }
            TextureIO.addTextureProvider(new DDSTextureProvider());
            TextureIO.addTextureProvider(new SGITextureProvider());
            TextureIO.addTextureProvider(new TGATextureProvider());
            TextureIO.addTextureProvider(new PNGTextureProvider());
            if (GLProfile.isAWTAvailable()) {
                try {
                    object = (TextureWriter)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureWriter").newInstance();
                    TextureIO.addTextureWriter((TextureWriter)object);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }
                catch (Error error) {
                    if (!DEBUG) break block9;
                    error.printStackTrace();
                }
            }
        }
        TextureIO.addTextureWriter(new DDSTextureWriter());
        TextureIO.addTextureWriter(new SGITextureWriter());
        TextureIO.addTextureWriter(new TGATextureWriter());
        TextureIO.addTextureWriter(new NetPbmTextureWriter());
        TextureIO.addTextureWriter(new PNGTextureWriter());
    }

    static class PNGTextureWriter
    implements TextureWriter {
        PNGTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.PNG.equals(IOUtil.getFileSuffix((File)file))) {
                int n;
                boolean bl;
                int n2 = textureData.getPixelFormat();
                int n3 = textureData.getPixelType();
                switch (n2) {
                    case 6409: {
                        bl = false;
                        n = 1;
                        break;
                    }
                    case 6407: {
                        bl = false;
                        n = 3;
                        break;
                    }
                    case 6408: {
                        bl = false;
                        n = 4;
                        break;
                    }
                    case 32992: {
                        bl = true;
                        n = 3;
                        break;
                    }
                    case 32993: {
                        bl = true;
                        n = 4;
                        break;
                    }
                    default: {
                        bl = false;
                        n = -1;
                    }
                }
                if (!(1 != n && 3 != n && 4 != n || n3 != 5120 && n3 != 5121)) {
                    ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
                    if (null == byteBuffer) {
                        byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
                    }
                    byteBuffer.rewind();
                    PNGImage pNGImage = PNGImage.createFromData(textureData.getWidth(), textureData.getHeight(), -1.0, -1.0, n, bl, byteBuffer);
                    pNGImage.write(file, true);
                    return true;
                }
                throw new IOException("PNG writer doesn't support this pixel format 0x" + Integer.toHexString(n2) + " / type 0x" + Integer.toHexString(n2) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class TGATextureWriter
    implements TextureWriter {
        TGATextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.TGA.equals(IOUtil.getFileSuffix((File)file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 && n != 32992 && n != 32993 || n2 != 5120 && n2 != 5121)) {
                    ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
                    if (null == byteBuffer) {
                        byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
                    }
                    byteBuffer.rewind();
                    if (n == 6407 || n == 6408) {
                        int n3 = n == 6407 ? 3 : 4;
                        for (int i = 0; i < byteBuffer.remaining(); i += n3) {
                            byte by = byteBuffer.get(i + 0);
                            byte by2 = byteBuffer.get(i + 2);
                            byteBuffer.put(i + 0, by2);
                            byteBuffer.put(i + 2, by);
                        }
                    }
                    TGAImage tGAImage = TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408 || n == 32993, false, byteBuffer);
                    tGAImage.write(file);
                    return true;
                }
                throw new IOException("TGA writer doesn't support this pixel format 0x" + Integer.toHexString(n) + " / type 0x" + Integer.toHexString(n) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class SGITextureWriter
    implements TextureWriter {
        SGITextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            String string = IOUtil.getFileSuffix((File)file);
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string)) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    byte[] byArray;
                    ByteBuffer byteBuffer;
                    ByteBuffer byteBuffer2 = byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byteBuffer.rewind();
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        byteBuffer.rewind();
                    }
                    SGIImage sGIImage = SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, byArray);
                    sGIImage.write(file, false);
                    return true;
                }
                throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }

    static class DDSTextureWriter
    implements TextureWriter {
        DDSTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.DDS.equals(IOUtil.getFileSuffix((File)file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (n2 != 5120 && n2 != 5121) {
                    throw new IOException("DDS writer only supports byte / unsigned byte textures");
                }
                int n3 = 0;
                switch (n) {
                    case 6407: {
                        n3 = 20;
                        break;
                    }
                    case 6408: {
                        n3 = 21;
                        break;
                    }
                    case 33776: {
                        n3 = 827611204;
                        break;
                    }
                    case 33777: {
                        throw new IOException("RGBA DXT1 not yet supported");
                    }
                    case 33778: {
                        n3 = 861165636;
                        break;
                    }
                    case 33779: {
                        n3 = 894720068;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n) + " by DDS writer");
                    }
                }
                ByteBuffer[] byteBufferArray = null;
                if (textureData.getMipmapData() != null) {
                    byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                    for (int i = 0; i < byteBufferArray.length; ++i) {
                        byteBufferArray[i] = (ByteBuffer)textureData.getMipmapData()[i];
                    }
                } else {
                    byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
                }
                DDSImage dDSImage = DDSImage.createFromData(n3, textureData.getWidth(), textureData.getHeight(), byteBufferArray);
                dDSImage.write(file);
                return true;
            }
            return false;
        }
    }

    static class PNGTextureProvider
    extends StreamBasedTextureProvider {
        PNGTextureProvider() {
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.PNG.equals(string)) {
                PNGImage pNGImage = PNGImage.read(inputStream);
                if (n2 == 0) {
                    n2 = pNGImage.getGLFormat();
                }
                if (n == 0) {
                    n = gLProfile.isGL2GL3() ? (pNGImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (pNGImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n, pNGImage.getWidth(), pNGImage.getHeight(), 0, n2, pNGImage.getGLType(), bl, false, false, pNGImage.getData(), null);
            }
            return null;
        }
    }

    static class TGATextureProvider
    extends StreamBasedTextureProvider {
        TGATextureProvider() {
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.TGA.equals(string)) {
                TGAImage tGAImage = TGAImage.read(gLProfile, inputStream);
                if (n2 == 0) {
                    n2 = tGAImage.getGLFormat();
                }
                if (n == 0) {
                    n = gLProfile.isGL2GL3() ? (tGAImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (tGAImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n, tGAImage.getWidth(), tGAImage.getHeight(), 0, n2, 5121, bl, false, false, tGAImage.getData(), null);
            }
            return null;
        }
    }

    static class SGITextureProvider
    extends StreamBasedTextureProvider {
        SGITextureProvider() {
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string) || SGIImage.isSGIImage(inputStream)) {
                SGIImage sGIImage = SGIImage.read(inputStream);
                if (n2 == 0) {
                    n2 = sGIImage.getFormat();
                }
                if (n == 0) {
                    n = sGIImage.getFormat();
                }
                return new TextureData(gLProfile, n, sGIImage.getWidth(), sGIImage.getHeight(), 0, n2, 5121, bl, false, false, ByteBuffer.wrap(sGIImage.getData()), null);
            }
            return null;
        }
    }

    static abstract class StreamBasedTextureProvider
    implements TextureProvider {
        StreamBasedTextureProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                TextureData textureData = this.newTextureData(gLProfile, bufferedInputStream, n, n2, bl, string != null ? string : IOUtil.getFileSuffix((File)file));
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(gLProfile, bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    static class DDSTextureProvider
    implements TextureProvider {
        DDSTextureProvider() {
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || TextureIO.DDS.equals(IOUtil.getFileSuffix((File)file))) {
                DDSImage dDSImage = DDSImage.read(file);
                return this.newTextureData(gLProfile, dDSImage, n, n2, bl);
            }
            return null;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || DDSImage.isDDSImage(inputStream)) {
                byte[] byArray = IOUtil.copyStream2ByteArray((InputStream)inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                DDSImage dDSImage = DDSImage.read(byteBuffer);
                return this.newTextureData(gLProfile, dDSImage, n, n2, bl);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(gLProfile, bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        private TextureData newTextureData(GLProfile gLProfile, final DDSImage dDSImage, int n, int n2, boolean bl) {
            TextureData textureData;
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(0);
            if (n2 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            if (imageInfo.isCompressed()) {
                switch (imageInfo.getCompressionFormat()) {
                    case 827611204: {
                        n = 33776;
                        break;
                    }
                    case 861165636: {
                        n = 33778;
                        break;
                    }
                    case 894720068: {
                        n = 33779;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(imageInfo.getCompressionFormat()) + "\"");
                    }
                }
            }
            if (n == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            TextureData.Flusher flusher = new TextureData.Flusher(){

                @Override
                public void flush() {
                    dDSImage.close();
                }
            };
            if (bl && dDSImage.getNumMipMaps() > 0) {
                Buffer[] bufferArray = new Buffer[dDSImage.getNumMipMaps()];
                for (int i = 0; i < dDSImage.getNumMipMaps(); ++i) {
                    bufferArray[i] = dDSImage.getMipMap(i).getData();
                }
                textureData = new TextureData(gLProfile, n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, imageInfo.isCompressed(), true, bufferArray, flusher);
            } else {
                bl = false;
                textureData = new TextureData(gLProfile, n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, bl, imageInfo.isCompressed(), true, imageInfo.getData(), flusher);
            }
            return textureData;
        }
    }
}

