/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.JoglVersion;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;
import javax.swing.SwingUtilities;
import jogamp.common.awt.AWTEDTExecutor;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;

public class GLCanvas
extends Canvas
implements AWTGLAutoDrawable,
WindowClosingProtocol,
OffscreenLayerOption {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private AWTGraphicsConfiguration awtConfig;
    private volatile GLDrawable drawable;
    private GLContextImpl context;
    private boolean sendReshape = false;
    private GLCapabilitiesImmutable capsReqUser;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private int additionalCtxCreationFlags = 0;
    private GraphicsDevice device;
    private boolean shallUseOffscreenLayer = false;
    private AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.destroy();
        }
    });
    private Runnable setRealizedOnEventDispatchThreadAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawable.setRealized(true);
        }
    };
    private boolean disposeRegenerate;
    private final Runnable postDisposeAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.context = null;
            if (null != GLCanvas.this.drawable) {
                JAWTWindow jAWTWindow = (JAWTWindow)GLCanvas.this.drawable.getNativeSurface();
                GLCanvas.this.drawable.setRealized(false);
                GLCanvas.this.drawable = null;
                if (null != jAWTWindow) {
                    jAWTWindow.destroy();
                }
            }
            if (GLCanvas.this.disposeRegenerate) {
                GLCanvas.this.createDrawableAndContext();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.dispose(true): new drawable: " + GLCanvas.this.drawable);
                }
                GLCanvas.this.validateGLDrawable();
            }
        }
    };
    private final Runnable disposeOnEventDispatchThreadAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.disposeGL(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.postDisposeAction);
        }
    };
    private final Runnable disposeAbstractGraphicsDeviceAction = new Runnable(){

        @Override
        public void run() {
            if (null != GLCanvas.this.awtConfig) {
                AbstractGraphicsConfiguration abstractGraphicsConfiguration = GLCanvas.this.awtConfig.getNativeGraphicsConfiguration();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
                String string = DEBUG ? abstractGraphicsDevice.toString() : null;
                boolean bl = abstractGraphicsDevice.close();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.dispose(false): closed GraphicsDevice: " + string + ", result: " + bl);
                }
                GLCanvas.this.awtConfig = null;
            }
        }
    };
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Reshape: " + GLCanvas.this.getWidth() + "x" + GLCanvas.this.getHeight());
                }
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    };
    private final Runnable swapBuffersAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    };
    private final Runnable displayOnEventDispatchThreadAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
        }
    };
    private final Runnable swapBuffersOnEventDispatchThreadAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.swapBuffersAction, GLCanvas.this.initAction);
        }
    };
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public GLCanvas() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null, null, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLContext gLContext) throws GLException {
        this(gLCapabilitiesImmutable, null, gLContext, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) throws GLException {
        GraphicsConfiguration graphicsConfiguration;
        gLCapabilitiesImmutable = null == gLCapabilitiesImmutable ? new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice())) : (GLCapabilitiesImmutable)gLCapabilitiesImmutable.cloneMutable();
        if (null == graphicsDevice && null != (graphicsConfiguration = super.getGraphicsConfiguration())) {
            graphicsDevice = graphicsConfiguration.getDevice();
        }
        this.capsReqUser = gLCapabilitiesImmutable;
        this.chooser = gLCapabilitiesChooser;
        this.shareWith = gLContext;
        this.device = graphicsDevice;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        if (null != this.drawable) {
            return ((JAWTWindow)this.drawable.getNativeSurface()).isOffscreenLayerSurfaceEnabled();
        }
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        GraphicsConfiguration graphicsConfiguration2 = this.awtConfig.getAWTGraphicsConfiguration();
        if (graphicsConfiguration != null && graphicsConfiguration2 != null && !graphicsConfiguration2.equals(graphicsConfiguration)) {
            if (!graphicsConfiguration2.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = this.chooseGraphicsConfiguration((GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities(), (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getAWTGraphicsConfiguration() : null;
                boolean bl = ((Object)aWTGraphicsConfiguration.getChosenCapabilities()).equals(this.awtConfig.getChosenCapabilities());
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info:");
                    System.err.println("Created Config (n): HAVE    GC " + graphicsConfiguration2);
                    System.err.println("Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("Created Config (n): Choosen GC " + graphicsConfiguration3);
                    System.err.println("Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("Created Config (n): EQUALS CAPS " + bl);
                    Thread.dumpStack();
                }
                if (graphicsConfiguration3 != null) {
                    graphicsConfiguration2 = graphicsConfiguration3;
                    this.awtConfig = aWTGraphicsConfiguration;
                    if (!bl && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                        this.dispose(true);
                    }
                }
            }
            return graphicsConfiguration2;
        }
        if (graphicsConfiguration == null) {
            return graphicsConfiguration2;
        }
        return graphicsConfiguration;
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return null != this.drawable ? this.drawable.createContext(gLContext) : null;
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public boolean isRealized() {
        return null != this.drawable ? this.drawable.isRealized() : false;
    }

    protected final boolean isRealizedImpl() {
        return null != this.drawable ? this.drawable.isRealized() : false;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    @Override
    public void display() {
        if (!this.validateGLDrawable()) {
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas display - skipped GL render, drawable not valid yet");
            }
            return;
        }
        Threading.invoke(true, this.displayOnEventDispatchThreadAction, this.getTreeLock());
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
    }

    private void dispose(boolean bl) {
        GLAnimatorControl gLAnimatorControl = this.getAnimator();
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: dispose(" + bl + ") - START, hasContext " + (null != this.context) + ", hasDrawable " + (null != this.drawable) + ", " + gLAnimatorControl);
            Thread.dumpStack();
        }
        if (null != this.context) {
            boolean bl2 = false;
            if (null != gLAnimatorControl) {
                bl2 = gLAnimatorControl.pause();
            }
            this.disposeRegenerate = bl;
            if (this.context.isCreated()) {
                Threading.invoke(true, this.disposeOnEventDispatchThreadAction, this.getTreeLock());
            }
            if (bl2) {
                gLAnimatorControl.resume();
            }
        }
        if (!bl) {
            this.disposeAbstractGraphicsDevice();
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": dispose(" + bl + ") - END, " + gLAnimatorControl);
        }
    }

    @Override
    public void destroy() {
        this.removeNotify();
    }

    @Override
    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (!this.drawableHelper.isAnimatorAnimating()) {
            this.display();
        }
    }

    @Override
    public void addNotify() {
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - start, bounds: " + this.getBounds());
            Thread.dumpStack();
        }
        this.awtConfig = this.chooseGraphicsConfiguration(this.capsReqUser, this.capsReqUser, this.chooser, this.device);
        if (null == this.awtConfig) {
            throw new GLException("Error: NULL AWTGraphicsConfiguration");
        }
        this.disableBackgroundErase();
        super.addNotify();
        this.disableBackgroundErase();
        if (!Beans.isDesignTime()) {
            this.createDrawableAndContext();
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - end: peer: " + this.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDrawableAndContext() {
        JAWTWindow jAWTWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow(this, this.awtConfig);
        jAWTWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
        jAWTWindow.lockSurface();
        try {
            this.drawable = GLDrawableFactory.getFactory(this.capsReqUser.getGLProfile()).createGLDrawable(jAWTWindow);
            this.context = (GLContextImpl)this.drawable.createContext(this.shareWith);
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
        finally {
            jAWTWindow.unlockSurface();
        }
    }

    private boolean validateGLDrawable() {
        boolean bl = false;
        if (!Beans.isDesignTime() && null != this.drawable && !(bl = this.drawable.isRealized()) && 0 < this.drawable.getWidth() * this.drawable.getHeight()) {
            AWTEDTExecutor.singleton.invoke(true, this.setRealizedOnEventDispatchThreadAction);
            bl = true;
            this.sendReshape = true;
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Realized Drawable: " + ((Object)this.drawable).toString());
                Thread.dumpStack();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - start");
            Thread.dumpStack();
        }
        this.awtWindowClosingProtocol.removeClosingListener();
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            try {
                this.dispose(false);
            }
            finally {
                this.context = null;
                this.drawable = null;
                this.awtConfig = null;
                super.removeNotify();
            }
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - end, peer: " + this.getPeer());
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (null != this.drawable && this.drawable.isRealized() && !this.drawable.getChosenGLCapabilities().isOnscreen()) {
            this.dispose(true);
        } else {
            this.sendReshape = true;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.drawableHelper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.drawableHelper.getAnimator();
    }

    @Override
    public void invoke(boolean bl, GLRunnable gLRunnable) {
        this.drawableHelper.invoke(this, bl, gLRunnable);
    }

    @Override
    public void setContext(GLContext gLContext) {
        this.context = (GLContextImpl)gLContext;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        Threading.invoke(true, this.swapBuffersOnEventDispatchThreadAction, this.getTreeLock());
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsReqUser.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.awtConfig == null) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (this.awtConfig == null) {
            return this.capsReqUser;
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities();
    }

    @Override
    public NativeSurface getNativeSurface() {
        return null != this.drawable ? this.drawable.getNativeSurface() : null;
    }

    @Override
    public long getHandle() {
        return null != this.drawable ? this.drawable.getHandle() : 0L;
    }

    @Override
    public GLDrawableFactory getFactory() {
        return null != this.drawable ? this.drawable.getFactory() : null;
    }

    @Override
    public String toString() {
        int n = null != this.drawable ? this.drawable.getWidth() : -1;
        int n2 = null != this.drawable ? this.drawable.getHeight() : -1;
        return "AWT-GLCanvas[Realized " + this.isRealized() + ",\n\t" + (null != this.drawable ? this.drawable.getClass().getName() : "null-drawable") + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    0x" + Long.toHexString(this.getHandle()) + ",\n\tDrawable size " + n + "x" + n2 + ",\n\tAWT pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ",\n\tvisible " + this.isVisible() + ",\n\t" + this.awtConfig + "]";
    }

    void disposeAbstractGraphicsDevice() {
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            this.disposeAbstractGraphicsDeviceAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(this.disposeAbstractGraphicsDeviceAction);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = GLCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    private AWTGraphicsConfiguration chooseGraphicsConfiguration(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesImmutable gLCapabilitiesImmutable2, final GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        final AbstractGraphicsScreen abstractGraphicsScreen = null != graphicsDevice ? AWTGraphicsScreen.createScreenDevice(graphicsDevice, 0) : AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration aWTGraphicsConfiguration = null;
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen);
        } else {
            try {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen);
                        arrayList.add(aWTGraphicsConfiguration);
                    }
                });
                aWTGraphicsConfiguration = arrayList.size() > 0 ? (AWTGraphicsConfiguration)arrayList.get(0) : null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
        if (aWTGraphicsConfiguration == null) {
            throw new GLException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        final Frame frame = new Frame("JOGL AWT Test");
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        frame.add(gLCanvas);
        frame.setSize(128, 128);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        gLCanvas.display();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

