/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.newt.DisplayImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.x11.X11Display;
import jogamp.newt.driver.x11.X11Screen;

public class X11Window
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private static final int X11_WHEEL_ONE_UP_BUTTON = 4;
    private static final int X11_WHEEL_ONE_DOWN_BUTTON = 5;
    private static final int X11_WHEEL_TWO_UP_BUTTON = 6;
    private static final int X11_WHEEL_TWO_DOWN_BUTTON = 7;
    private long windowHandleClose;

    @Override
    protected void createNativeImpl() {
        X11Screen x11Screen = (X11Screen)this.getScreen();
        X11Display x11Display = (X11Display)x11Screen.getDisplay();
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11Display.getGraphicsDevice());
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11Screen.getGraphicsScreen());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + abstractGraphicsConfiguration);
        }
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 == n) {
            throw new NativeWindowException("Chosen Configuration w/o native visual ID: " + abstractGraphicsConfiguration);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n2 = this.getReconfigureFlags(0, true) & 0xA00;
        this.setWindowHandle(this.CreateWindow0(this.getParentWindowHandle(), x11Display.getEDTHandle(), x11Screen.getIndex(), n, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n2));
        this.windowHandleClose = this.getWindowHandle();
        if (0L == this.windowHandleClose) {
            throw new NativeWindowException("Error creating window");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose && null != this.getScreen()) {
            X11Display x11Display = (X11Display)this.getScreen().getDisplay();
            try {
                this.CloseWindow0(x11Display.getEDTHandle(), this.windowHandleClose, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        Object object;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + X11Window.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5)) {
            object = this.getInsets();
            n -= object.getLeftWidth();
            n2 -= object.getTopHeight();
        }
        object = (X11Display)this.getScreen().getDisplay();
        this.reconfigureWindow0(this.getDisplayEDTHandle(), this.getScreenIndex(), this.getParentWindowHandle(), this.getWindowHandle(), ((X11Display)object).getWindowDeleteAtom(), n, n2, n3, n4, n5);
        return true;
    }

    protected void reparentNotify(long l) {
        if (DEBUG_IMPLEMENTATION) {
            long l2 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + X11Window.getThreadName() + "): " + X11Window.toHexString(l2) + " -> " + X11Window.toHexString(l));
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getDisplayEDTHandle(), this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                X11Window.setTitle0(l, X11Window.this.getWindowHandle(), string);
                return null;
            }
        });
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        return this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                return X11Window.setPointerVisible0(X11Window.this.getDisplayEDTHandle(), X11Window.this.getWindowHandle(), bl);
            }
        });
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        return this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                return X11Window.confinePointer0(X11Window.this.getDisplayEDTHandle(), X11Window.this.getWindowHandle(), bl);
            }
        });
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                X11Window.warpPointer0(X11Window.this.getDisplayEDTHandle(), X11Window.this.getWindowHandle(), n, n2);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return X11Lib.GetRelativeLocation(this.getScreen().getDisplay().getHandle(), this.getScreenIndex(), this.getWindowHandle(), 0L, n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    @Override
    protected void doMouseEvent(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6) {
        block0 : switch (n) {
            case 203: {
                switch (n5) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
                break;
            }
            case 204: {
                switch (n5) {
                    case 4: {
                        n = 207;
                        n5 = 1;
                        n6 = 1;
                        break block0;
                    }
                    case 5: {
                        n = 207;
                        n5 = 1;
                        n6 = -1;
                        break block0;
                    }
                    case 6: {
                        n = 207;
                        n5 = 2;
                        n6 = 1;
                        break block0;
                    }
                    case 7: {
                        n = 207;
                        n5 = 2;
                        n6 = -1;
                    }
                }
            }
        }
        super.doMouseEvent(bl, bl2, n, n2, n3, n4, n5, n6);
    }

    private final long getDisplayEDTHandle() {
        return ((X11Display)this.getScreen().getDisplay()).getEDTHandle();
    }

    private final <T> T runWithLockedDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return ((DisplayImpl)this.getScreen().getDisplay()).runWithLockedDisplayHandle(displayRunnable);
    }

    protected static native boolean initIDs0();

    private native long CreateWindow0(long var1, long var3, int var5, int var6, long var7, long var9, int var11, int var12, int var13, int var14, boolean var15, int var16);

    private native void CloseWindow0(long var1, long var3, long var5, long var7);

    private native void reconfigureWindow0(long var1, int var3, long var4, long var6, long var8, int var10, int var11, int var12, int var13, int var14);

    private native void requestFocus0(long var1, long var3, boolean var5);

    private static native void setTitle0(long var0, long var2, String var4);

    private static native long getParentWindow0(long var0, long var2);

    private static native boolean setPointerVisible0(long var0, long var2, boolean var4);

    private static native boolean confinePointer0(long var0, long var2, boolean var4);

    private static native void warpPointer0(long var0, long var2, int var4, int var5);

    static {
        X11Display.initSingleton();
    }
}

