/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.accessories;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class Rumblepad2Controller
implements Hardware,
BusDMA {
    private static final int PAK_TYPE_NONE = 1;
    private static final int PAK_TYPE_MEMPAK = 2;
    private static final int PAK_TYPE_RAW = 5;
    private static final int PAK_TYPE_REG = 0;
    private static final int PAK_CONTROL_REG = 1;
    private static final int NUMBER_OF_BUTTONS = 14;
    private static final int U_DPAD = -1;
    private static final int D_DPAD = -1;
    private static final int L_DPAD = -1;
    private static final int R_DPAD = -1;
    private static final int START_BUTTON = 9;
    private static final int A_BUTTON = 1;
    private static final int B_BUTTON = 0;
    private static final int L_TRIG = 4;
    private static final int R_TRIG = 5;
    private static final int Z_TRIG = 6;
    private static final int U_CBUTTON = -1;
    private static final int D_CBUTTON = -1;
    private static final int L_CBUTTON = -1;
    private static final int R_CBUTTON = -1;
    private static final int A_BUTTON_VALUE = Integer.MIN_VALUE;
    private static final int B_BUTTON_VALUE = 0x40000000;
    private static final int Z_TRIG_VALUE = 0x20000000;
    private static final int START_BUTTON_VALUE = 0x10000000;
    private static final int U_DPAD_VALUE = 0x8000000;
    private static final int D_DPAD_VALUE = 0x4000000;
    private static final int L_DPAD_VALUE = 0x2000000;
    private static final int R_DPAD_VALUE = 0x1000000;
    private static final int L_TRIG_VALUE = 0x200000;
    private static final int R_TRIG_VALUE = 0x100000;
    private static final int U_CBUTTON_VALUE = 524288;
    private static final int D_CBUTTON_VALUE = 262144;
    private static final int L_CBUTTON_VALUE = 131072;
    private static final int R_CBUTTON_VALUE = 65536;
    Runnable poll = new Runnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Controllers.poll();
                Rumblepad2Controller.this.update();
            }
        }
    };
    Controller controller;
    int buttonCount;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private int controllerButtons;
    private Key[] keys = new Key[14];
    private int pakType = 1;
    private boolean config;
    private Bus32bit expansionslot;

    private void update() {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].vkey >= 0) {
                this.controllerButtons = this.controller.isButtonPressed(this.keys[i].vkey) ? (this.controllerButtons |= this.keys[i].value) : (this.controllerButtons &= ~this.keys[i].value);
            }
            ++i;
        }
        i = this.buttonCount;
        while (i < this.buttonCount + this.controller.getAxisCount()) {
            float value;
            if (this.controller.getAxisName(i - this.buttonCount).equals("X Axis")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.controllerButtons |= this.keys[3].value;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.controllerButtons |= this.keys[2].value;
                } else {
                    this.controllerButtons &= ~this.keys[3].value;
                    this.controllerButtons &= ~this.keys[2].value;
                }
            }
            if (this.controller.getAxisName(i - this.buttonCount).equals("Y Axis")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.controllerButtons |= this.keys[1].value;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.controllerButtons |= this.keys[0].value;
                } else {
                    this.controllerButtons &= ~this.keys[1].value;
                    this.controllerButtons &= ~this.keys[0].value;
                }
            }
            if (this.controller.getAxisName(i - this.buttonCount).equals("Z Axis")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.controllerButtons |= this.keys[13].value;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.controllerButtons |= this.keys[12].value;
                } else {
                    this.controllerButtons &= ~this.keys[13].value;
                    this.controllerButtons &= ~this.keys[12].value;
                }
            }
            if (this.controller.getAxisName(i - this.buttonCount).equals("Z Rotation")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.controllerButtons |= this.keys[11].value;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.controllerButtons |= this.keys[10].value;
                } else {
                    this.controllerButtons &= ~this.keys[11].value;
                    this.controllerButtons &= ~this.keys[10].value;
                }
            }
            ++i;
        }
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.expansionslot = (Bus32bit)bus;
                this.pakType = this.expansionslot != null ? this.expansionslot.read32bit(0) : 1;
            }
        }
    }

    public void reset() {
        this.config = false;
        if (this.expansionslot != null) {
            ((Hardware)this.expansionslot).reset();
        }
    }

    public void readDMA(int pAddr, ByteBuffer dmaObj, int offset, int length) {
        if (!this.config) {
            this.config(pAddr);
        }
        byte[] dma = dmaObj.array();
        switch (dma[offset + 2] & 0xFF) {
            case 1: {
                dma[offset + 3] = (byte)(this.controllerButtons >> 24);
                dma[offset + 4] = (byte)(this.controllerButtons >> 16);
                dma[offset + 5] = (byte)(this.controllerButtons >> 8);
                dma[offset + 6] = (byte)this.controllerButtons;
                break;
            }
            case 2: {
                switch (this.pakType) {
                    default: 
                }
                break;
            }
            case 3: {
                switch (this.pakType) {
                    default: 
                }
            }
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dmaObj, int offset, int length) {
        if (!this.config) {
            this.config(pAddr);
        }
        byte[] dma = dmaObj.array();
        block0 : switch (dma[offset + 2] & 0xFF) {
            case 0: 
            case 255: {
                if ((dma[offset + 1] & 0x80) != 0) break;
                dma[offset + 3] = 5;
                dma[offset + 4] = 0;
                switch (this.pakType) {
                    case 2: {
                        dma[offset + 5] = 1;
                        break block0;
                    }
                    case 5: {
                        dma[offset + 5] = 1;
                        break block0;
                    }
                }
                dma[offset + 5] = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int address = (dma[offset + 3] & 0xFF) << 8 | dma[offset + 4] & 0xFF;
                switch (this.pakType) {
                    case 2: {
                        this.expansionslot.write32bit(1, pAddr);
                        ((BusDMA)this.expansionslot).readDMA(address, dmaObj, offset + 5, 32);
                        dma[offset + 5 + 32] = this.mempacksCalulateCrc(dma, offset + 5);
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                Arrays.fill(dma, offset + 5, offset + 5 + 32, (byte)0);
                dma[offset + 37] = 0;
                break;
            }
            case 3: {
                int address = (dma[offset + 3] & 0xFF) << 8 | dma[offset + 4] & 0xFF;
                switch (this.pakType) {
                    case 2: {
                        this.expansionslot.write32bit(1, pAddr);
                        ((BusDMA)this.expansionslot).writeDMA(address, dmaObj, offset + 5, 32);
                        dma[offset + 5 + 32] = this.mempacksCalulateCrc(dma, offset + 5);
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                dma[offset + 5 + 37] = this.mempacksCalulateCrc(dma, offset + 5);
                break;
            }
            default: {
                System.err.printf("Unknown ControllerCommand %d\n", dma[offset + 2]);
            }
        }
    }

    private int setYAxis(int b) {
        return b << 8 & 0xFF00;
    }

    private int setXAxis(int b) {
        return b & 0xFF;
    }

    private byte mempacksCalulateCrc(byte[] data, int offset) {
        byte crc = 0;
        int dataToCrc = 0;
        int count = 0;
        while (count < 33) {
            int length = 128;
            while (length >= 1) {
                int xorTap = (crc & 0x80) != 0 ? 133 : 0;
                crc = (byte)(crc << 1);
                if (count == 32) {
                    crc = (byte)(crc & 0xFF);
                } else if ((data[offset + dataToCrc] & length) != 0) {
                    crc = (byte)(crc | 1);
                }
                crc = (byte)(crc ^ xorTap);
                length >>= 1;
            }
            ++dataToCrc;
            ++count;
        }
        return crc;
    }

    private void config(int value) {
        switch (value) {
            case 0: {
                try {
                    Controllers.create();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int count = Controllers.getControllerCount();
                int i = 0;
                while (i < count) {
                    this.controller = Controllers.getController((int)i);
                    if (this.controller.getAxisCount() == 4 && this.controller.getButtonCount() >= 8) {
                        this.buttonCount = this.controller.getButtonCount();
                        break;
                    }
                    ++i;
                }
                this.keys[0] = new Key(this.setXAxis(80) | 0x8000000, -1);
                this.keys[1] = new Key(this.setXAxis(-80) | 0x4000000, -1);
                this.keys[2] = new Key(this.setYAxis(-80) | 0x2000000, -1);
                this.keys[3] = new Key(this.setYAxis(80) | 0x1000000, -1);
                this.keys[4] = new Key(0x10000000, 9);
                this.keys[5] = new Key(Integer.MIN_VALUE, 1);
                this.keys[6] = new Key(0x40000000, 0);
                this.keys[7] = new Key(0x200000, 4);
                this.keys[8] = new Key(0x100000, 5);
                this.keys[9] = new Key(0x20000000, 6);
                this.keys[10] = new Key(524288, -1);
                this.keys[11] = new Key(262144, -1);
                this.keys[12] = new Key(131072, -1);
                this.keys[13] = new Key(65536, -1);
                this.executor.execute(this.poll);
            }
        }
        this.config = true;
    }

    private class Key {
        public int vkey;
        public int value;

        public Key(int value, int vkey) {
            this.value = value;
            this.vkey = vkey;
        }
    }
}

