/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.cartridge;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class FlashRam
implements Hardware,
Bus32bit,
BusDMA,
Configurable {
    private static final String AUTO_SAVE_DIR = "./save/default.fla";
    private static final int FLASHRAM_MODE_NOPES = 0;
    private static final int FLASHRAM_MODE_ERASE = 1;
    private static final int FLASHRAM_MODE_WRITE = 2;
    private static final int FLASHRAM_MODE_READ = 3;
    private static final int FLASHRAM_MODE_STATUS = 4;
    private int flashRamOffset;
    private int flashFlag = 0;
    private RandomAccessFile hFlashRamFile;
    private File file = new File("./save/default.fla");
    private byte[] flashRamPointer;
    private int flashRamPointerOffset;
    private long flashStatus = 0L;

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        this.close();
    }

    public int read32bit(int reg) {
        switch (reg) {
            case 0: {
                return (int)(this.flashStatus >> 32);
            }
        }
        System.err.printf("Reading from flash ram status (%X)\n", reg);
        return (int)(this.flashStatus >> 32);
    }

    public void write32bit(int reg, int value) {
        if (reg != 16384) {
            return;
        }
        byte[] emptyBlock = new byte[128];
        switch (value & 0xFF000000) {
            case -771751936: {
                switch (this.flashFlag) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        Arrays.fill(emptyBlock, (byte)-1);
                        if (this.hFlashRamFile == null && !this.loadFlashram()) {
                            return;
                        }
                        try {
                            this.hFlashRamFile.seek(this.flashRamOffset);
                            this.hFlashRamFile.write(emptyBlock, 0, 128);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        if (this.hFlashRamFile == null && !this.loadFlashram()) {
                            return;
                        }
                        try {
                            this.hFlashRamFile.seek(this.flashRamOffset);
                            this.hFlashRamFile.write(this.flashRamPointer, this.flashRamPointerOffset, 128);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        System.err.printf("Writing %X to flash ram command register\nFlashFlag: %d\n", value, this.flashFlag);
                    }
                }
                this.flashFlag = 0;
                break;
            }
            case -520093696: {
                this.flashFlag = 4;
                this.flashStatus = 1229904915044892672L;
                break;
            }
            case -268435456: {
                this.flashFlag = 3;
                this.flashStatus = 1229904931943612416L;
                break;
            }
            case 0x4B000000: {
                this.flashRamOffset = (value & 0xFFFF) * 128;
                break;
            }
            case 0x78000000: {
                this.flashFlag = 1;
                this.flashStatus = 1229904945109663744L;
                break;
            }
            case -1275068416: {
                this.flashFlag = 2;
                break;
            }
            case -1526726656: {
                this.flashRamOffset = (value & 0xFFFF) * 128;
                this.flashStatus = 1229904927929794560L;
                break;
            }
            default: {
                System.err.printf("Writing %X to flash ram command register\n", value);
            }
        }
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("file")) {
            this.file = new File(value.toString());
        }
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        switch (this.flashFlag) {
            case 3: {
                if (this.hFlashRamFile == null && !this.loadFlashram()) {
                    return;
                }
                if (length > 65536) {
                    System.err.printf("DmaFromFlashram FlipBuffer to small (len: %d)\n", length);
                    length = 65536;
                }
                if ((length & 3) != 0) {
                    System.err.printf("Unaligned flash ram read ???\n", new Object[0]);
                    return;
                }
                pAddr <<= 1;
                try {
                    this.hFlashRamFile.seek(pAddr);
                    this.hFlashRamFile.read(dma.array(), offset, length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                if (pAddr != 0 && length != 8) {
                    System.err.printf("Reading flashstatus not being handled correctly\nStart: %X len: %X\n", pAddr, length);
                }
                ByteBuffer dest = ByteBuffer.wrap(dma.array());
                dest.putInt(offset + 0, (int)(this.flashStatus >> 32));
                dest.putInt(offset + 4, (int)this.flashStatus);
                break;
            }
            default: {
                System.err.printf("DmaFromFlashram Start: %X, Offset: %X len: %X\n", offset, pAddr, length);
            }
        }
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        switch (this.flashFlag) {
            case 2: {
                this.flashRamPointer = dma.array();
                this.flashRamPointerOffset = offset;
                break;
            }
            default: {
                System.err.printf("DmaToFlashram Start: %X, Offset: %X len: %X\n", offset, pAddr, length);
            }
        }
    }

    private void close() {
        if (this.hFlashRamFile != null) {
            try {
                this.hFlashRamFile.close();
                this.hFlashRamFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean loadFlashram() {
        try {
            this.hFlashRamFile = new RandomAccessFile(this.file, "rwd");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

