/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class Rcp
implements Hardware,
Configurable {
    private static final int CLK_TIMER0_PORT = 0;
    private static final int CLK_TIMER1_PORT = 1;
    private static final int CLK_TIMER2_PORT = 2;
    private static final int CLK_TIMER3_PORT = 3;
    private static final int SP_RDRAM_PORT = 0;
    private static final int SP_MIPS_PORT = 1;
    private static final int SP_DATA_PORT = 2;
    private static final int SP_TIMING_PORT = 3;
    private static final int MI_RDRAM_PORT = 0;
    private static final int MI_SP_PORT = 1;
    private static final int MI_DP_PORT = 2;
    private static final int MI_CPU_PORT = 3;
    private static final int MI_VI_PORT = 4;
    private static final int MI_AI_PORT = 5;
    private static final int MI_PI_PORT = 6;
    private static final int MI_RI_PORT = 7;
    private static final int MI_SI_PORT = 8;
    private static final int MI_CART_PORT = 9;
    private static final int MI_PIF_PORT = 10;
    private static final int VI_RDRAM_PORT = 0;
    private static final int VI_MIPS_PORT = 1;
    private static final int VI_DATA_PORT = 2;
    private static final int VI_TIMING_PORT = 3;
    private static final int AI_RDRAM_PORT = 0;
    private static final int AI_MIPS_PORT = 1;
    private static final int AI_DATA_PORT = 2;
    private static final int AI_TIMING_PORT = 3;
    private static final int PI_RDRAM_PORT = 0;
    private static final int PI_MIPS_PORT = 1;
    private static final int PI_DATA_PORT = 2;
    private static final int PI_TIMING_PORT = 3;
    private static final int SI_RDRAM_PORT = 0;
    private static final int SI_MIPS_PORT = 1;
    private static final int SI_DATA_PORT = 2;
    private static final int SI_TIMING_PORT = 3;
    private Hardware timing;
    private Hardware sp;
    private Hardware dp;
    private Hardware mi;
    private Hardware vi;
    private Hardware ai;
    private Hardware pi;
    private Hardware ri;
    private Hardware si;

    public Rcp() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.timing = (Hardware)Class.forName(prop.getProperty("RCP_TIMER", "RCP_TIMER"), true, loader).newInstance();
            this.sp = (Hardware)Class.forName(prop.getProperty("SIGNAL_PROCESSOR", "SIGNAL_PROCESSOR"), true, loader).newInstance();
            this.dp = (Hardware)Class.forName(prop.getProperty("DISPLAY_PROCESSOR", "DISPLAY_PROCESSOR"), true, loader).newInstance();
            this.mi = (Hardware)Class.forName(prop.getProperty("MIPS_INTERFACE", "MIPS_INTERFACE"), true, loader).newInstance();
            this.vi = (Hardware)Class.forName(prop.getProperty("VIDEO_INTERFACE", "VIDEO_INTERFACE"), true, loader).newInstance();
            this.ai = (Hardware)Class.forName(prop.getProperty("AUDIO_INTERFACE", "AUDIO_INTERFACE"), true, loader).newInstance();
            this.pi = (Hardware)Class.forName(prop.getProperty("PARALLEL_INTERFACE", "PARALLEL_INTERFACE"), true, loader).newInstance();
            this.ri = (Hardware)Class.forName(prop.getProperty("RDRAM_INTERFACE", "RDRAM_INTERFACE"), true, loader).newInstance();
            this.si = (Hardware)Class.forName(prop.getProperty("SERIAL_INTERFACE", "SERIAL_INTERFACE"), true, loader).newInstance();
        }
        catch (Exception e) {
            System.err.println("Missing resources.");
            e.printStackTrace();
            return;
        }
        this.timing.connect(0, null);
        this.timing.connect(1, this.si);
        this.timing.connect(2, this.pi);
        this.timing.connect(3, this.vi);
        this.sp.connect(0, null);
        this.sp.connect(1, this.mi);
        this.sp.connect(2, this.dp);
        this.sp.connect(3, null);
        this.dp.connect(0, null);
        this.dp.connect(1, this.mi);
        this.dp.connect(2, this.vi);
        this.dp.connect(3, null);
        this.mi.connect(1, this.sp);
        this.mi.connect(2, this.dp);
        this.mi.connect(3, null);
        this.mi.connect(4, this.vi);
        this.mi.connect(5, this.ai);
        this.mi.connect(6, this.pi);
        this.mi.connect(7, this.ri);
        this.mi.connect(8, this.si);
        this.mi.connect(9, null);
        this.mi.connect(0, null);
        this.mi.connect(10, null);
        this.vi.connect(0, null);
        this.vi.connect(1, this.mi);
        this.vi.connect(2, null);
        this.vi.connect(3, this.timing);
        this.ai.connect(0, null);
        this.ai.connect(1, this.mi);
        this.ai.connect(2, null);
        this.ai.connect(3, null);
        this.pi.connect(0, null);
        this.pi.connect(1, this.mi);
        this.pi.connect(2, null);
        this.pi.connect(3, this.timing);
        this.si.connect(0, null);
        this.si.connect(1, this.mi);
        this.si.connect(2, null);
        this.si.connect(3, this.timing);
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                break;
            }
            case 1: {
                if (bus == null) {
                    this.vi.reset();
                    this.ai.reset();
                    break;
                }
                this.pi.connect(2, bus);
                this.mi.connect(9, bus);
                this.vi.reset();
                this.ai.reset();
                break;
            }
            case 2: {
                this.mi.connect(10, bus);
                this.si.connect(2, bus);
                break;
            }
            case 3: {
                if (bus == null) break;
                this.mi.connect(3, bus);
                break;
            }
            case 4: {
                this.sp.connect(0, bus);
                this.dp.connect(0, bus);
                this.mi.connect(0, bus);
                this.vi.connect(0, bus);
                this.ai.connect(0, bus);
                this.pi.connect(0, bus);
                this.si.connect(0, bus);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.vi.connect(2, bus);
                this.ai.connect(2, bus);
            }
        }
    }

    public void reset() {
        this.timing.reset();
        this.sp.reset();
        this.dp.reset();
        this.mi.reset();
        this.vi.reset();
        this.ai.reset();
        this.pi.reset();
        this.ri.reset();
        this.si.reset();
    }

    public Object readConfig(String key) {
        if (key.equals("framelimit")) {
            return ((Configurable)this.vi).readConfig("framelimit");
        }
        if (key.equals("framebuffer")) {
            return ((Configurable)this.vi).readConfig("framebuffer");
        }
        if (key.equals("MIPS")) {
            return this.mi;
        }
        if (key.equals("TIMER")) {
            return this.timing;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("framelimit")) {
            ((Configurable)this.vi).writeConfig("framelimit", value);
        } else if (key.equals("framebuffer")) {
            ((Configurable)this.vi).writeConfig("framebuffer", value);
        }
    }
}

