/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Hardware;
import jario.n64.ucode.Gbi;
import jario.n64.ucode.Math3D;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class F3d
implements Hardware,
Clockable,
Bus32bit,
Bus64bit {
    protected static final int RDRAM_CAPACITY_REG = 10;
    protected static final int SP_DLPC_STACK_REG = 9;
    protected static final int SP_DLPC_REG = 10;
    protected static final int SP_DL_REG = 11;
    protected static final int SP_NON_REG = 12;
    protected static final int DP_OTHERMODE_LO_REG = 8;
    protected static final int DP_OTHERMODE_HI_REG = 9;
    protected static final int DP_VIEWPORT_REG = 10;
    protected static final int DP_CULL_FACE_REG = 12;
    protected static final int DP_FOG_REG = 13;
    protected static final int DP_DEPTH_REG = 14;
    protected static final int CHANGED_MATRIX = 2;
    protected static final int CHANGED_COLORBUFFER = 4;
    protected static final int CHANGED_GEOMETRYMODE = 8;
    protected static final int CHANGED_FOGPOSITION = 16;
    protected static final int CHANGED_VIEWPORT = 32;
    protected static final int PIPELINE_MODE = 0x800000;
    protected static final int CYCLE_TYPE = 0x300000;
    protected static final int TEX_PERSP = 524288;
    protected static final int TEX_DETAIL = 393216;
    protected static final int TEX_LOD = 65536;
    protected static final int TEX_LUT = 49152;
    protected static final int TEX_FILTER = 12288;
    protected static final int TEX_CONVERT = 3584;
    protected static final int COMBINE_KEY = 256;
    protected static final int COLOR_DITHER = 192;
    protected static final int ALPHA_DITHER = 48;
    protected static final int DEPTH_SOURCE = 4;
    protected static final int ALPHA_COMPARE = 3;
    protected static final int F3D_MTX_STACKSIZE = 10;
    protected static final int F3D_MTX_MODELVIEW = 0;
    protected static final int F3D_MTX_PROJECTION = 1;
    protected static final int F3D_MTX_MUL = 0;
    protected static final int F3D_MTX_LOAD = 2;
    protected static final int F3D_MTX_NOPUSH = 0;
    protected static final int F3D_MTX_PUSH = 4;
    protected static final int F3D_TEXTURE_ENABLE = 2;
    protected static final int F3D_SHADING_SMOOTH = 512;
    protected static final int F3D_CULL_FRONT = 4096;
    protected static final int F3D_CULL_BACK = 8192;
    protected static final int F3D_CULL_BOTH = 12288;
    protected static final int F3D_CLIPPING = 0;
    protected static final int F3D_MV_VIEWPORT = 128;
    protected static final int F3D_MWO_aLIGHT_1 = 0;
    protected static final int F3D_MWO_bLIGHT_1 = 4;
    protected static final int F3D_MWO_aLIGHT_2 = 32;
    protected static final int F3D_MWO_bLIGHT_2 = 36;
    protected static final int F3D_MWO_aLIGHT_3 = 64;
    protected static final int F3D_MWO_bLIGHT_3 = 68;
    protected static final int F3D_MWO_aLIGHT_4 = 96;
    protected static final int F3D_MWO_bLIGHT_4 = 100;
    protected static final int F3D_MWO_aLIGHT_5 = 128;
    protected static final int F3D_MWO_bLIGHT_5 = 132;
    protected static final int F3D_MWO_aLIGHT_6 = 160;
    protected static final int F3D_MWO_bLIGHT_6 = 164;
    protected static final int F3D_MWO_aLIGHT_7 = 192;
    protected static final int F3D_MWO_bLIGHT_7 = 196;
    protected static final int F3D_MWO_aLIGHT_8 = 224;
    protected static final int F3D_MWO_bLIGHT_8 = 228;
    protected static final int F3D_SPNOOP = 0;
    protected static final int F3D_MTX = 1;
    protected static final int F3D_RESERVED0 = 2;
    protected static final int F3D_MOVEMEM = 3;
    protected static final int F3D_VTX = 4;
    protected static final int F3D_RESERVED1 = 5;
    protected static final int F3D_DL = 6;
    protected static final int F3D_RESERVED2 = 7;
    protected static final int F3D_RESERVED3 = 8;
    protected static final int F3D_SPRITE2D_BASE = 9;
    protected static final int F3D_TRI1 = 191;
    protected static final int F3D_CULLDL = 190;
    protected static final int F3D_POPMTX = 189;
    protected static final int F3D_MOVEWORD = 188;
    protected static final int F3D_TEXTURE = 187;
    protected static final int F3D_SETOTHERMODE_H = 186;
    protected static final int F3D_SETOTHERMODE_L = 185;
    protected static final int F3D_ENDDL = 184;
    protected static final int F3D_SETGEOMETRYMODE = 183;
    protected static final int F3D_CLEARGEOMETRYMODE = 182;
    protected static final int F3D_QUAD = 181;
    protected static final int F3D_RDPHALF_1 = 180;
    protected static final int F3D_RDPHALF_2 = 179;
    protected static final int F3D_RDPHALF_CONT = 178;
    protected static final int F3D_TRI4 = 177;
    protected static OpCode gbiUnknown = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected static int half_1;
    protected static int half_2;
    protected static Bus32bit sp;
    protected static Bus32bit dp;
    protected static BusDMA dpDMA;
    protected static Bus8bit rdram;
    protected static Bus16bit rdram16bit;
    protected static Hardware dmem;
    protected static int rdramSize;
    protected static boolean init;
    protected static ByteBuffer cmdBuffer;
    protected static byte[] cmdBuf;
    protected static int[] segment;
    public static int geometryMode;
    public static int changed;
    protected static SPVertex[] vertices;
    protected static int vertexi;
    protected static Matrix matrix;
    protected static DMAOffsets DMAOffsets;
    protected static float[][] tmpmtx;
    protected static int numLights;
    protected static int uc8_normale_addr;
    protected static float[] uc8_coord_mod;
    protected static Light[] lights;
    protected static Fog fog;
    protected static int nextCmd;
    protected static ByteBuffer dpcmdbuf;
    protected static byte[] dpcmd;
    protected static OpCode[] dlist;
    protected OpCode F3D_SPNoOp = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_Mtx = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            if ((w0 & 0xFFFF) != 64) {
                return;
            }
            F3d.gSPMatrix(F3d.segmentToPhysical(w1), w0 >> 16 & 0xFF);
        }
    };
    protected OpCode F3D_Reserved0 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_MoveMem = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            w1 = F3d.segmentToPhysical(w1);
            switch (w0 >> 16 & 0xFF) {
                case 128: {
                    if (w1 + 16 > rdramSize) break;
                    F3d.dp_writeRegister(10, w1);
                    break;
                }
                case 158: {
                    F3d.gSPForceMatrix(w1);
                    F3d.this.getWord();
                    F3d.this.getWord();
                    F3d.this.getWord();
                    F3d.this.getWord();
                    F3d.this.getWord();
                    F3d.this.getWord();
                    break;
                }
                case 134: {
                    F3d.gSPLight(w1, 1);
                    break;
                }
                case 136: {
                    F3d.gSPLight(w1, 2);
                    break;
                }
                case 138: {
                    F3d.gSPLight(w1, 3);
                    break;
                }
                case 140: {
                    F3d.gSPLight(w1, 4);
                    break;
                }
                case 142: {
                    F3d.gSPLight(w1, 5);
                    break;
                }
                case 144: {
                    F3d.gSPLight(w1, 6);
                    break;
                }
                case 146: {
                    F3d.gSPLight(w1, 7);
                    break;
                }
                case 148: {
                    F3d.gSPLight(w1, 8);
                    break;
                }
                case 132: {
                    break;
                }
            }
        }
    };
    protected OpCode F3D_Vtx = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSPVertex(F3d.segmentToPhysical(w1), (w0 >>> 20 & 0xF) + 1, w0 >>> 16 & 0xF);
        }
    };
    protected OpCode F3D_Reserved1 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_DList = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            switch (w0 >> 16 & 0xFF) {
                case 0: {
                    F3d.sp_writeRegister(11, F3d.segmentToPhysical(w1));
                    break;
                }
                case 1: {
                    F3d.this.gSPBranchList(F3d.segmentToPhysical(w1));
                }
            }
        }
    };
    protected OpCode F3D_Reserved2 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_Reserved3 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_Sprite2D_Base = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.this.getWord();
            F3d.this.getWord();
        }
    };
    protected OpCode F3D_Tri1 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSP1Triangle((w1 >> 16 & 0xFF) / 10, (w1 >> 8 & 0xFF) / 10, (w1 & 0xFF) / 10, w1 >> 24 & 0xFF);
        }
    };
    protected OpCode F3D_CullDL = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSPCullDisplayList((w0 & 0xFFFFFF) / 40, w1 / 40 - 1);
        }
    };
    protected OpCode F3D_PopMtx = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSPPopMatrix(w1);
        }
    };
    protected OpCode F3D_MoveWord = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            switch (w0 & 0xFF) {
                case 0: {
                    F3d.gSPInsertMatrix(w0 >> 8 & 0xFFFF, w1);
                    break;
                }
                case 2: {
                    F3d.gSPNumLights((w1 - Integer.MIN_VALUE >>> 5) - 1);
                    break;
                }
                case 4: {
                    break;
                }
                case 6: {
                    F3d.gSPSegment((w0 >> 8 & 0xFFFF) >>> 2, w1 & 0xFFFFFF);
                    break;
                }
                case 8: {
                    F3d.gSPFogFactor((short)(w1 >> 16 & 0xFFFF), (short)(w1 & 0xFFFF));
                    break;
                }
                case 10: {
                    switch (w0 >> 8 & 0xFFFF) {
                        case 0: {
                            F3d.gSPLightColor(1, w1);
                            break;
                        }
                        case 32: {
                            F3d.gSPLightColor(2, w1);
                            break;
                        }
                        case 64: {
                            F3d.gSPLightColor(3, w1);
                            break;
                        }
                        case 96: {
                            F3d.gSPLightColor(4, w1);
                            break;
                        }
                        case 128: {
                            F3d.gSPLightColor(5, w1);
                            break;
                        }
                        case 160: {
                            F3d.gSPLightColor(6, w1);
                            break;
                        }
                        case 192: {
                            F3d.gSPLightColor(7, w1);
                            break;
                        }
                        case 224: {
                            F3d.gSPLightColor(8, w1);
                        }
                    }
                    break;
                }
                case 12: {
                    F3d.gSPModifyVertex((w0 >> 8 & 0xFFFF) / 40, (w0 & 0xFF) % 40, w1);
                    break;
                }
            }
        }
    };
    protected OpCode F3D_Texture = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.cmdBuf[0] = 18;
            F3d.cmdBuf[1] = (byte)(w0 >> 11 & 7);
            F3d.cmdBuf[2] = (byte)(w0 >> 8 & 7);
            F3d.cmdBuf[3] = (byte)w0;
            F3d.cmdBuf[4] = (byte)(w1 >> 24);
            F3d.cmdBuf[5] = (byte)(w1 >> 16);
            F3d.cmdBuf[6] = (byte)(w1 >> 8);
            F3d.cmdBuf[7] = (byte)(w1 >> 0);
            ((BusDMA)dp).writeDMA(18, cmdBuffer, 0, 8);
        }
    };
    protected OpCode F3D_SetOtherMode_H = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            switch (w0 >> 8 & 0xFF) {
                case 23: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFF7FFFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 23 & 1) << 23);
                    break;
                }
                case 20: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFCFFFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 20 & 3) << 20);
                    break;
                }
                case 19: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFF7FFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 19 & 1) << 19);
                    break;
                }
                case 17: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFF9FFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 17 & 3) << 17);
                    break;
                }
                case 16: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFEFFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 16 & 1) << 16);
                    break;
                }
                case 14: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFF3FFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 14 & 3) << 14);
                    break;
                }
                case 12: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFFCFFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 12 & 3) << 12);
                    break;
                }
                case 9: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFFF1FF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 9 & 7) << 9);
                    break;
                }
                case 8: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFFFEFF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 8 & 1) << 8);
                    break;
                }
                case 6: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFFFF3F);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 6 & 3) << 6);
                    break;
                }
                case 4: {
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & 0xFFFFFFCF);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | (w1 >>> 4 & 3) << 4);
                    break;
                }
                default: {
                    int length = w0 & 0xFF;
                    int shift = w0 >> 8 & 0xFF;
                    int mask = (1 << length) - 1 << shift;
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) & ~mask);
                    F3d.dp_writeRegister(9, F3d.dp_readRegister(9) | w1 & mask);
                }
            }
        }
    };
    protected OpCode F3D_SetOtherMode_L = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            switch (w0 >> 8 & 0xFF) {
                case 0: {
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) & 0xFFFFFFFC);
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) | (w1 >>> 0 & 3) << 0);
                    break;
                }
                case 2: {
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) & 0xFFFFFFFB);
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) | (w1 >>> 2 & 1) << 2);
                    break;
                }
                case 3: {
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) & 7);
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) | w1 & 0xCCCCFFFF | w1 & 0x3333FFFF);
                    break;
                }
                default: {
                    int shift = w0 >> 8 & 0xFF;
                    int length = w0 & 0xFF;
                    int mask = (1 << length) - 1 << shift;
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) & ~mask);
                    F3d.dp_writeRegister(8, F3d.dp_readRegister(8) | w1 & mask);
                }
            }
        }
    };
    protected OpCode F3D_EndDL = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.sp_readRegister(11);
        }
    };
    protected OpCode F3D_SetGeometryMode = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.this.gSPSetGeometryMode(w1);
        }
    };
    protected OpCode F3D_ClearGeometryMode = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.this.gSPClearGeometryMode(w1);
        }
    };
    protected OpCode F3D_Line3D = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_Quad = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSP1Quadrangle((w1 >> 24 & 0xFF) / 10, (w1 >> 16 & 0xFF) / 10, (w1 >> 8 & 0xFF) / 10, (w1 & 0xFF) / 10);
        }
    };
    protected OpCode F3D_RDPHalf_1 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            half_1 = w1;
        }
    };
    protected OpCode F3D_RDPHalf_2 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            half_2 = w1;
        }
    };
    protected OpCode F3D_RDPHalf_Cont = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
        }
    };
    protected OpCode F3D_Tri4 = new OpCode(){

        @Override
        public void exec(int w0, int w1) {
            F3d.gSP4Triangles(w0 & 0xF, w1 & 0xF, w1 >> 4 & 0xF, w0 >> 4 & 0xF, w1 >> 8 & 0xF, w1 >> 12 & 0xF, w0 >> 8 & 0xF, w1 >> 16 & 0xF, w1 >> 20 & 0xF, w0 >> 12 & 0xF, w1 >> 24 & 0xF, w1 >> 28 & 0xF);
        }
    };

    static {
        cmdBuffer = ByteBuffer.allocate(128);
        cmdBuf = cmdBuffer.array();
        segment = new int[16];
        vertices = new SPVertex[80];
        matrix = new Matrix();
        DMAOffsets = new DMAOffsets();
        tmpmtx = new float[4][4];
        uc8_normale_addr = 0;
        uc8_coord_mod = new float[16];
        lights = new Light[12];
        fog = new Fog();
        dpcmdbuf = ByteBuffer.allocate(256);
        dpcmd = dpcmdbuf.array();
        dlist = new OpCode[256];
    }

    protected static final int dp_readRegister(int address) {
        return dp.read32bit(0x4100000 + (address << 2));
    }

    protected static final void dp_writeRegister(int address, int value) {
        dp.write32bit(0x4100000 + (address << 2), value);
    }

    protected static final int sp_readRegister(int address) {
        return sp.read32bit(0x4040000 + (address << 2));
    }

    protected static final void sp_writeRegister(int address, int value) {
        sp.write32bit(0x4040000 + (address << 2), value);
    }

    public F3d() {
        if (!init) {
            int i = 0;
            while (i < vertices.length) {
                F3d.vertices[i] = new SPVertex();
                ++i;
            }
            i = 0;
            while (i < lights.length) {
                F3d.lights[i] = new Light();
                ++i;
            }
            changed = -1;
            i = 0;
            while (i < dlist.length) {
                F3d.dlist[i] = gbiUnknown;
                ++i;
            }
            init = true;
        }
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                break;
            }
            case 1: {
                rdram = (Bus8bit)bus;
                rdram16bit = (Bus16bit)bus;
                if (rdram == null) break;
                rdramSize = ((Bus32bit)rdram).read32bit(66060328);
                break;
            }
            case 2: {
                sp = (Bus32bit)bus;
                break;
            }
            case 3: {
                dp = (Bus32bit)bus;
                dpDMA = (BusDMA)bus;
            }
        }
    }

    public void reset() {
        changed = -1;
    }

    public void clock(long ticks) {
        F3d.gbiInitFlags();
        Gbi.G_TRI1 = 191;
        Gbi.G_QUAD = 181;
        Gbi.G_TRI4 = 177;
        F3d.sp_writeRegister(9, 10);
        F3d.dlist[0] = this.F3D_SPNoOp;
        F3d.dlist[1] = this.F3D_Mtx;
        F3d.dlist[2] = this.F3D_Reserved0;
        F3d.dlist[3] = this.F3D_MoveMem;
        F3d.dlist[4] = this.F3D_Vtx;
        F3d.dlist[5] = this.F3D_Reserved1;
        F3d.dlist[6] = this.F3D_DList;
        F3d.dlist[7] = this.F3D_Reserved2;
        F3d.dlist[8] = this.F3D_Reserved3;
        F3d.dlist[9] = this.F3D_Sprite2D_Base;
        F3d.dlist[191] = this.F3D_Tri1;
        F3d.dlist[190] = this.F3D_CullDL;
        F3d.dlist[189] = this.F3D_PopMtx;
        F3d.dlist[188] = this.F3D_MoveWord;
        F3d.dlist[187] = this.F3D_Texture;
        F3d.dlist[186] = this.F3D_SetOtherMode_H;
        F3d.dlist[185] = this.F3D_SetOtherMode_L;
        F3d.dlist[184] = this.F3D_EndDL;
        F3d.dlist[183] = this.F3D_SetGeometryMode;
        F3d.dlist[182] = this.F3D_ClearGeometryMode;
        F3d.dlist[181] = this.F3D_Quad;
        F3d.dlist[180] = this.F3D_RDPHalf_1;
        F3d.dlist[179] = this.F3D_RDPHalf_2;
        F3d.dlist[178] = this.F3D_RDPHalf_Cont;
        F3d.dlist[177] = this.F3D_Tri4;
    }

    public int read32bit(int reg) {
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg) {
            case 0: {
                F3d.initMatrix(StrictMath.min(32, value >> 6));
                changed |= 2;
            }
        }
    }

    public long read64bit(int pAddr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write64bit(int pAddr, long value) {
        int inst1 = (int)(value >> 32);
        int inst2 = (int)value;
        OpCode op = dlist[inst1 >>> 24];
        op.exec(inst1, inst2);
    }

    protected static void gbiInitFlags() {
        Gbi.G_MTX_PROJECTION = 1;
        Gbi.G_MTX_LOAD = 2;
        Gbi.G_MTX_PUSH = 4;
        Gbi.G_CULL_BACK = 8192;
        Gbi.G_CULL_BOTH = 12288;
    }

    protected static void initMatrix(int stackSize) {
        F3d.matrix.stackSize = stackSize;
        F3d.matrix.modelViewi = 0;
        int i = 0;
        while (i < 4) {
            Arrays.fill(F3d.matrix.modelView[0][i], 0.0f);
            ++i;
        }
        F3d.matrix.modelView[0][0][0] = 1.0f;
        F3d.matrix.modelView[0][1][1] = 1.0f;
        F3d.matrix.modelView[0][2][2] = 1.0f;
        F3d.matrix.modelView[0][3][3] = 1.0f;
    }

    protected static void loadMatrix(float[][] mtx, int address) {
        float recip = 1.5258789E-5f;
        int i = 0;
        while (i < 4) {
            mtx[i][0] = (float)rdram16bit.read16bit(address) + (float)(rdram16bit.read16bit(address + 32) & 0xFFFF) * 1.5258789E-5f;
            mtx[i][1] = (float)rdram16bit.read16bit(address + 2) + (float)(rdram16bit.read16bit(address + 34) & 0xFFFF) * 1.5258789E-5f;
            mtx[i][2] = (float)rdram16bit.read16bit(address + 4) + (float)(rdram16bit.read16bit(address + 36) & 0xFFFF) * 1.5258789E-5f;
            mtx[i][3] = (float)rdram16bit.read16bit(address + 6) + (float)(rdram16bit.read16bit(address + 38) & 0xFFFF) * 1.5258789E-5f;
            address += 8;
            ++i;
        }
    }

    protected static void gSPMatrix(int address, int param) {
        if (address + 64 > rdramSize) {
            return;
        }
        F3d.loadMatrix(tmpmtx, address);
        if ((param & Gbi.G_MTX_PROJECTION) != 0) {
            if ((param & Gbi.G_MTX_LOAD) != 0) {
                Math3D.copyMatrix(F3d.matrix.projection, tmpmtx);
            } else {
                Math3D.multMatrix(F3d.matrix.projection, tmpmtx);
            }
        } else {
            if ((param & Gbi.G_MTX_PUSH) != 0 && F3d.matrix.modelViewi < F3d.matrix.stackSize - 1) {
                Math3D.copyMatrix(F3d.matrix.modelView[F3d.matrix.modelViewi + 1], F3d.matrix.modelView[F3d.matrix.modelViewi]);
                ++F3d.matrix.modelViewi;
            }
            if ((param & Gbi.G_MTX_LOAD) != 0) {
                Math3D.copyMatrix(F3d.matrix.modelView[F3d.matrix.modelViewi], tmpmtx);
            } else {
                Math3D.multMatrix(F3d.matrix.modelView[F3d.matrix.modelViewi], tmpmtx);
            }
        }
        changed |= 2;
    }

    protected static void gSPForceMatrix(int address) {
        if (address + 64 > rdramSize) {
            return;
        }
        F3d.loadMatrix(F3d.matrix.combined, address);
        changed &= 0xFFFFFFFD;
    }

    protected static void gSPInsertMatrix(int where, int num) {
        if ((changed & 2) != 0) {
            F3d.gSPCombineMatrices();
        }
        if ((where & 3) != 0 || where > 60) {
            return;
        }
        if (where < 32) {
            int w = where >> 1;
            int r = w / 4;
            int c = w % 4;
            int w2 = w + 1;
            int r2 = w2 / 4;
            int c2 = w2 % 4;
            float integer = (int)F3d.matrix.combined[r][c];
            float fraction = F3d.matrix.combined[r][c] - integer;
            F3d.matrix.combined[r][c] = (float)((short)(num >> 16 & 0xFFFF)) + StrictMath.abs(fraction);
            integer = (int)F3d.matrix.combined[r2][c2];
            fraction = F3d.matrix.combined[r2][c2] - integer;
            F3d.matrix.combined[r2][c2] = (float)((short)(num & 0xFFFF)) + StrictMath.abs(fraction);
        } else {
            int w = where - 32 >> 1;
            int r = w / 4;
            int c = w % 4;
            int w2 = w + 1;
            int r2 = w2 / 4;
            int c2 = w2 % 4;
            float integer = (int)F3d.matrix.combined[r][c];
            float fraction = F3d.matrix.combined[r][c] - integer;
            float newValue = integer + (float)(num >> 16 & 0xFFFF) * 1.5258789E-5f;
            if (integer == 0.0f && fraction != 0.0f) {
                newValue *= fraction / StrictMath.abs(fraction);
            }
            F3d.matrix.combined[r][c] = newValue;
            integer = (int)F3d.matrix.combined[r2][c2];
            fraction = F3d.matrix.combined[r2][c2] - integer;
            newValue = integer + (float)(num & 0xFFFF) * 1.5258789E-5f;
            if (integer == 0.0f && fraction != 0.0f) {
                newValue *= fraction / StrictMath.abs(fraction);
            }
            F3d.matrix.combined[r2][c2] = newValue;
        }
    }

    protected static void gSPPopMatrix(int param) {
        if (F3d.matrix.modelViewi > 0) {
            --F3d.matrix.modelViewi;
            changed |= 2;
        }
    }

    protected static void gSPCombineMatrices() {
        Math3D.copyMatrix(F3d.matrix.combined, F3d.matrix.projection);
        Math3D.multMatrix(F3d.matrix.combined, F3d.matrix.modelView[F3d.matrix.modelViewi]);
        changed &= 0xFFFFFFFD;
    }

    protected static void gSPVertex(int address, int n, int v0) {
        if (address + 16 * n > rdramSize) {
            return;
        }
        if (n + v0 < 80) {
            int i = v0;
            while (i < n + v0) {
                SPVertex vertex = vertices[i];
                vertex.vtx[0] = rdram16bit.read16bit(address);
                vertex.vtx[1] = rdram16bit.read16bit(address + 2);
                vertex.vtx[2] = rdram16bit.read16bit(address + 4);
                vertex.flag = rdram16bit.read16bit(address + 6);
                vertex.tex[0] = (float)rdram16bit.read16bit(address + 8) * 0.03125f;
                vertex.tex[1] = (float)rdram16bit.read16bit(address + 10) * 0.03125f;
                if ((geometryMode & 0x20000) != 0) {
                    vertex.norm[0] = rdram.read8bit(address + 12);
                    vertex.norm[1] = rdram.read8bit(address + 13);
                    vertex.norm[2] = rdram.read8bit(address + 14);
                    vertex.color[3] = (float)(rdram.read8bit(address + 15) & 0xFF) * 0.003921569f;
                } else {
                    vertex.color[0] = (float)(rdram.read8bit(address + 12) & 0xFF) * 0.003921569f;
                    vertex.color[1] = (float)(rdram.read8bit(address + 13) & 0xFF) * 0.003921569f;
                    vertex.color[2] = (float)(rdram.read8bit(address + 14) & 0xFF) * 0.003921569f;
                    vertex.color[3] = (float)(rdram.read8bit(address + 15) & 0xFF) * 0.003921569f;
                }
                F3d.gSPProcessVertex(vertex);
                address += 16;
                ++i;
            }
        }
    }

    protected static void gSPModifyVertex(int vtx, int where, int val) {
        switch (where) {
            case 16: {
                F3d.vertices[vtx].color[0] = (float)(val >> 24 & 0xFF) * 0.003921569f;
                F3d.vertices[vtx].color[1] = (float)(val >> 16 & 0xFF) * 0.003921569f;
                F3d.vertices[vtx].color[2] = (float)(val >> 8 & 0xFF) * 0.003921569f;
                F3d.vertices[vtx].color[3] = (float)(val & 0xFF) * 0.003921569f;
                break;
            }
            case 20: {
                F3d.vertices[vtx].tex[0] = (float)((short)(val >> 16 & 0xFFFF)) * 0.03125f;
                F3d.vertices[vtx].tex[1] = (float)((short)(val & 0xFFFF)) * 0.03125f;
                break;
            }
            case 24: {
                break;
            }
        }
    }

    protected static void gSPProcessVertex(SPVertex vert) {
        if ((changed & 2) != 0) {
            F3d.gSPCombineMatrices();
        }
        Math3D.transformVertex(vert.vtx, F3d.matrix.combined);
        if (F3d.matrix.billboard != 0) {
            vert.vtx[0] = vert.vtx[0] + F3d.vertices[0].vtx[0];
            vert.vtx[1] = vert.vtx[1] + F3d.vertices[0].vtx[1];
            vert.vtx[2] = vert.vtx[2] + F3d.vertices[0].vtx[2];
            vert.vtx[3] = vert.vtx[3] + F3d.vertices[0].vtx[3];
        }
        if ((geometryMode & 1) == 0) {
            vert.vtx[2] = -vert.vtx[3];
        }
        if ((geometryMode & 0x20000) != 0) {
            Math3D.transformVector(vert.norm, F3d.matrix.modelView[F3d.matrix.modelViewi]);
            Math3D.normalize(vert.norm);
            float r = F3d.lights[F3d.numLights].color[0];
            float g = F3d.lights[F3d.numLights].color[1];
            float b = F3d.lights[F3d.numLights].color[2];
            int i = 0;
            while (i < numLights) {
                float intensity = Math3D.dotProduct(vert.norm, F3d.lights[i].vec);
                if (intensity < 0.0f) {
                    intensity = 0.0f;
                }
                r += F3d.lights[i].color[0] * intensity;
                g += F3d.lights[i].color[1] * intensity;
                b += F3d.lights[i].color[2] * intensity;
                ++i;
            }
            vert.color[0] = r;
            vert.color[1] = g;
            vert.color[2] = b;
            if ((geometryMode & 0x40000) != 0) {
                Math3D.transformVector(vert.norm, F3d.matrix.projection);
                Math3D.normalize(vert.norm);
                if ((geometryMode & 0x80000) != 0) {
                    vert.tex[0] = (float)StrictMath.acos(vert.norm[0]) * 325.9493f;
                    vert.tex[1] = (float)StrictMath.acos(vert.norm[1]) * 325.9493f;
                } else {
                    vert.tex[0] = (vert.norm[0] + 1.0f) * 512.0f;
                    vert.tex[1] = (vert.norm[1] + 1.0f) * 512.0f;
                }
            }
        }
        vert.clip();
    }

    protected static boolean gSPCullVertices(int v0, int vn) {
        float zClip = 0.0f;
        float yClip = 0.0f;
        float xClip = 0.0f;
        int i = v0;
        while (i <= vn) {
            if (F3d.vertices[i].clip[0] == 0.0f) {
                return false;
            }
            if (F3d.vertices[i].clip[0] < 0.0f) {
                if (xClip > 0.0f) {
                    return false;
                }
                xClip = F3d.vertices[i].clip[0];
            } else if (F3d.vertices[i].clip[0] > 0.0f) {
                if (xClip < 0.0f) {
                    return false;
                }
                xClip = F3d.vertices[i].clip[0];
            }
            if (F3d.vertices[i].clip[1] == 0.0f) {
                return false;
            }
            if (F3d.vertices[i].clip[1] < 0.0f) {
                if (yClip > 0.0f) {
                    return false;
                }
                yClip = F3d.vertices[i].clip[1];
            } else if (F3d.vertices[i].clip[1] > 0.0f) {
                if (yClip < 0.0f) {
                    return false;
                }
                yClip = F3d.vertices[i].clip[1];
            }
            if (F3d.vertices[i].clip[2] == 0.0f) {
                return false;
            }
            if (F3d.vertices[i].clip[2] < 0.0f) {
                if (zClip > 0.0f) {
                    return false;
                }
                zClip = F3d.vertices[i].clip[2];
            } else if (F3d.vertices[i].clip[2] > 0.0f) {
                if (zClip < 0.0f) {
                    return false;
                }
                zClip = F3d.vertices[i].clip[2];
            }
            ++i;
        }
        return true;
    }

    public static void gSPCullDisplayList(int v0, int vn) {
        if (F3d.gSPCullVertices(v0, vn)) {
            F3d.sp_readRegister(11);
        }
    }

    protected static void gSPTriangle(int v0, int v1, int v2, int flag) {
        if (v0 < 80 && v1 < 80 && v2 < 80) {
            if (F3d.vertices[v0].clip[0] < 0.0f && F3d.vertices[v1].clip[0] < 0.0f && F3d.vertices[v2].clip[0] < 0.0f || F3d.vertices[v0].clip[0] > 0.0f && F3d.vertices[v1].clip[0] > 0.0f && F3d.vertices[v2].clip[0] > 0.0f || F3d.vertices[v0].clip[1] < 0.0f && F3d.vertices[v1].clip[1] < 0.0f && F3d.vertices[v2].clip[1] < 0.0f || F3d.vertices[v0].clip[1] > 0.0f && F3d.vertices[v1].clip[1] > 0.0f && F3d.vertices[v2].clip[1] > 0.0f || F3d.vertices[v0].clip[2] > 0.1f && F3d.vertices[v1].clip[2] > 0.1f && F3d.vertices[v2].clip[2] > 0.1f || F3d.vertices[v0].clip[2] < -0.1f && F3d.vertices[v1].clip[2] < -0.1f && F3d.vertices[v2].clip[2] < -0.1f) {
                return;
            }
            F3d.updateStates();
            F3d.createTriangleCommand(F3d.vertices[v0].vtx, F3d.vertices[v0].color, F3d.vertices[v0].tex, F3d.vertices[v0].clip, F3d.vertices[v1].vtx, F3d.vertices[v1].color, F3d.vertices[v1].tex, F3d.vertices[v1].clip, F3d.vertices[v2].vtx, F3d.vertices[v2].color, F3d.vertices[v2].tex, F3d.vertices[v2].clip);
            ((BusDMA)dp).writeDMA(16, dpcmdbuf, 0, 176);
        }
    }

    protected static void gSPFlushTriangles() {
        nextCmd = ((Bus32bit)rdram).read32bit(F3d.sp_readRegister(10)) >> 24 & 0xFF;
        if (nextCmd != Gbi.G_TRI1 && nextCmd != Gbi.G_TRI2 && nextCmd != Gbi.G_TRI4 && nextCmd != Gbi.G_QUAD && nextCmd != Gbi.G_DMA_TRI) {
            F3d.dp_readRegister(11);
        }
    }

    protected static void gSP1Triangle(int v0, int v1, int v2, int flag) {
        F3d.gSPTriangle(v0, v1, v2, flag);
        F3d.gSPFlushTriangles();
    }

    protected static void gSP4Triangles(int v00, int v01, int v02, int v10, int v11, int v12, int v20, int v21, int v22, int v30, int v31, int v32) {
        F3d.gSPTriangle(v00, v01, v02, 0);
        F3d.gSPTriangle(v10, v11, v12, 0);
        F3d.gSPTriangle(v20, v21, v22, 0);
        F3d.gSPTriangle(v30, v31, v32, 0);
        F3d.gSPFlushTriangles();
    }

    protected static void gSP1Quadrangle(int v0, int v1, int v2, int v3) {
        F3d.gSPTriangle(v0, v1, v2, 0);
        F3d.gSPTriangle(v0, v2, v3, 0);
        F3d.gSPFlushTriangles();
    }

    protected static void createTriangleCommand(float[] vtx1, float[] c1, float[] tex1, float[] clip1, float[] vtx2, float[] c2, float[] tex2, float[] clip2, float[] vtx3, float[] c3, float[] tex3, float[] clip3) {
        F3d.dpcmd[0] = 16;
        F3d.dpcmd[1] = (byte)F3d.sp_readRegister(12);
        int vtx1_x = Float.floatToIntBits(vtx1[0]);
        F3d.dpcmd[8] = (byte)(vtx1_x >> 24);
        F3d.dpcmd[9] = (byte)(vtx1_x >> 16);
        F3d.dpcmd[10] = (byte)(vtx1_x >> 8);
        F3d.dpcmd[11] = (byte)vtx1_x;
        int vtx1_y = Float.floatToIntBits(vtx1[1]);
        F3d.dpcmd[12] = (byte)(vtx1_y >> 24);
        F3d.dpcmd[13] = (byte)(vtx1_y >> 16);
        F3d.dpcmd[14] = (byte)(vtx1_y >> 8);
        F3d.dpcmd[15] = (byte)vtx1_y;
        int vtx1_z = Float.floatToIntBits(vtx1[2]);
        F3d.dpcmd[16] = (byte)(vtx1_z >> 24);
        F3d.dpcmd[17] = (byte)(vtx1_z >> 16);
        F3d.dpcmd[18] = (byte)(vtx1_z >> 8);
        F3d.dpcmd[19] = (byte)vtx1_z;
        int vtx1_w = Float.floatToIntBits(vtx1[3]);
        F3d.dpcmd[20] = (byte)(vtx1_w >> 24);
        F3d.dpcmd[21] = (byte)(vtx1_w >> 16);
        F3d.dpcmd[22] = (byte)(vtx1_w >> 8);
        F3d.dpcmd[23] = (byte)vtx1_w;
        int vtx2_x = Float.floatToIntBits(vtx2[0]);
        F3d.dpcmd[24] = (byte)(vtx2_x >> 24);
        F3d.dpcmd[25] = (byte)(vtx2_x >> 16);
        F3d.dpcmd[26] = (byte)(vtx2_x >> 8);
        F3d.dpcmd[27] = (byte)vtx2_x;
        int vtx2_y = Float.floatToIntBits(vtx2[1]);
        F3d.dpcmd[28] = (byte)(vtx2_y >> 24);
        F3d.dpcmd[29] = (byte)(vtx2_y >> 16);
        F3d.dpcmd[30] = (byte)(vtx2_y >> 8);
        F3d.dpcmd[31] = (byte)vtx2_y;
        int vtx2_z = Float.floatToIntBits(vtx2[2]);
        F3d.dpcmd[32] = (byte)(vtx2_z >> 24);
        F3d.dpcmd[33] = (byte)(vtx2_z >> 16);
        F3d.dpcmd[34] = (byte)(vtx2_z >> 8);
        F3d.dpcmd[35] = (byte)vtx2_z;
        int vtx2_w = Float.floatToIntBits(vtx2[3]);
        F3d.dpcmd[36] = (byte)(vtx2_w >> 24);
        F3d.dpcmd[37] = (byte)(vtx2_w >> 16);
        F3d.dpcmd[38] = (byte)(vtx2_w >> 8);
        F3d.dpcmd[39] = (byte)vtx2_w;
        int vtx3_x = Float.floatToIntBits(vtx3[0]);
        F3d.dpcmd[40] = (byte)(vtx3_x >> 24);
        F3d.dpcmd[41] = (byte)(vtx3_x >> 16);
        F3d.dpcmd[42] = (byte)(vtx3_x >> 8);
        F3d.dpcmd[43] = (byte)vtx3_x;
        int vtx3_y = Float.floatToIntBits(vtx3[1]);
        F3d.dpcmd[44] = (byte)(vtx3_y >> 24);
        F3d.dpcmd[45] = (byte)(vtx3_y >> 16);
        F3d.dpcmd[46] = (byte)(vtx3_y >> 8);
        F3d.dpcmd[47] = (byte)vtx3_y;
        int vtx3_z = Float.floatToIntBits(vtx3[2]);
        F3d.dpcmd[48] = (byte)(vtx3_z >> 24);
        F3d.dpcmd[49] = (byte)(vtx3_z >> 16);
        F3d.dpcmd[50] = (byte)(vtx3_z >> 8);
        F3d.dpcmd[51] = (byte)vtx3_z;
        int vtx3_w = Float.floatToIntBits(vtx3[3]);
        F3d.dpcmd[52] = (byte)(vtx3_w >> 24);
        F3d.dpcmd[53] = (byte)(vtx3_w >> 16);
        F3d.dpcmd[54] = (byte)(vtx3_w >> 8);
        F3d.dpcmd[55] = (byte)vtx3_w;
        int c1_r = Float.floatToIntBits(c1[0]);
        F3d.dpcmd[56] = (byte)(c1_r >> 24);
        F3d.dpcmd[57] = (byte)(c1_r >> 16);
        F3d.dpcmd[58] = (byte)(c1_r >> 8);
        F3d.dpcmd[59] = (byte)c1_r;
        int c1_g = Float.floatToIntBits(c1[1]);
        F3d.dpcmd[60] = (byte)(c1_g >> 24);
        F3d.dpcmd[61] = (byte)(c1_g >> 16);
        F3d.dpcmd[62] = (byte)(c1_g >> 8);
        F3d.dpcmd[63] = (byte)c1_g;
        int c1_b = Float.floatToIntBits(c1[2]);
        F3d.dpcmd[64] = (byte)(c1_b >> 24);
        F3d.dpcmd[65] = (byte)(c1_b >> 16);
        F3d.dpcmd[66] = (byte)(c1_b >> 8);
        F3d.dpcmd[67] = (byte)c1_b;
        int c1_a = Float.floatToIntBits(c1[3]);
        F3d.dpcmd[68] = (byte)(c1_a >> 24);
        F3d.dpcmd[69] = (byte)(c1_a >> 16);
        F3d.dpcmd[70] = (byte)(c1_a >> 8);
        F3d.dpcmd[71] = (byte)c1_a;
        int c2_r = Float.floatToIntBits(c2[0]);
        F3d.dpcmd[72] = (byte)(c2_r >> 24);
        F3d.dpcmd[73] = (byte)(c2_r >> 16);
        F3d.dpcmd[74] = (byte)(c2_r >> 8);
        F3d.dpcmd[75] = (byte)c2_r;
        int c2_g = Float.floatToIntBits(c2[1]);
        F3d.dpcmd[76] = (byte)(c2_g >> 24);
        F3d.dpcmd[77] = (byte)(c2_g >> 16);
        F3d.dpcmd[78] = (byte)(c2_g >> 8);
        F3d.dpcmd[79] = (byte)c2_g;
        int c2_b = Float.floatToIntBits(c2[2]);
        F3d.dpcmd[80] = (byte)(c2_b >> 24);
        F3d.dpcmd[81] = (byte)(c2_b >> 16);
        F3d.dpcmd[82] = (byte)(c2_b >> 8);
        F3d.dpcmd[83] = (byte)c2_b;
        int c2_a = Float.floatToIntBits(c2[3]);
        F3d.dpcmd[84] = (byte)(c2_a >> 24);
        F3d.dpcmd[85] = (byte)(c2_a >> 16);
        F3d.dpcmd[86] = (byte)(c2_a >> 8);
        F3d.dpcmd[87] = (byte)c2_a;
        int c3_r = Float.floatToIntBits(c3[0]);
        F3d.dpcmd[88] = (byte)(c3_r >> 24);
        F3d.dpcmd[89] = (byte)(c3_r >> 16);
        F3d.dpcmd[90] = (byte)(c3_r >> 8);
        F3d.dpcmd[91] = (byte)c3_r;
        int c3_g = Float.floatToIntBits(c3[1]);
        F3d.dpcmd[92] = (byte)(c3_g >> 24);
        F3d.dpcmd[93] = (byte)(c3_g >> 16);
        F3d.dpcmd[94] = (byte)(c3_g >> 8);
        F3d.dpcmd[95] = (byte)c3_g;
        int c3_b = Float.floatToIntBits(c3[2]);
        F3d.dpcmd[96] = (byte)(c3_b >> 24);
        F3d.dpcmd[97] = (byte)(c3_b >> 16);
        F3d.dpcmd[98] = (byte)(c3_b >> 8);
        F3d.dpcmd[99] = (byte)c3_b;
        int c3_a = Float.floatToIntBits(c3[3]);
        F3d.dpcmd[100] = (byte)(c3_a >> 24);
        F3d.dpcmd[101] = (byte)(c3_a >> 16);
        F3d.dpcmd[102] = (byte)(c3_a >> 8);
        F3d.dpcmd[103] = (byte)c3_a;
        int tex1_s = Float.floatToIntBits(tex1[0]);
        F3d.dpcmd[104] = (byte)(tex1_s >> 24);
        F3d.dpcmd[105] = (byte)(tex1_s >> 16);
        F3d.dpcmd[106] = (byte)(tex1_s >> 8);
        F3d.dpcmd[107] = (byte)tex1_s;
        int tex1_t = Float.floatToIntBits(tex1[1]);
        F3d.dpcmd[108] = (byte)(tex1_t >> 24);
        F3d.dpcmd[109] = (byte)(tex1_t >> 16);
        F3d.dpcmd[110] = (byte)(tex1_t >> 8);
        F3d.dpcmd[111] = (byte)tex1_t;
        int tex2_s = Float.floatToIntBits(tex2[0]);
        F3d.dpcmd[112] = (byte)(tex2_s >> 24);
        F3d.dpcmd[113] = (byte)(tex2_s >> 16);
        F3d.dpcmd[114] = (byte)(tex2_s >> 8);
        F3d.dpcmd[115] = (byte)tex2_s;
        int tex2_t = Float.floatToIntBits(tex2[1]);
        F3d.dpcmd[116] = (byte)(tex2_t >> 24);
        F3d.dpcmd[117] = (byte)(tex2_t >> 16);
        F3d.dpcmd[118] = (byte)(tex2_t >> 8);
        F3d.dpcmd[119] = (byte)tex2_t;
        int tex3_s = Float.floatToIntBits(tex3[0]);
        F3d.dpcmd[120] = (byte)(tex3_s >> 24);
        F3d.dpcmd[121] = (byte)(tex3_s >> 16);
        F3d.dpcmd[122] = (byte)(tex3_s >> 8);
        F3d.dpcmd[123] = (byte)tex3_s;
        int tex3_t = Float.floatToIntBits(tex3[1]);
        F3d.dpcmd[124] = (byte)(tex3_t >> 24);
        F3d.dpcmd[125] = (byte)(tex3_t >> 16);
        F3d.dpcmd[126] = (byte)(tex3_t >> 8);
        F3d.dpcmd[127] = (byte)tex3_t;
        int clip1_x = Float.floatToIntBits(clip1[0]);
        F3d.dpcmd[128] = (byte)(clip1_x >> 24);
        F3d.dpcmd[129] = (byte)(clip1_x >> 16);
        F3d.dpcmd[130] = (byte)(clip1_x >> 8);
        F3d.dpcmd[131] = (byte)clip1_x;
        int clip1_y = Float.floatToIntBits(clip1[1]);
        F3d.dpcmd[132] = (byte)(clip1_y >> 24);
        F3d.dpcmd[133] = (byte)(clip1_y >> 16);
        F3d.dpcmd[134] = (byte)(clip1_y >> 8);
        F3d.dpcmd[135] = (byte)clip1_y;
        int clip1_z = Float.floatToIntBits(clip1[2]);
        F3d.dpcmd[136] = (byte)(clip1_z >> 24);
        F3d.dpcmd[137] = (byte)(clip1_z >> 16);
        F3d.dpcmd[138] = (byte)(clip1_z >> 8);
        F3d.dpcmd[139] = (byte)clip1_z;
        int clip2_x = Float.floatToIntBits(clip2[0]);
        F3d.dpcmd[144] = (byte)(clip2_x >> 24);
        F3d.dpcmd[145] = (byte)(clip2_x >> 16);
        F3d.dpcmd[146] = (byte)(clip2_x >> 8);
        F3d.dpcmd[147] = (byte)clip2_x;
        int clip2_y = Float.floatToIntBits(clip2[1]);
        F3d.dpcmd[148] = (byte)(clip2_y >> 24);
        F3d.dpcmd[149] = (byte)(clip2_y >> 16);
        F3d.dpcmd[150] = (byte)(clip2_y >> 8);
        F3d.dpcmd[151] = (byte)clip2_y;
        int clip2_z = Float.floatToIntBits(clip2[2]);
        F3d.dpcmd[152] = (byte)(clip2_z >> 24);
        F3d.dpcmd[153] = (byte)(clip2_z >> 16);
        F3d.dpcmd[154] = (byte)(clip2_z >> 8);
        F3d.dpcmd[155] = (byte)clip2_z;
        int clip3_x = Float.floatToIntBits(clip3[0]);
        F3d.dpcmd[160] = (byte)(clip3_x >> 24);
        F3d.dpcmd[161] = (byte)(clip3_x >> 16);
        F3d.dpcmd[162] = (byte)(clip3_x >> 8);
        F3d.dpcmd[163] = (byte)clip3_x;
        int clip3_y = Float.floatToIntBits(clip3[1]);
        F3d.dpcmd[164] = (byte)(clip3_y >> 24);
        F3d.dpcmd[165] = (byte)(clip3_y >> 16);
        F3d.dpcmd[166] = (byte)(clip3_y >> 8);
        F3d.dpcmd[167] = (byte)clip3_y;
        int clip3_z = Float.floatToIntBits(clip3[2]);
        F3d.dpcmd[168] = (byte)(clip3_z >> 24);
        F3d.dpcmd[169] = (byte)(clip3_z >> 16);
        F3d.dpcmd[170] = (byte)(clip3_z >> 8);
        F3d.dpcmd[171] = (byte)clip3_z;
    }

    protected static void gSPLight(int address, int n) {
        if (address + 12 > rdramSize) {
            return;
        }
        if (--n < 12) {
            F3d.lights[n].color[0] = (float)(rdram.read8bit(address) & 0xFF) * 0.003921569f;
            F3d.lights[n].color[1] = (float)(rdram.read8bit(address + 1) & 0xFF) * 0.003921569f;
            F3d.lights[n].color[2] = (float)(rdram.read8bit(address + 2) & 0xFF) * 0.003921569f;
            F3d.lights[n].vec[0] = rdram.read8bit(address + 8);
            F3d.lights[n].vec[1] = rdram.read8bit(address + 9);
            F3d.lights[n].vec[2] = rdram.read8bit(address + 10);
            Math3D.normalize(F3d.lights[n].vec);
        }
    }

    protected static void gSPNumLights(int n) {
        if (n <= 8) {
            numLights = n;
        }
    }

    protected static void gSPLightColor(int lightNum, int packedColor) {
        if (--lightNum < 12) {
            F3d.lights[lightNum].color[0] = (float)(packedColor >> 24 & 0xFF) * 0.003921569f;
            F3d.lights[lightNum].color[1] = (float)(packedColor >> 16 & 0xFF) * 0.003921569f;
            F3d.lights[lightNum].color[2] = (float)(packedColor >> 8 & 0xFF) * 0.003921569f;
        }
    }

    protected static void gSPFogFactor(short fm, short fo) {
    }

    protected static int segmentToPhysical(int segaddr) {
        return segment[segaddr >> 24 & 0xF] + (segaddr & 0xFFFFFF) & 0xFFFFFF;
    }

    protected static void gSPSegment(int seg, int base) {
        if (seg > 15) {
            return;
        }
        if (base > rdramSize - 1) {
            return;
        }
        F3d.segment[seg] = base;
    }

    protected void gSPBranchList(int address) {
        if (address + 8 > rdramSize) {
            return;
        }
        F3d.sp_writeRegister(10, address);
    }

    protected void gSPSetGeometryMode(int mode) {
        geometryMode |= mode;
        changed |= 8;
    }

    protected void gSPClearGeometryMode(int mode) {
        geometryMode &= ~mode;
        changed |= 8;
    }

    protected void gSPGeometryMode(int clear, int set) {
        geometryMode = geometryMode & ~clear | set;
        changed |= 8;
    }

    protected static void updateStates() {
        if (changed == 0) {
            return;
        }
        if ((changed & 8) != 0) {
            if ((geometryMode & Gbi.G_CULL_BOTH) != 0) {
                if ((geometryMode & Gbi.G_CULL_BACK) != 0) {
                    F3d.dp_writeRegister(12, 1);
                } else {
                    F3d.dp_writeRegister(12, 2);
                }
            } else {
                F3d.dp_writeRegister(12, 0);
            }
            if ((geometryMode & 0x10000) != 0) {
                F3d.dp_writeRegister(13, 1);
            } else {
                F3d.dp_writeRegister(13, 0);
            }
            if ((geometryMode & 1) != 0) {
                F3d.dp_writeRegister(14, 1);
            } else {
                F3d.dp_writeRegister(14, 0);
            }
            changed &= 0xFFFFFFF7;
        }
        changed &= 2;
    }

    protected int getWord() {
        int pc = F3d.sp_readRegister(10);
        int w = ((Bus32bit)rdram).read32bit(pc);
        F3d.sp_writeRegister(10, pc + 4);
        return w;
    }

    protected static class DMAOffsets {
        public int vtx;
        public int mtx;

        protected DMAOffsets() {
        }
    }

    protected static class Fog {
        public short multiplier;
        public short offset;

        protected Fog() {
        }
    }

    protected static class Light {
        public float[] color = new float[3];
        public float[] vec = new float[3];
        public float x;
        public float y;
        public float z;
        public float w;
        public int nonzero;
        public int nonblack;
        public float a;
        public float ca;

        protected Light() {
        }
    }

    protected static class Matrix {
        public int modelViewi;
        public int stackSize;
        public int billboard;
        public float[][][] modelView = new float[32][4][4];
        public float[][] projection = new float[4][4];
        public float[][] combined = new float[4][4];

        protected Matrix() {
        }
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }

    protected static class SPVertex {
        public float[] vtx = new float[4];
        public float[] norm = new float[4];
        public float[] color = new float[4];
        public float[] tex = new float[2];
        public float[] clip = new float[3];
        public short flag;

        protected SPVertex() {
        }

        public void clip() {
            this.clip[0] = this.vtx[0] < -this.vtx[3] ? -1.0f : (this.vtx[0] > this.vtx[3] ? 1.0f : 0.0f);
            this.clip[1] = this.vtx[1] < -this.vtx[3] ? -1.0f : (this.vtx[1] > this.vtx[3] ? 1.0f : 0.0f);
            this.clip[2] = this.vtx[3] <= 0.0f ? -1.0f : (this.vtx[2] < -this.vtx[3] ? -0.1f : (this.vtx[2] > this.vtx[3] ? 1.0f : 0.0f));
        }
    }
}

