/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus32bit;
import jario.hardware.Clockable;
import jario.hardware.Hardware;

public class Timer
implements Hardware,
Clockable,
Bus32bit {
    private static final int MAX_TIMERS = 4;
    private int[] nextTimer = new int[4];
    private int currentTimerType = -1;
    private int timer = 0;
    private boolean[] active = new boolean[4];
    private Clockable[] devices = new Clockable[4];

    public Timer() {
        int count = 0;
        while (count < 4) {
            this.active[count] = false;
            ++count;
        }
    }

    public void connect(int port, Hardware bus) {
        if (port < 0 || port > 3) {
            return;
        }
        this.devices[port] = (Clockable)bus;
    }

    public void reset() {
        this.timer = 0;
    }

    public void clock(long ticks) {
        this.timer = (int)((long)this.timer - ticks);
        this.checkTimerDone();
    }

    public int read32bit(int reg) {
        switch (reg) {
            case 4: {
                return this.timer;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg) {
            case 0: {
                this.changeTimer(0, this.timer + this.nextTimer[0] + value);
                break;
            }
            case 1: {
                this.changeTimer(1, this.timer + this.nextTimer[1] + value);
                break;
            }
            case 2: {
                this.changeTimer(2, this.timer + this.nextTimer[2] + value);
                break;
            }
            case 3: {
                this.changeTimer(3, this.timer + this.nextTimer[3] + value);
                break;
            }
            case 4: {
                this.timer = value;
            }
        }
    }

    private void checkTimerDone() {
        if (this.timer >= 0 || this.currentTimerType == -1) {
            return;
        }
        this.devices[this.currentTimerType].clock((long)this.timer);
    }

    private void changeTimer(int type, int value) {
        if (value == 0) {
            this.nextTimer[type] = 0;
            this.active[type] = false;
            return;
        }
        this.nextTimer[type] = value - this.timer;
        this.active[type] = true;
        int count = 1;
        while (count < 4) {
            if (this.active[count]) {
                int n = count;
                this.nextTimer[n] = this.nextTimer[n] + this.timer;
            }
            ++count;
        }
        this.currentTimerType = -1;
        this.timer = Integer.MAX_VALUE;
        count = 1;
        while (count < 4) {
            if (this.active[count] && this.nextTimer[count] < this.timer) {
                this.timer = this.nextTimer[count];
                this.currentTimerType = count;
            }
            ++count;
        }
        if (this.currentTimerType == -1) {
            System.err.printf("No active timers ???\nEmulation Stoped\n", new Object[0]);
            System.exit(0);
        }
        count = 1;
        while (count < 4) {
            if (this.active[count]) {
                int n = count;
                this.nextTimer[n] = this.nextTimer[n] - this.timer;
            }
            ++count;
        }
    }
}

