/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.system;

import jario.hardware.Bus32bit;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Jario64System
implements Hardware {
    private static final String AUTO_SAVE_DIR = "./save/";
    private static final int CONSOLE_CONTROLLER1_PORT = 1;
    private static final int CONSOLE_CONTROLLER2_PORT = 2;
    private static final int CONSOLE_CONTROLLER3_PORT = 3;
    private static final int CONSOLE_CONTROLLER4_PORT = 4;
    private static final int CONSOLE_CARTRIDGE_PORT = 5;
    private static final int CONSOLE_VIDEO_PORT = 6;
    private static final int CONSOLE_AUDIO_PORT = 7;
    private static final int CONTROLLER_EXPANSION_PORT = 0;
    private static final int VIDEO_ENABLE_REG = 1;
    private ExecutorService romThreadExecutor;
    private Hardware console;
    private Hardware mempak;
    private Hardware controller1;
    private Hardware controller2;
    private Hardware controller3;
    private Hardware controller4;
    private Bus32bit video;
    private Hardware audio;
    private Hardware cartridge;
    private WindowAdapter winListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            Jario64System.this.exit("Window Closed.");
        }
    };
    private final Runnable romProcessThread = new Runnable(){

        @Override
        public void run() {
            Jario64System.this.insertGameCartridge();
        }
    };

    public Jario64System() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cartridge = (Hardware)Class.forName(prop.getProperty("CARTRIDGE", "CARTRIDGE"), true, loader).newInstance();
            this.mempak = (Hardware)Class.forName(prop.getProperty("MEMPAK", "MEMPAK"), true, loader).newInstance();
            this.controller1 = (Hardware)Class.forName(prop.getProperty("CONTROLLER", "CONTROLLER"), true, loader).newInstance();
            this.controller2 = (Hardware)Class.forName(prop.getProperty("CONTROLLER", "CONTROLLER"), true, loader).newInstance();
            this.controller3 = (Hardware)Class.forName(prop.getProperty("CONTROLLER", "CONTROLLER"), true, loader).newInstance();
            this.controller4 = (Hardware)Class.forName(prop.getProperty("CONTROLLER", "CONTROLLER"), true, loader).newInstance();
            this.console = (Hardware)Class.forName(prop.getProperty("CONSOLE", "CONSOLE"), true, loader).newInstance();
            this.audio = (Hardware)Class.forName(prop.getProperty("AUDIO_PLAYER", "AUDIO_PLAYER"), true, loader).newInstance();
            this.video = (Bus32bit)Class.forName(prop.getProperty("VIDEO_PLAYER", "VIDEO_PLAYER"), true, loader).newInstance();
        }
        catch (Exception e) {
            System.err.println("Missing resources.");
            e.printStackTrace();
            return;
        }
        ((Configurable)this.video).writeConfig("callback", (Object)this.winListener);
        ((Configurable)this.video).writeConfig("menu", (Object)new Jario64MenuBar());
        this.romThreadExecutor = Executors.newSingleThreadExecutor();
        this.console.connect(6, (Hardware)this.video);
        this.console.connect(7, this.audio);
        this.controller1.connect(0, this.mempak);
        this.console.connect(1, this.controller1);
        this.console.connect(2, this.controller2);
        this.console.connect(3, this.controller3);
        this.console.connect(4, this.controller4);
    }

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void exit(String msg) {
        System.exit(0);
    }

    private void removeGameCartridge() {
        this.mempak.reset();
        this.console.connect(5, null);
        this.video.write32bit(1, 0);
    }

    private void insertGameCartridge() {
        this.video.write32bit(1, 0);
        File romFile = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open ROM");
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        romFile = fileChooser.getSelectedFile();
        File Directory = new File(AUTO_SAVE_DIR);
        if (!Directory.exists()) {
            Directory.mkdirs();
        }
        String romName = romFile.getName().substring(0, romFile.getName().lastIndexOf(46));
        String path = String.valueOf(Directory.getAbsolutePath()) + "/" + romName;
        ((Configurable)this.mempak).writeConfig("file", (Object)(String.valueOf(path) + ".mpk"));
        this.setSaveFile(path);
        this.loadCartRom(romFile.getAbsolutePath());
        this.video.write32bit(1, 1);
        this.console.connect(5, this.cartridge);
    }

    private void loadCartRom(String fileName) {
        ((Configurable)this.cartridge).writeConfig("romfile", (Object)fileName);
        System.out.printf("Opened rom: %s\n", fileName);
    }

    private void setSaveFile(String fileName) {
        ((Configurable)this.cartridge).writeConfig("savefile", (Object)fileName);
    }

    private class Jario64MenuBar
    extends JMenuBar {
        public Jario64MenuBar() {
            this.add(this.makeFileMenu());
            this.add(this.makeSettingsMenu());
        }

        private JMenu makeFileMenu() {
            JMenu fileMenu = new JMenu();
            fileMenu.setText("File");
            JMenuItem loadRom = new JMenuItem("Insert Game Cartridge");
            loadRom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Jario64System.this.removeGameCartridge();
                    Jario64System.this.romThreadExecutor.execute(Jario64System.this.romProcessThread);
                }
            });
            fileMenu.add(loadRom);
            JMenuItem unloadRom = new JMenuItem("Remove Game Cartridge");
            unloadRom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Jario64System.this.removeGameCartridge();
                }
            });
            fileMenu.add(unloadRom);
            JMenuItem exit = new JMenuItem("Exit");
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Jario64System.this.exit("Goodbye");
                }
            });
            fileMenu.add(exit);
            return fileMenu;
        }

        private JMenu makeSettingsMenu() {
            JMenu settingsMenu = new JMenu();
            settingsMenu.setText("Settings");
            JCheckBoxMenuItem cache = new JCheckBoxMenuItem("Cache Instructions");
            cache.setState((Boolean)((Configurable)Jario64System.this.console).readConfig("instructioncache"));
            cache.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    ((Configurable)Jario64System.this.console).writeConfig("instructioncache", (Object)i.isSelected());
                }
            });
            settingsMenu.add(cache);
            JCheckBoxMenuItem audioToggle = new JCheckBoxMenuItem("Enable Audio");
            audioToggle.setState((Boolean)((Configurable)Jario64System.this.audio).readConfig("enable"));
            audioToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    ((Configurable)Jario64System.this.audio).writeConfig("enable", (Object)i.isSelected());
                }
            });
            settingsMenu.add(audioToggle);
            JCheckBoxMenuItem frameLimit = new JCheckBoxMenuItem("Enable Frame Limit");
            frameLimit.setState((Boolean)((Configurable)Jario64System.this.console).readConfig("framelimit"));
            frameLimit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    ((Configurable)Jario64System.this.console).writeConfig("framelimit", (Object)i.isSelected());
                }
            });
            settingsMenu.add(frameLimit);
            JCheckBoxMenuItem frameBuffer = new JCheckBoxMenuItem("Use Video Frame Buffer");
            frameBuffer.setState((Boolean)((Configurable)Jario64System.this.console).readConfig("framebuffer"));
            frameBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    ((Configurable)Jario64System.this.console).writeConfig("framebuffer", (Object)i.isSelected());
                }
            });
            settingsMenu.add(frameBuffer);
            return settingsMenu;
        }
    }
}

