/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.cpu;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class Cpu
implements Hardware,
Clockable,
Bus8bit,
Bus16bit,
Bus32bit,
Bus64bit,
Configurable {
    private static final int R4300i_SPECIAL = 0;
    private static final int R4300i_REGIMM = 1;
    private static final int R4300i_J = 2;
    private static final int R4300i_JAL = 3;
    private static final int R4300i_BEQ = 4;
    private static final int R4300i_BNE = 5;
    private static final int R4300i_BLEZ = 6;
    private static final int R4300i_BGTZ = 7;
    private static final int R4300i_ADDI = 8;
    private static final int R4300i_ADDIU = 9;
    private static final int R4300i_SLTI = 10;
    private static final int R4300i_SLTIU = 11;
    private static final int R4300i_ANDI = 12;
    private static final int R4300i_ORI = 13;
    private static final int R4300i_XORI = 14;
    private static final int R4300i_LUI = 15;
    private static final int R4300i_CP0 = 16;
    private static final int R4300i_CP1 = 17;
    private static final int R4300i_BEQL = 20;
    private static final int R4300i_BNEL = 21;
    private static final int R4300i_BLEZL = 22;
    private static final int R4300i_BGTZL = 23;
    private static final int R4300i_DADDI = 24;
    private static final int R4300i_DADDIU = 25;
    private static final int R4300i_LDL = 26;
    private static final int R4300i_LDR = 27;
    private static final int R4300i_LB = 32;
    private static final int R4300i_LH = 33;
    private static final int R4300i_LWL = 34;
    private static final int R4300i_LW = 35;
    private static final int R4300i_LBU = 36;
    private static final int R4300i_LHU = 37;
    private static final int R4300i_LWR = 38;
    private static final int R4300i_LWU = 39;
    private static final int R4300i_SB = 40;
    private static final int R4300i_SH = 41;
    private static final int R4300i_SWL = 42;
    private static final int R4300i_SW = 43;
    private static final int R4300i_SDL = 44;
    private static final int R4300i_SDR = 45;
    private static final int R4300i_SWR = 46;
    private static final int R4300i_CACHE = 47;
    private static final int R4300i_LL = 48;
    private static final int R4300i_LWC1 = 49;
    private static final int R4300i_LWC2 = 50;
    private static final int R4300i_LLD = 52;
    private static final int R4300i_LDC1 = 53;
    private static final int R4300i_LDC2 = 54;
    private static final int R4300i_LD = 55;
    private static final int R4300i_SC = 56;
    private static final int R4300i_SWC1 = 57;
    private static final int R4300i_SWC2 = 58;
    private static final int R4300i_SCD = 60;
    private static final int R4300i_SDC1 = 61;
    private static final int R4300i_SDC2 = 62;
    private static final int R4300i_SD = 63;
    private static final int R4300i_SPECIAL_SLL = 0;
    private static final int R4300i_SPECIAL_SRL = 2;
    private static final int R4300i_SPECIAL_SRA = 3;
    private static final int R4300i_SPECIAL_SLLV = 4;
    private static final int R4300i_SPECIAL_SRLV = 6;
    private static final int R4300i_SPECIAL_SRAV = 7;
    private static final int R4300i_SPECIAL_JR = 8;
    private static final int R4300i_SPECIAL_JALR = 9;
    private static final int R4300i_SPECIAL_SYSCALL = 12;
    private static final int R4300i_SPECIAL_BREAK = 13;
    private static final int R4300i_SPECIAL_SYNC = 15;
    private static final int R4300i_SPECIAL_MFHI = 16;
    private static final int R4300i_SPECIAL_MTHI = 17;
    private static final int R4300i_SPECIAL_MFLO = 18;
    private static final int R4300i_SPECIAL_MTLO = 19;
    private static final int R4300i_SPECIAL_DSLLV = 20;
    private static final int R4300i_SPECIAL_DSRLV = 22;
    private static final int R4300i_SPECIAL_DSRAV = 23;
    private static final int R4300i_SPECIAL_MULT = 24;
    private static final int R4300i_SPECIAL_MULTU = 25;
    private static final int R4300i_SPECIAL_DIV = 26;
    private static final int R4300i_SPECIAL_DIVU = 27;
    private static final int R4300i_SPECIAL_DMULT = 28;
    private static final int R4300i_SPECIAL_DMULTU = 29;
    private static final int R4300i_SPECIAL_DDIV = 30;
    private static final int R4300i_SPECIAL_DDIVU = 31;
    private static final int R4300i_SPECIAL_ADD = 32;
    private static final int R4300i_SPECIAL_ADDU = 33;
    private static final int R4300i_SPECIAL_SUB = 34;
    private static final int R4300i_SPECIAL_SUBU = 35;
    private static final int R4300i_SPECIAL_AND = 36;
    private static final int R4300i_SPECIAL_OR = 37;
    private static final int R4300i_SPECIAL_XOR = 38;
    private static final int R4300i_SPECIAL_NOR = 39;
    private static final int R4300i_SPECIAL_SLT = 42;
    private static final int R4300i_SPECIAL_SLTU = 43;
    private static final int R4300i_SPECIAL_DADD = 44;
    private static final int R4300i_SPECIAL_DADDU = 45;
    private static final int R4300i_SPECIAL_DSUB = 46;
    private static final int R4300i_SPECIAL_DSUBU = 47;
    private static final int R4300i_SPECIAL_TGE = 48;
    private static final int R4300i_SPECIAL_TGEU = 49;
    private static final int R4300i_SPECIAL_TLT = 50;
    private static final int R4300i_SPECIAL_TLTU = 51;
    private static final int R4300i_SPECIAL_TEQ = 52;
    private static final int R4300i_SPECIAL_TNE = 54;
    private static final int R4300i_SPECIAL_DSLL = 56;
    private static final int R4300i_SPECIAL_DSRL = 58;
    private static final int R4300i_SPECIAL_DSRA = 59;
    private static final int R4300i_SPECIAL_DSLL32 = 60;
    private static final int R4300i_SPECIAL_DSRL32 = 62;
    private static final int R4300i_SPECIAL_DSRA32 = 63;
    private static final int R4300i_REGIMM_BLTZ = 0;
    private static final int R4300i_REGIMM_BGEZ = 1;
    private static final int R4300i_REGIMM_BLTZL = 2;
    private static final int R4300i_REGIMM_BGEZL = 3;
    private static final int R4300i_REGIMM_TGEI = 8;
    private static final int R4300i_REGIMM_TGEIU = 9;
    private static final int R4300i_REGIMM_TLTI = 10;
    private static final int R4300i_REGIMM_TLTIU = 11;
    private static final int R4300i_REGIMM_TEQI = 12;
    private static final int R4300i_REGIMM_TNEI = 14;
    private static final int R4300i_REGIMM_BLTZAL = 16;
    private static final int R4300i_REGIMM_BGEZAL = 17;
    private static final int R4300i_REGIMM_BLTZALL = 18;
    private static final int R4300i_REGIMM_BGEZALL = 19;
    private static final int R4300i_COP0_MF = 0;
    private static final int R4300i_COP0_MT = 4;
    private static final int R4300i_COP0_CO_TLBR = 1;
    private static final int R4300i_COP0_CO_TLBWI = 2;
    private static final int R4300i_COP0_CO_TLBWR = 6;
    private static final int R4300i_COP0_CO_TLBP = 8;
    private static final int R4300i_COP0_CO_ERET = 24;
    private static final int R4300i_COP1_MF = 0;
    private static final int R4300i_COP1_DMF = 1;
    private static final int R4300i_COP1_CF = 2;
    private static final int R4300i_COP1_MT = 4;
    private static final int R4300i_COP1_DMT = 5;
    private static final int R4300i_COP1_CT = 6;
    private static final int R4300i_COP1_BC = 8;
    private static final int R4300i_COP1_S = 16;
    private static final int R4300i_COP1_D = 17;
    private static final int R4300i_COP1_W = 20;
    private static final int R4300i_COP1_L = 21;
    private static final int R4300i_COP1_BC_BCF = 0;
    private static final int R4300i_COP1_BC_BCT = 1;
    private static final int R4300i_COP1_BC_BCFL = 2;
    private static final int R4300i_COP1_BC_BCTL = 3;
    private static final int R4300i_COP1_FUNCT_ADD = 0;
    private static final int R4300i_COP1_FUNCT_SUB = 1;
    private static final int R4300i_COP1_FUNCT_MUL = 2;
    private static final int R4300i_COP1_FUNCT_DIV = 3;
    private static final int R4300i_COP1_FUNCT_SQRT = 4;
    private static final int R4300i_COP1_FUNCT_ABS = 5;
    private static final int R4300i_COP1_FUNCT_MOV = 6;
    private static final int R4300i_COP1_FUNCT_NEG = 7;
    private static final int R4300i_COP1_FUNCT_ROUND_L = 8;
    private static final int R4300i_COP1_FUNCT_TRUNC_L = 9;
    private static final int R4300i_COP1_FUNCT_CEIL_L = 10;
    private static final int R4300i_COP1_FUNCT_FLOOR_L = 11;
    private static final int R4300i_COP1_FUNCT_ROUND_W = 12;
    private static final int R4300i_COP1_FUNCT_TRUNC_W = 13;
    private static final int R4300i_COP1_FUNCT_CEIL_W = 14;
    private static final int R4300i_COP1_FUNCT_FLOOR_W = 15;
    private static final int R4300i_COP1_FUNCT_CVT_S = 32;
    private static final int R4300i_COP1_FUNCT_CVT_D = 33;
    private static final int R4300i_COP1_FUNCT_CVT_W = 36;
    private static final int R4300i_COP1_FUNCT_CVT_L = 37;
    private static final int R4300i_COP1_FUNCT_C_F = 48;
    private static final int R4300i_COP1_FUNCT_C_UN = 49;
    private static final int R4300i_COP1_FUNCT_C_EQ = 50;
    private static final int R4300i_COP1_FUNCT_C_UEQ = 51;
    private static final int R4300i_COP1_FUNCT_C_OLT = 52;
    private static final int R4300i_COP1_FUNCT_C_ULT = 53;
    private static final int R4300i_COP1_FUNCT_C_OLE = 54;
    private static final int R4300i_COP1_FUNCT_C_ULE = 55;
    private static final int R4300i_COP1_FUNCT_C_SF = 56;
    private static final int R4300i_COP1_FUNCT_C_NGLE = 57;
    private static final int R4300i_COP1_FUNCT_C_SEQ = 58;
    private static final int R4300i_COP1_FUNCT_C_NGL = 59;
    private static final int R4300i_COP1_FUNCT_C_LT = 60;
    private static final int R4300i_COP1_FUNCT_C_NGE = 61;
    private static final int R4300i_COP1_FUNCT_C_LE = 62;
    private static final int R4300i_COP1_FUNCT_C_NGT = 63;
    private static final int INDEX_REGISTER = 0;
    private static final int RANDOM_REGISTER = 1;
    private static final int ENTRYLO0_REGISTER = 2;
    private static final int ENTRYLO1_REGISTER = 3;
    private static final int CONTEXT_REGISTER = 4;
    private static final int PAGE_MASK_REGISTER = 5;
    private static final int WIRED_REGISTER = 6;
    private static final int BAD_VADDR_REGISTER = 8;
    private static final int COUNT_REGISTER = 9;
    private static final int ENTRYHI_REGISTER = 10;
    private static final int COMPARE_REGISTER = 11;
    private static final int STATUS_REGISTER = 12;
    private static final int CAUSE_REGISTER = 13;
    private static final int EPC_REGISTER = 14;
    private static final int CONFIG_REGISTER = 16;
    private static final int TAGLO_REGISTER = 28;
    private static final int TAGHI_REGISTER = 29;
    private static final int ERROREPC_REGISTER = 30;
    private static final int FAKE_CAUSE_REGISTER = 32;
    private static final int COP0_ADDRESS_REG = 33;
    private static final int COP0_INTR_REG = 37;
    private static final int COP0_ERROR_REG = 38;
    private static final int COP0_MEM_RW_REG = 39;
    private static final int COP0_INSTR_REG = 40;
    private static final int COP0_EXC_REG = 41;
    private static final int CAUSE_EXC_CODE = 255;
    private static final int CAUSE_IP0 = 256;
    private static final int CAUSE_IP1 = 512;
    private static final int CAUSE_IP2 = 1024;
    private static final int CAUSE_IP3 = 2048;
    private static final int CAUSE_IP4 = 4096;
    private static final int CAUSE_IP5 = 8192;
    private static final int CAUSE_IP6 = 16384;
    private static final int CAUSE_IP7 = 32768;
    private static final int CAUSE_BD = Integer.MIN_VALUE;
    private static final int STATUS_IE = 1;
    private static final int STATUS_EXL = 2;
    private static final int STATUS_ERL = 4;
    private static final int STATUS_IP0 = 256;
    private static final int STATUS_IP1 = 512;
    private static final int STATUS_IP2 = 1024;
    private static final int STATUS_IP3 = 2048;
    private static final int STATUS_IP4 = 4096;
    private static final int STATUS_IP5 = 8192;
    private static final int STATUS_IP6 = 16384;
    private static final int STATUS_IP7 = 32768;
    private static final int STATUS_BEV = 0x400000;
    private static final int STATUS_FR = 0x4000000;
    private static final int STATUS_CU0 = 0x10000000;
    private static final int STATUS_CU1 = 0x20000000;
    private static final int EXC_INT = 0;
    private static final int EXC_MOD = 4;
    private static final int EXC_RMISS = 8;
    private static final int EXC_WMISS = 12;
    private static final int EXC_RADE = 16;
    private static final int EXC_WADE = 20;
    private static final int EXC_IBE = 24;
    private static final int EXC_DBE = 28;
    private static final int EXC_SYSCALL = 32;
    private static final int EXC_BREAK = 36;
    private static final int EXC_II = 40;
    private static final int EXC_CPU = 44;
    private static final int EXC_OV = 48;
    private static final int EXC_TRAP = 52;
    private static final int EXC_VCEI = 56;
    private static final int EXC_FPE = 60;
    private static final int EXC_WATCH = 92;
    private static final int EXC_VCED = 124;
    private static final int CE_COP0 = 0;
    private static final int CE_COP1 = 0x10000000;
    private static final int REVISION_REGISTER = 0;
    private static final int FSTATUS_REGISTER = 31;
    private static final int COP1_FP_EXT_REG = 64;
    private static final int COP1_INSTR_REG = 65;
    private static final int FPCSR_FS = 0x1000000;
    private static final int FPCSR_C = 0x800000;
    private static final int FPCSR_CE = 131072;
    private static final int FPCSR_CV = 65536;
    private static final int FPCSR_CZ = 32768;
    private static final int FPCSR_CO = 16384;
    private static final int FPCSR_CU = 8192;
    private static final int FPCSR_CI = 4096;
    private static final int FPCSR_EV = 2048;
    private static final int FPCSR_EZ = 1024;
    private static final int FPCSR_EO = 512;
    private static final int FPCSR_EU = 256;
    private static final int FPCSR_EI = 128;
    private static final int FPCSR_FV = 64;
    private static final int FPCSR_FZ = 32;
    private static final int FPCSR_FO = 16;
    private static final int FPCSR_FU = 8;
    private static final int FPCSR_FI = 4;
    private static final int FPCSR_RM_MASK = 3;
    private static final int FPCSR_RM_RN = 0;
    private static final int FPCSR_RM_RZ = 1;
    private static final int FPCSR_RM_RP = 2;
    private static final int FPCSR_RM_RM = 3;
    private static final int NORMAL = 0;
    private static final int DO_DELAY_SLOT = 1;
    private static final int DO_END_DELAY_SLOT = 2;
    private static final int DELAY_SLOT = 3;
    private static final int END_DELAY_SLOT = 4;
    private static final int LIKELY_DELAY_SLOT = 5;
    private static final int JUMP = 6;
    private static final int DELAY_SLOT_DONE = 7;
    private static final int LIKELY_DELAY_SLOT_DONE = 8;
    private static final int END_BLOCK = 9;
    private static final int OP = 26;
    private static final int RS = 21;
    private static final int RT = 16;
    private static final int RD = 11;
    private static final int SA = 6;
    private static long[] LDL_MASK;
    private static int[] LDL_SHIFT;
    private static long[] LDR_MASK;
    private static int[] LDR_SHIFT;
    private static int[] LWL_MASK;
    private static int[] LWL_SHIFT;
    private static int[] LWR_MASK;
    private static int[] LWR_SHIFT;
    private static int[] SWL_MASK;
    private static int[] SWL_SHIFT;
    private static long[] SDL_MASK;
    private static int[] SDL_SHIFT;
    private static long[] SDR_MASK;
    private static int[] SDR_SHIFT;
    private static int[] SWR_MASK;
    private static int[] SWR_SHIFT;
    protected int nextInstruction;
    protected int pc;
    protected long[] GPR = new long[32];
    protected int jumpToLocation;
    protected long HI;
    protected long LO;
    protected int tmpWord;
    protected long tmpDouble;
    protected int instruction;
    protected int target;
    protected int rs;
    protected int base;
    protected int rt;
    protected short offset;
    protected int rd;
    protected int sa;
    protected int funct;
    protected int currentInstr;
    private int llBit;
    private int llAddr;
    private CachedOpcode[] cachedOpcodes;
    private CachedOpcode cachedOp;
    private OpCode cachedCode;
    private OpCode[] r4300i_Opcode;
    private OpCode[] r4300i_Special;
    private OpCode[] r4300i_Regimm;
    private long[] tmpDmultu = new long[3];
    private int tmpOp;
    private int tmpRs;
    private int tmpRt;
    private int tmpRd;
    private int tmpFunct;
    private boolean cacheInstructions;
    private int tick;
    private int tickTimer;
    private int countPerOp;
    private int mode32;
    private boolean running;
    private boolean tableException;
    private Bus8bit mi8bit;
    private Bus16bit mi16bit;
    private Bus32bit mi32bit;
    private Bus64bit mi64bit;
    protected Bus32bit cop0;
    protected Bus32bit mmu;
    protected Bus32bit cop1;
    protected Bus32bit timer;
    protected OpCode R4300i_opcode_SPECIAL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.r4300i_Special[instr & 0x3F].exec(instr, unused);
        }
    };
    protected OpCode R4300i_opcode_REGIMM = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.r4300i_Regimm[instr >> 16 & 0x1F].exec(instr, unused);
        }
    };
    protected OpCode R4300i_opcode_COP0 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.cop0.write32bit(40, instr);
        }
    };
    protected OpCode R4300i_opcode_COP1 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int status = Cpu.this.cop0.read32bit(12);
            if ((status & 0x20000000) == 0) {
                Cpu.this.cop0.write32bit(41, 268435500);
                return;
            }
            if ((status & 0x4000000) == Cpu.this.mode32) {
                Cpu cpu = Cpu.this;
                cpu.mode32 = cpu.mode32 ^ 1;
                Cpu.this.cop1.write32bit(64, status & 0x4000000);
            }
            Cpu.this.cop1.write32bit(65, instr);
        }
    };
    protected OpCode r4300i_J = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.jumpToLocation = (Cpu.this.pc & 0xF0000000) + ((instr & 0x3FFFFFF) << 2);
            Cpu.this.nextInstruction = 3;
            Cpu.this.testInterpreterJump();
        }
    };
    protected OpCode r4300i_JAL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.jumpToLocation = (Cpu.this.pc & 0xF0000000) + ((instr & 0x3FFFFFF) << 2);
            Cpu.this.nextInstruction = 3;
            Cpu.this.testInterpreterJump();
            Cpu.this.GPR[31] = Cpu.this.pc + 8;
        }
    };
    protected OpCode r4300i_BEQ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] == Cpu.this.GPR[instr >> 16 & 0x1F]) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_BNE = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] != Cpu.this.GPR[instr >> 16 & 0x1F]) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_BLEZ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] <= 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_BGTZ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] > 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_ADDI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
        }
    };
    protected OpCode r4300i_ADDIU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
        }
    };
    protected OpCode r4300i_SLTI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] < (long)((short)instr) ? 1L : 0L;
        }
    };
    protected OpCode r4300i_SLTIU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.compareUnsignedLongs(Cpu.this.GPR[instr >> 21 & 0x1F], (short)instr) < 0 ? 1L : 0L;
        }
    };
    protected OpCode r4300i_ANDI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] & (long)(instr & 0xFFFF);
        }
    };
    protected OpCode r4300i_ORI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] | (long)(instr & 0xFFFF);
        }
    };
    protected OpCode r4300i_XORI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] ^ (long)(instr & 0xFFFF);
        }
    };
    protected OpCode r4300i_LUI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = (instr & 0xFFFF) << 16;
        }
    };
    protected OpCode r4300i_BEQL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] == Cpu.this.GPR[instr >> 16 & 0x1F]) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_BNEL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] != Cpu.this.GPR[instr >> 16 & 0x1F]) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_BLEZL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] <= 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_BGTZL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] > 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_DADDIU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] + (long)((short)instr);
        }
    };
    protected OpCode r4300i_LDL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpDouble = Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8);
            Cpu.this.GPR[instr >> 16 & 0x1F] = (Cpu.this.GPR[instr >> 16 & 0x1F] & LDL_MASK[addr & 7]) + (Cpu.this.tmpDouble << LDL_SHIFT[addr & 7]);
        }
    };
    protected OpCode r4300i_LDR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpDouble = Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8);
            Cpu.this.GPR[instr >> 16 & 0x1F] = (Cpu.this.GPR[instr >> 16 & 0x1F] & LDR_MASK[addr & 7]) + (Cpu.this.tmpDouble >> LDR_SHIFT[addr & 7]);
        }
    };
    protected OpCode r4300i_LB = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.mi8bit.read8bit(Cpu.this.mmu.read32bit(addr));
        }
    };
    protected OpCode r4300i_LH = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 1) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.mi16bit.read16bit(Cpu.this.mmu.read32bit(addr));
        }
    };
    protected OpCode r4300i_LWL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpWord = Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC);
            Cpu.this.GPR[instr >> 16 & 0x1F] = ((int)Cpu.this.GPR[instr >> 16 & 0x1F] & LWL_MASK[addr & 3]) + (Cpu.this.tmpWord << LWL_SHIFT[addr & 3]);
        }
    };
    protected OpCode r4300i_LW = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr));
        }
    };
    protected OpCode r4300i_LBU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.GPR[instr >> 16 & 0x1F] = (long)Cpu.this.mi8bit.read8bit(Cpu.this.mmu.read32bit(addr)) & 0xFFL;
        }
    };
    protected OpCode r4300i_LHU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 1) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = (long)Cpu.this.mi16bit.read16bit(Cpu.this.mmu.read32bit(addr)) & 0xFFFFL;
        }
    };
    protected OpCode r4300i_LWR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpWord = Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC);
            Cpu.this.GPR[instr >> 16 & 0x1F] = ((int)Cpu.this.GPR[instr >> 16 & 0x1F] & LWR_MASK[addr & 3]) + (Cpu.this.tmpWord >> LWR_SHIFT[addr & 3]);
        }
    };
    protected OpCode r4300i_LWU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = (long)Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr)) & 0xFFFFFFFFL;
        }
    };
    protected OpCode r4300i_SB = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi8bit.write8bit(pAddr, (byte)Cpu.this.GPR[instr >> 16 & 0x1F]);
            } else {
                Cpu.this.mi8bit.write8bit(Cpu.this.mmu.read32bit(addr), (byte)Cpu.this.GPR[instr >> 16 & 0x1F]);
            }
        }
    };
    protected OpCode r4300i_SH = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 1) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi16bit.write16bit(pAddr, (short)Cpu.this.GPR[instr >> 16 & 0x1F]);
            } else {
                Cpu.this.mi16bit.write16bit(Cpu.this.mmu.read32bit(addr), (short)Cpu.this.GPR[instr >> 16 & 0x1F]);
            }
        }
    };
    protected OpCode r4300i_SWL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpWord = (Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC) & SWL_MASK[addr & 3]) + ((int)Cpu.this.GPR[instr >> 16 & 0x1F] >>> SWL_SHIFT[addr & 3]);
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC;
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi32bit.write32bit(pAddr, Cpu.this.tmpWord);
            } else {
                Cpu.this.mi32bit.write32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC, Cpu.this.tmpWord);
            }
        }
    };
    protected OpCode r4300i_SW = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi32bit.write32bit(pAddr, (int)Cpu.this.GPR[instr >> 16 & 0x1F]);
            } else {
                Cpu.this.mi32bit.write32bit(Cpu.this.mmu.read32bit(addr), (int)Cpu.this.GPR[instr >> 16 & 0x1F]);
            }
        }
    };
    protected OpCode r4300i_SDL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpDouble = (Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8) & SDL_MASK[addr & 7]) + (Cpu.this.GPR[instr >> 16 & 0x1F] >> SDL_SHIFT[addr & 7]);
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8;
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi64bit.write64bit(pAddr, Cpu.this.tmpDouble);
            } else {
                Cpu.this.mi64bit.write64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8, Cpu.this.tmpDouble);
            }
        }
    };
    protected OpCode r4300i_SDR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpDouble = (Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8) & SDR_MASK[addr & 7]) + (Cpu.this.GPR[instr >> 16 & 0x1F] << SDR_SHIFT[addr & 7]);
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8;
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi64bit.write64bit(pAddr, Cpu.this.tmpDouble);
            } else {
                Cpu.this.mi64bit.write64bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFF8, Cpu.this.tmpDouble);
            }
        }
    };
    protected OpCode r4300i_SWR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            Cpu.this.tmpWord = (Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC) & SWR_MASK[addr & 3]) + ((int)Cpu.this.GPR[instr >> 16 & 0x1F] << SWR_SHIFT[addr & 3]);
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC;
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi32bit.write32bit(pAddr, Cpu.this.tmpWord);
            } else {
                Cpu.this.mi32bit.write32bit(Cpu.this.mmu.read32bit(addr) & 0xFFFFFFFC, Cpu.this.tmpWord);
            }
        }
    };
    protected OpCode r4300i_CACHE = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
        }
    };
    protected OpCode r4300i_LL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 16 & 0x1F) == 0) {
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr));
            Cpu.this.llBit = 1;
            Cpu.this.llAddr = addr;
            Cpu.this.llAddr = Cpu.this.mmu.read32bit(addr);
        }
    };
    protected OpCode r4300i_LWC1 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((Cpu.this.cop0.read32bit(12) & 0x20000000) == 0) {
                Cpu.this.cop0.write32bit(41, 268435500);
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.cop1.write32bit(instr >> 16 & 0x1F, Cpu.this.mi32bit.read32bit(Cpu.this.mmu.read32bit(addr)));
        }
    };
    protected OpCode r4300i_SC = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.llBit == 1) {
                if (Cpu.this.cacheInstructions) {
                    int pAddr = Cpu.this.mmu.read32bit(addr);
                    if (pAddr < 0x400000) {
                        ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                    } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                        ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                    }
                    Cpu.this.mi32bit.write32bit(pAddr, (int)Cpu.this.GPR[instr >> 16 & 0x1F]);
                } else {
                    Cpu.this.mi32bit.write32bit(Cpu.this.mmu.read32bit(addr), (int)Cpu.this.GPR[instr >> 16 & 0x1F]);
                }
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = (long)Cpu.this.llBit & 0xFFFFFFFFL | Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFF00000000L;
        }
    };
    protected OpCode r4300i_LD = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 7) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            Cpu.this.GPR[instr >> 16 & 0x1F] = Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr));
        }
    };
    protected OpCode r4300i_LDC1 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((Cpu.this.cop0.read32bit(12) & 0x20000000) == 0) {
                Cpu.this.cop0.write32bit(41, 268435500);
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 7) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 16);
                return;
            }
            ((Bus64bit)Cpu.this.cop1).write64bit(instr >> 16 & 0x1F, Cpu.this.mi64bit.read64bit(Cpu.this.mmu.read32bit(addr)));
        }
    };
    protected OpCode r4300i_SWC1 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((Cpu.this.cop0.read32bit(12) & 0x20000000) == 0) {
                Cpu.this.cop0.write32bit(41, 268435500);
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 3) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi32bit.write32bit(pAddr, Cpu.this.cop1.read32bit(instr >> 16 & 0x1F));
            } else {
                Cpu.this.mi32bit.write32bit(Cpu.this.mmu.read32bit(addr), Cpu.this.cop1.read32bit(instr >> 16 & 0x1F));
            }
        }
    };
    protected OpCode r4300i_SDC1 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((Cpu.this.cop0.read32bit(12) & 0x20000000) == 0) {
                Cpu.this.cop0.write32bit(41, 268435500);
                return;
            }
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 7) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi64bit.write64bit(pAddr, ((Bus64bit)Cpu.this.cop1).read64bit(instr >> 16 & 0x1F));
            } else {
                Cpu.this.mi64bit.write64bit(Cpu.this.mmu.read32bit(addr), ((Bus64bit)Cpu.this.cop1).read64bit(instr >> 16 & 0x1F));
            }
        }
    };
    protected OpCode r4300i_SD = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            int addr = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (short)instr;
            if ((addr & 7) != 0) {
                Cpu.this.cop0.write32bit(33, addr);
                Cpu.this.cop0.write32bit(41, 20);
                return;
            }
            if (Cpu.this.cacheInstructions) {
                int pAddr = Cpu.this.mmu.read32bit(addr);
                if (pAddr < 0x400000) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 >>> 2].cached = false;
                } else if (pAddr - 0x3C00000 >>> 2 < Cpu.this.cachedOpcodes.length) {
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr - 0x3C00000 >>> 2].cached = false;
                    ((Cpu)Cpu.this).cachedOpcodes[pAddr + 4 - 0x3C00000 >>> 2].cached = false;
                }
                Cpu.this.mi64bit.write64bit(pAddr, Cpu.this.GPR[instr >> 16 & 0x1F]);
            } else {
                Cpu.this.mi64bit.write64bit(Cpu.this.mmu.read32bit(addr), Cpu.this.GPR[instr >> 16 & 0x1F]);
            }
        }
    };
    protected OpCode r4300i_SPECIAL_SLL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] << (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_SRL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] >>> (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_SRA = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] >> (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_SLLV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if ((instr >> 11 & 0x1F) == 0) {
                return;
            }
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] << (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x1FL);
        }
    };
    protected OpCode r4300i_SPECIAL_SRLV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] >>> (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x1FL);
        }
    };
    protected OpCode r4300i_SPECIAL_SRAV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 16 & 0x1F] >> (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x1FL);
        }
    };
    protected OpCode r4300i_SPECIAL_JR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.nextInstruction = 3;
            Cpu.this.jumpToLocation = (int)Cpu.this.GPR[instr >> 21 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_JALR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.nextInstruction = 3;
            Cpu.this.jumpToLocation = (int)Cpu.this.GPR[instr >> 21 & 0x1F];
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.pc + 8;
        }
    };
    protected OpCode r4300i_SPECIAL_SYSCALL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.cop0.write32bit(41, 32);
        }
    };
    protected OpCode r4300i_SPECIAL_BREAK = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.cop0.write32bit(41, 36);
        }
    };
    protected OpCode r4300i_SPECIAL_SYNC = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
        }
    };
    protected OpCode r4300i_SPECIAL_MFHI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.HI;
        }
    };
    protected OpCode r4300i_SPECIAL_MTHI = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.HI = Cpu.this.GPR[instr >> 21 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_MFLO = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.LO;
        }
    };
    protected OpCode r4300i_SPECIAL_MTLO = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = Cpu.this.GPR[instr >> 21 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DSLLV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] << (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x3FL);
        }
    };
    protected OpCode r4300i_SPECIAL_DSRLV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >>> (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x3FL);
        }
    };
    protected OpCode r4300i_SPECIAL_DSRAV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >> (int)(Cpu.this.GPR[instr >> 21 & 0x1F] & 0x3FL);
        }
    };
    protected OpCode r4300i_SPECIAL_MULT = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.HI = (long)((int)Cpu.this.GPR[instr >> 21 & 0x1F]) * (long)((int)Cpu.this.GPR[instr >> 16 & 0x1F]);
            Cpu.this.LO = (int)Cpu.this.HI;
            Cpu.this.HI = (int)(Cpu.this.HI >> 32);
        }
    };
    protected OpCode r4300i_SPECIAL_MULTU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.HI = (Cpu.this.GPR[instr >> 21 & 0x1F] & 0xFFFFFFFFL) * (Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFFL);
            Cpu.this.LO = (int)Cpu.this.HI;
            Cpu.this.HI = (int)(Cpu.this.HI >> 32);
        }
    };
    protected OpCode r4300i_SPECIAL_DIV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = (int)Cpu.this.GPR[instr >> 21 & 0x1F] / (int)Cpu.this.GPR[instr >> 16 & 0x1F];
            Cpu.this.HI = (int)Cpu.this.GPR[instr >> 21 & 0x1F] % (int)Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DIVU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = (Cpu.this.GPR[instr >> 21 & 0x1F] & 0xFFFFFFFFL) / (Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFFL);
            Cpu.this.HI = (Cpu.this.GPR[instr >> 21 & 0x1F] & 0xFFFFFFFFL) % (Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFFL);
        }
    };
    protected OpCode r4300i_SPECIAL_DMULT = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
        }
    };
    protected OpCode r4300i_SPECIAL_DMULTU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = (Cpu.this.GPR[instr >> 21 & 0x1F] & 0xFFFFFFFFL) * (Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFFL);
            ((Cpu)Cpu.this).tmpDmultu[0] = (Cpu.this.GPR[instr >> 21 & 0x1F] >>> 32) * (Cpu.this.GPR[instr >> 16 & 0x1F] & 0xFFFFFFFFL);
            ((Cpu)Cpu.this).tmpDmultu[1] = (Cpu.this.GPR[instr >> 21 & 0x1F] & 0xFFFFFFFFL) * (Cpu.this.GPR[instr >> 16 & 0x1F] >>> 32);
            Cpu.this.HI = (Cpu.this.GPR[instr >> 21 & 0x1F] >>> 32) * (Cpu.this.GPR[instr >> 16 & 0x1F] >>> 32);
            ((Cpu)Cpu.this).tmpDmultu[2] = (Cpu.this.LO >>> 32) + (Cpu.this.tmpDmultu[0] & 0xFFFFFFFFL) + (Cpu.this.tmpDmultu[1] & 0xFFFFFFFFL);
            Cpu.this.LO += (Cpu.this.tmpDmultu[0] & 0xFFFFFFFFL) + (Cpu.this.tmpDmultu[1] & 0xFFFFFFFFL) << 32;
            Cpu.this.HI += (Cpu.this.tmpDmultu[0] >>> 32) + (Cpu.this.tmpDmultu[1] >>> 32) + (Cpu.this.tmpDmultu[2] >>> 32);
        }
    };
    protected OpCode r4300i_SPECIAL_DDIV = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = Cpu.this.GPR[instr >> 21 & 0x1F] / Cpu.this.GPR[instr >> 16 & 0x1F];
            Cpu.this.HI = Cpu.this.GPR[instr >> 21 & 0x1F] % Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DDIVU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.LO = Cpu.this.GPR[instr >> 21 & 0x1F] / Cpu.this.GPR[instr >> 16 & 0x1F];
            Cpu.this.HI = Cpu.this.GPR[instr >> 21 & 0x1F] % Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_ADD = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (int)Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_ADDU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] + (int)Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_SUB = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] - (int)Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_SUBU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (int)Cpu.this.GPR[instr >> 21 & 0x1F] - (int)Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_AND = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] & Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_OR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] | Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_XOR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] ^ Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_NOR = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = (Cpu.this.GPR[instr >> 21 & 0x1F] | Cpu.this.GPR[instr >> 16 & 0x1F]) ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    protected OpCode r4300i_SPECIAL_SLT = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] < Cpu.this.GPR[instr >> 16 & 0x1F] ? 1L : 0L;
        }
    };
    protected OpCode r4300i_SPECIAL_SLTU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.compareUnsignedLongs(Cpu.this.GPR[instr >> 21 & 0x1F], Cpu.this.GPR[instr >> 16 & 0x1F]) < 0 ? 1L : 0L;
        }
    };
    protected OpCode r4300i_SPECIAL_DADD = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] + Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DADDU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] + Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DSUB = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] - Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_DSUBU = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 21 & 0x1F] - Cpu.this.GPR[instr >> 16 & 0x1F];
        }
    };
    protected OpCode r4300i_SPECIAL_TEQ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
        }
    };
    protected OpCode r4300i_SPECIAL_DSLL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] << (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_DSRL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >>> (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_DSRA = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >> (instr >> 6 & 0x1F);
        }
    };
    protected OpCode r4300i_SPECIAL_DSLL32 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] << (instr >> 6 & 0x1F) + 32;
        }
    };
    protected OpCode r4300i_SPECIAL_DSRL32 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >>> (instr >> 6 & 0x1F) + 32;
        }
    };
    protected OpCode r4300i_SPECIAL_DSRA32 = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            Cpu.this.GPR[instr >> 11 & 0x1F] = Cpu.this.GPR[instr >> 16 & 0x1F] >> (instr >> 6 & 0x1F) + 32;
        }
    };
    protected OpCode r4300i_REGIMM_BLTZ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] < 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_REGIMM_BGEZ = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] >= 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
        }
    };
    protected OpCode r4300i_REGIMM_BLTZL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] < 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_REGIMM_BGEZL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] >= 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 6;
            }
        }
    };
    protected OpCode r4300i_REGIMM_BLTZAL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] < 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
            Cpu.this.GPR[31] = Cpu.this.pc + 8;
        }
    };
    protected OpCode r4300i_REGIMM_BGEZAL = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            if (Cpu.this.GPR[instr >> 21 & 0x1F] >= 0L) {
                Cpu.this.jumpToLocation = Cpu.this.pc + ((short)instr << 2) + 4;
                Cpu.this.nextInstruction = 3;
                Cpu.this.testInterpreterJump();
            } else {
                Cpu.this.jumpToLocation = Cpu.this.pc + 8;
                Cpu.this.nextInstruction = 3;
            }
            Cpu.this.GPR[31] = Cpu.this.pc + 8;
        }
    };
    protected OpCode R4300i_UnknownOpcode = new OpCode(){

        @Override
        public void exec(int instr, int unused) {
            System.err.printf("PC:%X ,Unhandled r4300i OpCode:%X\n", Cpu.this.pc, instr);
            System.exit(0);
        }
    };

    static {
        long[] lArray = new long[8];
        lArray[1] = 255L;
        lArray[2] = 65535L;
        lArray[3] = 0xFFFFFFL;
        lArray[4] = 0xFFFFFFFFL;
        lArray[5] = 0xFFFFFFFFFFL;
        lArray[6] = 0xFFFFFFFFFFFFL;
        lArray[7] = 0xFFFFFFFFFFFFFFL;
        LDL_MASK = lArray;
        int[] nArray = new int[8];
        nArray[1] = 8;
        nArray[2] = 16;
        nArray[3] = 24;
        nArray[4] = 32;
        nArray[5] = 40;
        nArray[6] = 48;
        nArray[7] = 56;
        LDL_SHIFT = nArray;
        long[] lArray2 = new long[8];
        lArray2[0] = -256L;
        lArray2[1] = -65536L;
        lArray2[2] = -16777216L;
        lArray2[3] = -4294967296L;
        lArray2[4] = -1099511627776L;
        lArray2[5] = -281474976710656L;
        lArray2[6] = -72057594037927936L;
        LDR_MASK = lArray2;
        int[] nArray2 = new int[8];
        nArray2[0] = 56;
        nArray2[1] = 48;
        nArray2[2] = 40;
        nArray2[3] = 32;
        nArray2[4] = 24;
        nArray2[5] = 16;
        nArray2[6] = 8;
        LDR_SHIFT = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 255;
        nArray3[2] = 65535;
        nArray3[3] = 0xFFFFFF;
        LWL_MASK = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 8;
        nArray4[2] = 16;
        nArray4[3] = 24;
        LWL_SHIFT = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = -256;
        nArray5[1] = -65536;
        nArray5[2] = -16777216;
        LWR_MASK = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 24;
        nArray6[1] = 16;
        nArray6[2] = 8;
        LWR_SHIFT = nArray6;
        int[] nArray7 = new int[4];
        nArray7[1] = -16777216;
        nArray7[2] = -65536;
        nArray7[3] = -256;
        SWL_MASK = nArray7;
        int[] nArray8 = new int[4];
        nArray8[1] = 8;
        nArray8[2] = 16;
        nArray8[3] = 24;
        SWL_SHIFT = nArray8;
        long[] lArray3 = new long[8];
        lArray3[1] = -72057594037927936L;
        lArray3[2] = -281474976710656L;
        lArray3[3] = -1099511627776L;
        lArray3[4] = -4294967296L;
        lArray3[5] = -16777216L;
        lArray3[6] = -65536L;
        lArray3[7] = -256L;
        SDL_MASK = lArray3;
        int[] nArray9 = new int[8];
        nArray9[1] = 8;
        nArray9[2] = 16;
        nArray9[3] = 24;
        nArray9[4] = 32;
        nArray9[5] = 40;
        nArray9[6] = 48;
        nArray9[7] = 56;
        SDL_SHIFT = nArray9;
        long[] lArray4 = new long[8];
        lArray4[0] = 0xFFFFFFFFFFFFFFL;
        lArray4[1] = 0xFFFFFFFFFFFFL;
        lArray4[2] = 0xFFFFFFFFFFL;
        lArray4[3] = 0xFFFFFFFFL;
        lArray4[4] = 0xFFFFFFL;
        lArray4[5] = 65535L;
        lArray4[6] = 255L;
        SDR_MASK = lArray4;
        int[] nArray10 = new int[8];
        nArray10[0] = 56;
        nArray10[1] = 48;
        nArray10[2] = 40;
        nArray10[3] = 32;
        nArray10[4] = 24;
        nArray10[5] = 16;
        nArray10[6] = 8;
        SDR_SHIFT = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 0xFFFFFF;
        nArray11[1] = 65535;
        nArray11[2] = 255;
        SWR_MASK = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 24;
        nArray12[1] = 16;
        nArray12[2] = 8;
        SWR_SHIFT = nArray12;
    }

    public Cpu() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cop0 = (Bus32bit)Class.forName(prop.getProperty("CPU_COP0", "CPU_COP0"), true, loader).newInstance();
            this.cop1 = (Bus32bit)Class.forName(prop.getProperty("CPU_COP1", "CPU_COP1"), true, loader).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((Hardware)this.cop0).connect(0, (Hardware)this);
        ((Hardware)this.cop1).connect(0, (Hardware)this);
        this.mmu = (Bus32bit)((Configurable)this.cop0).readConfig("MMU");
        this.LO = 0L;
        this.HI = 0L;
        this.cachedOpcodes = new CachedOpcode[0x100800];
        int i = 0;
        while (i < 0x100800) {
            this.cachedOpcodes[i] = new CachedOpcode();
            ++i;
        }
        this.buildOps();
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 4: {
                this.mi8bit = (Bus8bit)bus;
                this.mi16bit = (Bus16bit)bus;
                this.mi32bit = (Bus32bit)bus;
                this.mi64bit = (Bus64bit)bus;
                break;
            }
            case 5: {
                this.timer = (Bus32bit)bus;
            }
        }
    }

    public void reset() {
        this.running = false;
        this.nextInstruction = 0;
        this.pc = 0;
        this.GPR = new long[32];
        this.jumpToLocation = 0;
        this.HI = 0L;
        this.LO = 0L;
        this.tmpWord = 0;
        this.tmpDouble = 0L;
        this.instruction = 0;
        this.target = 0;
        this.rs = 0;
        this.base = 0;
        this.rt = 0;
        this.offset = 0;
        this.rd = 0;
        this.sa = 0;
        this.funct = 0;
        this.currentInstr = 0;
        this.llBit = 0;
        this.llAddr = 0;
        this.cachedOp = null;
        this.cachedCode = null;
        this.tmpDmultu = new long[3];
        this.tmpOp = 0;
        this.tmpRs = 0;
        this.tmpRt = 0;
        this.tmpRd = 0;
        this.tmpFunct = 0;
        this.tick = 0;
        this.tickTimer = 0;
        this.countPerOp = 0;
        this.mode32 = 0;
        int i = 0;
        while (i < this.cachedOpcodes.length) {
            this.cachedOpcodes[i].cached = false;
            ++i;
        }
        ((Hardware)this.cop0).reset();
        ((Hardware)this.cop1).reset();
    }

    public void clock(long clocks) {
        if (clocks != 0L) {
            this.startEmulation();
        } else {
            this.running = false;
        }
    }

    private int readRegister(int reg) {
        switch (reg) {
            case 32: {
                return this.pc;
            }
            case 33: {
                int tmp = this.tick;
                this.tick = 0;
                return tmp;
            }
            case 35: {
                return this.llBit;
            }
            case 37: {
                return this.nextInstruction;
            }
            case 38: {
                return this.mi32bit.read32bit(70254604) & this.mi32bit.read32bit(70254600);
            }
            case 39: {
                return this.testInterpreterJump();
            }
            case 40: {
                return this.instruction;
            }
            case 41: {
                return (int)(this.HI >> 32);
            }
            case 42: {
                return (int)this.HI;
            }
            case 43: {
                return (int)(this.LO >> 32);
            }
            case 44: {
                return (int)this.LO;
            }
        }
        return 0;
    }

    private void writeRegister(int reg, int value) {
        switch (reg) {
            case 32: {
                if (!this.running) {
                    this.pc = value;
                    break;
                }
                this.jumpToLocation = value + 4;
                this.nextInstruction = 6;
                break;
            }
            case 33: {
                this.countPerOp = value;
                this.cop0.write32bit(36, value);
                break;
            }
            case 35: {
                this.llBit = value;
                break;
            }
            case 38: {
                this.cop0.write32bit(37, value);
                break;
            }
            case 40: {
                if (value == 0) {
                    this.jumpToLocation = this.pc + 8;
                    this.nextInstruction = 6;
                    break;
                }
                this.nextInstruction = 3;
                break;
            }
            case 41: {
                this.HI = ((long)value & 0xFFFFFFFFL) << 32 | this.HI & 0xFFFFFFFFL;
                break;
            }
            case 42: {
                this.HI = this.HI & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
                break;
            }
            case 43: {
                this.LO = ((long)value & 0xFFFFFFFFL) << 32 | this.LO & 0xFFFFFFFFL;
                break;
            }
            case 44: {
                this.LO = this.LO & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
                break;
            }
            case 64: {
                this.tableException = true;
            }
        }
    }

    public Object readConfig(String key) {
        if (key.equals("instructioncache")) {
            return this.cacheInstructions;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("instructioncache")) {
            this.cacheInstructions = (Boolean)value;
        }
    }

    public byte read8bit(int pAddr) {
        return (byte)this.GPR[pAddr];
    }

    public short read16bit(int pAddr) {
        return (short)this.GPR[pAddr];
    }

    public int read32bit(int pAddr) {
        if (pAddr < 32) {
            return (int)this.GPR[pAddr];
        }
        return this.readRegister(pAddr);
    }

    public long read64bit(int pAddr) {
        return this.GPR[pAddr];
    }

    public void write8bit(int pAddr, byte value) {
        this.GPR[pAddr] = value;
    }

    public void write16bit(int pAddr, short value) {
        this.GPR[pAddr] = value;
    }

    public void write32bit(int pAddr, int value) {
        if (pAddr < 32) {
            this.GPR[pAddr] = value;
        } else {
            this.writeRegister(pAddr, value);
        }
    }

    public void write64bit(int pAddr, long value) {
        this.GPR[pAddr] = value;
    }

    private void startEmulation() {
        this.running = true;
        this.startInterpreterCPU();
    }

    private void startInterpreterCPU() {
        while (this.running) {
            int pAddr = this.mmu.read32bit(this.pc);
            if (this.tableException) {
                this.tableException = false;
                this.pc = this.jumpToLocation;
                this.nextInstruction = 0;
                continue;
            }
            if (this.cacheInstructions) {
                this.cachedOp = this.cachedOpcodes[pAddr < 0x400000 ? pAddr >>> 2 : pAddr - 0x3C00000 >>> 2];
                if (this.cachedOp.cached) {
                    this.instruction = this.cachedOp.inst;
                    this.cachedCode = this.cachedOp.code;
                } else {
                    this.cachedOp.cached = true;
                    this.cachedOp.inst = this.instruction = this.mi32bit.read32bit(pAddr);
                    this.cachedOp.code = (this.instruction >> 26 & 0x3F) == 0 ? this.r4300i_Special[this.instruction & 0x3F] : this.r4300i_Opcode[this.instruction >> 26 & 0x3F];
                    this.cachedCode = this.cachedOp.code;
                }
            } else {
                this.instruction = this.mi32bit.read32bit(pAddr);
            }
            ++this.tick;
            ++this.tickTimer;
            if (this.cacheInstructions) {
                this.cachedCode.exec(this.instruction, 0);
            } else {
                this.r4300i_Opcode[this.instruction >> 26 & 0x3F].exec(this.instruction, 0);
            }
            switch (this.nextInstruction) {
                case 0: {
                    this.pc += 4;
                    break;
                }
                case 3: {
                    this.nextInstruction = 6;
                    this.pc += 4;
                    break;
                }
                case 6: {
                    this.pc = this.jumpToLocation;
                    this.nextInstruction = 0;
                    ((Clockable)this.timer).clock((long)(this.tickTimer * this.countPerOp));
                    this.tickTimer = 0;
                    this.cop0.read32bit(37);
                    this.pc = this.jumpToLocation;
                    this.nextInstruction = 0;
                    break;
                }
                default: {
                    System.err.printf("%X:Invalid next-instruction type:%d\n", this.pc, this.nextInstruction);
                }
            }
        }
    }

    private int testInterpreterJump() {
        if (this.delaySlotEffectsCompare() == 0) {
            int error = this.cop0.read32bit(38);
            if (error == 1) {
                System.err.printf("In a permanent loop that can not be exited\n\nEmulation will now stop\n", new Object[0]);
                System.exit(0);
            } else if (error == 2) {
                ((Clockable)this.timer).clock((long)(this.tickTimer * this.countPerOp + 5));
                this.tickTimer = 0;
                int time = this.timer.read32bit(4);
                if (time > 0) {
                    ((Clockable)this.cop0).clock((long)(time + 1));
                    this.timer.write32bit(4, -1);
                }
            }
        }
        return 1;
    }

    private int delaySlotEffectsCompare() {
        int tmpInstr;
        if (this.pc != this.jumpToLocation) {
            return 1;
        }
        int pAddr = this.mmu.read32bit(this.pc + 4);
        if (this.tableException) {
            this.tableException = false;
            return 1;
        }
        if (this.cacheInstructions) {
            this.cachedOp = this.cachedOpcodes[pAddr < 0x400000 ? pAddr >>> 2 : pAddr - 0x3C00000 >>> 2];
            if (this.cachedOp.cached) {
                tmpInstr = this.cachedOp.inst;
            } else {
                this.cachedOp.cached = true;
                this.cachedOp.inst = this.mi32bit.read32bit(pAddr);
                tmpInstr = this.cachedOp.inst;
                this.cachedOp.code = (tmpInstr >> 26 & 0x3F) == 0 ? this.r4300i_Special[tmpInstr & 0x3F] : this.r4300i_Opcode[tmpInstr >> 26 & 0x3F];
            }
        } else {
            tmpInstr = this.mi32bit.read32bit(pAddr);
        }
        this.tmpOp = tmpInstr >> 26 & 0x3F;
        this.tmpRs = tmpInstr >> 21 & 0x1F;
        this.tmpRt = tmpInstr >> 16 & 0x1F;
        this.tmpRd = tmpInstr >> 11 & 0x1F;
        this.tmpFunct = tmpInstr & 0x3F;
        int reg1 = this.instruction >> 21 & 0x1F;
        int reg2 = this.instruction >> 16 & 0x1F;
        block0 : switch (this.tmpOp) {
            case 0: {
                switch (this.tmpFunct) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 22: 
                    case 23: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 63: {
                        if (this.tmpRd == 0) {
                            return 0;
                        }
                        if (this.tmpRd == reg1) {
                            return 1;
                        }
                        if (this.tmpRd != reg2) break block0;
                        return 1;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        break block0;
                    }
                    default: {
                        return 1;
                    }
                }
            }
            case 16: {
                switch (this.tmpRs) {
                    case 4: {
                        break block0;
                    }
                    case 0: {
                        if (this.tmpRt == 0) {
                            return 0;
                        }
                        if (this.tmpRt == reg1) {
                            return 1;
                        }
                        if (this.tmpRt != reg2) break block0;
                        return 1;
                    }
                    default: {
                        if ((this.tmpRs & 0x10) != 0) {
                            switch (this.instruction & 0x3F) {
                                case 1: {
                                    break block0;
                                }
                                case 2: {
                                    break block0;
                                }
                                case 6: {
                                    break block0;
                                }
                                case 8: {
                                    break block0;
                                }
                            }
                            return 1;
                        }
                        return 1;
                    }
                }
            }
            case 17: {
                switch (this.tmpRs) {
                    case 0: {
                        if (this.tmpRt == 0) {
                            return 0;
                        }
                        if (this.tmpRt == reg1) {
                            return 1;
                        }
                        if (this.tmpRt != reg2) break block0;
                        return 1;
                    }
                    case 2: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 6: {
                        break block0;
                    }
                    case 16: {
                        break block0;
                    }
                    case 17: {
                        break block0;
                    }
                    case 20: {
                        break block0;
                    }
                    case 21: {
                        break block0;
                    }
                    default: {
                        return 1;
                    }
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 53: 
            case 55: {
                if (this.tmpRt == 0) {
                    return 0;
                }
                if (this.tmpRt == reg1) {
                    return 1;
                }
                if (this.tmpRt != reg2) break;
                return 1;
            }
            case 47: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 43: {
                break;
            }
            case 46: {
                break;
            }
            case 42: {
                break;
            }
            case 57: {
                break;
            }
            case 61: {
                break;
            }
            case 63: {
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    private int compareUnsignedLongs(long a, long b) {
        if (a == b) {
            return 0;
        }
        if ((a >> 32 & 0xFFFFFFFFL) < (b >> 32 & 0xFFFFFFFFL)) {
            return -1;
        }
        if ((a >> 32 & 0xFFFFFFFFL) > (b >> 32 & 0xFFFFFFFFL)) {
            return 1;
        }
        if ((a >> 32 & 0xFFFFFFFFL) == (b >> 32 & 0xFFFFFFFFL) && (a & 0xFFFFFFFFL) < (b & 0xFFFFFFFFL)) {
            return -1;
        }
        return 1;
    }

    private void buildOps() {
        this.r4300i_Opcode = new OpCode[64];
        int i = 0;
        while (i < 64) {
            this.r4300i_Opcode[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_Opcode[0] = this.R4300i_opcode_SPECIAL;
        this.r4300i_Opcode[1] = this.R4300i_opcode_REGIMM;
        this.r4300i_Opcode[2] = this.r4300i_J;
        this.r4300i_Opcode[3] = this.r4300i_JAL;
        this.r4300i_Opcode[4] = this.r4300i_BEQ;
        this.r4300i_Opcode[5] = this.r4300i_BNE;
        this.r4300i_Opcode[6] = this.r4300i_BLEZ;
        this.r4300i_Opcode[7] = this.r4300i_BGTZ;
        this.r4300i_Opcode[8] = this.r4300i_ADDI;
        this.r4300i_Opcode[9] = this.r4300i_ADDIU;
        this.r4300i_Opcode[10] = this.r4300i_SLTI;
        this.r4300i_Opcode[11] = this.r4300i_SLTIU;
        this.r4300i_Opcode[12] = this.r4300i_ANDI;
        this.r4300i_Opcode[13] = this.r4300i_ORI;
        this.r4300i_Opcode[14] = this.r4300i_XORI;
        this.r4300i_Opcode[15] = this.r4300i_LUI;
        this.r4300i_Opcode[16] = this.R4300i_opcode_COP0;
        this.r4300i_Opcode[17] = this.R4300i_opcode_COP1;
        this.r4300i_Opcode[20] = this.r4300i_BEQL;
        this.r4300i_Opcode[21] = this.r4300i_BNEL;
        this.r4300i_Opcode[22] = this.r4300i_BLEZL;
        this.r4300i_Opcode[23] = this.r4300i_BGTZL;
        this.r4300i_Opcode[25] = this.r4300i_DADDIU;
        this.r4300i_Opcode[26] = this.r4300i_LDL;
        this.r4300i_Opcode[27] = this.r4300i_LDR;
        this.r4300i_Opcode[32] = this.r4300i_LB;
        this.r4300i_Opcode[33] = this.r4300i_LH;
        this.r4300i_Opcode[34] = this.r4300i_LWL;
        this.r4300i_Opcode[35] = this.r4300i_LW;
        this.r4300i_Opcode[36] = this.r4300i_LBU;
        this.r4300i_Opcode[37] = this.r4300i_LHU;
        this.r4300i_Opcode[38] = this.r4300i_LWR;
        this.r4300i_Opcode[39] = this.R4300i_UnknownOpcode;
        this.r4300i_Opcode[40] = this.r4300i_SB;
        this.r4300i_Opcode[41] = this.r4300i_SH;
        this.r4300i_Opcode[42] = this.r4300i_SWL;
        this.r4300i_Opcode[43] = this.r4300i_SW;
        this.r4300i_Opcode[44] = this.r4300i_SDL;
        this.r4300i_Opcode[45] = this.r4300i_SDR;
        this.r4300i_Opcode[46] = this.r4300i_SWR;
        this.r4300i_Opcode[47] = this.r4300i_CACHE;
        this.r4300i_Opcode[48] = this.R4300i_UnknownOpcode;
        this.r4300i_Opcode[49] = this.r4300i_LWC1;
        this.r4300i_Opcode[53] = this.r4300i_LDC1;
        this.r4300i_Opcode[55] = this.r4300i_LD;
        this.r4300i_Opcode[56] = this.R4300i_UnknownOpcode;
        this.r4300i_Opcode[57] = this.r4300i_SWC1;
        this.r4300i_Opcode[61] = this.r4300i_SDC1;
        this.r4300i_Opcode[63] = this.r4300i_SD;
        this.r4300i_Special = new OpCode[64];
        i = 0;
        while (i < 64) {
            this.r4300i_Special[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_Special[0] = this.r4300i_SPECIAL_SLL;
        this.r4300i_Special[2] = this.r4300i_SPECIAL_SRL;
        this.r4300i_Special[3] = this.r4300i_SPECIAL_SRA;
        this.r4300i_Special[4] = this.r4300i_SPECIAL_SLLV;
        this.r4300i_Special[6] = this.r4300i_SPECIAL_SRLV;
        this.r4300i_Special[7] = this.r4300i_SPECIAL_SRAV;
        this.r4300i_Special[8] = this.r4300i_SPECIAL_JR;
        this.r4300i_Special[9] = this.r4300i_SPECIAL_JALR;
        this.r4300i_Special[12] = this.r4300i_SPECIAL_SYSCALL;
        this.r4300i_Special[13] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[15] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[16] = this.r4300i_SPECIAL_MFHI;
        this.r4300i_Special[17] = this.r4300i_SPECIAL_MTHI;
        this.r4300i_Special[18] = this.r4300i_SPECIAL_MFLO;
        this.r4300i_Special[19] = this.r4300i_SPECIAL_MTLO;
        this.r4300i_Special[20] = this.r4300i_SPECIAL_DSLLV;
        this.r4300i_Special[22] = this.r4300i_SPECIAL_DSRLV;
        this.r4300i_Special[23] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[24] = this.r4300i_SPECIAL_MULT;
        this.r4300i_Special[25] = this.r4300i_SPECIAL_MULTU;
        this.r4300i_Special[26] = this.r4300i_SPECIAL_DIV;
        this.r4300i_Special[27] = this.r4300i_SPECIAL_DIVU;
        this.r4300i_Special[28] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[29] = this.r4300i_SPECIAL_DMULTU;
        this.r4300i_Special[30] = this.r4300i_SPECIAL_DDIV;
        this.r4300i_Special[31] = this.r4300i_SPECIAL_DDIVU;
        this.r4300i_Special[32] = this.r4300i_SPECIAL_ADD;
        this.r4300i_Special[33] = this.r4300i_SPECIAL_ADDU;
        this.r4300i_Special[34] = this.r4300i_SPECIAL_SUB;
        this.r4300i_Special[35] = this.r4300i_SPECIAL_SUBU;
        this.r4300i_Special[36] = this.r4300i_SPECIAL_AND;
        this.r4300i_Special[37] = this.r4300i_SPECIAL_OR;
        this.r4300i_Special[38] = this.r4300i_SPECIAL_XOR;
        this.r4300i_Special[39] = this.r4300i_SPECIAL_NOR;
        this.r4300i_Special[42] = this.r4300i_SPECIAL_SLT;
        this.r4300i_Special[43] = this.r4300i_SPECIAL_SLTU;
        this.r4300i_Special[44] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[45] = this.r4300i_SPECIAL_DADDU;
        this.r4300i_Special[46] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[47] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[52] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[56] = this.r4300i_SPECIAL_DSLL;
        this.r4300i_Special[58] = this.r4300i_SPECIAL_DSRL;
        this.r4300i_Special[59] = this.R4300i_UnknownOpcode;
        this.r4300i_Special[60] = this.r4300i_SPECIAL_DSLL32;
        this.r4300i_Special[62] = this.r4300i_SPECIAL_DSRL32;
        this.r4300i_Special[63] = this.r4300i_SPECIAL_DSRA32;
        this.r4300i_Regimm = new OpCode[32];
        i = 0;
        while (i < 32) {
            this.r4300i_Regimm[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_Regimm[0] = this.r4300i_REGIMM_BLTZ;
        this.r4300i_Regimm[1] = this.r4300i_REGIMM_BGEZ;
        this.r4300i_Regimm[2] = this.r4300i_REGIMM_BLTZL;
        this.r4300i_Regimm[3] = this.r4300i_REGIMM_BGEZL;
        this.r4300i_Regimm[16] = this.r4300i_REGIMM_BLTZAL;
        this.r4300i_Regimm[17] = this.r4300i_REGIMM_BGEZAL;
    }

    private class CachedOpcode {
        public int inst;
        public boolean cached;
        public OpCode code;

        private CachedOpcode() {
        }
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }
}

