/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.Hardware;
import java.util.HashMap;

public class MIPSInterface
implements Hardware,
Bus8bit,
Bus16bit,
Bus32bit,
Bus64bit {
    private static final boolean DEBUG_MEMORY = false;
    private static final int MI_MODE_REG = 0;
    private static final int MI_VERSION_REG = 1;
    private static final int MI_INTR_REG = 2;
    private static final int MI_INTR_MASK_REG = 3;
    private static final int MI_CLR_INIT = 128;
    private static final int MI_SET_INIT = 256;
    private static final int MI_CLR_EBUS = 512;
    private static final int MI_SET_EBUS = 1024;
    private static final int MI_CLR_DP_INTR = 2048;
    private static final int MI_CLR_RDRAM = 4096;
    private static final int MI_SET_RDRAM = 8192;
    private static final int MI_MODE_INIT = 128;
    private static final int MI_MODE_EBUS = 256;
    private static final int MI_MODE_RDRAM = 512;
    private static final int MI_INTR_CLR_SP = 1;
    private static final int MI_INTR_SET_SP = 2;
    private static final int MI_INTR_CLR_SI = 4;
    private static final int MI_INTR_SET_SI = 8;
    private static final int MI_INTR_CLR_AI = 16;
    private static final int MI_INTR_SET_AI = 32;
    private static final int MI_INTR_CLR_VI = 64;
    private static final int MI_INTR_SET_VI = 128;
    private static final int MI_INTR_CLR_PI = 256;
    private static final int MI_INTR_SET_PI = 512;
    private static final int MI_INTR_CLR_DP = 1024;
    private static final int MI_INTR_SET_DP = 2048;
    private static final int MI_INTR_MASK_CLR_SP = 1;
    private static final int MI_INTR_MASK_SET_SP = 2;
    private static final int MI_INTR_MASK_CLR_SI = 4;
    private static final int MI_INTR_MASK_SET_SI = 8;
    private static final int MI_INTR_MASK_CLR_AI = 16;
    private static final int MI_INTR_MASK_SET_AI = 32;
    private static final int MI_INTR_MASK_CLR_VI = 64;
    private static final int MI_INTR_MASK_SET_VI = 128;
    private static final int MI_INTR_MASK_CLR_PI = 256;
    private static final int MI_INTR_MASK_SET_PI = 512;
    private static final int MI_INTR_MASK_CLR_DP = 1024;
    private static final int MI_INTR_MASK_SET_DP = 2048;
    private static final int MI_INTR_MASK_SP = 1;
    private static final int MI_INTR_MASK_SI = 2;
    private static final int MI_INTR_MASK_AI = 4;
    private static final int MI_INTR_MASK_VI = 8;
    private static final int MI_INTR_MASK_PI = 16;
    private static final int MI_INTR_MASK_DP = 32;
    private static final int MI_INTR_SP = 1;
    private static final int MI_INTR_SI = 2;
    private static final int MI_INTR_AI = 4;
    private static final int MI_INTR_VI = 8;
    private static final int MI_INTR_PI = 16;
    private static final int MI_INTR_DP = 32;
    private int[] regMI = new int[4];
    private Bus8bit sp8bit;
    private Bus16bit sp16bit;
    private Bus32bit sp32bit;
    private Bus32bit dp;
    private Bus32bit cpu;
    private Bus32bit vi;
    private Bus32bit ai;
    private Bus32bit pi;
    private Bus32bit ri;
    private Bus32bit si;
    private Bus32bit cart;
    private Bus8bit rdram8bit;
    private Bus16bit rdram16bit;
    private Bus32bit rdram32bit;
    private Bus32bit pif;
    private HashMap<Integer, Byte> bMem = new HashMap();

    public MIPSInterface() {
        this.regMI[1] = 0x2020102;
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram8bit = (Bus8bit)bus;
                this.rdram16bit = (Bus16bit)bus;
                this.rdram32bit = (Bus32bit)bus;
                break;
            }
            case 1: {
                this.sp8bit = (Bus8bit)bus;
                this.sp16bit = (Bus16bit)bus;
                this.sp32bit = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.dp = (Bus32bit)bus;
                break;
            }
            case 3: {
                this.cpu = (Bus32bit)bus;
                break;
            }
            case 4: {
                this.vi = (Bus32bit)bus;
                break;
            }
            case 5: {
                this.ai = (Bus32bit)bus;
                break;
            }
            case 6: {
                this.pi = (Bus32bit)bus;
                break;
            }
            case 7: {
                this.ri = (Bus32bit)bus;
                break;
            }
            case 8: {
                this.si = (Bus32bit)bus;
                break;
            }
            case 9: {
                this.cart = (Bus32bit)bus;
                break;
            }
            case 10: {
                this.pif = (Bus32bit)bus;
                break;
            }
            default: {
                System.err.println("Attempting to connect bus on invalid port: " + port);
            }
        }
    }

    public void reset() {
        this.regMI[1] = 0x2020102;
    }

    public final byte read8bit(int pAddr) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            return this.rdram8bit.read8bit(pAddr);
        }
        if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
            System.err.println("Illegal Memory LB access: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
            return this.sp8bit.read8bit(pAddr - 0x4000000);
        }
        if (pAddr >= 0x10000000 && pAddr < 0x16000000) {
            return ((Bus8bit)this.cart).read8bit(pAddr - 0x5000000);
        }
        int cfr_ignored_0 = pAddr & 0xFFF00000;
        Byte b = this.bMem.get(pAddr);
        return b == null ? (byte)0 : b;
    }

    public final short read16bit(int pAddr) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            return this.rdram16bit.read16bit(pAddr);
        }
        if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
            System.err.println("Illegal Memory LH access: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
            return this.sp16bit.read16bit(pAddr - 0x4000000);
        }
        int cfr_ignored_0 = pAddr & 0xFFF00000;
        Byte bb1 = this.bMem.get(pAddr);
        int b1 = (bb1 == null ? (byte)0 : bb1) & 0xFF;
        Byte bb2 = this.bMem.get(pAddr + 1);
        int b2 = (bb2 == null ? (byte)0 : bb2) & 0xFF;
        return (short)(b1 << 8 | b2);
    }

    public final int read32bit(int pAddr) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            return this.rdram32bit.read32bit(pAddr);
        }
        if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
            System.err.println("Illegal Memory LW access: " + Integer.toHexString(pAddr));
            return 0;
        }
        if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
            return this.sp32bit.read32bit(pAddr - 0x4000000);
        }
        if (pAddr >= 0x10000000 && pAddr < 0x16000000) {
            return this.cart.read32bit(pAddr - 0x5000000);
        }
        switch (pAddr & 0xFFF00000) {
            case 0x3F00000: {
                return this.rdram32bit.read32bit(pAddr);
            }
            case 0x4000000: {
                return this.sp32bit.read32bit(pAddr);
            }
            case 0x4100000: {
                return this.dp.read32bit(pAddr);
            }
            case 0x4300000: {
                return this.readRegister(pAddr - 0x4300000 >> 2);
            }
            case 0x4400000: {
                return this.vi.read32bit(pAddr);
            }
            case 0x4500000: {
                return this.ai.read32bit(pAddr);
            }
            case 0x4600000: {
                return this.pi.read32bit(pAddr);
            }
            case 0x4700000: {
                return this.ri.read32bit(pAddr);
            }
            case 0x4800000: {
                return this.si.read32bit(pAddr);
            }
            case 0x5000000: {
                return this.cart.read32bit(pAddr - 0x5000000);
            }
            case 0x8000000: {
                return this.cart.read32bit(pAddr - 0x5000000);
            }
            case 532676608: {
                return this.pif.read32bit(pAddr - 532676608);
            }
        }
        Byte bb1 = this.bMem.get(pAddr);
        int b1 = (bb1 == null ? (byte)0 : bb1) & 0xFF;
        Byte bb2 = this.bMem.get(pAddr + 1);
        int b2 = (bb2 == null ? (byte)0 : bb2) & 0xFF;
        Byte bb3 = this.bMem.get(pAddr + 2);
        int b3 = (bb3 == null ? (byte)0 : bb3) & 0xFF;
        Byte bb4 = this.bMem.get(pAddr + 3);
        int b4 = (bb4 == null ? (byte)0 : bb4) & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public final long read64bit(int pAddr) {
        return (long)this.read32bit(pAddr) << 32 | (long)this.read32bit(pAddr + 4) & 0xFFFFFFFFL;
    }

    public final void write8bit(int pAddr, byte value) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            this.rdram8bit.write8bit(pAddr, value);
        } else {
            if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
                System.err.println("Illegal Memory SB access: " + Integer.toHexString(pAddr));
                return;
            }
            if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
                this.sp8bit.write8bit(pAddr - 0x4000000, value);
            } else {
                switch (pAddr & 0xFFF00000) {
                    case 0: 
                    case 0x100000: 
                    case 0x200000: 
                    case 0x300000: 
                    case 0x400000: 
                    case 0x500000: 
                    case 0x600000: 
                    case 0x700000: {
                        System.err.println("Illegal RAM Memory SB: " + Integer.toHexString(pAddr));
                        return;
                    }
                }
                this.bMem.put(pAddr, value);
            }
        }
    }

    public final void write16bit(int pAddr, short value) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            this.rdram16bit.write16bit(pAddr, value);
        } else {
            if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
                System.err.println("Illegal Memory SH access: " + Integer.toHexString(pAddr));
                return;
            }
            if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
                this.sp16bit.write16bit(pAddr - 0x4000000, value);
            } else {
                switch (pAddr & 0xFFF00000) {
                    case 0: 
                    case 0x100000: 
                    case 0x200000: 
                    case 0x300000: 
                    case 0x400000: 
                    case 0x500000: 
                    case 0x600000: 
                    case 0x700000: {
                        System.err.println("Illegal RAM Memory SH: " + Integer.toHexString(pAddr));
                        return;
                    }
                }
                this.bMem.put(pAddr, (byte)(value >> 8 & 0xFFFF));
                this.bMem.put(pAddr + 1, (byte)(value & 0xFFFF));
            }
        }
    }

    public final void write32bit(int pAddr, int value) {
        if (pAddr >= 0 && pAddr < 0x800000) {
            this.rdram32bit.write32bit(pAddr, value);
        } else {
            if (pAddr >= 0x800000 && pAddr < 0x3F00000) {
                System.err.println("Illegal Memory  SW access: " + Integer.toHexString(pAddr));
                return;
            }
            if (pAddr >= 0x4000000 && pAddr < 0x4002000) {
                this.sp32bit.write32bit(pAddr - 0x4000000, value);
            } else {
                if (pAddr >= 0x10000000 && pAddr < 0x16000000) {
                    this.cart.write32bit(pAddr - 0x5000000, value);
                }
                switch (pAddr & 0xFFF00000) {
                    case 0: 
                    case 0x100000: 
                    case 0x200000: 
                    case 0x300000: 
                    case 0x400000: 
                    case 0x500000: 
                    case 0x600000: 
                    case 0x700000: {
                        System.err.println("Illegal RAM Memory SW: " + Integer.toHexString(pAddr));
                        return;
                    }
                    case 0x3F00000: {
                        this.rdram32bit.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4000000: {
                        this.sp32bit.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4100000: {
                        this.dp.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4300000: {
                        this.writeRegister(pAddr - 0x4300000 >> 2, value);
                        break;
                    }
                    case 0x4400000: {
                        this.vi.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4500000: {
                        this.ai.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4600000: {
                        this.pi.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4700000: {
                        this.ri.write32bit(pAddr, value);
                        break;
                    }
                    case 0x4800000: {
                        this.si.write32bit(pAddr, value);
                        break;
                    }
                    case 0x8000000: {
                        this.cart.write32bit(pAddr - 0x5000000, value);
                        break;
                    }
                    case 532676608: {
                        this.pif.write32bit(pAddr - 532676608, value);
                        break;
                    }
                    default: {
                        this.bMem.put(pAddr, (byte)(value >> 24 & 0xFFFF));
                        this.bMem.put(pAddr + 1, (byte)(value >> 16 & 0xFFFF));
                        this.bMem.put(pAddr + 2, (byte)(value >> 8 & 0xFFFF));
                        this.bMem.put(pAddr + 3, (byte)(value & 0xFFFF));
                    }
                }
            }
        }
    }

    public final void write64bit(int pAddr, long value) {
        this.write32bit(pAddr, (int)(value >> 32));
        this.write32bit(pAddr + 4, (int)value);
    }

    private int readRegister(int reg) {
        switch (reg) {
            case 0: {
                return this.regMI[0];
            }
            case 1: {
                return this.regMI[1];
            }
            case 2: {
                return this.regMI[2];
            }
            case 3: {
                return this.regMI[3];
            }
        }
        return 0;
    }

    private void writeRegister(int reg, int value) {
        switch (reg) {
            case 0: {
                this.regMI[0] = this.regMI[0] & 0xFFFFFF80;
                this.regMI[0] = this.regMI[0] | value & 0x7F;
                if ((value & 0x80) != 0) {
                    this.regMI[0] = this.regMI[0] & 0xFFFFFF7F;
                }
                if ((value & 0x100) != 0) {
                    this.regMI[0] = this.regMI[0] | 0x80;
                }
                if ((value & 0x200) != 0) {
                    this.regMI[0] = this.regMI[0] & 0xFFFFFEFF;
                }
                if ((value & 0x400) != 0) {
                    this.regMI[0] = this.regMI[0] | 0x100;
                }
                if ((value & 0x800) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFDF;
                    this.cpu.write32bit(38, this.regMI[3] & this.regMI[2]);
                }
                if ((value & 0x1000) != 0) {
                    this.regMI[0] = this.regMI[0] & 0xFFFFFDFF;
                }
                if ((value & 0x2000) == 0) break;
                this.regMI[0] = this.regMI[0] | 0x200;
                break;
            }
            case 2: {
                if ((value & 1) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFFE;
                }
                if ((value & 2) != 0) {
                    this.regMI[2] = this.regMI[2] | 1;
                }
                if ((value & 4) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFFD;
                }
                if ((value & 8) != 0) {
                    this.regMI[2] = this.regMI[2] | 2;
                }
                if ((value & 0x10) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFFB;
                }
                if ((value & 0x20) != 0) {
                    this.regMI[2] = this.regMI[2] | 4;
                }
                if ((value & 0x40) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFF7;
                }
                if ((value & 0x80) != 0) {
                    this.regMI[2] = this.regMI[2] | 8;
                }
                if ((value & 0x100) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFEF;
                }
                if ((value & 0x200) != 0) {
                    this.regMI[2] = this.regMI[2] | 0x10;
                }
                if ((value & 0x400) != 0) {
                    this.regMI[2] = this.regMI[2] & 0xFFFFFFDF;
                }
                if ((value & 0x800) != 0) {
                    this.regMI[2] = this.regMI[2] | 0x20;
                }
                this.cpu.write32bit(38, this.regMI[3] & this.regMI[2]);
                break;
            }
            case 3: {
                if ((value & 1) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFFE;
                }
                if ((value & 2) != 0) {
                    this.regMI[3] = this.regMI[3] | 1;
                }
                if ((value & 4) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFFD;
                }
                if ((value & 8) != 0) {
                    this.regMI[3] = this.regMI[3] | 2;
                }
                if ((value & 0x10) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFFB;
                }
                if ((value & 0x20) != 0) {
                    this.regMI[3] = this.regMI[3] | 4;
                }
                if ((value & 0x40) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFF7;
                }
                if ((value & 0x80) != 0) {
                    this.regMI[3] = this.regMI[3] | 8;
                }
                if ((value & 0x100) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFEF;
                }
                if ((value & 0x200) != 0) {
                    this.regMI[3] = this.regMI[3] | 0x10;
                }
                if ((value & 0x400) != 0) {
                    this.regMI[3] = this.regMI[3] & 0xFFFFFFDF;
                }
                if ((value & 0x800) == 0) break;
                this.regMI[3] = this.regMI[3] | 0x20;
            }
        }
    }
}

